<!--

@license Apache-2.0

Copyright (c) 2019 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Simulation Iterators

> Standard library simulation iterators.

<section class="usage">

## Usage

```javascript
var ns = require( '@stdlib/simulate/iter' );
```

#### ns

Standard library simulation iterators.

```javascript
var iterators = ns;
// returns {...}
```

The namespace contains the following functions for creating iterator protocol-compliant iterators:

<!-- <toc pattern="*"> -->

<div class="namespace-toc">

-   <span class="signature">[`iterawgn( iterator, sigma[, options] )`][@stdlib/simulate/iter/awgn]</span><span class="delimiter">: </span><span class="description">create an iterator which introduces additive white Gaussian noise (AWGN).</span>
-   <span class="signature">[`iterawln( iterator, sigma[, options] )`][@stdlib/simulate/iter/awln]</span><span class="delimiter">: </span><span class="description">create an iterator which introduces additive white Laplacian noise (AWLN).</span>
-   <span class="signature">[`iterawun( iterator, sigma[, options] )`][@stdlib/simulate/iter/awun]</span><span class="delimiter">: </span><span class="description">create an iterator which introduces additive white uniform noise (AWUN).</span>
-   <span class="signature">[`iterBartlettHannPulse( [options] )`][@stdlib/simulate/iter/bartlett-hann-pulse]</span><span class="delimiter">: </span><span class="description">create an iterator which generates a Bartlett-Hann pulse waveform.</span>
-   <span class="signature">[`iterBartlettPulse( [options] )`][@stdlib/simulate/iter/bartlett-pulse]</span><span class="delimiter">: </span><span class="description">create an iterator which generates a Bartlett pulse waveform.</span>
-   <span class="signature">[`iterCosineWave( [options] )`][@stdlib/simulate/iter/cosine-wave]</span><span class="delimiter">: </span><span class="description">create an iterator which generates a cosine wave.</span>
-   <span class="signature">[`iterDiracComb( [options] )`][@stdlib/simulate/iter/dirac-comb]</span><span class="delimiter">: </span><span class="description">create an iterator which generates a Dirac comb.</span>
-   <span class="signature">[`iterFlatTopPulse( [options] )`][@stdlib/simulate/iter/flat-top-pulse]</span><span class="delimiter">: </span><span class="description">create an iterator which generates a flat top pulse waveform.</span>
-   <span class="signature">[`iterHannPulse( [options] )`][@stdlib/simulate/iter/hann-pulse]</span><span class="delimiter">: </span><span class="description">create an iterator which generates a Hann pulse waveform.</span>
-   <span class="signature">[`iterLanczosPulse( [options] )`][@stdlib/simulate/iter/lanczos-pulse]</span><span class="delimiter">: </span><span class="description">create an iterator which generates a Lanczos pulse waveform.</span>
-   <span class="signature">[`iterPeriodicSinc( n[, options] )`][@stdlib/simulate/iter/periodic-sinc]</span><span class="delimiter">: </span><span class="description">create an iterator which generates a periodic sinc waveform.</span>
-   <span class="signature">[`iterPulse( [options] )`][@stdlib/simulate/iter/pulse]</span><span class="delimiter">: </span><span class="description">create an iterator which generates a pulse waveform.</span>
-   <span class="signature">[`iterSawtoothWave( [options] )`][@stdlib/simulate/iter/sawtooth-wave]</span><span class="delimiter">: </span><span class="description">create an iterator which generates a sawtooth wave.</span>
-   <span class="signature">[`iterSineWave( [options] )`][@stdlib/simulate/iter/sine-wave]</span><span class="delimiter">: </span><span class="description">create an iterator which generates a sine wave.</span>
-   <span class="signature">[`iterSquareWave( [options] )`][@stdlib/simulate/iter/square-wave]</span><span class="delimiter">: </span><span class="description">create an iterator which generates a square wave.</span>
-   <span class="signature">[`iterTriangleWave( [options] )`][@stdlib/simulate/iter/triangle-wave]</span><span class="delimiter">: </span><span class="description">create an iterator which generates a triangle wave.</span>

</div>

<!-- </toc> -->

</section>

<!-- /.usage -->

<section class="examples">

## Examples

<!-- TODO: better examples -->

<!-- eslint no-undef: "error" -->

```javascript
var objectKeys = require( '@stdlib/utils/keys' );
var ns = require( '@stdlib/simulate/iter' );

console.log( objectKeys( ns ) );
```

</section>

<!-- /.examples -->

<section class="links">

<!-- <toc-links> -->

[@stdlib/simulate/iter/awgn]: https://github.com/stdlib-js/simulate/tree/main/iter/awgn

[@stdlib/simulate/iter/awln]: https://github.com/stdlib-js/simulate/tree/main/iter/awln

[@stdlib/simulate/iter/awun]: https://github.com/stdlib-js/simulate/tree/main/iter/awun

[@stdlib/simulate/iter/bartlett-hann-pulse]: https://github.com/stdlib-js/simulate/tree/main/iter/bartlett-hann-pulse

[@stdlib/simulate/iter/bartlett-pulse]: https://github.com/stdlib-js/simulate/tree/main/iter/bartlett-pulse

[@stdlib/simulate/iter/cosine-wave]: https://github.com/stdlib-js/simulate/tree/main/iter/cosine-wave

[@stdlib/simulate/iter/dirac-comb]: https://github.com/stdlib-js/simulate/tree/main/iter/dirac-comb

[@stdlib/simulate/iter/flat-top-pulse]: https://github.com/stdlib-js/simulate/tree/main/iter/flat-top-pulse

[@stdlib/simulate/iter/hann-pulse]: https://github.com/stdlib-js/simulate/tree/main/iter/hann-pulse

[@stdlib/simulate/iter/lanczos-pulse]: https://github.com/stdlib-js/simulate/tree/main/iter/lanczos-pulse

[@stdlib/simulate/iter/periodic-sinc]: https://github.com/stdlib-js/simulate/tree/main/iter/periodic-sinc

[@stdlib/simulate/iter/pulse]: https://github.com/stdlib-js/simulate/tree/main/iter/pulse

[@stdlib/simulate/iter/sawtooth-wave]: https://github.com/stdlib-js/simulate/tree/main/iter/sawtooth-wave

[@stdlib/simulate/iter/sine-wave]: https://github.com/stdlib-js/simulate/tree/main/iter/sine-wave

[@stdlib/simulate/iter/square-wave]: https://github.com/stdlib-js/simulate/tree/main/iter/square-wave

[@stdlib/simulate/iter/triangle-wave]: https://github.com/stdlib-js/simulate/tree/main/iter/triangle-wave

<!-- </toc-links> -->

</section>

<!-- /.links -->
