/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Boolean indicating if an environment is big endian.
*
* @module @stdlib/assert/is-big-endian
*
* @example
* var IS_BIG_ENDIAN = require( '@stdlib/assert/is-big-endian' );
*
* var bool = IS_BIG_ENDIAN;
* // returns <boolean>
*/

// MODULES //

var IS_BIG_ENDIAN = require( './main.js' );


// EXPORTS //

module.exports = IS_BIG_ENDIAN;
