/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.lang.reflect.Modifier;

public class Modifiers {
    public static final Modifiers NONE = new Modifiers(0);
    public static final Modifiers PUBLIC = new Modifiers(1);
    public static final Modifiers PUBLIC_ABSTRACT = new Modifiers(1025);
    public static final Modifiers PUBLIC_STATIC = new Modifiers(9);
    public static final Modifiers PROTECTED = new Modifiers(4);
    public static final Modifiers PRIVATE = new Modifiers(2);
    private final int mBitmask;

    public static Modifiers getInstance(int bitmask) {
        switch (bitmask) {
            case 0: {
                return NONE;
            }
            case 1: {
                return PUBLIC;
            }
            case 1025: {
                return PUBLIC_ABSTRACT;
            }
            case 9: {
                return PUBLIC_STATIC;
            }
            case 4: {
                return PROTECTED;
            }
            case 2: {
                return PRIVATE;
            }
        }
        return new Modifiers(bitmask);
    }

    private static int toPublic(int bitmask, boolean b) {
        if (b) {
            return (bitmask | 1) & 0xFFFFFFF9;
        }
        return bitmask & 0xFFFFFFFE;
    }

    private static int toPrivate(int bitmask, boolean b) {
        if (b) {
            return (bitmask | 2) & 0xFFFFFFFA;
        }
        return bitmask & 0xFFFFFFFD;
    }

    private static int toProtected(int bitmask, boolean b) {
        if (b) {
            return (bitmask | 4) & 0xFFFFFFFC;
        }
        return bitmask & 0xFFFFFFFB;
    }

    private static int toStatic(int bitmask, boolean b) {
        if (b) {
            return bitmask | 8;
        }
        return bitmask & 0xFFFFFFF7;
    }

    private static int toFinal(int bitmask, boolean b) {
        if (b) {
            return (bitmask | 0x10) & 0xFFFFF9FF;
        }
        return bitmask & 0xFFFFFFEF;
    }

    private static int toSynchronized(int bitmask, boolean b) {
        if (b) {
            return (bitmask | 0x20) & 0xFFFFFD3F;
        }
        return bitmask & 0xFFFFFFDF;
    }

    private static int toVolatile(int bitmask, boolean b) {
        if (b) {
            return (bitmask | 0x40) & 0xFFFFF0DF;
        }
        return bitmask & 0xFFFFFFBF;
    }

    private static int toTransient(int bitmask, boolean b) {
        if (b) {
            return (bitmask | 0x80) & 0xFFFFF0DF;
        }
        return bitmask & 0xFFFFFF7F;
    }

    private static int toNative(int bitmask, boolean b) {
        if (b) {
            return (bitmask | 0x100) & 0xFFFFF13F;
        }
        return bitmask & 0xFFFFFEFF;
    }

    private static int toInterface(int bitmask, boolean b) {
        if (b) {
            return (bitmask | 0x600) & 0xFFFFFE0F;
        }
        return bitmask & 0xFFFFFDFF;
    }

    private static int toAbstract(int bitmask, boolean b) {
        if (b) {
            return (bitmask | 0x400) & 0xFFFFF60F;
        }
        return bitmask & 0xFFFFFBFF & 0xFFFFFDFF;
    }

    private static int toStrict(int bitmask, boolean b) {
        if (b) {
            return bitmask | 0x800;
        }
        return bitmask & 0xFFFFF7FF;
    }

    private static int toBridge(int bitmask, boolean b) {
        if (b) {
            return (bitmask | 0x40) & 0xFFFFF8FF;
        }
        return bitmask & 0xFFFFFFBF;
    }

    private static int toEnum(int bitmask, boolean b) {
        if (b) {
            return (bitmask | 0x100) & 0xFFFFF1DF;
        }
        return bitmask & 0xFFFFFEFF;
    }

    private static int toVarArgs(int bitmask, boolean b) {
        if (b) {
            return (bitmask | 0x80) & 0xFFFFFDBF;
        }
        return bitmask & 0xFFFFFF7F;
    }

    private Modifiers(int bitmask) {
        this.mBitmask = bitmask;
    }

    public final int getBitmask() {
        return this.mBitmask;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.mBitmask);
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.mBitmask);
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.mBitmask);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.mBitmask);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.mBitmask);
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.mBitmask);
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.mBitmask);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.mBitmask);
    }

    public boolean isNative() {
        return Modifier.isNative(this.mBitmask);
    }

    public boolean isInterface() {
        return Modifier.isInterface(this.mBitmask);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.mBitmask);
    }

    public boolean isStrict() {
        return Modifier.isStrict(this.mBitmask);
    }

    public boolean isBridge() {
        return Modifier.isVolatile(this.mBitmask);
    }

    public boolean isEnum() {
        return Modifier.isNative(this.mBitmask);
    }

    public boolean isVarArgs() {
        return Modifier.isTransient(this.mBitmask);
    }

    public Modifiers toPublic(boolean b) {
        return this.convert(Modifiers.toPublic(this.mBitmask, b));
    }

    public Modifiers toPrivate(boolean b) {
        return this.convert(Modifiers.toPrivate(this.mBitmask, b));
    }

    public Modifiers toProtected(boolean b) {
        return this.convert(Modifiers.toProtected(this.mBitmask, b));
    }

    public Modifiers toStatic(boolean b) {
        return this.convert(Modifiers.toStatic(this.mBitmask, b));
    }

    public Modifiers toFinal(boolean b) {
        return this.convert(Modifiers.toFinal(this.mBitmask, b));
    }

    public Modifiers toSynchronized(boolean b) {
        return this.convert(Modifiers.toSynchronized(this.mBitmask, b));
    }

    public Modifiers toVolatile(boolean b) {
        return this.convert(Modifiers.toVolatile(this.mBitmask, b));
    }

    public Modifiers toTransient(boolean b) {
        return this.convert(Modifiers.toTransient(this.mBitmask, b));
    }

    public Modifiers toNative(boolean b) {
        return this.convert(Modifiers.toNative(this.mBitmask, b));
    }

    public Modifiers toInterface(boolean b) {
        return this.convert(Modifiers.toInterface(this.mBitmask, b));
    }

    public Modifiers toAbstract(boolean b) {
        return this.convert(Modifiers.toAbstract(this.mBitmask, b));
    }

    public Modifiers toStrict(boolean b) {
        return this.convert(Modifiers.toStrict(this.mBitmask, b));
    }

    public Modifiers toBridge(boolean b) {
        return this.convert(Modifiers.toBridge(this.mBitmask, b));
    }

    public Modifiers toEnum(boolean b) {
        return this.convert(Modifiers.toEnum(this.mBitmask, b));
    }

    public Modifiers toVarArgs(boolean b) {
        return this.convert(Modifiers.toVarArgs(this.mBitmask, b));
    }

    public int hashCode() {
        return this.mBitmask;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Modifiers) {
            Modifiers other = (Modifiers)obj;
            return this.mBitmask == other.mBitmask;
        }
        return false;
    }

    public String toString() {
        return Modifier.toString(this.mBitmask);
    }

    private Modifiers convert(int bitmask) {
        return bitmask == this.mBitmask ? this : Modifiers.getInstance(bitmask);
    }
}

