/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.result.output;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import jd.io.Encoding;
import jd.xml.xslt.result.output.CharOutput;
import jd.xml.xslt.result.output.Output;
import jd.xml.xslt.result.output.Utf8ByteOutput;

public abstract class OutputFactory {
    public static Output createOutput(Writer writer) {
        return new CharOutput(writer);
    }

    public static Output createOutput(OutputStream outputStream, Encoding encoding) throws UnsupportedEncodingException {
        if ("UTF8".equals(encoding.getJavaName())) {
            return new Utf8ByteOutput(outputStream);
        }
        try {
            return new CharOutput(new OutputStreamWriter(outputStream, encoding.getJavaName()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new CharOutput(new OutputStreamWriter(outputStream, encoding.getName()));
        }
    }
}

