.\" DO NOT MODIFY THIS FILE!  It was generated by help2man 1.40.4.
.TH DCONV "1" "July 2013" "dateutils 0.2.5" "User Commands"
.SH NAME
dconv - Convert dates between calendars or time zones
.SH SYNOPSIS
.B dconv
[\fIOPTION\fR]... [\fIDATE/TIME\fR]...
.SH DESCRIPTION
dconv 0.2.5
.PP
Convert DATE/TIMEs between calendrical systems.
If DATE/TIME is omitted date/times are read from stdin.
.PP
DATE/TIME can also be one of the following specials
.TP
\- `now'
interpreted as the current (UTC) time stamp
.TP
\- `time'
the time part of the current (UTC) time stamp
.TP
\- `today'
the current date (according to UTC)
.TP
\- `tomo[rrow]'
tomorrow's date (according to UTC)
.TP
\- `y[ester]day'
yesterday's date (according to UTC)
.TP
\fB\-h\fR, \fB\-\-help\fR
Print help and exit
.TP
\fB\-V\fR, \fB\-\-version\fR
Print version and exit
.TP
\fB\-q\fR, \fB\-\-quiet\fR
Suppress message about date/time and duration
parser errors.
.TP
\fB\-f\fR, \fB\-\-format\fR=\fISTRING\fR
Output format.  This can either be a specifier
string (similar to strftime()'s FMT) or the name
of a calendar.
.TP
\fB\-i\fR, \fB\-\-input\-format\fR=\fISTRING\fR
Input format, can be used multiple times.
Each date/time will be passed to the input
format parsers in the order they are given, if a
date/time can be read successfully with a given
input format specifier string, that value will
be used.
.TP
\fB\-\-default\fR=\fIDT\fR
For underspecified input use DT as a fallback to
fill in missing fields.  Must be a date/time in
ISO8601 format.  If omitted the default value is
the current date/time.
.TP
\fB\-e\fR, \fB\-\-backslash\-escapes\fR
Enable interpretation of backslash escapes in the
output and input format specifier strings.
.TP
\fB\-S\fR, \fB\-\-sed\-mode\fR
Copy parts from the input before and after a
matching date/time.
Note that all occurrences of date/times within a
line will be processed.
.TP
\fB\-\-from\-zone\fR=\fIZONE\fR
Interpret dates on stdin or the command line as
coming from the time zone ZONE.
.TP
\fB\-z\fR, \fB\-\-zone\fR=\fIZONE\fR
Convert dates printed on stdout to time zone ZONE,
default: UTC.
.SH EXAMPLES

  % dconv 2012-03-01
  2012-03-01


  % dconv -i "%d/%b/%y" 01/Mar/12
  2012-03-01


  % dconv -f "%d/%b/%y" 2012-03-01
  01/Mar/12


  % dconv -f "%d/%b/%y" -i "%OY %Om %Od" "MCMXCVIII IX XVII"
  17/Sep/98


  % dconv 12:03:01
  12:03:01


  % dconv -i "%I:%M:%S %p" "11:22:33 PM"
  23:22:33


  % dconv '2012-03-01 00:00:00'
  2012-03-01T00:00:00


  % dconv 2012-03-01T12:34:56
  2012-03-01T12:34:56


  % dconv --zone America/Chicago <<EOF
  2012-03-01T07:05:06
  2012-03-01T08:12:34
  2012-03-11T01:05:06
  2012-03-11T02:05:06
  2012-03-11T07:05:06
  2012-03-11T08:05:06
  2012-03-11T17:05:06
  EOF
  2012-03-01T01:05:06
  2012-03-01T02:12:34
  2012-03-10T19:05:06
  2012-03-10T20:05:06
  2012-03-11T01:05:06
  2012-03-11T03:05:06
  2012-03-11T12:05:06


  % dconv --from-zone America/Chicago <<EOF
  2012-03-01T01:05:06
  2012-03-01T02:12:34
  2012-03-10T19:05:06
  2012-03-10T20:05:06
  2012-03-11T01:05:06
  2012-03-11T03:05:06
  2012-03-11T12:05:06
  EOF
  2012-03-01T07:05:06
  2012-03-01T08:12:34
  2012-03-11T01:05:06
  2012-03-11T02:05:06
  2012-03-11T07:05:06
  2012-03-11T08:05:06
  2012-03-11T17:05:06


  % dconv --from-zone America/Chicago -z Europe/Berlin '2012-03-01 12:00' -i '%F %H:%M' -f '%F %T'
  2012-03-01 19:00:00
.SH "FORMAT SPECS"

Format specs in dateutils are similar to posix' strftime().

However, due to a broader range of supported calendars dateutils must
employ different rules.

Date specs:
  %a  The abbreviated weekday name
  %A  The full weekday name
  %_a The weekday name shortened to a single character (MTWRFAS)
  %b  The abbreviated month name
  %B  The full month name
  %_b The month name shortened to a single character (FGHJKMNQUVXZ)
  %c  The count of the weekday within the month (range 00 to 05)
  %C  The count of the weekday within the year (range 00 to 53)
  %d  The day of the month, 2 digits (range 00 to 31)
  %D  The day of the year, 3 digits (range 000 to 366)
  %F  Equivalent to %Y-%m-%d (ymd's canonical format)
  %j  Equivalent to %D
  %m  The month in the current calendar (range 00 to 19)
  %Q  The quarter of the year (range Q1 to Q4)
  %q  The number of the quarter (range 01 to 04)
  %s  The number of seconds since the Epoch.
  %u  The weekday as number (range 01 to 07, Sunday being 07)
  %U  The week count, first day of week is Sun (range 00 to 53)
  %V  The ISO week count, first day of week is Mon (range 01 to 53)
  %w  The weekday as number (range 00 to 06, Sunday being 00)
  %W  The week count, first day of week is Mon (range 00 to 53)
  %y  The year without a century (range 00 to 99)
  %Y  The year including the century

  %Od The day as roman numerals
  %Om The month as roman numerals
  %Oy The two digit year as roman numerals
  %OY The year including the century as roman numerals

  %rs In time systems whose Epoch is different from the unix Epoch, this
      selects the number of seconds since then.
  %rY In calendars with years that don't coincide with the Gregorian
      years, this selects the calendar's year.

  %dth  The day of the month as an ordinal number, 1st, 2nd, 3rd, etc.
  %mth  The month of the year as an ordinal number, 1st, 2nd, 3rd, etc.

  %db The business day of the month (since last month's ultimo)
  %dB Number of business days until this month's ultimo

Time specs:
  %H  The hour of the day using a 24h clock, 2 digits (range 00 to 23)
  %I  The hour of the day using a 12h clock, 2 digits (range 01 to 12)
  %M  The minute (range 00 to 59)
  %N  The nanoseconds (range 000000000 to 999999999)
  %p  The string AM or PM, noon is PM and midnight is AM.
  %P  Like %p but in lowercase
  %S  The second (range 00 to 60, 60 is for leap seconds)
  %T  Equivalent to %H:%M:%S

General specs:
  %n  A newline character
  %t  A tab character
  %%  A literal % character

Modifiers:
  %O  Modifier to turn decimal numbers into Roman numerals
  %r  Modifier to turn units into real units
  th  Suffix.  Read and print ordinal numbers
  b   Treat date as business date

By design dates before 1601-01-01 are not supported.

For conformity here is a list of calendar spec names and their meaning:
  ymd   %Y-%m-%d
  ymcw  %Y-%m-%c-%w
  ywd   %rY-W%V-%u
  bizda %Y-%m-%db
.SH AUTHOR
Written by Sebastian Freundt <freundt@fresse.org>
.SH "REPORTING BUGS"
Report bugs to: https://github.com/hroptatyr/dateutils/issues
.SH "SEE ALSO"
The full documentation for
.B dconv
is maintained as a Texinfo manual.  If the
.B info
and
.B dconv
programs are properly installed at your site, the command
.IP
.B info (dateutils)dconv
.PP
should give you access to the complete manual.
