
/*--------------------------------------------------------------------*/
/*--- Arch-specific definitions.                 powerpc/cg_arch.c ---*/
/*--------------------------------------------------------------------*/

/*
   This file is part of Cachegrind, a Valgrind tool for cache
   profiling programs.

   Copyright (C) 2002-2004 Nicholas Nethercote
      njn25@cam.ac.uk
   Copyright (C) 2004 Paul Mackerras
      paulus@samba.org

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.

   The GNU General Public License is contained in the file COPYING.
*/

#include "tool.h"
#include "cg_arch.h"

void VGA_(configure_caches)(cache_t* I1c, cache_t* D1c, cache_t* L2c,
                         cache_t* I1_dflt, cache_t* D1_dflt, cache_t* L2_dflt,
                         Bool all_caches_clo_defined)
{
   Int res;
   
   // Set caches to default (values for PPC970)
   *I1_dflt = (cache_t) {  65536, 1, 128 };
   *D1_dflt = (cache_t) {  65536, 2, 128 };
   *L2_dflt = (cache_t) { 524288, 8, 128 };
   *I1c = *I1_dflt;
   *D1c = *D1_dflt;
   *L2c = *L2_dflt;

   // XXX should look in device tree, /proc/cpuinfo, etc.
}

/*--------------------------------------------------------------------*/
/*--- end                                                          ---*/
/*--------------------------------------------------------------------*/
