
/*--------------------------------------------------------------------*/
/*--- Proxy LWP machinery.                           vg_proxylwp.h ---*/
/*--------------------------------------------------------------------*/

/*
   This file is part of Valgrind, an extensible x86 protected-mode
   emulator for monitoring program execution on x86-Unixes.

   Copyright (C) 2000-2004 Julian Seward 
      jseward@acm.org

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.

   The GNU General Public License is contained in the file COPYING.
*/


enum PXState
{
   PXS_BAD = -1,
   PXS_WaitReq,		/* waiting for a request */
   PXS_RunSyscall,	/* running a syscall */
   PXS_IntReply,	/* request interrupted - need to send reply */
   PXS_SysDone,		/* small window between syscall
			   complete and results written out */
   PXS_SigACK,		/* waiting for a signal ACK */
};

enum RequestType {
   PX_BAD = -1,
   PX_SetSigmask,		/* sched->proxy; proxy->sched */
   PX_RunSyscall,		/* sched->proxy; proxy->sched */
   PX_Signal,			/* proxy->sched */
   PX_SigACK,			/* sched->proxy */
   PX_Ping,			/* use for sanity-checking */
   PX_Exiting,			/* reply sent by proxy for exit sync */
};

extern void VG_(thread_syscall)(Int syscallno, arch_thread_t *tst, 
				enum PXState *state, enum PXState poststate);

/* We need our own copy of VG_(do_syscall)() to handle a special
   race-condition.  If we've got signals unblocked, and we take a
   signal in the gap either just before or after the syscall, we may
   end up not running the syscall at all, or running it more than
   once.

   The solution is to make the signal handler derive the proxy's
   precise state by looking to see which eip it is executing at
   exception time.

   Ranges:

   sys_before ... sys_restarted:
	Setting up register arguments and running state.  If
	interrupted, then the syscall should be considered to return
	ERESTARTSYS.

   sys_restarted:
	If interrupted and eip==sys_restarted, then either the syscall
	was about to start running, or it has run, was interrupted and
	the kernel wants to restart it.  eax still contains the
	syscall number.  If interrupted, then the syscall return value
	should be ERESTARTSYS.

   sys_after:
	If interrupted and eip==sys_after, the syscall either just
	finished, or it was interrupted and the kernel doesn't want to
	restart it.  Either way, eax equals the correct return value
	(either the actual return value, or EINTR).

   sys_after ... sys_done:
	System call is complete, but the state hasn't been updated,
	nor has the result been written back.  eax contains the return
	value.
*/

extern const Addr sys_before, sys_restarted, sys_after, sys_done;
