// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 27.6.2  Output streams
//

#include <bits/std_cctype.h> 	// For isspace(char)
#include <bits/std_locale.h>

namespace std {

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>::sentry::
    sentry(basic_istream<_CharT, _Traits>& __is, bool __noskipws)
    {
      if (!__is.good())
	{
	  _M_ok = false;
	  return;
	}

      // Synchronize with associated stream.
      if (__is.tie())
	__is.tie()->flush();

      if (!__noskipws && (__is.flags() & ios_base::skipws))
	{
	  __streambuf_type* __streambuf = __is.rdbuf();
	  __int_type __c = __streambuf->sgetc();
	  __int_type __eof = traits_type::eof();
	  while (__c != __eof && isspace(__c))
	    __c = __streambuf->snextc();
	}
      
      _M_ok = true;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(bool& __n)
    {
      sentry __cerb(*this, false);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(short& __n)
    {
      sentry __cerb(*this, false);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(unsigned short& __n)
    {
      sentry __cerb(*this, false);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(int& __n)
    {
      sentry __cerb(*this, false);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(unsigned int& __n)
    {
      sentry __cerb(*this, false);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(long& __n)
    {
      sentry __cerb(*this, false);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(unsigned long& __n)
    {
      sentry __cerb(*this, false);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

#ifdef _GLIBCPP_USE_LONG_LONG
  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(long long& __n)
    {
      sentry __cerb(*this, false);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(unsigned long long& __n)
    {
      sentry __cerb(*this, false);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }
#endif

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(float& __n)
    {
      sentry __cerb(*this, false);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(double& __n)
    {
      sentry __cerb(*this, false);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(long double& __n)
    {
      sentry __cerb(*this, false);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(void*& __n)
    {
      sentry __cerb(*this, false);
      if (__cerb) 
	{
	  try {
	    iostate __err = iostate(0);
	    _M_fnumget->get(*this, 0, *this, __err, __n);
	    this->setstate(__err);
	  }
	  catch(exception& __fail){
	    // 27.6.1.2.1 Common requirements.
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>& 
    basic_istream<_CharT, _Traits>::operator>>(__streambuf_type* __sb)
    {
      streamsize __extracted = 0;
      __streambuf_type* __this_sb = this->rdbuf();
      streamsize __num = __this_sb ? __this_sb->in_avail() : 0;
      sentry __cerb(*this, false);
      if (__sb && __cerb && __num > 0)
	{
	  try {
	    __extracted = __sb->sputn(__this_sb->gptr(), __num);
	    if (__extracted)
	      {
		__this_sb->_M_in_cur += __extracted;
		bool __testin = __this_sb->_M_mode & ios_base::in;
		if (__testin && __this_sb->_M_buf_unified)
		  __this_sb->_M_out_cur += __extracted;
	      }
	  }
	  catch(...) {
	    this->setstate(ios_base::failbit);
	    if ((this->exceptions() & ios_base::failbit) != 0)
	      throw;
	  }
	}
      if (!__extracted)
	this->setstate(ios_base::failbit);

      return *this;
    }

  template<typename _CharT, typename _Traits>
    int
    basic_istream<_CharT, _Traits>::sync()
    {
      int __retval = traits_type::eof();
      _M_gcount = 0;
      sentry __cerb(*this, true);
      if (__cerb) 
	{
	  try {
	    __streambuf_type* __sb = this->rdbuf();
	    if (!__sb || __retval == __sb->pubsync())
	      this->setstate(ios_base::badbit);		    
	    else 
	      __retval = 0;
	  }
	  catch(exception& __fail){
	    // 27.6.1.3 paragraph 1
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return __retval;
    }
  
  template<typename _CharT, typename _Traits>
    typename basic_istream<_CharT, _Traits>::pos_type
    basic_istream<_CharT, _Traits>::tellg()
    {
      pos_type __retval = pos_type(-1);
      bool __testok = this->fail() != true;
      _M_gcount = 0;
      sentry __cerb(*this, true);
      if (__cerb) 
	{
	  try {
	    if (__testok)
	      __retval = this->rdbuf()->pubseekoff(0, ios_base::cur, 
						   ios_base::in);
	    _M_gcount = __retval;
	  }
	  catch(exception& __fail){
	    // 27.6.1.3 paragraph 1
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return __retval;
    }


  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>&
    basic_istream<_CharT, _Traits>::seekg(pos_type __pos)
    {
      bool __testok = this->fail() != true;
      _M_gcount = 0;
      sentry __cerb(*this, true);
      if (__cerb) 
	{
	  try {
	    if (__testok)
	      _M_gcount = this->rdbuf()->pubseekpos(__pos);
	  }
	  catch(exception& __fail){
	    // 27.6.1.3 paragraph 1
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  template<typename _CharT, typename _Traits>
    basic_istream<_CharT, _Traits>&
    basic_istream<_CharT, _Traits>::seekg(off_type __off, 
					  ios_base::seekdir __dir)
    {
      bool __testok = this->fail() != true;
      _M_gcount = 0;
      sentry __cerb(*this, true);
      if (__cerb) 
	{
	  try {
	    if (__testok)
	      _M_gcount = this->rdbuf()->pubseekoff(__off, __dir);
	  }
	  catch(exception& __fail){
	    // 27.6.1.3 paragraph 1
	    // Turn this on without causing an ios::failure to be thrown.
	    this->setstate(ios_base::badbit);
	    if ((this->exceptions() & ios_base::badbit) != 0)
	      throw;
	  }
	}
      return *this;
    }

  // 21.3.7.8 basic_string::getline and operators
  template<typename _CharT, typename _Traits, typename _Alloc>
    basic_istream<_CharT, _Traits>&
    operator>>(basic_istream<_CharT, _Traits>& __is,
	       basic_string<_CharT, _Traits, _Alloc>& __str)
    {
      typedef basic_istream<_CharT, _Traits> 		__istream_type;
      typedef typename __istream_type::int_type 	__int_type;
      typedef basic_string<_CharT, _Traits, _Alloc> 	__string_type;
      typedef typename __string_type::size_type		__size_type;

      __istream_type::sentry __cerb(__is, false);
      if (__cerb) 
	{
	  __str.erase();
	  streamsize __w = __is.width();
	  __size_type __n;
	  __n = __w > 0 ? static_cast<__size_type>(__w) : __str.max_size();
	  __int_type __eof = _Traits::eof();

	  for (__size_type __i = 0; __i <= __n; ++__i)
	    {
	      __int_type __bufval = __is.rdbuf()->sbumpc();
	      if (__bufval == __eof)
		break;
	      if (isspace(_Traits::to_char_type(__bufval)))
		{
		  __is.rdbuf()->sputbackc(_Traits::to_char_type(__bufval));
		  break;
		}
	      __str += _Traits::to_char_type(__bufval);
	    }
	  __is.width(0);
	}
      return __is;
    }

  template<typename _CharT, typename _Traits, typename _Alloc>
    basic_istream<_CharT, _Traits>&
    getline(basic_istream<_CharT, _Traits>& __is,
	    basic_string<_CharT, _Traits, _Alloc>& __str, _CharT __delim)
    {
      typedef basic_istream<_CharT, _Traits> 		__istream_type;
      typedef typename __istream_type::int_type 	__int_type;
      typedef basic_string<_CharT, _Traits, _Alloc> 	__string_type;
      typedef typename __string_type::size_type		__size_type;

      __istream_type::sentry __cerb(__is, true);
      if (__cerb) 
	{
	  __str.erase();
	  streamsize __w = __is.width();
	  __size_type __n = __str.max_size();
	  __int_type __eof = _Traits::eof();
	  __int_type __idelim = _Traits::to_int_type(__delim);
	  __size_type __i = 0;

	  for (; __i <= __n; ++__i)
	    {
	      __int_type __bufval = __is.rdbuf()->sbumpc();
	      if (__bufval == __eof)
		{
		  __is.setstate(ios_base::eofbit);
		  break;
		}
	      if (__idelim == __bufval)
		{
		  ++__i;
		  break;
		}
	      __str += _Traits::to_char_type(__bufval);
	    }
	  if (__i > __n || __i == 0)
	    __is.setstate(ios_base::failbit);
	}
      return __is;
    }

  template<class _CharT, class _Traits, class _Alloc>
    inline basic_istream<_CharT,_Traits>&
    getline(basic_istream<_CharT, _Traits>& __is, 
	    basic_string<_CharT,_Traits,_Alloc>& __str)
    {
      return getline(__is, __str, __is.widen('\n'));
    }

  // 27.6.1.4 Standard basic_istream manipulators
  template<typename _CharT, typename _Traits>
    basic_istream<_CharT,_Traits>& 
    ws(basic_istream<_CharT,_Traits>& __is)
    {
      typedef basic_istream<_CharT, _Traits> 		__istream_type;
      typedef typename __istream_type::int_type 	__int_type;
      typedef typename __istream_type::char_type 	__char_type;
      __int_type __eof = _Traits::eof();	      
      __char_type __c;
      bool __testeof;
      bool __testspace;

      do 
	{
	  __c = __is.rdbuf()->sbumpc();
	  __testeof = __c == __eof;
	  __testspace = isspace(__c); 
	}
      while (!__testeof && __testspace);

      if (__testeof)
	__is.setstate(ios_base::eofbit);
      else if (!__testspace)
	__is.putback(__c);

      return __is;
    }

} // namespace std

// Local Variables:
// mode:C++
// End:








