
// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

#ifndef _CPP_TYPEINFO
#define _CPP_TYPEINFO 1

#include <bits/c++config.h>
#include <bits/std_exception.h>

#ifdef __GNUG__
# include_next <typeinfo>
#else

__STL_BEGIN_NAMESPACE

    class type_info {
    public:
      virtual ~type_info();
      bool operator==(const type_info& rhs) const;
      bool operator!=(const type_info& rhs) const;
      bool before(const type_info& rhs) const;
      const char* name() const;
    private:
      type_info(const type_info& rhs);
      type_info& operator=(const type_info& rhs);
    };

    class bad_cast : public exception {
    public:
      bad_cast() throw();
      bad_cast(const bad_cast&) throw();
      bad_cast& operator=(const bad_cast&) throw();
      virtual ~bad_cast() throw();
      virtual const char* what() const throw();
    };

    class bad_typeid : public exception {
    public:
      bad_typeid() throw();
      bad_typeid(const bad_typeid&) throw();
      bad_typeid& operator=(const bad_typeid&) throw();
      virtual ~bad_typeid() throw();
      virtual const char* what() const throw();
    };

__STL_END_NAMESPACE

#endif

#endif /* _CPP_TYPEINFO */

// Local Variables:
// mode:C++
// End:
