'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) messagedialog.n 1.21 94/12/17 16:04:44
'\" 
.so man.macros
.HS iwidgets::messagedialog iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
iwidgets::messagedialog \- Create and manipulate a message dialog widget
.SH SYNOPSIS
\fBiwidgets::messagedialog\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Toplevel <- iwidgets::Shell <- iwidgets::Dialogshell <- iwidgets::Dialog <- iwidgets::Messagedialog
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbackground\fR	\fBbitmap\fR	\fBcursor\fR	\fBfont\fR
\fBforeground\fR	\fBimage\fR	\fBtext\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbuttonBoxPadX\fR	\fBbuttonBoxPadY\fR	\fBbuttonBoxPos\fR	\fBpadX\fR
\fBpadY\fR	\fBseparator\fR	\fBthickness\fR	
.fi
.LP
See the "dialogshell" widget manual entry for details on the above
inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBmaster\fR	\fBmodality\fR
.fi
.LP
See the "shell" widget manual entry for details on the above
inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBtitle\fR
.fi
.LP
See the "Toplevel" widget manual entry for details on the above
inherited options.
.LP
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBimagePos\fR
Class:	\fBPosition\fR
Command-Line Switch:	\fB-imagepos\fR
.fi
.IP
Specifies the image position relative to the message text: \fBn\fR, \fBs\fR, 
\fBe\fR, or \fBw\fR.  The default is w.
.LP
.nf
Name:	\fBtextPadX\fR
Class:	\fBPad\fR
Command-Line Switch:	\fB-textpadx\fR
.fi
.IP
Specifies a non-negative value indicating how much extra space to request for 
the message text in the X direction.  The value may have any of the forms 
acceptable to Tk_GetPixels.
.LP
.nf
Name:	\fBtextPadY\fR
Class:	\fBPad\fR
Command-Line Switch:	\fB-textpady\fR
.fi
.IP
Specifies a non-negative value indicating how much extra space to request for 
the message text in the X direction.  The value may have any of the forms 
acceptable to Tk_GetPixels.
.LP
.BE

.SH DESCRIPTION
.PP
The \fBiwidgets::messagedialog\fR command creates a message dialog composite widget. 
The messagedialog is derived from the Dialog class and is composed of 
an image and associated message text with commands to manipulate the 
dialog buttons.

.SH "METHODS"
.PP
The \fBiwidgets::messagedialog\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for messagedialog widgets:

.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBadd\fR	\fBbuttonconfigure\fR	\fBdefault\fR	\fBhide\fR
\fBinsert\fR	\fBinvoke\fR	\fBshow\fR
.fi
.LP
See the "buttonbox" widget manual entry for details on the above
inherited methods.
.LP
.nf
.ta 4c 8c 12c
\fBchildsite\fR	
.fi
.LP
See the "dialogshell" widget manual entry for details on the above
inherited methods.
.LP
.nf
.ta 4c 8c 12c
\fBactivate\fR	\fBcenter\fR	\fBdeactivate\fR
.fi
.LP
See the "dialogshell" widget manual entry for details on the above
inherited methods.
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::messagedialog\fR
command.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBiwidgets::messagedialog\fR
command.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBimage\fR
Class:	\fBLabel\fR
.fi
.IP
The image component is the bitmap or image of the message dialog.  See 
the "label" widget manual entry for details on the image component item.
.LP
.nf
Name:	\fBmessage\fR
Class:	\fBLabel\fR
.fi
.IP
The message component provides the textual portion of the message dialog.
See the "label" widget manual entry for details on the message component item.
.fi

.SH EXAMPLE
.DS
 package require Iwidgets 4.0
 #
 # Standard question message dialog used for confirmation.
 #
 iwidgets::messagedialog .md -title "Message Dialog" -text "Are you sure ?" \\
	-bitmap questhead -modality global

 .md buttonconfigure OK -text Yes
 .md buttonconfigure Cancel -text No

 if {[.md activate]} {
    .md configure -text "Are you really sure ?"
    if {[.md activate]} {
	puts stdout "Yes"
    } else {
	puts stdout "No"
    }
 } else {
    puts stdout "No"
 }

 destroy .md

 #
 # Copyright notice with automatic deactivation.
 #
 iwidgets::messagedialog .cr -title "Copyright" -bitmap @dsc.xbm -imagepos n \\
     -text "Copyright 1995 DSC Communications Corporation\\n \\
	    All rights reserved"
 
 .cr hide Cancel

 .cr activate
 after 10000 ".cr deactivate"
.DE
.SH AUTHOR
Mark L. Ulferts
.SH KEYWORDS
messagedialog, dialog, dialogshell, shell, widget
