'\"
'\" Copyright (c) 1993 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: scan.n,v 1.12 1999/01/26 03:53:06 jingham Exp $
'\" 
.so man.macros
.TH scan n "" Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
scan \- Parse string using conversion specifiers in the style of sscanf
.SH SYNOPSIS
\fBscan \fIstring format varName \fR?\fIvarName ...\fR?
.BE

.SH INTRODUCTION
.PP
This command parses fields from an input string in the same fashion
as the ANSI C \fBsscanf\fR procedure and returns a count of the number
of conversions performed, or -1 if the end of the input string is
reached before any conversions have been performed.
\fIString\fR gives the input to be parsed and \fIformat\fR indicates
how to parse it, using \fB%\fR conversion specifiers as in \fBsscanf\fR.
Each \fIvarName\fR gives the name of a variable; when a field is
scanned from \fIstring\fR the result is converted back into a string
and assigned to the corresponding variable.

.SH "DETAILS ON SCANNING"
.PP
\fBScan\fR operates by scanning \fIstring\fR and \fIformatString\fR together.
If the next character in \fIformatString\fR is a blank or tab then it
matches any number of white space characters in \fIstring\fR (including
zero).
Otherwise, if it isn't a \fB%\fR character then it 
must match the next character of \fIstring\fR.
When a \fB%\fR is encountered in \fIformatString\fR, it indicates
the start of a conversion specifier.
A conversion specifier contains three fields after the \fB%\fR:
a \fB*\fR, which indicates that the converted value is to be discarded 
instead of assigned to a variable; a number indicating a maximum field
width; and a conversion character.
All of these fields are optional except for the conversion character.
.PP
When \fBscan\fR finds a conversion specifier in \fIformatString\fR, it
first skips any white-space characters in \fIstring\fR.
Then it converts the next input characters according to the 
conversion specifier and stores the result in the variable given
by the next argument to \fBscan\fR.
The following conversion characters are supported:
.TP 10
\fBd\fR
The input field must be a decimal integer.
It is read in and the value is stored in the variable as a decimal string.
.TP 10
\fBo\fR
The input field must be an octal integer. It is read in and the 
value is stored in the variable as a decimal string.
.TP 10
\fBx\fR
The input field must be a hexadecimal integer. It is read in 
and the value is stored in the variable as a decimal string.
.TP 10
\fBc\fR
A single character is read in and its binary value is stored in 
the variable as a decimal string.
Initial white space is not skipped in this case, so the input
field may be a white-space character.
This conversion is different from the ANSI standard in that the
input field always consists of a single character and no field
width may be specified.
.TP 10
\fBs\fR
The input field consists of all the characters up to the next 
white-space character; the characters are copied to the variable.
.TP 10
\fBe\fR or \fBf\fR or \fBg\fR
The input field must be a floating-point number consisting 
of an optional sign, a string of decimal digits possibly
containing a decimal point, and an optional exponent consisting 
of an \fBe\fR or \fBE\fR followed by an optional sign and a string of 
decimal digits.
It is read in and stored in the variable as a floating-point string.
.TP 10
\fB[\fIchars\fB]\fR
The input field consists of any number of characters in 
\fIchars\fR.
The matching string is stored in the variable.
If the first character between the brackets is a \fB]\fR then
it is treated as part of \fIchars\fR rather than the closing
bracket for the set.
.TP 10
\fB[^\fIchars\fB]\fR
The input field consists of any number of characters not in 
\fIchars\fR.
The matching string is stored in the variable.
If the character immediately following the \fB^\fR is a \fB]\fR then it is 
treated as part of the set rather than the closing bracket for 
the set.
.LP
The number of characters read from the input for a conversion is the
largest number that makes sense for that particular conversion (e.g.
as many decimal digits as possible for \fB%d\fR, as 
many octal digits as possible for \fB%o\fR, and so on).
The input field for a given conversion terminates either when a
white-space character is encountered or when the maximum field 
width has been reached, whichever comes first.
If a \fB*\fR is present in the conversion specifier 
then no variable is assigned and the next scan argument is not consumed.

.SH "DIFFERENCES FROM ANSI SSCANF"
.PP
The behavior of the \fBscan\fR command is the same as the behavior of
the ANSI C \fBsscanf\fR procedure except for the following differences:
.IP [1]
\fB%p\fR and \fB%n\fR conversion specifiers are not currently
supported.
.IP [2]
For \fB%c\fR conversions a single character value is
converted to a decimal string, which is then assigned to the
corresponding \fIvarName\fR;
no field width may be specified for this conversion.
.IP [3]
The \fBl\fR, \fBh\fR, and \fBL\fR modifiers are ignored;  integer
values are always converted as if there were no modifier present
and real values are always converted as if the \fBl\fR modifier
were present (i.e. type \fBdouble\fR is used for the internal
representation).

.SH KEYWORDS
conversion specifier, parse, scan
