/* Parameters for VxWorks Intel 960's, for GDB, the GNU debugger.
   Copyright (C) 1986-1991 Free Software Foundation, Inc.
   Contributed by Cygnus Support.

This file is part of GDB.

GDB is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GDB is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GDB; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "tm-i960.h"

#define	GDBINIT_FILENAME	".vxgdbinit"

#define	DEFAULT_PROMPT		"(vxgdb) "

/* We have more complex, useful breakpoints on the target.
   Amount ip must be decremented by after a breakpoint.  */

#define	DECR_PC_AFTER_BREAK	0

/* We are guaranteed to have a zero frame pointer at bottom of stack, too. */

#define FRAME_CHAIN_VALID(chain, thisframe) (chain != 0)

/* Breakpoint patching is handled at the target end in VxWorks.  */
/* #define BREAKPOINT {0x00, 0x3e, 0x00, 0x66} */

/* Not needed, because we don't support core files:
  	#define KERNEL_U_ADDR
  	#define REGISTER_U_ADDR(addr, blockend, regno)
 */

/* Address of end of stack space.
  	This doesn't matter for VxWorks, because it's only used
  	in manipulation of core files, which we don't support.  */

/* #define STACK_END_ADDR (0xfe000000) */
