/* Return value of complex exponential function for long double complex value.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"


__complex__ long double
cexpl (__complex__ long double x)
{
  __complex__ long double retval;

  if (FINITEL_P (__real__ x))
    {
      /* Real part is finite.  */
      if (FINITEL_P (__imag__ x))
	{
	  /* Imaginary part is finite.  */
	  long double exp_val = expl (__real__ x);
	  long double sinix = sinl (__imag__ x);
	  long double cosix = cosl (__imag__ x);

	  if (FINITEL_P (exp_val))
	    {
	      __real__ retval = exp_val * cosix;
	      __imag__ retval = exp_val * sinix;
	    }
	  else
	    {
	      __real__ retval = __copysignl (exp_val, cosix);
	      __imag__ retval = __copysignl (exp_val, sinix);
	    }
	}
      else
	{
	  /* If the imaginary part is +-inf or NaN and the real part
	     is not +-inf the result is NaN + iNaN.  */
	  __real__ retval = NAN;
	  __imag__ retval = NAN;
	}
    }
  else if (INFINITEL_P (__real__ x))
    {
      /* Real part is infinite.  */
      if (FINITEL_P (__imag__ x))
	{
	  /* Imaginary part is finite.  */
	  long double value = signbit (__real__ x) ? 0.0 : HUGE_VALL;

	  if (__imag__ x == 0.0)
	    {
	      /* Imaginary part is 0.0.  */
	      __real__ retval = value;
	      __imag__ retval = __imag__ x;
	    }
	  else
	    {
	      long double sinix = sinl (__imag__ x);
	      long double cosix = cosl (__imag__ x);

	      __real__ retval = __copysignl (value, cosix);
	      __imag__ retval = __copysignl (value, sinix);
	    }
	}
      else if (signbit (__real__ x) == 0)
	{
	  __real__ retval = HUGE_VALL;
	  __imag__ retval = NAN;
	}
      else
	{
	  __real__ retval = 0.0;
	  __imag__ retval = __copysignl (0.0, __imag__ x);
	}
    }
  else
    {
      /* If the real part is NaN the result is NaN + iNaN.  */
      __real__ retval = NAN;
      __imag__ retval = NAN;
    }

  return retval;
}
