/*
 a test file for Rational class
 */

#include <Rational.h>

// as a fct just to test Rational fcts
Rational estimate_e(long n)
{
  Rational x = Rational(n + 1, n);
  Rational e = pow(x, n);
  return e;
}

main()
{
  Rational one = 1;
  Rational third(1, 3);
  Rational half(1, 2);

  cout << "one = " << one << "\n";
  cout << "third = " << third << "\n";
  cout << "half = " << half << "\n";

  cout << "third + half = " << third + half << "\n";
  cout << "third - half = " << third - half << "\n";
  cout << "third * half = " << third * half << "\n";
  cout << "third / half = " << third / half << "\n";

  Rational onePointTwo = 1.2;
  cout << "onePointTwo = " << onePointTwo << "\n";
  cout << "double(onePointTwo) = " << double(onePointTwo) << "\n";

  Rational a = one;
  cout << "a = " << a << "\n";

  cout << "a += half = " << (a += half) << "\n";
  cout << "a -= half = " << (a -= half) << "\n";
  cout << "a *= half = " << (a *= half) << "\n";
  cout << "a /= half = " << (a /= half) << "\n";

  Rational approxpi(355, 113);
  cout << "approxpi = " << approxpi << "\n";
  cout << "double(approxpi) = " << double(approxpi) << "\n";

  Rational rpi = Rational(PI);
  cout << "rpi = Rational(PI) = " << rpi << "\n";
  cout << "double(rpi) = " << double(rpi) << "\n";

  cout << "approxpi + rpi = " << approxpi + rpi << "\n";
  cout << "approxpi - rpi = " << approxpi - rpi << "\n";
  cout << "approxpi * rpi = " << approxpi * rpi << "\n";
  cout << "approxpi / rpi = " << approxpi / rpi << "\n";
  cout << "-approxpi = " << -approxpi << "\n";
  cout << "abs(-approxpi) = " << abs(-approxpi) << "\n";

  cout << "approxpi == rpi = " << (approxpi == rpi) << "\n";
  cout << "approxpi != rpi = " << (approxpi != rpi) << "\n";
  cout << "approxpi <  rpi = " << (approxpi <  rpi) << "\n";
  cout << "approxpi <= rpi = " << (approxpi <= rpi) << "\n";
  cout << "approxpi >  rpi = " << (approxpi >  rpi) << "\n";
  cout << "approxpi >= rpi = " << (approxpi >= rpi) << "\n";
  cout << "approxpi >?  rpi = " << (approxpi >?  rpi) << "\n";
  cout << "approxpi <? rpi = " << (approxpi <? rpi) << "\n";

  cout << "floor(approxpi) = " << floor(approxpi) << "\n";
  cout << "ciel(approxpi) = " << ceil(approxpi) << "\n";
  cout << "trunc(approxpi) = " << trunc(approxpi) << "\n";
  cout << "round(approxpi) = " << round(approxpi) << "\n";

  cout << "floor(-approxpi + half) = " << floor(-approxpi + half) << "\n";
  cout << "ciel(-approxpi + half) = " << ceil(-approxpi + half) << "\n";
  cout << "trunc(-approxpi + half) = " << trunc(-approxpi + half) << "\n";
  cout << "round(-approxpi + half) = " << round(-approxpi + half) << "\n";


  long n = 100;
  cout << "approximating e as pow(1+1/n),n) for n =" << n << "\n";
  Rational approxe = estimate_e(n);
  cout << "double(approxe) = " << double(approxe) << "\n";
  cout << "log(approxe) = " << log(approxe) << "\n";
  cout << "approxe = " << approxe << "\n";

  n = 1000;
  cout << "approximating e as pow(1+1/n),n) for n =" << n << "\n";
  approxe = estimate_e(n);
  cout << "double(approxe) = " << double(approxe) << "\n";
  cout << "log(approxe) = " << log(approxe) << "\n";
  cout << "approxe = " << approxe << "\n";


  cout << "\nenter a Rational in form a/b or a: ";
  cin >> a;
  cout << "number = " << a << "\n";

  cout << "\nEnd of test\n";
}
