// This may look like C code, but it is really -*- C++ -*-
/* 
Copyright (C) 1988 Free Software Foundation
    written by Doug Lea (dl@rocky.oswego.edu)

This file is part of GNU CC.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU CC General Public
License for full details.

Everyone is granted permission to copy, modify and redistribute
GNU CC, but only under the conditions described in the
GNU CC General Public License.   A copy of this license is
supposed to have been given to you along with GNU CC so you
can know your rights and responsibilities.  It should be in a
file named COPYING.  Among other things, the copyright notice
and this notice must be preserved on all copies.  
*/


/*
This file contains machine and operating-system dependent constants
used by libg++
*/


#ifndef _libconfig_h

#define _libconfig_h 1

#include <values.h>

/*
   HAVE_VPRINTF should be set if vprintf is in libc.a
   HAVE_SETVBUF should be set if setvbuf is in libc.a
   HAVE_SETLINEBUF should be set if setlinebuf in libc.a

   The following are correct for vax BSD4.3 and sun. Others not yet known
*/

#if defined(vax)
//#define HAVE_VPRINTF
//#define  HAVE_SETVBUF  
#define HAVE_SETLINEBUF

#elif defined(sun)
#define  HAVE_VPRINTF
#define  HAVE_SETVBUF  
#define  HAVE_SETLINEBUF
#endif

/* 
  Define SHOULD_FREE_TO_REALLOC
  if realloc(p, l) only works (or just works best) if the pointer p
  is first passed through free(p).
  
  This should be set for vax 4.3BSD and probably for most other systems
*/

#define SHOULD_FREE_TO_REALLOC 1



/*
 Sizes of shifts for multiple-precision arithmetic.
 These should not be changed unless Integer representation
 as unsigned shorts is changed in the implementation files.
*/


#define I_SHIFT         SHORTBITS
#define I_RADIX         ((unsigned long)(1L << I_SHIFT))
#define I_MAXNUM        ((unsigned long)((I_RADIX - 1)))
#define I_MINNUM        ((unsigned long)(I_RADIX >> 1))
#define I_POSITIVE      1
#define I_NEGATIVE      0
#define SHORT_PER_LONG  ((LONGBITS + SHORTBITS - 1) / SHORTBITS)
#define CHAR_PER_LONG   ((LONGBITS + CHARBITS - 1) / CHARBITS)

/* 
  Sizes for BitSets and BitStrings
*/

#define B_SHIFT         LONGBITS

#endif
