;;- Machine description for GNU compiler
;;- Motorola 68000 Version
;;   Copyright (C) 1987 Free Software Foundation, Inc.

;; This file is part of GNU CC.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY.  No author or distributor
;; accepts responsibility to anyone for the consequences of using it
;; or for whether it serves any particular purpose or works at all,
;; unless he says so in writing.  Refer to the GNU CC General Public
;; License for full details.

;; Everyone is granted permission to copy, modify and redistribute
;; GNU CC, but only under the conditions described in the
;; GNU CC General Public License.   A copy of this license is
;; supposed to have been given to you along with GNU CC so you
;; can know your rights and responsibilities.  It should be in a
;; file named COPYING.  Among other things, the copyright notice
;; and this notice must be preserved on all copies.


;;- instruction definitions

;;- @@The original PO technology requires these to be ordered by speed,
;;- @@    so that assigner will pick the fastest.

;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.

;;- When naming insn's (operand 0 of define_insn) be careful about using
;;- names from other targets machine descriptions.

;;- cpp macro #define NOTICE_UPDATE_CC in file tm.h handles condition code
;;- updates for most instructions.

;;- Operand classes for the register allocator:
;;- 'a' one of the address registers can be used.
;;- 'd' one of the data registers can be used.
;;- 'r' either a data or an address register can be used.
  
;;- Immedidate integer operands Constrains:
;;- 'I'  1 .. 8
;;- 'J'  -32768 .. 32767
;;- 'K'  -128 .. 127
;;- 'L'  -8 .. -1

;;- Some of these insn's are composites of several m68000 op codes.
;;- The assembler (or final @@??) insures that the appropriate one is
;;- selected.

(define_insn ""
  [(set (match_operand:DF 0 "push_operand" "=m")
	(match_operand:DF 1 "general_operand" "ro<>fF"))]
  ""
  "*
{
  if (FP_REG_P (operands[1]))
    return \"fmove%.d %f1,%0\";
  return output_move_double (operands);
}")

(define_insn ""
  [(set (match_operand:DI 0 "push_operand" "=m")
	(match_operand:DI 1 "general_operand" "ro<>"))]
  ""
  "*
{
  return output_move_double (operands);
}")

(define_insn "tstsi"
  [(set (cc0)
	(match_operand:SI 0 "general_operand" "rm"))]
  ""
  "*
{
#ifdef ISI_OV
  /* ISI's assembler fails to handle tstl a0.  */
  if (! ADDRESS_REG_P (operands[0]))
#else
  if (TARGET_68020 || ! ADDRESS_REG_P (operands[0]))
#endif
    return \"tst%.l %0\";
  /* If you think that the 68020 does not support tstl a0,
     reread page B-167 of the 68020 manual more carefully.  */
  /* On an address reg, cmpw may replace cmpl.  */
#ifdef HPUX_ASM
  return \"cmp%.w %0,%#0\";
#else
  return \"cmp%.w %#0,%0\";
#endif
}")

(define_insn "tsthi"
  [(set (cc0)
	(match_operand:HI 0 "general_operand" "rm"))]
  ""
  "*
{
#ifdef ISI_OV
  if (! ADDRESS_REG_P (operands[0]))
#else
  if (TARGET_68020 || ! ADDRESS_REG_P (operands[0]))
#endif
    return \"tst%.w %0\";
#ifdef HPUX_ASM
  return \"cmp%.w %0,%#0\";
#else
  return \"cmp%.w %#0,%0\";
#endif
}")

(define_insn "tstqi"
  [(set (cc0)
	(match_operand:QI 0 "general_operand" "dm"))]
  ""
  "tst%.b %0")

(define_insn "tstsf"
  [(set (cc0)
	(match_operand:SF 0 "general_operand" "fdm"))]
  "TARGET_68881"
  "*
{
  cc_status.flags = CC_IN_68881;
  if (FP_REG_P (operands[0]))
    return \"ftst%.x %0\";
  return \"ftst%.s %0\";
}")

(define_insn "tstdf"
  [(set (cc0)
	(match_operand:DF 0 "general_operand" "fm"))]
  "TARGET_68881"
  "*
{
  cc_status.flags = CC_IN_68881;
  if (FP_REG_P (operands[0]))
    return \"ftst%.x %0\";
  return \"ftst%.d %0\";
}")

;; compare instructions.

;; A composite of the cmp, cmpa, & cmpi m68000 op codes.
(define_insn "cmpsi"
  [(set (cc0)
	(minus (match_operand:SI 0 "general_operand" "rKs,mr")
	       (match_operand:SI 1 "general_operand" "mr,Ksr")))]
  ""
  "*
{
  if (REG_P (operands[1])
      || (!REG_P (operands[0]) && GET_CODE (operands[0]) != MEM))
    { cc_status.flags |= CC_REVERSED;
#ifdef HPUX_ASM
      return \"cmp%.l %1,%0\";
#else
      return \"cmp%.l %0,%1\"; 
#endif
    }
#ifdef HPUX_ASM
  return \"cmp%.l %0,%1\";
#else
  return \"cmp%.l %1,%0\";
#endif
}")

(define_insn "cmphi"
  [(set (cc0)
	(minus (match_operand:HI 0 "general_operand" "rn,mr")
	       (match_operand:HI 1 "general_operand" "mr,nr")))]
  ""
  "*
{
  if (REG_P (operands[1])
      || (!REG_P (operands[0]) && GET_CODE (operands[0]) != MEM))
    { cc_status.flags |= CC_REVERSED;
#ifdef HPUX_ASM
      return \"cmp%.w %1,%0\";
#else
      return \"cmp%.w %0,%1\"; 
#endif
    }
#ifdef HPUX_ASM
  return \"cmp%.w %0,%1\";
#else
  return \"cmp%.w %1,%0\";
#endif
}")

(define_insn ""
  [(set (cc0)
	(minus (mem:QI (post_inc:SI (match_operand:SI 0 "general_operand" "+a")))
	       (mem:QI (post_inc:SI (match_operand:SI 1 "general_operand" "+a")))))]
  "! CONSTANT_P (operands[0]) && ! CONSTANT_P (operands[1])"
  "*
#ifdef MOTOROLA
  return \"cmpm.b (%1)+,(%0)+\";
#else
  return \"cmpmb %1@+,%0@+\";
#endif
")

(define_insn "cmpqi"
  [(set (cc0)
	(minus (match_operand:QI 0 "general_operand" "dn,md")
	       (match_operand:QI 1 "general_operand" "dm,nd")))]
  ""
  "*
{
  if (REG_P (operands[1])
      || (!REG_P (operands[0]) && GET_CODE (operands[0]) != MEM))
    { cc_status.flags |= CC_REVERSED;
#ifdef HPUX_ASM
      return \"cmp%.b %1,%0\";
#else
      return \"cmp%.b %0,%1\";
#endif
    }
#ifdef HPUX_ASM
  return \"cmp%.b %0,%1\";
#else
  return \"cmp%.b %1,%0\";
#endif
}")

(define_insn "cmpdf"
  [(set (cc0)
	(minus:DF (match_operand:DF 0 "general_operand" "f,mG")
		  (match_operand:DF 1 "general_operand" "fmG,f")))]
  "TARGET_68881"
  "*
{
  cc_status.flags = CC_IN_68881;
#ifdef HPUX_ASM
  if (REG_P (operands[0]))
    {
      if (REG_P (operands[1]))
	return \"fcmp%.x %0,%1\";
      else
        return \"fcmp%.d %0,%f1\";
    }
  cc_status.flags |= CC_REVERSED;
  return \"fcmp%.d %1,%f0\";
#else
  if (REG_P (operands[0]))
    {
      if (REG_P (operands[1]))
	return \"fcmp%.x %1,%0\";
      else
        return \"fcmp%.d %f1,%0\";
    }
  cc_status.flags |= CC_REVERSED;
  return \"fcmp%.d %f0,%1\";
#endif
}")

(define_insn "cmpsf"
  [(set (cc0)
	(minus:SF (match_operand:SF 0 "general_operand" "f,mdG")
		  (match_operand:SF 1 "general_operand" "fmdG,f")))]
  "TARGET_68881"
  "*
{
  cc_status.flags = CC_IN_68881;
#ifdef HPUX_ASM
  if (FP_REG_P (operands[0]))
    {
      if (FP_REG_P (operands[1]))
	return \"fcmp%.x %0,%1\";
      else
        return \"fcmp%.s %0,%f1\";
    }
  cc_status.flags |= CC_REVERSED;
  return \"fcmp%.s %1,%f0\";
#else
  if (FP_REG_P (operands[0]))
    {
      if (FP_REG_P (operands[1]))
	return \"fcmp%.x %1,%0\";
      else
        return \"fcmp%.s %f1,%0\";
    }
  cc_status.flags |= CC_REVERSED;
  return \"fcmp%.s %f0,%1\";
#endif
}")

;; Recognizers for btst instructions.

(define_insn ""
  [(set (cc0) (zero_extract (match_operand:QI 0 "general_operand" "do")
			    (const_int 1)
			    (minus:SI (const_int 7)
				      (match_operand:SI 1 "general_operand" "di"))))]
  ""
  "* { return output_btst (operands, operands[1], operands[0], insn, 7); }")

(define_insn ""
  [(set (cc0) (zero_extract (match_operand:SI 0 "general_operand" "d")
			    (const_int 1)
			    (minus:SI (const_int 31)
				      (match_operand:SI 1 "general_operand" "di"))))]
  ""
  "* { return output_btst (operands, operands[1], operands[0], insn, 31); }")

;; The following two patterns are like the previous two
;; except that they use the fact that bit-number operands
;; are automatically masked to 3 or 5 bits.

(define_insn ""
  [(set (cc0) (zero_extract (match_operand:QI 0 "general_operand" "do")
			    (const_int 1)
			    (minus:SI (const_int 7)
				      (and:SI
				       (match_operand:SI 1 "general_operand" "d")
				       (const_int 7)))))]
  ""
  "* { return output_btst (operands, operands[1], operands[0], insn, 7); }")

(define_insn ""
  [(set (cc0) (zero_extract (match_operand:SI 0 "general_operand" "d")
			    (const_int 1)
			    (minus:SI (const_int 31)
				      (and:SI
				       (match_operand:SI 1 "general_operand" "d")
				       (const_int 31)))))]
  ""
  "* { return output_btst (operands, operands[1], operands[0], insn, 31); }")

(define_insn ""
  ;; The constraint "o,d" here means that a nonoffsetable memref
  ;; will match the first alternative, and its address will be reloaded.
  ;; Copying the memory contents into a reg would be incorrect if the
  ;; bit position is over 7.
  [(set (cc0) (zero_extract (match_operand:QI 0 "general_operand" "o,d")
			    (const_int 1)
			    (match_operand:SI 1 "general_operand" "i,i")))]
  "GET_CODE (operands[1]) == CONST_INT"
  "*
{ operands[1] = gen_rtx (CONST_INT, VOIDmode, 7 - INTVAL (operands[1]));
  return output_btst (operands, operands[1], operands[0], insn, 7); }")

(define_insn ""
  [(set (cc0) (zero_extract (match_operand:HI 0 "general_operand" "o,d")
			    (const_int 1)
			    (match_operand:SI 1 "general_operand" "i,i")))]
  "GET_CODE (operands[1]) == CONST_INT"
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    {
      operands[0] = adj_offsetable_operand (operands[0],
					    INTVAL (operands[1]) / 8);
      operands[1] = gen_rtx (CONST_INT, VOIDmode, 
			     7 - INTVAL (operands[1]) % 8);
      return output_btst (operands, operands[1], operands[0], insn, 7);
    }
  operands[1] = gen_rtx (CONST_INT, VOIDmode,
			 15 - INTVAL (operands[1]));
  return output_btst (operands, operands[1], operands[0], insn, 15);
}")

(define_insn ""
  [(set (cc0) (zero_extract (match_operand:SI 0 "general_operand" "do")
			    (const_int 1)
			    (match_operand:SI 1 "general_operand" "i")))]
  "GET_CODE (operands[1]) == CONST_INT"
  "*
{
  if (GET_CODE (operands[0]) == MEM)
    {
      operands[0] = adj_offsetable_operand (operands[0],
					    INTVAL (operands[1]) / 8);
      operands[1] = gen_rtx (CONST_INT, VOIDmode, 
			     7 - INTVAL (operands[1]) % 8);
      return output_btst (operands, operands[1], operands[0], insn, 7);
    }
  operands[1] = gen_rtx (CONST_INT, VOIDmode,
			 31 - INTVAL (operands[1]));
  return output_btst (operands, operands[1], operands[0], insn, 31);
}")

(define_insn ""
  [(set (cc0) (subreg:SI (lshiftrt:QI (match_operand:QI 0 "general_operand" "dm")
				      (const_int 7))
			 0))]
  ""
  "*
{
  cc_status.flags = CC_Z_IN_NOT_N | CC_NOT_NEGATIVE;
  return \"tst%.b %0\";
}")

(define_insn ""
  [(set (cc0) (and:SI (sign_extend:SI (sign_extend:HI (match_operand:QI 0 "general_operand" "dm")))
		      (match_operand:SI 1 "general_operand" "i")))]
  "(GET_CODE (operands[1]) == CONST_INT
    && (unsigned) INTVAL (operands[1]) < 0x100
    && exact_log2 (INTVAL (operands[1])) >= 0)"
  "*
{ register int log = exact_log2 (INTVAL (operands[1]));
  operands[1] = gen_rtx (CONST_INT, VOIDmode, log);
  return output_btst (operands, operands[1], operands[0], insn, 7);
}")

;; move instructions
(define_insn "swapsi"
  [(set (match_operand:SI 0 "general_operand" "r")
	(match_operand:SI 1 "general_operand" "r"))
   (set (match_dup 1) (match_dup 0))]
  ""
  "exg %1,%0")

;; Special case of fullword move when source is zero.
;; The reason this is special is to avoid loading a zero
;; into a data reg with moveq in order to store it elsewhere.
   
(define_insn ""
  [(set (match_operand:SI 0 "general_operand" "=g")
	(const_int 0))]
  ""
  "*
{
  if (ADDRESS_REG_P (operands[0]))
    return \"sub%.l %0,%0\";
  return \"clr%.l %0\";
}")

;; Another special case in which it is not desirable
;; to reload the constant into a data register.
(define_insn ""
  [(set (match_operand:SI 0 "push_operand" "=m")
	(match_operand:SI 1 "general_operand" "J"))]
  "GET_CODE (operands[1]) == CONST_INT
   && INTVAL (operands[1]) >= -0x8000
   && INTVAL (operands[1]) < 0x8000"
  "pea %a1")

;; General case of fullword move.  The register constraints
;; force integer constants in range for a moveq to be reloaded
;; if they are headed for memory.
(define_insn "movsi"
  [(set (match_operand:SI 0 "general_operand" "=g,da")
	(match_operand:SI 1 "general_operand" "damKs,i"))]
  ""
  "*
{
  if (GET_CODE (operands[1]) == CONST_INT)
    {
      if (operands[1] == const0_rtx
	  && (DATA_REG_P (operands[0])
	      || GET_CODE (operands[0]) == MEM))
	return \"clr%.l %0\";
      else if (DATA_REG_P (operands[0])
	       && INTVAL (operands[1]) < 128
	       && INTVAL (operands[1]) >= -128)
        {
#ifdef MOTOROLA
          return \"moveq%.l %1,%0\";
#else
	  return \"moveq %1,%0\";
#endif
	}
      else if (ADDRESS_REG_P (operands[0])
	       && INTVAL (operands[1]) < 0x8000
	       && INTVAL (operands[1]) >= -0x8000)
	return \"move%.w %1,%0\";
      else if (push_operand (operands[0], SImode)
	       && INTVAL (operands[1]) < 0x8000
	       && INTVAL (operands[1]) >= -0x8000)
        return \"pea %a1\";
    }
  else if ((GET_CODE (operands[1]) == SYMBOL_REF
	    || GET_CODE (operands[1]) == CONST)
	   && push_operand (operands[0], SImode))
    return \"pea %a1\";
  else if ((GET_CODE (operands[1]) == SYMBOL_REF
	    || GET_CODE (operands[1]) == CONST)
	   && ADDRESS_REG_P (operands[0]))
    return \"lea %a1,%0\";
  return \"move%.l %1,%0\";
}")

(define_insn "movhi"
  [(set (match_operand:HI 0 "general_operand" "=g")
	(match_operand:HI 1 "general_operand" "g"))]
  ""
  "*
{
  if (GET_CODE (operands[1]) == CONST_INT)
    {
      if (operands[1] == const0_rtx
	  && (DATA_REG_P (operands[0])
	      || GET_CODE (operands[0]) == MEM))
	return \"clr%.w %0\";
    }
  else if (CONSTANT_P (operands[1]))
    return \"move%.l %1,%0\";
  /* Recognize the insn before a tablejump, one that refers
     to a table of offsets.  Such an insn will need to refer
     to a label on the insn.  So output one.  Use the label-number
     of the table of offsets to generate this label.  */
  if (GET_CODE (operands[1]) == MEM
      && GET_CODE (XEXP (operands[1], 0)) == PLUS
      && (GET_CODE (XEXP (XEXP (operands[1], 0), 0)) == LABEL_REF
	  || GET_CODE (XEXP (XEXP (operands[1], 0), 1)) == LABEL_REF)
      && GET_CODE (XEXP (XEXP (operands[1], 0), 0)) != PLUS
      && GET_CODE (XEXP (XEXP (operands[1], 0), 1)) != PLUS)
    {
      rtx labelref;
      if (GET_CODE (XEXP (XEXP (operands[1], 0), 0)) == LABEL_REF)
	labelref = XEXP (XEXP (operands[1], 0), 0);
      else
	labelref = XEXP (XEXP (operands[1], 0), 1);
#if defined (MOTOROLA) && ! defined (SGS_3B1)
#ifdef SGS
      fprintf (asm_out_file, \"\\tset %s%d,.+2\\n\", \"LI\",
	       CODE_LABEL_NUMBER (XEXP (labelref, 0)));
#else
      fprintf (asm_out_file, \"\\t.set %s%d,.+2\\n\", \"LI\",
	       CODE_LABEL_NUMBER (XEXP (labelref, 0)));
#endif
#else
      ASM_OUTPUT_INTERNAL_LABEL (asm_out_file, \"LI\",
				 CODE_LABEL_NUMBER (XEXP (labelref, 0)));
#endif
    }
  return \"move%.w %1,%0\";
}")

(define_insn "movstricthi"
  [(set (strict_low_part (match_operand:HI 0 "general_operand" "+dm"))
	(match_operand:HI 1 "general_operand" "rmn"))]
  ""
  "*
{
  if (GET_CODE (operands[1]) == CONST_INT)
    {
      if (operands[1] == const0_rtx
	  && (DATA_REG_P (operands[0])
	      || GET_CODE (operands[0]) == MEM))
	return \"clr%.w %0\";
    }
  return \"move%.w %1,%0\";
}")

(define_insn "movqi"
  [(set (match_operand:QI 0 "general_operand" "=d,a,m")
	(match_operand:QI 1 "general_operand" "g,d,dmi"))]
  ""
  "*
{
  if (operands[1] == const0_rtx)
    return \"clr%.b %0\";
  if (GET_CODE (operands[1]) == CONST_INT
      && INTVAL (operands[1]) == -1)
    return \"st %0\";
  if (GET_CODE (operands[1]) != CONST_INT && CONSTANT_P (operands[1]))
    return \"move%.l %1,%0\";
  if (ADDRESS_REG_P (operands[0]) || ADDRESS_REG_P (operands[1]))
    return \"move%.w %1,%0\";
  return \"move%.b %1,%0\";
}")

(define_insn "movstrictqi"
  [(set (strict_low_part (match_operand:QI 0 "general_operand" "+dm"))
	(match_operand:QI 1 "general_operand" "dmn"))]
  ""
  "*
{
  if (operands[1] == const0_rtx)
    return \"clr%.b %0\";
  return \"move%.b %1,%0\";
}")

(define_insn "movsf"
  [(set (match_operand:SF 0 "general_operand" "=rmf")
	(match_operand:SF 1 "general_operand" "rmfF"))]
  ""
  "*
{
  if (FP_REG_P (operands[0]))
    {
      if (FP_REG_P (operands[1]))
	return \"fmove%.x %1,%0\";
      else if (ADDRESS_REG_P (operands[1]))
	return \"move%.l %1,%-\;fmove%.s %+,%0\";
      else if (GET_CODE (operands[1]) == CONST_DOUBLE)
	return output_move_const_single (operands);
      return \"fmove%.s %f1,%0\";
    }
  if (FP_REG_P (operands[1]))
    {
      if (ADDRESS_REG_P (operands[0]))
	return \"fmove%.s %1,%-\;move%.l %+,%0\";
      return \"fmove%.s %f1,%0\";
    }
  return \"move%.l %1,%0\";
}")

(define_insn "movdf"
  [(set (match_operand:DF 0 "general_operand" "=rm,&rf,&rof<>")
	(match_operand:DF 1 "general_operand" "rf,m,rofF<>"))]
  ""
  "*
{
  if (FP_REG_P (operands[0]))
    {
      if (FP_REG_P (operands[1]))
	return \"fmove%.x %1,%0\";
      if (REG_P (operands[1]))
	{
	  rtx xoperands[2];
	  xoperands[1] = gen_rtx (REG, SImode, REGNO (operands[1]) + 1);
	  output_asm_insn (\"move%.l %1,%-\", xoperands);
	  output_asm_insn (\"move%.l %1,%-\", operands);
	  return \"fmove%.d %+,%0\";
	}
      if (GET_CODE (operands[1]) == CONST_DOUBLE)
	return output_move_const_double (operands);
      return \"fmove%.d %f1,%0\";
    }
  else if (FP_REG_P (operands[1]))
    {
      if (REG_P (operands[0]))
	{
	  output_asm_insn (\"fmove%.d %f1,%-\;move%.l %+,%0\", operands);
	  operands[0] = gen_rtx (REG, SImode, REGNO (operands[0]) + 1);
	  return \"move%.l %+,%0\";
	}
      else
        return \"fmove%.d %f1,%0\";
    }
  return output_move_double (operands);
}
")

;; movdi can apply to fp regs in some cases
(define_insn "movdi"
  [(set (match_operand:DI 0 "general_operand" "=rm,&rf,&rof<>")
	(match_operand:DI 1 "general_operand" "rf,m,roifF<>"))]
  ""
  "*
{
  if (FP_REG_P (operands[0]))
    {
      if (FP_REG_P (operands[1]))
	return \"fmove%.x %1,%0\";
      if (REG_P (operands[1]))
	{
	  rtx xoperands[2];
	  xoperands[1] = gen_rtx (REG, SImode, REGNO (operands[1]) + 1);
	  output_asm_insn (\"move%.l %1,%-\", xoperands);
	  output_asm_insn (\"move%.l %1,%-\", operands);
	  return \"fmove%.d %+,%0\";
	}
      if (GET_CODE (operands[1]) == CONST_DOUBLE)
	return output_move_const_double (operands);
      return \"fmove%.d %f1,%0\";
    }
  else if (FP_REG_P (operands[1]))
    {
      if (REG_P (operands[0]))
	{
	  output_asm_insn (\"fmove.d %f1,%-\;move%.l %+,%0\", operands);
	  operands[0] = gen_rtx (REG, SImode, REGNO (operands[0]) + 1);
	  return \"move%.l %+,%0\";
	}
      else
        return \"fmove%.d %f1,%0\";
    }
  return output_move_double (operands);
}
")

;; These go after the move instructions
;; because the move instructions are better (require no spilling)
;; when they can apply.  But these go before the add and subtract insns
;; because it is often shorter to use these when both apply.
(define_insn "pushasi"
  [(set (match_operand:SI 0 "push_operand" "=m")
	(match_operand:SI 1 "address_operand" "p"))]
  ""
  "pea %a1")


(define_insn ""
  [(set (match_operand:SI 0 "general_operand" "=a")
	(match_operand:QI 1 "address_operand" "p"))]
  ""
  "lea %a1,%0")

;; truncation instructions
(define_insn "truncsiqi2"
  [(set (match_operand:QI 0 "general_operand" "=dm,d")
	(truncate:QI
	 (match_operand:SI 1 "general_operand" "doJ,i")))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == REG)
    return \"move%.l %1,%0\";
  if (GET_CODE (operands[1]) == MEM)
    operands[1] = adj_offsetable_operand (operands[1], 3);
  return \"move%.b %1,%0\";
}")

(define_insn "trunchiqi2"
  [(set (match_operand:QI 0 "general_operand" "=dm,d")
	(truncate:QI
	 (match_operand:HI 1 "general_operand" "doJ,i")))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == REG)
    return \"move%.l %1,%0\";
  if (GET_CODE (operands[1]) == MEM)
    operands[1] = adj_offsetable_operand (operands[1], 1);
  return \"move%.b %1,%0\";
}")

(define_insn "truncsihi2"
  [(set (match_operand:HI 0 "general_operand" "=dm,d")
	(truncate:HI
	 (match_operand:SI 1 "general_operand" "roJ,i")))]
  ""
  "*
{
  if (GET_CODE (operands[0]) == REG)
    return \"move%.l %1,%0\";
  if (GET_CODE (operands[1]) == MEM)
    operands[1] = adj_offsetable_operand (operands[1], 2);
  return \"move%.w %1,%0\";
}")

;; zero extension instructions

(define_expand "zero_extendhisi2"
  [(set (match_operand:SI 0 "general_operand" "")
	(const_int 0))
   (set (strict_low_part (subreg:HI (match_operand:SI 0 "general_operand" "") 0))
	(match_operand:HI 1 "general_operand" ""))]
  ""
  "operands[1] = make_safe_from (operands[1], operands[0]);")

;; Note that the one starting from HImode comes before those for QImode
;; so that a constant operand will match HImode, not QImode.
;(define_insn "zero_extendhisi2"
;  [(set (match_operand:SI 0 "general_operand" "=do<>")
;	(zero_extend:SI
;	 (match_operand:HI 1 "general_operand" "rmn")))]
;  ""
;  "*
;{
;  if (DATA_REG_P (operands[0]))
;    {
;      if (GET_CODE (operands[1]) == REG
;	  && REGNO (operands[0]) == REGNO (operands[1]))
;	return \"and%.l %#0xFFFF,%0\";
;      if (reg_mentioned_p (operands[0], operands[1]))
;        return \"move%.w %1,%0\;and%.l %#0xFFFF,%0\";
;      return \"clr%.l %0\;move%.w %1,%0\";
;    }
;  else if (GET_CODE (operands[0]) == MEM
;	   && GET_CODE (XEXP (operands[0], 0)) == PRE_DEC)
;    return \"move%.w %1,%0\;clr%.w %0\";
;  else if (GET_CODE (operands[0]) == MEM
;	   && GET_CODE (XEXP (operands[0], 0)) == POST_INC)
;    return \"clr%.w %0\;move%.w %1,%0\";
;  else
;    {
;      output_asm_insn (\"clr%.w %0\", operands);
;      operands[0] = adj_offsetable_operand (operands[0], 2);
;      return \"move%.w %1,%0\";
;    }
;}")

(define_expand "zero_extendqihi2"
  [(set (match_operand:HI 0 "general_operand" "")
	(const_int 0))
   (set (strict_low_part (subreg:QI (match_operand:HI 0 "general_operand" "") 0))
	(match_operand:QI 1 "general_operand" ""))]
  ""
  "operands[1] = make_safe_from (operands[1], operands[0]);")

;(define_insn "zero_extendqihi2"
;  [(set (match_operand:HI 0 "general_operand" "=do<>")
;	(zero_extend:HI
;	 (match_operand:QI 1 "general_operand" "dmn")))]
;  ""
;  "*
;{
;  if (DATA_REG_P (operands[0]))
;    {
;      if (GET_CODE (operands[1]) == REG
;	  && REGNO (operands[0]) == REGNO (operands[1]))
;	return \"and%.w %#0xFF,%0\";
;      if (reg_mentioned_p (operands[0], operands[1]))
;        return \"move%.b %1,%0\;and%.w %#0xFF,%0\";
;      return \"clr%.w %0\;move%.b %1,%0\";
;    }
;  else if (GET_CODE (operands[0]) == MEM
;	   && GET_CODE (XEXP (operands[0], 0)) == PRE_DEC)
;    {
;      if (REGNO (XEXP (XEXP (operands[0], 0), 0))
;	  == STACK_POINTER_REGNUM)
;	return \"clr%.w %-\;move%.b %1,%0\";
;      else
;	return \"move%.b %1,%0\;clr%.b %0\";
;    }
;  else if (GET_CODE (operands[0]) == MEM
;	   && GET_CODE (XEXP (operands[0], 0)) == POST_INC)
;    return \"clr%.b %0\;move%.b %1,%0\";
;  else
;    {
;      output_asm_insn (\"clr%.b %0\", operands);
;      operands[0] = adj_offsetable_operand (operands[0], 1);
;      return \"move%.b %1,%0\";
;    }
;}")

(define_expand "zero_extendqisi2"
  [(set (match_operand:SI 0 "general_operand" "")
	(const_int 0))
   (set (strict_low_part (subreg:QI (match_operand:SI 0 "general_operand" "") 0))
	(match_operand:QI 1 "general_operand" ""))]
  ""
  " operands[1] = make_safe_from (operands[1], operands[0]); ")

;(define_insn "zero_extendqisi2"
;  [(set (match_operand:SI 0 "general_operand" "=do<>")
;	(zero_extend:SI
;	 (match_operand:QI 1 "general_operand" "dmn")))]
;  ""
;  "*
;{
;  if (DATA_REG_P (operands[0]))
;    {
;      if (GET_CODE (operands[1]) == REG
;	  && REGNO (operands[0]) == REGNO (operands[1]))
;	return \"and%.l %#0xFF,%0\";
;      if (reg_mentioned_p (operands[0], operands[1]))
;        return \"move%.b %1,%0\;and%.l %#0xFF,%0\";
;      return \"clr%.l %0\;move%.b %1,%0\";
;    }
;  else if (GET_CODE (operands[0]) == MEM
;	   && GET_CODE (XEXP (operands[0], 0)) == PRE_DEC)
;    {
;      operands[0] = XEXP (XEXP (operands[0], 0), 0);
;#ifdef MOTOROLA
;      return \"clr.l -(%0)\;move%.b %1,(3,%0)\";
;#else
;      return \"clrl %0@-\;moveb %1,%0@(3)\";
;#endif
;    }
;  else if (GET_CODE (operands[0]) == MEM
;	   && GET_CODE (XEXP (operands[0], 0)) == POST_INC)
;    {
;      operands[0] = XEXP (XEXP (operands[0], 0), 0);
;#ifdef MOTOROLA
;      return \"clr.l (%0)+\;move%.b %1,(-1,%0)\";
;#else
;      return \"clrl %0@+\;moveb %1,%0@(-1)\";
;#endif
;    }
;  else
;    {
;      output_asm_insn (\"clr%.l %0\", operands);
;      operands[0] = adj_offsetable_operand (operands[0], 3);
;      return \"move%.b %1,%0\";
;    }
;}")

;; sign extension instructions
;; Note that the one starting from HImode comes before those for QImode
;; so that a constant operand will match HImode, not QImode.

(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "general_operand" "=*d,a")
	(sign_extend:SI
	 (match_operand:HI 1 "general_operand" "0,rmn")))]
  ""
  "*
{
  if (ADDRESS_REG_P (operands[0]))
    return \"move%.w %1,%0\";
  return \"ext%.l %0\";
}")

(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(sign_extend:HI
	 (match_operand:QI 1 "general_operand" "0")))]
  ""
  "ext%.w %0")

(define_insn "extendqisi2"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(sign_extend:SI
	 (match_operand:QI 1 "general_operand" "0")))]
  "TARGET_68020"
  "extb%.l %0")

;; Conversions between float and double.

(define_insn "extendsfdf2"
  [(set (match_operand:DF 0 "general_operand" "=*fdm,f")
	(float_extend:DF
	 (match_operand:SF 1 "general_operand" "f,dmF")))]
  "TARGET_68881"
  "*
{
  if (FP_REG_P (operands[0]) && FP_REG_P (operands[1]))
    {
      if (REGNO (operands[0]) == REGNO (operands[1]))
	{
	  /* Extending float to double in an fp-reg is a no-op.
	     NOTICE_UPDATE_CC has already assumed that the
	     cc will be set.  So cancel what it did.  */
	  cc_status = cc_prev_status;
	  return \"\";
	}
      return \"fmove%.x %1,%0\";
    }
  if (FP_REG_P (operands[0]))
    return \"fmove%.s %f1,%0\";
  if (DATA_REG_P (operands[0]) && FP_REG_P (operands[1]))
    {
      output_asm_insn (\"fmove%.d %f1,%-\;move%.l %+,%0\", operands);
      operands[0] = gen_rtx (REG, SImode, REGNO (operands[0]) + 1);
      return \"move%.l %+,%0\";
    }
  return \"fmove%.d %f1,%0\";
}")

;; This cannot output into an f-reg because there is no way to be
;; sure of truncating in that case.
(define_insn "truncdfsf2"
  [(set (match_operand:SF 0 "general_operand" "=dm")
	(float_truncate:SF
	 (match_operand:DF 1 "general_operand" "f")))]
  "TARGET_68881"
  "fmove%.s %f1,%0")

;; Conversion between fixed point and floating point.
;; Note that among the fix-to-float insns
;; the ones that start with SImode come first.
;; That is so that an operand that is a CONST_INT
;; (and therefore lacks a specific machine mode).
;; will be recognized as SImode (which is always valid)
;; rather than as QImode or HImode.

(define_insn "floatsisf2"
  [(set (match_operand:SF 0 "general_operand" "=f")
	(float:SF (match_operand:SI 1 "general_operand" "dmi")))]
  "TARGET_68881"
  "fmove%.l %1,%0")

(define_insn "floatsidf2"
  [(set (match_operand:DF 0 "general_operand" "=f")
	(float:DF (match_operand:SI 1 "general_operand" "dmi")))]
  "TARGET_68881"
  "fmove%.l %1,%0")

(define_insn "floathisf2"
  [(set (match_operand:SF 0 "general_operand" "=f")
	(float:SF (match_operand:HI 1 "general_operand" "dmn")))]
  "TARGET_68881"
  "fmove%.w %1,%0")

(define_insn "floathidf2"
  [(set (match_operand:DF 0 "general_operand" "=f")
	(float:DF (match_operand:HI 1 "general_operand" "dmn")))]
  "TARGET_68881"
  "fmove%.w %1,%0")

(define_insn "floatqisf2"
  [(set (match_operand:SF 0 "general_operand" "=f")
	(float:SF (match_operand:QI 1 "general_operand" "dmn")))]
  "TARGET_68881"
  "fmove%.b %1,%0")

(define_insn "floatqidf2"
  [(set (match_operand:DF 0 "general_operand" "=f")
	(float:DF (match_operand:QI 1 "general_operand" "dmn")))]
  "TARGET_68881"
  "fmove%.b %1,%0")

;; Convert a float to a float whose value is an integer.
;; This is the first stage of converting it to an integer type.

(define_insn "ftruncdf2"
  [(set (match_operand:DF 0 "general_operand" "=f")
	(fix:DF (match_operand:DF 1 "general_operand" "fFm")))]
  "TARGET_68881"
  "*
{
  if (FP_REG_P (operands[1]))
    return \"fintrz%.x %f1,%0\";
  return \"fintrz%.d %f1,%0\";
}")

(define_insn "ftruncsf2"
  [(set (match_operand:SF 0 "general_operand" "=f")
	(fix:SF (match_operand:SF 1 "general_operand" "dfFm")))]
  "TARGET_68881"
  "*
{
  if (FP_REG_P (operands[1]))
    return \"fintrz%.x %f1,%0\";
  return \"fintrz%.s %f1,%0\";
}")

;; Convert a float whose value is an integer
;; to an actual integer.  Second stage of converting float to integer type.
(define_insn "fixsfqi2"
  [(set (match_operand:QI 0 "general_operand" "=dm")
	(fix:QI (match_operand:SF 1 "general_operand" "f")))]
  "TARGET_68881"
  "fmove%.b %1,%0")

(define_insn "fixsfhi2"
  [(set (match_operand:HI 0 "general_operand" "=dm")
	(fix:HI (match_operand:SF 1 "general_operand" "f")))]
  "TARGET_68881"
  "fmove%.w %1,%0")

(define_insn "fixsfsi2"
  [(set (match_operand:SI 0 "general_operand" "=dm")
	(fix:SI (match_operand:SF 1 "general_operand" "f")))]
  "TARGET_68881"
  "fmove%.l %1,%0")

(define_insn "fixdfqi2"
  [(set (match_operand:QI 0 "general_operand" "=dm")
	(fix:QI (match_operand:DF 1 "general_operand" "f")))]
  "TARGET_68881"
  "fmove%.b %1,%0")

(define_insn "fixdfhi2"
  [(set (match_operand:HI 0 "general_operand" "=dm")
	(fix:HI (match_operand:DF 1 "general_operand" "f")))]
  "TARGET_68881"
  "fmove%.w %1,%0")

(define_insn "fixdfsi2"
  [(set (match_operand:SI 0 "general_operand" "=dm")
	(fix:SI (match_operand:DF 1 "general_operand" "f")))]
  "TARGET_68881"
  "fmove%.l %1,%0")

;; add instructions

(define_insn "addsi3"
  [(set (match_operand:SI 0 "general_operand" "=m,r,!a")
	(plus:SI (match_operand:SI 1 "general_operand" "%0,0,a")
		 (match_operand:SI 2 "general_operand" "dIKLs,mrIKLs,rJK")))]
  ""
  "*
{
  if (! operands_match_p (operands[0], operands[1]))
    {
      /* These insns can result from reloads to access
	 stack slots over 64k from the frame pointer.  */
      if (GET_CODE (operands[2]) == CONST_INT
	  && INTVAL (operands[2]) + 0x8000 >= (unsigned) 0x10000)
        return \"move%.l %2,%0\;add%.l %1,%0\";
#ifdef SGS
      if (GET_CODE (operands[2]) == REG)
	return \"lea (%1,%2.l),%0\";
      else
	return \"lea %c2(%1),%0\";
#else /* not SGS */
#ifdef MOTOROLA
      if (GET_CODE (operands[2]) == REG)
	return \"lea (%1,%2.l),%0\";
      else
	return \"lea (%c2,%1),%0\";
#else /* not MOTOROLA (MIT syntax) */
      if (GET_CODE (operands[2]) == REG)
	return \"lea %1@(0,%2:l),%0\";
      else
	return \"lea %1@(%c2),%0\";
#endif /* not MOTOROLA */
#endif /* not SGS */
    }
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      if (INTVAL (operands[2]) > 0
	  && INTVAL (operands[2]) <= 8)
	return \"addq%.l %2,%0\";
      if (INTVAL (operands[2]) < 0
	  && INTVAL (operands[2]) >= -8)
        {
	  operands[2] = gen_rtx (CONST_INT, VOIDmode,
			         - INTVAL (operands[2]));
	  return \"subq%.l %2,%0\";
	}
      if (ADDRESS_REG_P (operands[0])
	  && INTVAL (operands[2]) >= -0x8000
	  && INTVAL (operands[2]) < 0x8000)
	return \"add%.w %2,%0\";
    }
  return \"add%.l %2,%0\";
}")

(define_insn ""
  [(set (match_operand:SI 0 "general_operand" "=a")
	(plus:SI (match_operand:SI 1 "general_operand" "0")
		 (sign_extend:SI (match_operand:HI 2 "general_operand" "rmn"))))]
  ""
  "add%.w %2,%0")

(define_insn "addhi3"
  [(set (match_operand:HI 0 "general_operand" "=m,r")
	(plus:HI (match_operand:HI 1 "general_operand" "%0,0")
		 (match_operand:HI 2 "general_operand" "dn,rmn")))]
  ""
  "*
{
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      if (INTVAL (operands[2]) > 0
	  && INTVAL (operands[2]) <= 8)
	return \"addq%.w %2,%0\";
    }
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      if (INTVAL (operands[2]) < 0
	  && INTVAL (operands[2]) >= -8)
	{
	  operands[2] = gen_rtx (CONST_INT, VOIDmode,
			         - INTVAL (operands[2]));
	  return \"subq%.w %2,%0\";
	}
    }
  return \"add%.w %2,%0\";
}")

(define_insn ""
  [(set (strict_low_part (match_operand:HI 0 "general_operand" "+m,d"))
	(plus:HI (match_dup 0)
		 (match_operand:HI 1 "general_operand" "dn,rmn")))]
  ""
  "add%.w %1,%0")

(define_insn "addqi3"
  [(set (match_operand:QI 0 "general_operand" "=m,d")
	(plus:QI (match_operand:QI 1 "general_operand" "%0,0")
		 (match_operand:QI 2 "general_operand" "dn,dmn")))]
  ""
  "*
{
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      if (INTVAL (operands[2]) > 0
	  && INTVAL (operands[2]) <= 8)
	return \"addq%.b %2,%0\";
    }
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      if (INTVAL (operands[2]) < 0 && INTVAL (operands[2]) >= -8)
       {
	 operands[2] = gen_rtx (CONST_INT, VOIDmode, - INTVAL (operands[2]));
	 return \"subq%.b %2,%0\";
       }
    }
  return \"add%.b %2,%0\";
}")

(define_insn ""
  [(set (strict_low_part (match_operand:QI 0 "general_operand" "+m,d"))
	(plus:QI (match_dup 0)
		 (match_operand:QI 1 "general_operand" "dn,dmn")))]
  ""
  "add%.b %1,%0")

(define_insn "adddf3"
  [(set (match_operand:DF 0 "general_operand" "=f")
	(plus:DF (match_operand:DF 1 "general_operand" "%0")
		 (match_operand:DF 2 "general_operand" "fmG")))]
  "TARGET_68881"
  "*
{
  if (REG_P (operands[2]))
    return \"fadd%.x %2,%0\";
  return \"fadd%.d %f2,%0\";
}")

(define_insn "addsf3"
  [(set (match_operand:SF 0 "general_operand" "=f")
	(plus:SF (match_operand:SF 1 "general_operand" "%0")
		 (match_operand:SF 2 "general_operand" "fdmF")))]
  "TARGET_68881"
  "*
{
  if (REG_P (operands[2]) && ! DATA_REG_P (operands[2]))
    return \"fadd%.x %2,%0\";
  return \"fadd%.s %f2,%0\";
}")

;; subtract instructions

(define_insn "subsi3"
  [(set (match_operand:SI 0 "general_operand" "=m,r,!a,?d")
	(minus:SI (match_operand:SI 1 "general_operand" "0,0,a,mrIKs")
		  (match_operand:SI 2 "general_operand" "dIKs,mrIKs,J,0")))]
  ""
  "*
{
  if (! operands_match_p (operands[0], operands[1]))
    {
      if (operands_match_p (operands[0], operands[2]))
	{
	  if (GET_CODE (operands[1]) == CONST_INT)
	    {
	      if (INTVAL (operands[1]) > 0
		  && INTVAL (operands[1]) <= 8)
		return \"subq%.l %1,%0\;neg%.l %0\";
	    }
	  return \"sub%.l %1,%0\;neg%.l %0\";
	}
      /* This case is matched by J, but negating -0x8000
         in an lea would give an invalid displacement.
	 So do this specially.  */
      if (INTVAL (operands[2]) == -0x8000)
	return \"move%.l %1,%0\;sub%.l %2,%0\";
#ifdef SGS
      return \"lea %n2(%1),%0\";
#else
#ifdef MOTOROLA
      return \"lea (%n2,%1),%0\";
#else /* not MOTOROLA (MIT syntax) */
      return \"lea %1@(%n2),%0\";
#endif /* not MOTOROLA */
#endif /* not SGS */
    }
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      if (INTVAL (operands[2]) > 0
	  && INTVAL (operands[2]) <= 8)
	return \"subq%.l %2,%0\";
      if (ADDRESS_REG_P (operands[0])
	  && INTVAL (operands[2]) >= -0x8000
	  && INTVAL (operands[2]) < 0x8000)
	return \"sub%.w %2,%0\";
    }
  return \"sub%.l %2,%0\";
}")

(define_insn ""
  [(set (match_operand:SI 0 "general_operand" "=a")
	(minus:SI (match_operand:SI 1 "general_operand" "0")
		  (sign_extend:SI (match_operand:HI 2 "general_operand" "rmn"))))]
  ""
  "sub%.w %2,%0")

(define_insn "subhi3"
  [(set (match_operand:HI 0 "general_operand" "=m,r")
	(minus:HI (match_operand:HI 1 "general_operand" "0,0")
		  (match_operand:HI 2 "general_operand" "dn,rmn")))]
  ""
  "sub%.w %2,%0")

(define_insn ""
  [(set (strict_low_part (match_operand:HI 0 "general_operand" "+m,d"))
	(minus:HI (match_dup 0)
		  (match_operand:HI 1 "general_operand" "dn,rmn")))]
  ""
  "sub%.w %1,%0")

(define_insn "subqi3"
  [(set (match_operand:QI 0 "general_operand" "=m,d")
	(minus:QI (match_operand:QI 1 "general_operand" "0,0")
		  (match_operand:QI 2 "general_operand" "dn,dmn")))]
  ""
  "sub%.b %2,%0")

(define_insn ""
  [(set (strict_low_part (match_operand:QI 0 "general_operand" "+m,d"))
	(minus:QI (match_dup 0)
		  (match_operand:QI 1 "general_operand" "dn,dmn")))]
  ""
  "sub%.b %1,%0")

(define_insn "subdf3"
  [(set (match_operand:DF 0 "general_operand" "=f")
	(minus:DF (match_operand:DF 1 "general_operand" "0")
		  (match_operand:DF 2 "general_operand" "fmG")))]
  "TARGET_68881"
  "*
{
  if (REG_P (operands[2]))
    return \"fsub%.x %2,%0\";
  return \"fsub%.d %f2,%0\";
}")

(define_insn "subsf3"
  [(set (match_operand:SF 0 "general_operand" "=f")
	(minus:SF (match_operand:SF 1 "general_operand" "0")
		  (match_operand:SF 2 "general_operand" "fdmF")))]
  "TARGET_68881"
  "*
{
  if (REG_P (operands[2]) && ! DATA_REG_P (operands[2]))
    return \"fsub%.x %2,%0\";
  return \"fsub%.s %f2,%0\";
}")

;; multiply instructions

(define_insn "mulhi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(mult:HI (match_operand:HI 1 "general_operand" "%0")
		 (match_operand:HI 2 "general_operand" "dmn")))]
  ""
  "*
{
#ifdef MOTOROLA
  return \"muls.w %2,%0\";
#else
  return \"muls %2,%0\";
#endif
}")

(define_insn "mulhisi3"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(mult:SI (match_operand:HI 1 "general_operand" "%0")
		 (match_operand:HI 2 "general_operand" "dmn")))]
  ""
  "*
{
#ifdef MOTOROLA
  return \"muls.w %2,%0\";
#else
  return \"muls %2,%0\";
#endif
}")

(define_insn "mulsi3"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(mult:SI (match_operand:SI 1 "general_operand" "%0")
		 (match_operand:SI 2 "general_operand" "dmsK")))]
  "TARGET_68020"
  "muls%.l %2,%0")

(define_insn "umulhi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(umult:HI (match_operand:HI 1 "general_operand" "%0")
		  (match_operand:HI 2 "general_operand" "dmn")))]
  ""
  "*
{
#ifdef MOTOROLA
  return \"mulu.w %2,%0\";
#else
  return \"mulu %2,%0\";
#endif
}")

(define_insn "umulhisi3"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(umult:SI (match_operand:HI 1 "general_operand" "%0")
		  (match_operand:HI 2 "general_operand" "dmn")))]
  ""
  "*
{
#ifdef MOTOROLA
  return \"mulu.w %2,%0\";
#else
  return \"mulu %2,%0\";
#endif
}")

(define_insn "umulsi3"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(umult:SI (match_operand:SI 1 "general_operand" "%0")
		  (match_operand:SI 2 "general_operand" "dmsK")))]
  "TARGET_68020"
  "mulu%.l %2,%0")

(define_insn "muldf3"
  [(set (match_operand:DF 0 "general_operand" "=f")
	(mult:DF (match_operand:DF 1 "general_operand" "%0")
		 (match_operand:DF 2 "general_operand" "fmG")))]
  "TARGET_68881"
  "*
{
  if (REG_P (operands[2]))
    return \"fmul%.x %2,%0\";
  return \"fmul%.d %f2,%0\";
}")

(define_insn "mulsf3"
  [(set (match_operand:SF 0 "general_operand" "=f")
	(mult:SF (match_operand:SF 1 "general_operand" "%0")
		 (match_operand:SF 2 "general_operand" "fdmF")))]
  "TARGET_68881"
  "*
{
  if (REG_P (operands[2]) && ! DATA_REG_P (operands[2]))
    return \"fsglmul%.x %2,%0\";
  return \"fsglmul%.s %f2,%0\";
}")

;; divide instructions

(define_insn "divhi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(div:HI (match_operand:HI 1 "general_operand" "0")
		(match_operand:HI 2 "general_operand" "dmn")))]
  ""
  "*
{
#ifdef MOTOROLA
  return \"ext.l %0\;divs.w %2,%0\";
#else
  return \"extl %0\;divs %2,%0\";
#endif
}")

(define_insn "divhisi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(div:HI (match_operand:SI 1 "general_operand" "0")
		(match_operand:HI 2 "general_operand" "dmn")))]
  ""
  "*
{
#ifdef MOTOROLA
  return \"divs.w %2,%0\";
#else
  return \"divs %2,%0\";
#endif
}")

(define_insn "divsi3"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(div:SI (match_operand:SI 1 "general_operand" "0")
		(match_operand:SI 2 "general_operand" "dmsK")))]
  "TARGET_68020"
  "divs%.l %2,%0")

(define_insn "udivhi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(udiv:HI (match_operand:HI 1 "general_operand" "0")
		 (match_operand:HI 2 "general_operand" "dmn")))]
  ""
  "*
{
#ifdef MOTOROLA
  return \"and.l %#0xFFFF,%0\;divu.w %2,%0\";
#else
  return \"andl %#0xFFFF,%0\;divu %2,%0\";
#endif
}")

(define_insn "udivhisi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(udiv:HI (match_operand:SI 1 "general_operand" "0")
		 (match_operand:HI 2 "general_operand" "dmn")))]
  ""
  "*
{
#ifdef MOTOROLA
  return \"divu.w %2,%0\";
#else
  return \"divu %2,%0\";
#endif
}")

(define_insn "udivsi3"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(udiv:SI (match_operand:SI 1 "general_operand" "0")
		 (match_operand:SI 2 "general_operand" "dmsK")))]
  "TARGET_68020"
  "divu%.l %2,%0")

(define_insn "divdf3"
  [(set (match_operand:DF 0 "general_operand" "=f")
	(div:DF (match_operand:DF 1 "general_operand" "0")
		(match_operand:DF 2 "general_operand" "fmG")))]
  "TARGET_68881"
  "*
{
  if (REG_P (operands[2]))
    return \"fdiv%.x %2,%0\";
  return \"fdiv%.d %f2,%0\";
}")

(define_insn "divsf3"
  [(set (match_operand:SF 0 "general_operand" "=f")
	(div:SF (match_operand:SF 1 "general_operand" "0")
		(match_operand:SF 2 "general_operand" "fdmF")))]
  "TARGET_68881"
  "*
{
  if (REG_P (operands[2]) && ! DATA_REG_P (operands[2]))
    return \"fsgldiv%.x %2,%0\";
  return \"fsgldiv%.s %f2,%0\";
}")

;; Remainder instructions.

(define_insn "modhi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(mod:HI (match_operand:HI 1 "general_operand" "0")
		(match_operand:HI 2 "general_operand" "dmn")))]
  ""
  "*
{
  /* The swap insn produces cc's that don't correspond to the result.  */
  CC_STATUS_INIT;
#ifdef MOTOROLA
  return \"ext.l %0\;divs.w %2,%0\;swap %0\";
#else
  return \"extl %0\;divs %2,%0\;swap %0\";
#endif
}")

(define_insn "modhisi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(mod:HI (match_operand:SI 1 "general_operand" "0")
		(match_operand:HI 2 "general_operand" "dmn")))]
  ""
  "*
{
  /* The swap insn produces cc's that don't correspond to the result.  */
  CC_STATUS_INIT;
#ifdef MOTOROLA
  return \"divs.w %2,%0\;swap %0\";
#else
  return \"divs %2,%0\;swap %0\";
#endif
}")

(define_insn "umodhi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(umod:HI (match_operand:HI 1 "general_operand" "0")
		 (match_operand:HI 2 "general_operand" "dmn")))]
  ""
  "*
{
  /* The swap insn produces cc's that don't correspond to the result.  */
  CC_STATUS_INIT;
#ifdef MOTOROLA
  return \"and.l %#0xFFFF,%0\;divu.w %2,%0\;swap %0\";
#else
  return \"andl %#0xFFFF,%0\;divu %2,%0\;swap %0\";
#endif
}")

(define_insn "umodhisi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(umod:HI (match_operand:SI 1 "general_operand" "0")
		 (match_operand:HI 2 "general_operand" "dmn")))]
  ""
  "*
{
  /* The swap insn produces cc's that don't correspond to the result.  */
  CC_STATUS_INIT;
#ifdef MOTOROLA
  return \"divu.w %2,%0\;swap %0\";
#else
  return \"divu %2,%0\;swap %0\";
#endif
}")

(define_insn "divmodsi4"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(div:SI (match_operand:SI 1 "general_operand" "0")
		(match_operand:SI 2 "general_operand" "dmsK")))
   (set (match_operand:SI 3 "general_operand" "=d")
	(mod:SI (match_dup 1) (match_dup 2)))]
  "TARGET_68020"
  "divsl%.l %2,%3:%0")

(define_insn "udivmodsi4"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(udiv:SI (match_operand:SI 1 "general_operand" "0")
		 (match_operand:SI 2 "general_operand" "dmsK")))
   (set (match_operand:SI 3 "general_operand" "=d")
	(umod:SI (match_dup 1) (match_dup 2)))]
  "TARGET_68020"
  "divul%.l %2,%3:%0")

;; logical-and instructions

(define_insn "andsi3"
  [(set (match_operand:SI 0 "general_operand" "=m,d")
	(and:SI (match_operand:SI 1 "general_operand" "%0,0")
		(match_operand:SI 2 "general_operand" "dKs,dmKs")))]
  ""
  "*
{
  if (GET_CODE (operands[2]) == CONST_INT
      && (INTVAL (operands[2]) | 0xffff) == 0xffffffff
      && (DATA_REG_P (operands[0])
	  || offsetable_memref_p (operands[0])))
    { 
      if (GET_CODE (operands[0]) != REG)
        operands[0] = adj_offsetable_operand (operands[0], 2);
      operands[2] = gen_rtx (CONST_INT, VOIDmode,
			     INTVAL (operands[2]) & 0xffff);
      /* Do not delete a following tstl %0 insn; that would be incorrect.  */
      CC_STATUS_INIT;
      return \"and%.w %2,%0\";
    }
  return \"and%.l %2,%0\";
}")

(define_insn "andhi3"
  [(set (match_operand:HI 0 "general_operand" "=m,d")
	(and:HI (match_operand:HI 1 "general_operand" "%0,0")
		(match_operand:HI 2 "general_operand" "dn,dmn")))]
  ""
  "and%.w %2,%0")

(define_insn "andqi3"
  [(set (match_operand:QI 0 "general_operand" "=m,d")
	(and:QI (match_operand:QI 1 "general_operand" "%0,0")
		(match_operand:QI 2 "general_operand" "dn,dmn")))]
  ""
  "and%.b %2,%0")

(define_insn ""
  [(set (match_operand:SI 0 "general_operand" "=d")
	(and:SI (zero_extend:SI (match_operand:HI 1 "general_operand" "dm"))
		(match_operand:SI 2 "general_operand" "0")))]
  "GET_CODE (operands[2]) == CONST_INT
   && (unsigned int) INTVAL (operands[2]) < (1 << GET_MODE_BITSIZE (HImode))"
  "and%.w %1,%0")

(define_insn ""
  [(set (match_operand:SI 0 "general_operand" "=d")
	(and:SI (zero_extend:SI (match_operand:QI 1 "general_operand" "dm"))
		(match_operand:SI 2 "general_operand" "0")))]
  "GET_CODE (operands[2]) == CONST_INT
   && (unsigned int) INTVAL (operands[2]) < (1 << GET_MODE_BITSIZE (QImode))"
  "and%.b %1,%0")

;; inclusive-or instructions

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "general_operand" "=m,d")
	(ior:SI (match_operand:SI 1 "general_operand" "%0,0")
		(match_operand:SI 2 "general_operand" "dKs,dmKs")))]
  ""
  "*
{
  register int logval;
  if (GET_CODE (operands[2]) == CONST_INT
      && INTVAL (operands[2]) >> 16 == 0
      && (DATA_REG_P (operands[0])
	  || offsetable_memref_p (operands[0])))
    { 
      if (GET_CODE (operands[0]) != REG)
        operands[0] = adj_offsetable_operand (operands[0], 2);
      /* Do not delete a following tstl %0 insn; that would be incorrect.  */
      CC_STATUS_INIT;
      return \"or%.w %2,%0\";
    }
  if (GET_CODE (operands[2]) == CONST_INT
      && (logval = exact_log2 (INTVAL (operands[2]))) >= 0
      && (DATA_REG_P (operands[0])
	  || offsetable_memref_p (operands[0])))
    { 
      if (DATA_REG_P (operands[0]))
	{
	  operands[1] = gen_rtx (CONST_INT, VOIDmode, logval);
	}
      else
        {
	  operands[0] = adj_offsetable_operand (operands[0], 3 - (logval / 8));
	  operands[1] = gen_rtx (CONST_INT, VOIDmode, logval % 8);
	}
      return \"bset %1,%0\";
    }
  return \"or%.l %2,%0\";
}")

(define_insn "iorhi3"
  [(set (match_operand:HI 0 "general_operand" "=m,d")
	(ior:HI (match_operand:HI 1 "general_operand" "%0,0")
		(match_operand:HI 2 "general_operand" "dn,dmn")))]
  ""
  "or%.w %2,%0")

(define_insn "iorqi3"
  [(set (match_operand:QI 0 "general_operand" "=m,d")
	(ior:QI (match_operand:QI 1 "general_operand" "%0,0")
		(match_operand:QI 2 "general_operand" "dn,dmn")))]
  ""
  "or%.b %2,%0")

;; xor instructions

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "general_operand" "=do,m")
	(xor:SI (match_operand:SI 1 "general_operand" "%0,0")
		(match_operand:SI 2 "general_operand" "di,dKs")))]
  ""
  "*
{
  if (GET_CODE (operands[2]) == CONST_INT
      && INTVAL (operands[2]) >> 16 == 0
      && (offsetable_memref_p (operands[0]) || DATA_REG_P (operands[0])))
    { 
      if (! DATA_REG_P (operands[0]))
	operands[0] = adj_offsetable_operand (operands[0], 2);
      /* Do not delete a following tstl %0 insn; that would be incorrect.  */
      CC_STATUS_INIT;
      return \"eor%.w %2,%0\";
    }
  return \"eor%.l %2,%0\";
}")

(define_insn "xorhi3"
  [(set (match_operand:HI 0 "general_operand" "=dm")
	(xor:HI (match_operand:HI 1 "general_operand" "%0")
		(match_operand:HI 2 "general_operand" "dn")))]
  ""
  "eor%.w %2,%0")

(define_insn "xorqi3"
  [(set (match_operand:QI 0 "general_operand" "=dm")
	(xor:QI (match_operand:QI 1 "general_operand" "%0")
		(match_operand:QI 2 "general_operand" "dn")))]
  ""
  "eor%.b %2,%0")

;; negation instructions

(define_insn "negsi2"
  [(set (match_operand:SI 0 "general_operand" "=dm")
	(neg:SI (match_operand:SI 1 "general_operand" "0")))]
  ""
  "neg%.l %0")

(define_insn "neghi2"
  [(set (match_operand:HI 0 "general_operand" "=dm")
	(neg:HI (match_operand:HI 1 "general_operand" "0")))]
  ""
  "neg%.w %0")

(define_insn "negqi2"
  [(set (match_operand:QI 0 "general_operand" "=dm")
	(neg:QI (match_operand:QI 1 "general_operand" "0")))]
  ""
  "neg%.b %0")

(define_insn "negsf2"
  [(set (match_operand:SF 0 "general_operand" "=f")
	(neg:SF (match_operand:SF 1 "general_operand" "fdmF")))]
  "TARGET_68881"
  "*
{
  if (REG_P (operands[1]) && ! DATA_REG_P (operands[1]))
    return \"fneg%.x %1,%0\";
  return \"fneg%.s %f1,%0\";
}")

(define_insn "negdf2"
  [(set (match_operand:DF 0 "general_operand" "=f")
	(neg:DF (match_operand:DF 1 "general_operand" "fmF")))]
  "TARGET_68881"
  "*
{
  if (REG_P (operands[1]) && ! DATA_REG_P (operands[1]))
    return \"fneg%.x %1,%0\";
  return \"fneg%.d %f1,%0\";
}")

;; Absolute value instructions

(define_insn "abssf2"
  [(set (match_operand:SF 0 "general_operand" "=f")
	(abs:SF (match_operand:SF 1 "general_operand" "fdmF")))]
  "TARGET_68881"
  "*
{
  if (REG_P (operands[1]) && ! DATA_REG_P (operands[1]))
    return \"fabs%.x %1,%0\";
  return \"fabs%.s %f1,%0\";
}")

(define_insn "absdf2"
  [(set (match_operand:DF 0 "general_operand" "=f")
	(abs:DF (match_operand:DF 1 "general_operand" "fmF")))]
  "TARGET_68881"
  "*
{
  if (REG_P (operands[1]) && ! DATA_REG_P (operands[1]))
    return \"fabs%.x %1,%0\";
  return \"fabs%.d %f1,%0\";
}")

;; one complement instructions

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "general_operand" "=dm")
	(not:SI (match_operand:SI 1 "general_operand" "0")))]
  ""
  "not%.l %0")

(define_insn "one_cmplhi2"
  [(set (match_operand:HI 0 "general_operand" "=dm")
	(not:HI (match_operand:HI 1 "general_operand" "0")))]
  ""
  "not%.w %0")

(define_insn "one_cmplqi2"
  [(set (match_operand:QI 0 "general_operand" "=dm")
	(not:QI (match_operand:QI 1 "general_operand" "0")))]
  ""
  "not%.b %0")

;; Optimized special case of shifting.
;; Must precede the general case.

(define_insn ""
  [(set (match_operand:SI 0 "general_operand" "=d")
	(ashiftrt:SI (match_operand:SI 1 "memory_operand" "m")
		     (const_int 24)))]
  ""
  "*
{
  if (TARGET_68020)
    return \"move%.b %1,%0\;extb%.l %0\";
  return \"move%.b %1,%0\;ext%.w %0\;ext%.l %0\";
}")

(define_insn ""
  [(set (match_operand:SI 0 "general_operand" "=d")
	(lshiftrt:SI (match_operand:SI 1 "memory_operand" "m")
		     (const_int 24)))]
  ""
  "*
{
  if (reg_mentioned_p (operands[0], operands[1]))
    return \"move%.b %1,%0\;and%.l %#0xFF,%0\";
  return \"clr%.l %0\;move%.b %1,%0\";
}")

(define_insn ""
  [(set (cc0) (minus (match_operand:QI 0 "general_operand" "i")
		     (lshiftrt:SI (match_operand:SI 1 "memory_operand" "m")
				  (const_int 24))))]
  "(GET_CODE (operands[0]) == CONST_INT
    && (INTVAL (operands[0]) & ~0xff) == 0)"
  "* cc_status.flags |= CC_REVERSED;
#ifdef HPUX_ASM
  return \"cmp%.b %1,%0\";
#else
  return \"cmp%.b %0,%1\";
#endif
")

(define_insn ""
  [(set (cc0) (minus (lshiftrt:SI (match_operand:SI 0 "memory_operand" "m")
				  (const_int 24))
		     (match_operand:QI 1 "general_operand" "i")))]
  "(GET_CODE (operands[1]) == CONST_INT
    && (INTVAL (operands[1]) & ~0xff) == 0)"
  "*
#ifdef HPUX_ASM
  return \"cmp%.b %0,%1\";
#else
  return \"cmp%.b %1,%0\";
#endif
")

(define_insn ""
  [(set (cc0) (minus (match_operand:QI 0 "general_operand" "i")
		     (ashiftrt:SI (match_operand:SI 1 "memory_operand" "m")
				  (const_int 24))))]
  "(GET_CODE (operands[0]) == CONST_INT
    && ((INTVAL (operands[0]) + 0x80) & ~0xff) == 0)"
  "* cc_status.flags |= CC_REVERSED;
#ifdef HPUX_ASM
  return \"cmp%.b %1,%0\";
#else
  return \"cmp%.b %0,%1\";
#endif
")

(define_insn ""
  [(set (cc0) (minus (ashiftrt:SI (match_operand:SI 0 "memory_operand" "m")
				  (const_int 24))
		     (match_operand:QI 1 "general_operand" "i")))]
  "(GET_CODE (operands[1]) == CONST_INT
    && ((INTVAL (operands[1]) + 0x80) & ~0xff) == 0)"
  "*
#ifdef HPUX_ASM
  return \"cmp%.b %0,%1\";
#else
  return \"cmp%.b %1,%0\";
#endif
")

;; arithmetic shift instructions
;; We don't need the shift memory by 1 bit instruction

(define_insn "ashlsi3"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(ashift:SI (match_operand:SI 1 "general_operand" "0")
		   (match_operand:SI 2 "general_operand" "dI")))]
  ""
  "asl%.l %2,%0")

(define_insn "ashlhi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(ashift:HI (match_operand:HI 1 "general_operand" "0")
		   (match_operand:HI 2 "general_operand" "dI")))]
  ""
  "asl%.w %2,%0")

(define_insn "ashlqi3"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(ashift:QI (match_operand:QI 1 "general_operand" "0")
		   (match_operand:QI 2 "general_operand" "dI")))]
  ""
  "asl%.b %2,%0")

(define_insn "ashrsi3"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(ashiftrt:SI (match_operand:SI 1 "general_operand" "0")
		     (match_operand:SI 2 "general_operand" "dI")))]
  ""
  "asr%.l %2,%0")

(define_insn "ashrhi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(ashiftrt:HI (match_operand:HI 1 "general_operand" "0")
		     (match_operand:HI 2 "general_operand" "dI")))]
  ""
  "asr%.w %2,%0")

(define_insn "ashrqi3"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(ashiftrt:QI (match_operand:QI 1 "general_operand" "0")
		     (match_operand:QI 2 "general_operand" "dI")))]
  ""
  "asr%.b %2,%0")

;; logical shift instructions

(define_insn "lshlsi3"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(lshift:SI (match_operand:SI 1 "general_operand" "0")
		   (match_operand:SI 2 "general_operand" "dI")))]
  ""
  "lsl%.l %2,%0")

(define_insn "lshlhi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(lshift:HI (match_operand:HI 1 "general_operand" "0")
		   (match_operand:HI 2 "general_operand" "dI")))]
  ""
  "lsl%.w %2,%0")

(define_insn "lshlqi3"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(lshift:QI (match_operand:QI 1 "general_operand" "0")
		   (match_operand:QI 2 "general_operand" "dI")))]
  ""
  "lsl%.b %2,%0")

(define_insn "lshrsi3"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(lshiftrt:SI (match_operand:SI 1 "general_operand" "0")
		     (match_operand:SI 2 "general_operand" "dI")))]
  ""
  "lsr%.l %2,%0")

(define_insn "lshrhi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(lshiftrt:HI (match_operand:HI 1 "general_operand" "0")
		     (match_operand:HI 2 "general_operand" "dI")))]
  ""
  "lsr%.w %2,%0")

(define_insn "lshrqi3"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(lshiftrt:QI (match_operand:QI 1 "general_operand" "0")
		     (match_operand:QI 2 "general_operand" "dI")))]
  ""
  "lsr%.b %2,%0")

;; rotate instructions

(define_insn "rotlsi3"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(rotate:SI (match_operand:SI 1 "general_operand" "0")
		   (match_operand:SI 2 "general_operand" "dI")))]
  ""
  "rol%.l %2,%0")

(define_insn "rotlhi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(rotate:HI (match_operand:HI 1 "general_operand" "0")
		   (match_operand:HI 2 "general_operand" "dI")))]
  ""
  "rol%.w %2,%0")

(define_insn "rotlqi3"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(rotate:QI (match_operand:QI 1 "general_operand" "0")
		   (match_operand:QI 2 "general_operand" "dI")))]
  ""
  "rol%.b %2,%0")

(define_insn "rotrsi3"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(rotatert:SI (match_operand:SI 1 "general_operand" "0")
		     (match_operand:SI 2 "general_operand" "dI")))]
  ""
  "ror%.l %2,%0")

(define_insn "rotrhi3"
  [(set (match_operand:HI 0 "general_operand" "=d")
	(rotatert:HI (match_operand:HI 1 "general_operand" "0")
		     (match_operand:HI 2 "general_operand" "dI")))]
  ""
  "ror%.w %2,%0")

(define_insn "rotrqi3"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(rotatert:QI (match_operand:QI 1 "general_operand" "0")
		     (match_operand:QI 2 "general_operand" "dI")))]
  ""
  "ror%.b %2,%0")

;; Special cases of bit-field insns which we should
;; recognize in preference to the general case.
;; These handle aligned 8-bit and 16-bit fields,
;; which can usually be done with move instructions.

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "general_operand" "+do")
			 (match_operand:SI 1 "immediate_operand" "i")
			 (match_operand:SI 2 "immediate_operand" "i"))
	(match_operand:SI 3 "general_operand" "d"))]
  "TARGET_68020 && TARGET_BITFIELD
   && GET_CODE (operands[1]) == CONST_INT
   && (INTVAL (operands[1]) == 8 || INTVAL (operands[1]) == 16)
   && GET_CODE (operands[2]) == CONST_INT
   && INTVAL (operands[2]) % INTVAL (operands[1]) == 0
   && (GET_CODE (operands[0]) == REG
       || ! mode_dependent_address_p (XEXP (operands[0], 0)))"
  "*
{
  if (REG_P (operands[0]))
    {
      if (INTVAL (operands[1]) + INTVAL (operands[2]) != 32)
        return \"bfins %3,%0{%b2:%b1}\";
    }
  else
    operands[0]
      = adj_offsetable_operand (operands[0], INTVAL (operands[2]) / 8);

  if (GET_CODE (operands[3]) == MEM)
    operands[3] = adj_offsetable_operand (operands[3],
					  (32 - INTVAL (operands[1])) / 8);
  if (INTVAL (operands[1]) == 8)
    return \"move%.b %3,%0\";
  return \"move%.w %3,%0\";
}")

(define_insn ""
  [(set (match_operand:SI 0 "general_operand" "=&d")
	(zero_extract:SI (match_operand:SI 1 "general_operand" "do")
			 (match_operand:SI 2 "immediate_operand" "i")
			 (match_operand:SI 3 "immediate_operand" "i")))]
  "TARGET_68020 && TARGET_BITFIELD
   && GET_CODE (operands[2]) == CONST_INT
   && (INTVAL (operands[2]) == 8 || INTVAL (operands[2]) == 16)
   && GET_CODE (operands[3]) == CONST_INT
   && INTVAL (operands[3]) % INTVAL (operands[2]) == 0
   && (GET_CODE (operands[1]) == REG
       || ! mode_dependent_address_p (XEXP (operands[1], 0)))"
  "*
{
  if (REG_P (operands[1]))
    {
      if (INTVAL (operands[2]) + INTVAL (operands[3]) != 32)
	return \"bfextu %1{%b3:%b2},%0\";
    }
  else
    operands[1]
      = adj_offsetable_operand (operands[1], INTVAL (operands[3]) / 8);

  output_asm_insn (\"clr%.l %0\", operands);
  if (GET_CODE (operands[0]) == MEM)
    operands[0] = adj_offsetable_operand (operands[0],
					  (32 - INTVAL (operands[1])) / 8);
  if (INTVAL (operands[2]) == 8)
    return \"move%.b %1,%0\";
  return \"move%.w %1,%0\";
}")

(define_insn ""
  [(set (match_operand:SI 0 "general_operand" "=d")
	(sign_extract:SI (match_operand:SI 1 "general_operand" "do")
			 (match_operand:SI 2 "immediate_operand" "i")
			 (match_operand:SI 3 "immediate_operand" "i")))]
  "TARGET_68020 && TARGET_BITFIELD
   && GET_CODE (operands[2]) == CONST_INT
   && (INTVAL (operands[2]) == 8 || INTVAL (operands[2]) == 16)
   && GET_CODE (operands[3]) == CONST_INT
   && INTVAL (operands[3]) % INTVAL (operands[2]) == 0
   && (GET_CODE (operands[1]) == REG
       || ! mode_dependent_address_p (XEXP (operands[1], 0)))"
  "*
{
  if (REG_P (operands[1]))
    {
      if (INTVAL (operands[2]) + INTVAL (operands[3]) != 32)
	return \"bfexts %1{%b3:%b2},%0\";
    }
  else
    operands[1]
      = adj_offsetable_operand (operands[1], INTVAL (operands[3]) / 8);

  if (INTVAL (operands[2]) == 8)
    return \"move%.b %1,%0\;extb%.l %0\";
  return \"move%.w %1,%0\;ext%.l %0\";
}")

;; Bit field instructions, general cases.
;; "o,d" constraint causes a nonoffsetable memref to match the "o"
;; so that its address is reloaded.

(define_insn "extv"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(sign_extract:SI (match_operand:QI 1 "general_operand" "o,d")
			 (match_operand:SI 2 "general_operand" "di,di")
			 (match_operand:SI 3 "general_operand" "di,di")))]
  "TARGET_68020 && TARGET_BITFIELD"
  "bfexts %1{%b3:%b2},%0")

(define_insn "extzv"
  [(set (match_operand:SI 0 "general_operand" "=d")
	(zero_extract:SI (match_operand:QI 1 "general_operand" "o,d")
			 (match_operand:SI 2 "general_operand" "di,di")
			 (match_operand:SI 3 "general_operand" "di,di")))]
  "TARGET_68020 && TARGET_BITFIELD"
  "bfextu %1{%b3:%b2},%0")

(define_insn ""
  [(set (zero_extract:SI (match_operand:QI 0 "general_operand" "+o,d")
			 (match_operand:SI 1 "general_operand" "di,di")
			 (match_operand:SI 2 "general_operand" "di,di"))
        (xor:SI (zero_extract:SI (match_dup 0) (match_dup 1) (match_dup 2))
		(match_operand 3 "immediate_operand" "i")))]
  "TARGET_68020 && TARGET_BITFIELD
   && GET_CODE (operands[3]) == CONST_INT
   && (INTVAL (operands[3]) == -1
       || (GET_CODE (operands[1]) == CONST_INT
           && (~ INTVAL (operands[3]) & ((1 << INTVAL (operands[1]))- 1)) == 0))"
  "bfchg %0{%b2:%b1}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:QI 0 "general_operand" "+o,d")
			 (match_operand:SI 1 "general_operand" "di,di")
			 (match_operand:SI 2 "general_operand" "di,di"))
	(const_int 0))]
  "TARGET_68020 && TARGET_BITFIELD"
  "bfclr %0{%b2:%b1}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:QI 0 "general_operand" "+o,d")
			 (match_operand:SI 1 "general_operand" "di,di")
			 (match_operand:SI 2 "general_operand" "di,di"))
	(const_int -1))]
  "TARGET_68020 && TARGET_BITFIELD"
  "bfset %0{%b2:%b1}")

(define_insn "insv"
  [(set (zero_extract:SI (match_operand:QI 0 "general_operand" "+o,d")
			 (match_operand:SI 1 "general_operand" "di,di")
			 (match_operand:SI 2 "general_operand" "di,di"))
	(match_operand:SI 3 "general_operand" "d"))]
  "TARGET_68020 && TARGET_BITFIELD"
  "bfins %3,%0{%b2:%b1}")

;; Now recognize bit field insns that operate on registers
;; (or at least were intended to do so).

(define_insn ""
  [(set (match_operand:SI 0 "general_operand" "=d")
	(sign_extract:SI (match_operand:SI 1 "general_operand" "d")
			 (match_operand:SI 2 "general_operand" "di")
			 (match_operand:SI 3 "general_operand" "di")))]
  "TARGET_68020 && TARGET_BITFIELD"
  "bfexts %1{%b3:%b2},%0")

(define_insn ""
  [(set (match_operand:SI 0 "general_operand" "=d")
	(zero_extract:SI (match_operand:SI 1 "general_operand" "d")
			 (match_operand:SI 2 "general_operand" "di")
			 (match_operand:SI 3 "general_operand" "di")))]
  "TARGET_68020 && TARGET_BITFIELD"
  "bfextu %1{%b3:%b2},%0")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "general_operand" "+d")
			 (match_operand:SI 1 "general_operand" "di")
			 (match_operand:SI 2 "general_operand" "di"))
	(const_int 0))]
  "TARGET_68020 && TARGET_BITFIELD"
  "bfclr %0{%b2:%b1}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "general_operand" "+d")
			 (match_operand:SI 1 "general_operand" "di")
			 (match_operand:SI 2 "general_operand" "di"))
	(const_int -1))]
  "TARGET_68020 && TARGET_BITFIELD"
  "bfset %0{%b2:%b1}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "general_operand" "+d")
			 (match_operand:SI 1 "general_operand" "di")
			 (match_operand:SI 2 "general_operand" "di"))
	(match_operand:SI 3 "general_operand" "d"))]
  "TARGET_68020 && TARGET_BITFIELD"
  "*
{
#if 0
  /* These special cases are now recognized by a specific pattern.  */
  if (GET_CODE (operands[1]) == CONST_INT && GET_CODE (operands[2]) == CONST_INT
      && INTVAL (operands[1]) == 16 && INTVAL (operands[2]) == 16)
    return \"move%.w %3,%0\";
  if (GET_CODE (operands[1]) == CONST_INT && GET_CODE (operands[2]) == CONST_INT
      && INTVAL (operands[1]) == 24 && INTVAL (operands[2]) == 8)
    return \"move%.b %3,%0\";
#endif
  return \"bfins %3,%0{%b2:%b1}\";
}")

;; Special patterns for optimizing bit-field instructions.

(define_insn ""
  [(set (cc0)
	(zero_extract:SI (match_operand:QI 0 "memory_operand" "o")
			 (match_operand:SI 1 "general_operand" "di")
			 (match_operand:SI 2 "general_operand" "di")))]
  "TARGET_68020 && TARGET_BITFIELD
   && GET_CODE (operands[1]) == CONST_INT"
  "*
{
  if (operands[1] == const1_rtx
      && GET_CODE (operands[2]) == CONST_INT)
    {    
      int width = GET_CODE (operands[0]) == REG ? 31 : 7;
      return output_btst (operands,
			  gen_rtx (CONST_INT, VOIDmode,
				   width - INTVAL (operands[2])),
			  operands[0],
			  insn, 1000);
      /* Pass 1000 as SIGNPOS argument so that btst will
         not think we are testing the sign bit for an `and'
	 and assume that nonzero implies a negative result.  */
    }
  if (INTVAL (operands[1]) != 32)
    cc_status.flags = CC_NOT_NEGATIVE;
  return \"bftst %0{%b2:%b1}\";
}")

(define_insn ""
  [(set (cc0)
	(subreg:QI
	 (zero_extract:SI (match_operand:QI 0 "memory_operand" "o")
			  (match_operand:SI 1 "general_operand" "di")
			  (match_operand:SI 2 "general_operand" "di"))
	 0))]
  "TARGET_68020 && TARGET_BITFIELD
   && GET_CODE (operands[1]) == CONST_INT"
  "*
{
  if (operands[1] == const1_rtx
      && GET_CODE (operands[2]) == CONST_INT)
    {    
      int width = GET_CODE (operands[0]) == REG ? 31 : 7;
      return output_btst (operands,
			  gen_rtx (CONST_INT, VOIDmode,
				   width - INTVAL (operands[2])),
			  operands[0],
			  insn, 1000);
      /* Pass 1000 as SIGNPOS argument so that btst will
         not think we are testing the sign bit for an `and'
	 and assume that nonzero implies a negative result.  */
    }
  if (INTVAL (operands[1]) != 32)
    cc_status.flags = CC_NOT_NEGATIVE;
  return \"bftst %0{%b2:%b1}\";
}")

(define_insn ""
  [(set (cc0)
	(subreg:HI
	 (zero_extract:SI (match_operand:QI 0 "memory_operand" "o")
			  (match_operand:SI 1 "general_operand" "di")
			  (match_operand:SI 2 "general_operand" "di"))
	 0))]
  "TARGET_68020 && TARGET_BITFIELD
   && GET_CODE (operands[1]) == CONST_INT"
  "*
{
  if (operands[1] == const1_rtx
      && GET_CODE (operands[2]) == CONST_INT)
    {    
      int width = GET_CODE (operands[0]) == REG ? 31 : 7;
      return output_btst (operands,
			  gen_rtx (CONST_INT, VOIDmode,
				   width - INTVAL (operands[2])),
			  operands[0],
			  insn, 1000);
      /* Pass 1000 as SIGNPOS argument so that btst will
         not think we are testing the sign bit for an `and'
	 and assume that nonzero implies a negative result.  */
    }
  if (INTVAL (operands[1]) != 32)
    cc_status.flags = CC_NOT_NEGATIVE;
  return \"bftst %0{%b2:%b1}\";
}")
  
;;; now handle the register cases
(define_insn ""
  [(set (cc0)
	(zero_extract:SI (match_operand:SI 0 "general_operand" "d")
			 (match_operand:SI 1 "general_operand" "di")
			 (match_operand:SI 2 "general_operand" "di")))]
  "TARGET_68020 && TARGET_BITFIELD
   && GET_CODE (operands[1]) == CONST_INT"
  "*
{
  if (operands[1] == const1_rtx
      && GET_CODE (operands[2]) == CONST_INT)
    {    
      int width = GET_CODE (operands[0]) == REG ? 31 : 7;
      return output_btst (operands,
			  gen_rtx (CONST_INT, VOIDmode,
				   width - INTVAL (operands[2])),
			  operands[0],
			  insn, 1000);
      /* Pass 1000 as SIGNPOS argument so that btst will
         not think we are testing the sign bit for an `and'
	 and assume that nonzero implies a negative result.  */
    }
  if (INTVAL (operands[1]) != 32)
    cc_status.flags = CC_NOT_NEGATIVE;
  return \"bftst %0{%b2:%b1}\";
}")

(define_insn ""
  [(set (cc0)
	(subreg:QI
	 (zero_extract:SI (match_operand:SI 0 "general_operand" "d")
			  (match_operand:SI 1 "general_operand" "di")
			  (match_operand:SI 2 "general_operand" "di"))
	 0))]
  "TARGET_68020 && TARGET_BITFIELD
   && GET_CODE (operands[1]) == CONST_INT"
  "*
{
  if (operands[1] == const1_rtx
      && GET_CODE (operands[2]) == CONST_INT)
    {    
      int width = GET_CODE (operands[0]) == REG ? 31 : 7;
      return output_btst (operands,
			  gen_rtx (CONST_INT, VOIDmode,
				   width - INTVAL (operands[2])),
			  operands[0],
			  insn, 1000);
      /* Pass 1000 as SIGNPOS argument so that btst will
         not think we are testing the sign bit for an `and'
	 and assume that nonzero implies a negative result.  */
    }
  if (INTVAL (operands[1]) != 32)
    cc_status.flags = CC_NOT_NEGATIVE;
  return \"bftst %0{%b2:%b1}\";
}")

(define_insn ""
  [(set (cc0)
	(subreg:HI
	 (zero_extract:SI (match_operand:SI 0 "general_operand" "d")
			  (match_operand:SI 1 "general_operand" "di")
			  (match_operand:SI 2 "general_operand" "di"))
	 0))]
  "TARGET_68020 && TARGET_BITFIELD
   && GET_CODE (operands[1]) == CONST_INT"
  "*
{
  if (operands[1] == const1_rtx
      && GET_CODE (operands[2]) == CONST_INT)
    {    
      int width = GET_CODE (operands[0]) == REG ? 31 : 7;
      return output_btst (operands,
			  gen_rtx (CONST_INT, VOIDmode,
				   width - INTVAL (operands[2])),
			  operands[0],
			  insn, 1000);
      /* Pass 1000 as SIGNPOS argument so that btst will
         not think we are testing the sign bit for an `and'
	 and assume that nonzero implies a negative result.  */
    }
  if (INTVAL (operands[1]) != 32)
    cc_status.flags = CC_NOT_NEGATIVE;
  return \"bftst %0{%b2:%b1}\";
}")

(define_insn "seq"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(eq (cc0) (const_int 0)))]
  ""
  "*
  cc_status = cc_prev_status;
  if (cc_status.flags & CC_Z_IN_NOT_N)
    return \"spl %0\";
  OUTPUT_JUMP (\"seq %0\", \"fseq %0\", \"seq %0\");
")

(define_insn "sne"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(ne (cc0) (const_int 0)))]
  ""
  "*
  cc_status = cc_prev_status;
  if (cc_status.flags & CC_Z_IN_NOT_N)
    return \"smi %0\";
  OUTPUT_JUMP (\"sne %0\", \"fsne %0\", \"sne %0\");
")

(define_insn "sgt"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(gt (cc0) (const_int 0)))]
  ""
  "*
  cc_status = cc_prev_status;
  OUTPUT_JUMP (\"sgt %0\", \"fsgt %0\", \"and%.b %#0xc,%!\;sgt %0\");
")

(define_insn "sgtu"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(gtu (cc0) (const_int 0)))]
  ""
  "* cc_status = cc_prev_status;
     return \"shi %0\"; ")

(define_insn "slt"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(lt (cc0) (const_int 0)))]
  ""
  "* cc_status = cc_prev_status;
     OUTPUT_JUMP (\"slt %0\", \"fslt %0\", \"smi %0\"); ")

(define_insn "sltu"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(ltu (cc0) (const_int 0)))]
  ""
  "* cc_status = cc_prev_status;
     return \"scs %0\"; ")

(define_insn "sge"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(ge (cc0) (const_int 0)))]
  ""
  "* cc_status = cc_prev_status;
     OUTPUT_JUMP (\"sge %0\", \"fsge %0\", \"spl %0\"); ")

(define_insn "sgeu"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(geu (cc0) (const_int 0)))]
  ""
  "* cc_status = cc_prev_status;
     return \"scc %0\"; ")

(define_insn "sle"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(le (cc0) (const_int 0)))]
  ""
  "*
  cc_status = cc_prev_status;
  OUTPUT_JUMP (\"sle %0\", \"fsle %0\", \"and%.b %#0xc,%!\;sle %0\");
")

(define_insn "sleu"
  [(set (match_operand:QI 0 "general_operand" "=d")
	(leu (cc0) (const_int 0)))]
  ""
  "* cc_status = cc_prev_status;
     return \"sls %0\"; ")

;; Basic conditional jump instructions.

(define_insn "beq"
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  if (cc_status.flags & CC_Z_IN_NOT_N)
#ifdef MOTOROLA
    return \"jbpl %l0\";
#else
    return \"jpl %l0\";
#endif
#ifdef MOTOROLA
  OUTPUT_JUMP (\"jbeq %l0\", \"fbeq %l0\", \"jbeq %l0\");
#else
  OUTPUT_JUMP (\"jeq %l0\", \"fjeq %l0\", \"jeq %l0\");
#endif
}")

(define_insn "bne"
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  if (cc_status.flags & CC_Z_IN_NOT_N)
#ifdef MOTOROLA
    return \"jbmi %l0\";
#else
    return \"jmi %l0\";
#endif
#ifdef MOTOROLA
  OUTPUT_JUMP (\"jbne %l0\", \"fbne %l0\", \"jbne %l0\");
#else
  OUTPUT_JUMP (\"jne %l0\", \"fjne %l0\", \"jne %l0\");
#endif
}")

(define_insn "bgt"
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
#ifdef MOTOROLA
  OUTPUT_JUMP (\"jbgt %l0\", \"fbgt %l0\", \"and%.b %#0xc,%!\;jbgt %l0\");
#else
  OUTPUT_JUMP (\"jgt %l0\", \"fjgt %l0\", \"andb %#0xc,%!\;jgt %l0\");
#endif
")

(define_insn "bgtu"
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
#ifdef MOTOROLA
  return \"jbhi %l0\";
#else
  return \"jhi %l0\";
#endif
")

(define_insn "blt"
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
#ifdef MOTOROLA
  OUTPUT_JUMP (\"jblt %l0\", \"fblt %l0\", \"jbmi %l0\");
#else
  OUTPUT_JUMP (\"jlt %l0\", \"fjlt %l0\", \"jmi %l0\");
#endif
")

(define_insn "bltu"
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
#ifdef MOTOROLA
  return \"jbcs %l0\";
#else
  return \"jcs %l0\";
#endif
")

(define_insn "bge"
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
#ifdef MOTOROLA
  OUTPUT_JUMP (\"jbge %l0\", \"fbge %l0\", \"jbpl %l0\");
#else
  OUTPUT_JUMP (\"jge %l0\", \"fjge %l0\", \"jpl %l0\");
#endif
")

(define_insn "bgeu"
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
#ifdef MOTOROLA
  return \"jbcc %l0\";
#else
  return \"jcc %l0\";
#endif
")

(define_insn "ble"
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
#ifdef MOTOROLA
  OUTPUT_JUMP (\"jble %l0\", \"fble %l0\", \"and%.b %#0xc,%!\;jble %l0\");
#else
  OUTPUT_JUMP (\"jle %l0\", \"fjle %l0\", \"and%.b %#0xc,%!\;jle %l0\");
#endif
")

(define_insn "bleu"
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
#ifdef MOTOROLA
  return \"jbls %l0\";
#else
  return \"jls %l0\";
#endif
")

;; Negated conditional jump instructions.

(define_insn ""
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  if (cc_status.flags & CC_Z_IN_NOT_N)
#ifdef MOTOROLA
    return \"jbmi %l0\";
#else
    return \"jmi %l0\";
#endif
#ifdef MOTOROLA
  OUTPUT_JUMP (\"jbne %l0\", \"fbne %l0\", \"jbne %l0\");
#else
  OUTPUT_JUMP (\"jne %l0\", \"fjne %l0\", \"jne %l0\");
#endif
}")

(define_insn ""
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  if (cc_status.flags & CC_Z_IN_NOT_N)
#ifdef MOTOROLA
    return \"jbpl %l0\";
#else
    return \"jpl %l0\";
#endif
#ifdef MOTOROLA
  OUTPUT_JUMP (\"jbeq %l0\", \"fbeq %l0\", \"jbeq %l0\");
#else
  OUTPUT_JUMP (\"jeq %l0\", \"fjeq %l0\", \"jeq %l0\");
#endif
}")

(define_insn ""
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
#ifdef MOTOROLA
  OUTPUT_JUMP (\"jble %l0\", \"fbngt %l0\", \"and%.b %#0xc,%!\;jble %l0\");
#else
  OUTPUT_JUMP (\"jle %l0\", \"fjngt %l0\", \"and%.b %#0xc,%!\;jle %l0\");
#endif
")

(define_insn ""
  [(set (pc)
	(if_then_else (gtu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
#ifdef MOTOROLA
  return \"jbls %l0\";
#else
  return \"jls %l0\";
#endif
")

(define_insn ""
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
#ifdef MOTOROLA
  OUTPUT_JUMP (\"jbge %l0\", \"fbnlt %l0\", \"jbpl %l0\");
#else
  OUTPUT_JUMP (\"jge %l0\", \"fjnlt %l0\", \"jpl %l0\");
#endif
")

(define_insn ""
  [(set (pc)
	(if_then_else (ltu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
#ifdef MOTOROLA
  return \"jbcc %l0\";
#else
  return \"jcc %l0\";
#endif
")

(define_insn ""
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
#ifdef MOTOROLA
  OUTPUT_JUMP (\"jblt %l0\", \"fbnge %l0\", \"jbmi %l0\");
#else
  OUTPUT_JUMP (\"jlt %l0\", \"fjnge %l0\", \"jmi %l0\");
#endif
")

(define_insn ""
  [(set (pc)
	(if_then_else (geu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
#ifdef MOTOROLA
  return \"jbcs %l0\";
#else
  return \"jcs %l0\";
#endif
")

(define_insn ""
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
#ifdef MOTOROLA
  OUTPUT_JUMP (\"jbgt %l0\", \"fbnle %l0\", \"and%.b %#0xc,%!\;jbgt %l0\");
#else
  OUTPUT_JUMP (\"jgt %l0\", \"fjnle %l0\", \"and%.b %#0xc,%!\;jgt %l0\");
#endif
")

(define_insn ""
  [(set (pc)
	(if_then_else (leu (cc0)
			   (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
#ifdef MOTOROLA
  return \"jbhi %l0\";
#else
  return \"jhi %l0\";
#endif
")

;; Subroutines of "casesi".

(define_expand "casesi_1"
  [(set (match_operand:SI 3 "general_operand" "")
	(plus:SI (match_operand:SI 0 "general_operand" "")
		 ;; Note operand 1 has been negated!
		 (match_operand:SI 1 "immediate_operand" "")))
   (set (cc0) (minus (match_operand:SI 2 "general_operand" "")
		     (match_dup 3)))
   (set (pc) (if_then_else (ltu (cc0) (const_int 0))
			   (label_ref (match_operand 4 "" "")) (pc)))]
  ""
  "")

(define_expand "casesi_2"
  [(set (match_operand:SI 0 "" "") (mem:HI (match_operand:SI 1 "" "")))
   ;; The USE here is so that at least one jump-insn will refer to the label,
   ;; to keep it alive in jump_optimize.
   (parallel [(set (pc)
		   (plus:SI (pc) (match_dup 0)))
	      (use (label_ref (match_operand 2 "" "")))])]
  ""
  "")

;; Operand 0 is index (in bytes); operand 1 is minimum, operand 2 themaximum;
;; operand 3 is CODE_LABEL for the table;
;; operand 4 is the CODE_LABEL to go to if index out of range.
(define_expand "casesi"
  [(set (match_dup 7) (plus:SI (match_operand:SI 0 "general_operand" "")
			       ;; Note operand 1 has been negated!
			       (match_operand:SI 1 "immediate_operand" "")))
   (set (cc0) (minus (match_operand:SI 2 "general_operand" "")
		     (match_dup 7)))
   (set (pc) (if_then_else (ltu (cc0) (const_int 0))
			   (label_ref (match_operand 4 "" "")) (pc)))
   (set (match_dup 5) (mem:HI (match_dup 6)))
   ;; The USE here is so that at least one jump-insn will refer to the label,
   ;; to keep it alive in jump_optimize.
   (parallel [(set (pc)
		   (plus:SI (pc) (match_dup 5)))
	      (use (label_ref (match_operand 3 "" "")))])]
  ""
  "
{
  extern rtx negate_rtx ();
  rtx table_elt_addr;
  rtx index_diff;

  operands[1] = negate_rtx (operands[1]);
  index_diff = gen_reg_rtx (SImode);
  /* Emit the first few insns.  */
  emit_insn (gen_casesi_1 (operands[0], operands[1], operands[2],
			   index_diff, operands[4]));
  /* Construct a memory address.  This may emit some insns.  */
  table_elt_addr
    = memory_address (HImode,
		      gen_rtx (PLUS, Pmode,
			       gen_rtx (MULT, Pmode, index_diff,
					gen_rtx (CONST_INT, VOIDmode, 2)),
			       gen_rtx (LABEL_REF, VOIDmode, operands[3])));
  /* Emit the last few insns.  */
  emit_insn (gen_casesi_2 (gen_reg_rtx (HImode), table_elt_addr, operands[3]));
  DONE;
}")

;; Recognize one of the insns resulting from casesi_2.
(define_insn ""
  [(set (pc)
	(plus:SI (pc) (match_operand:HI 0 "general_operand" "r")))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "*
#ifdef SGS
#ifdef ASM_OUTPUT_CASE_LABEL
  return \"jmp 6(%%pc,%0.w)\";
#else
  return \"jmp 2(%%pc,%0.w)\";
#endif
#else
#ifdef MOTOROLA
  return \"jmp (2,pc,%0.w)\";
#else
  return \"jmp pc@(2,%0:w)\";
#endif
#endif
")

;; Unconditional and other jump instructions
(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "*
#ifdef MOTOROLA
  return \"jbra %l0\";
#else
  return \"jra %l0\";
#endif
")

(define_insn ""
  [(set (pc)
	(if_then_else
	 (ne (minus (plus:HI (match_operand:HI 0 "general_operand" "g")
			     (const_int -1))
		    (const_int -1))
	     (const_int 0))
	 (label_ref (match_operand 1 "" ""))
	 (pc)))
   (set (match_dup 0)
	(plus:HI (match_dup 0)
		 (const_int -1)))]
  ""
  "*
{
  if (DATA_REG_P (operands[0]))
    return \"dbra %0,%l1\";
  if (GET_CODE (operands[0]) == MEM)
    {
#ifdef MOTOROLA
      return \"subq%.w %#1,%0\;jbcc %l1\";
#else
      return \"subqw %#1,%0\;jcc %l1\";
#endif
    }
#ifdef MOTOROLA
#ifdef HPUX_ASM
  return \"subq%.w %#1,%0\;cmp%.w %0,%#-1\;jbne %l1\";
#else
  return \"subq%.w %#1,%0\;cmp%.w %#-1,%0\;jbne %l1\";
#endif
#else
  return \"subqw %#1,%0\;cmpw %#-1,%0\;jne %l1\";
#endif
}")

(define_insn ""
  [(set (pc)
	(if_then_else
	 (ne (minus (plus:SI (match_operand:SI 0 "general_operand" "g")
			     (const_int -1))
		    (const_int -1))
	     (const_int 0))
	 (label_ref (match_operand 1 "" ""))
	 (pc)))
   (set (match_dup 0)
	(plus:SI (match_dup 0)
		 (const_int -1)))]
  ""
  "*
{
#ifdef MOTOROLA
  if (DATA_REG_P (operands[0]))
    return \"dbra %0,%l1\;clr.w %0\;subq.l %#1,%0\;jbcc %l1\";
  if (GET_CODE (operands[0]) == MEM)
    return \"subq.l %#1,%0\;jbcc %l1\";
#ifdef HPUX_ASM
  return \"subq.l %#1,%0\;cmp.l %0,%#-1\;jbne %l1\";
#else
  return \"subq.l %#1,%0\;cmp.l %#-1,%0\;jbne %l1\";
#endif
#else
  if (DATA_REG_P (operands[0]))
    return \"dbra %0,%l1\;clrw %0\;subql %#1,%0\;jcc %l1\";
  if (GET_CODE (operands[0]) == MEM)
    return \"subql %#1,%0\;jcc %l1\";
  return \"subql %#1,%0\;cmpl %#-1,%0\;jne %l1\";
#endif
}")

;; Call subroutine with no return value.
(define_insn "call"
  [(call (match_operand:QI 0 "general_operand" "m")
	 (match_operand:SI 1 "general_operand" "g"))]
  ;; Operand 1 not really used on the m68000.

  ""
  "*
#ifdef MOTOROLA
  return \"jsr %0\";
#else
  return \"jbsr %0\";
#endif
")

;; Call subroutine, returning value in operand 0
;; (which must be a hard register).
(define_insn "call_value"
  [(set (match_operand 0 "" "rf")
	(call (match_operand:QI 1 "general_operand" "m")
	      (match_operand:SI 2 "general_operand" "g")))]
  ;; Operand 2 not really used on the m68000.
  ""
  "*
#ifdef MOTOROLA
  return \"jsr %1\";
#else
  return \"jbsr %1\";
#endif
")

(define_insn "return"
  [(return)]
  ""
  "rts")

;; This is the first machine-dependent peephole optimization.
;; It is useful when a floating value is returned from a function call
;; and then is moved into an FP register.
;; But it is mainly intended to test the support for these optimizations.

(define_peephole
  [(set (reg:SI 15) (plus:SI (reg:SI 15) (const_int 4)))
   (set (match_operand:DF 0 "register_operand" "f")
	(match_operand:DF 1 "register_operand" "ad"))]
  "FP_REG_P (operands[0]) && ! FP_REG_P (operands[1])"
  "*
{
  rtx xoperands[2];
  xoperands[1] = gen_rtx (REG, SImode, REGNO (operands[1]) + 1);
  output_asm_insn (\"move%.l %1,%s\", xoperands);
  output_asm_insn (\"move%.l %1,%-\", operands);
  return \"fmove%.d %+,%0\";
}
")

;;- Local variables:
;;- mode:emacs-lisp
;;- comment-start: ";;- "
;;- eval: (set-syntax-table (copy-sequence (syntax-table)))
;;- eval: (modify-syntax-entry ?[ "(]")
;;- eval: (modify-syntax-entry ?] ")[")
;;- eval: (modify-syntax-entry ?{ "(}")
;;- eval: (modify-syntax-entry ?} "){")
;;- End:
