// The template and inlines for the -*- C++ -*- complex number classes.

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

#include <bits/std_complex.h>
#include <bits/std_cmath.h>
// This is a ISO C 9X header.
#include <math/mathconf.h>
#undef complex

#ifndef FLT
# define FLT double
# define FCT(name) name
#endif

namespace std
{

template <class T, class charT, class traits>
basic_istream <charT, traits> &
operator >> (basic_istream<charT, traits> &__is, complex<T> &__x)
{
  // XXX TODO
  return __is;
}

template <class charT, class traits>
basic_ostream<charT, traits> &
operator << (basic_ostream<charT, traits> &__os, const complex<FLT> &__x)
{
  basic_ostringstream<charT, traits> __s;
  __s.flags (__os.flags ());
#ifdef _G_HAVE_LOCALE
  __s.imbue (__os.getloc ());
#endif
  __s.precision (__os.precision ());
  __s << '(' << __x.real () << "," << __x.imag () << ')' << ends;
  return __os << __s.str ();
}


FLT
abs (const complex<FLT> &x)
{
  return FCT(__mycabs) (x.__value ());
}

FLT
arg (const complex<FLT> &x)
{
  return FCT(carg) (x.__value ());
}

complex<FLT>
polar (const FLT &rho, const FLT &theta)
{
#if defined _G_HAVE_SINCOS && !defined __osf__
  /* Although sincos does exist on OSF3.2 and OSF4.0 we cannot use it
     since the necessary types are not defined in the headers.  */
  FLT __sinx, __cosx;
  FCT(sincos) (theta, &__sinx, &__cosx);
  return complex<FLT> (rho * __cosx, rho * __sinx);
#else
  return complex<FLT> (rho * FCT(cos) (theta), rho * FCT(sin) (theta));
#endif
}

complex<FLT>
cos (const complex<FLT> &x)
{
  return complex<FLT> (FCT(ccos) (x.__value ()));
}

complex<FLT>
cosh (const complex<FLT> &x)
{
  return complex<FLT> (FCT(ccosh) (x.__value ()));
}

complex<FLT>
exp (const complex<FLT> &x)
{
  return complex<FLT> (FCT(cexp) (x.__value ()));
}

complex<FLT>
log (const complex<FLT> &x)
{
  return complex<FLT> (FCT(c_log) (x.__value ()));
}

complex<FLT>
log10 (const complex<FLT> &x)
{
#ifdef _G_HAVE_CLOG10
  return complex<FLT> (FCT(clog10) (x.__value ()));
#else
  // This is very weak !!!
  return complex<FLT> (FCT(c_log) (x.__value () / FCT(log) (10.0)));
#endif
}

complex<FLT>
pow (const complex<FLT> &x, int n)
{
  return complex<FLT> (FCT(cexp) (n * FCT(c_log) (x.__value ())));
}

complex<FLT>
pow (const complex<FLT> &x, const FLT &y)
{
  return complex<FLT> (FCT(cexp) (y * FCT(c_log) (x.__value ())));
}

complex<FLT>
pow (const complex<FLT> &x, const complex<FLT> &y)
{
  return complex<FLT> (FCT(cpow) (x.__value (), y.__value ()));
}

complex<FLT>
pow (const FLT &x, const complex<FLT> &y)
{
  return complex<FLT> (FCT(cexp) (y.__value () * FCT(log) (x)));
}

complex<FLT>
sin (const complex<FLT> &x)
{
  return complex<FLT> (FCT(sin) (x.__value ()));
}

complex<FLT>
sinh (const complex<FLT> &x)
{
  return complex<FLT> (FCT(sinh) (x.__value ()));
}

complex<FLT>
sqrt (const complex<FLT> &x)
{
  return complex<FLT> (FCT(sqrt) (x.__value ()));
}

complex<FLT>
tan (const complex<FLT> &x)
{
  return complex<FLT> (FCT(tan) (x.__value ()));
}

complex<FLT>
tanh (const complex<FLT> &x)
{
  return complex<FLT> (FCT(tanh) (x.__value ()));
}

} // namespace std
