#ifndef CYGONCE_LIBM_EXP_H
#define CYGONCE_LIBM_EXP_H
//===========================================================================
//
//      exp.h
//
//      Test vectors for testing of exp() math library function
//
//===========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour
// Contributors:  jlarmour
// Date:        1998-02-13
// Purpose:     
// Description: 
// Usage:       #include "vectors/exp.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support.h"// extra support for math tests

#define EXP_TOLERANCE 1.0E-04

static const Cyg_libm_test_double_vec_t exp_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{ 1, 1074853420u, 2506787616u, 1090024059u, 3619148316u, 1079073766u, 1147571106u, 0, EXP_TOLERANCE, 0},
{ 2, 3220250806u, 3176730980u, 1051524793u, 2993920299u, 1070985501u, 3667586384u, 0, EXP_TOLERANCE, 0},
{ 3, 3226028315u, 2725707538u, 3232101343u, 2346810316u, 996177609u, 2816512701u, 0, EXP_TOLERANCE, 0},
{ 4, 1078922874u, 2088062470u, 3201242716u, 420891118u, 1166568645u, 2120331304u, 0, EXP_TOLERANCE, 0},
{ 5, 3221200677u, 2636405208u, 1100049309u, 471635570u, 1069661382u, 4196142410u, 0, EXP_TOLERANCE, 0},
{ 6, 1077828855u, 1746012320u, 1054478713u, 3333988501u, 1118565158u, 699114409u, 0, EXP_TOLERANCE, 0},
{ 7, 1066827528u, 183014794u, 3202039382u, 2016785810u, 1072716539u, 123580646u, 0, EXP_TOLERANCE, 0},
{ 8, 3219777490u, 2688957927u, 1046089230u, 2709029994u, 1071414232u, 1149200657u, 0, EXP_TOLERANCE, 0},
{ 9, 1070330066u, 624574473u, 1045840574u, 3473266330u, 1072949041u, 2377226642u, 0, EXP_TOLERANCE, 0},
{ 10, 3217502754u, 1605286142u, 1068931671u, 4233776869u, 1072345653u, 1083445165u, 0, EXP_TOLERANCE, 0},
{ 11, 1069780594u, 1857607719u, 3222889559u, 3417070006u, 1072866340u, 2899880271u, 0, EXP_TOLERANCE, 0},
{ 12, 1081579891u, 3981151660u, 1088899021u, 1332651746u, 1643831522u, 1345086100u, 0, EXP_TOLERANCE, 0},
{ 13, 1075860838u, 3824988054u, 1066856791u, 2070129652u, 1084982301u, 1912337979u, 0, EXP_TOLERANCE, 0},
{ 14, 3218045550u, 1372884064u, 1080833116u, 3229926662u, 1072236030u, 3106255365u, 0, EXP_TOLERANCE, 0},
{ 15, 1078097861u, 3217805330u, 3191644264u, 2014578707u, 1128498553u, 1807458751u, 0, EXP_TOLERANCE, 0},
{ 16, 1080267391u, 265058758u, 3239903247u, 1630600647u, 1309523294u, 1523986687u, 0, EXP_TOLERANCE, 0},
{ 17, 1073221381u, 1946677669u, 3198462609u, 926009897u, 1074920988u, 1465131398u, 0, EXP_TOLERANCE, 0},
{ 18, 1073178875u, 2271884183u, 3203741999u, 2118617783u, 1074874144u, 2764688608u, 0, EXP_TOLERANCE, 0},
{ 19, 3214772053u, 213658772u, 3249401130u, 314151656u, 1072633636u, 4130392148u, 0, EXP_TOLERANCE, 0},
{ 20, 3228946464u, 1564829925u, 3197817016u, 497230814u, 544633027u, 34803168u, 0, EXP_TOLERANCE, 0},
{ 21, 3219408362u, 2075329122u, 3231746400u, 169900577u, 1071709080u, 4184140427u, 0, EXP_TOLERANCE, 0},
{ 22, 1067674434u, 541549344u, 1096608669u, 3119070100u, 1072733781u, 3804791293u, 0, EXP_TOLERANCE, 0},
{ 23, 1075989871u, 567496114u, 1045286891u, 1969998540u, 1086482701u, 3180352384u, 0, EXP_TOLERANCE, 0},
{ 24, 1069985379u, 1299369769u, 1049342524u, 4167404066u, 1072896531u, 1629596946u, 0, EXP_TOLERANCE, 0},
{ 25, 3218302829u, 3348930841u, 1078472138u, 358457347u, 1072144759u, 3067143552u, 0, EXP_TOLERANCE, 0},
{ 26, 1073166449u, 2192461366u, 1099527247u, 3184735642u, 1074860805u, 1775317488u, 0, EXP_TOLERANCE, 0},
{ 27, 1068590412u, 331696577u, 3189610016u, 793242270u, 1072766977u, 1780216299u, 0, EXP_TOLERANCE, 0},
{ 28, 3229460262u, 2322696981u, 1083791358u, 3020766674u, 354871428u, 1974410974u, 0, EXP_TOLERANCE, 0},
{ 29, 1066922273u, 252085215u, 3214426435u, 4139068910u, 1072718053u, 1593026232u, 0, EXP_TOLERANCE, 0},
{ 30, 3221457149u, 105589263u, 1056316170u, 261630827u, 1068909924u, 4008856079u, 0, EXP_TOLERANCE, 0},
{ 31, 1082047584u, 428765703u, 3251828686u, 2009972239u, 1816546673u, 3462966019u, 0, EXP_TOLERANCE, 0},
{ 32, 1079693651u, 3517376586u, 3240257920u, 3304487302u, 1234899857u, 1250614638u, 0, EXP_TOLERANCE, 0},
{ 33, 3224100728u, 237004814u, 3237899261u, 3364008659u, 1051573078u, 1250441695u, 0, EXP_TOLERANCE, 0},
{ 34, 3214121920u, 472004928u, 3226869477u, 1186387580u, 1072653472u, 186620643u, 0, EXP_TOLERANCE, 0},
{ 35, 1068906914u, 4085763910u, 1106394906u, 2684738273u, 1072788350u, 3104710386u, 0, EXP_TOLERANCE, 0},
{ 36, 1069636551u, 2055490142u, 3231581370u, 3879040079u, 1072845542u, 714008610u, 0, EXP_TOLERANCE, 0},
{ 37, 3213093895u, 3725731239u, 1061652681u, 591292963u, 1072672946u, 3339751925u, 0, EXP_TOLERANCE, 0},
{ 38, 3221869253u, 1147041027u, 3215417793u, 624695933u, 1067731891u, 1490517545u, 0, EXP_TOLERANCE, 0},
{ 39, 3217587110u, 705725219u, 3238067573u, 1116238321u, 1072328147u, 3778478168u, 0, EXP_TOLERANCE, 0},
{ 40, 3217852848u, 7287411u, 1045917232u, 116067742u, 1072274139u, 800660017u, 0, EXP_TOLERANCE, 0},
{ 41, 3226423734u, 3604989074u, 1066381836u, 545298780u, 977849136u, 1417268874u, 0, EXP_TOLERANCE, 0},
{ 42, 3221178088u, 1681476121u, 1060345752u, 3553822398u, 1069686696u, 3471070187u, 0, EXP_TOLERANCE, 0},
{ 43, 1080811562u, 3410480388u, 1052460275u, 1660607230u, 1409975006u, 2715754844u, 0, EXP_TOLERANCE, 0},
{ 44, 1077682533u, 1494984673u, 3196647153u, 287894723u, 1115159161u, 2741076212u, 0, EXP_TOLERANCE, 0},
{ 45, 1068516615u, 644548665u, 1081948134u, 2442134629u, 1072762051u, 2743261701u, 0, EXP_TOLERANCE, 0},
{ 46, 1077068335u, 2312530895u, 3221584595u, 3379665576u, 1101051489u, 3357999194u, 0, EXP_TOLERANCE, 0},
{ 47, 1079308159u, 3018463866u, 1086226574u, 404012923u, 1199317798u, 2905917257u, 0, EXP_TOLERANCE, 0},
{ 48, 1071024755u, 1710279345u, 3251401196u, 3528946000u, 1073135949u, 3958225700u, 0, EXP_TOLERANCE, 0},
{ 49, 1070973535u, 2164450219u, 1083520023u, 3312018966u, 1073117849u, 2216238713u, 0, EXP_TOLERANCE, 0},
{ 50, 1069831588u, 2648986431u, 1050330591u, 1474376550u, 1072873789u, 3409301846u, 0, EXP_TOLERANCE, 0},
{ 51, 3214344972u, 1839068700u, 1077406406u, 3013052171u, 1072646645u, 923270809u, 0, EXP_TOLERANCE, 0},
{ 52, 1066416574u, 772102380u, 3220729740u, 4219039958u, 1072709995u, 1305461407u, 0, EXP_TOLERANCE, 0},
{ 53, 3223180765u, 3058618779u, 1046304788u, 3338676024u, 1061347966u, 1072422663u, 0, EXP_TOLERANCE, 0},
{ 54, 1067949353u, 506286854u, 1094907481u, 2217000199u, 1072742741u, 3706634962u, 0, EXP_TOLERANCE, 0},
{ 55, 1076136854u, 1147428263u, 1065432625u, 3034786717u, 1088176249u, 1631281700u, 0, EXP_TOLERANCE, 0},
{ 56, 1075725296u, 2844125311u, 1082985198u, 2561492677u, 1084108872u, 2831233524u, 0, EXP_TOLERANCE, 0},
{ 57, 3218876948u, 704542600u, 3222902057u, 2762779203u, 1071946646u, 190610401u, 0, EXP_TOLERANCE, 0},
{ 58, 3215409254u, 184131949u, 3249723525u, 1667366082u, 1072600139u, 3411518971u, 0, EXP_TOLERANCE, 0},
{ 59, 3221512446u, 3904224140u, 1067056698u, 2942159914u, 1068763822u, 1503414230u, 0, EXP_TOLERANCE, 0},
{ 60, 1080713919u, 426114282u, 3209056785u, 1083606355u, 1391928446u, 3657642479u, 0, EXP_TOLERANCE, 0},
{ 61, 1082048697u, 3774123863u, 1106787580u, 2722107965u, 1817003400u, 2241806278u, 0, EXP_TOLERANCE, 0},
{ 62, 1077519332u, 1377734762u, 1104232051u, 2377063483u, 1111477508u, 844049504u, 0, EXP_TOLERANCE, 0},
{ 63, 1072526287u, 1029739074u, 1105467109u, 3062201018u, 1074009347u, 4070953358u, 0, EXP_TOLERANCE, 0},
{ 64, 3225304413u, 773857656u, 3214251949u, 335833884u, 1026865589u, 4235967790u, 0, EXP_TOLERANCE, 0},
{ 65, 3216856098u, 1473865960u, 1103073830u, 4000427507u, 1072466239u, 2409423530u, 0, EXP_TOLERANCE, 0},
{ 66, 1081165135u, 4242092620u, 1067009473u, 14539161u, 1490638029u, 1225921132u, 0, EXP_TOLERANCE, 0},
{ 67, 3214536170u, 1732245037u, 1101371955u, 1533536108u, 1072640811u, 1577960147u, 0, EXP_TOLERANCE, 0},
{ 68, 3228182475u, 1833841275u, 1099430098u, 4144145552u, 756118454u, 4124162837u, 0, EXP_TOLERANCE, 0},
{ 69, 3227493247u, 935007012u, 3188865420u, 604442938u, 881158424u, 3059390833u, 0, EXP_TOLERANCE, 0},
{ 70, 3217389013u, 2211464602u, 1046255144u, 1635910526u, 1072369536u, 4272624615u, 0, EXP_TOLERANCE, 0},
{ 71, 1074725689u, 2549219008u, 3231633258u, 3733639385u, 1078468890u, 3538652097u, 0, EXP_TOLERANCE, 0},
{ 72, 1075803633u, 1819374372u, 3202219056u, 2617077637u, 1084512755u, 3226299243u, 0, EXP_TOLERANCE, 0},
{ 73, 1078616640u, 546465680u, 1048653554u, 532401530u, 1152481934u, 1660202510u, 0, EXP_TOLERANCE, 0},
{ 74, 1066591187u, 2759019783u, 3221570188u, 3554409630u, 1072712770u, 3539689839u, 0, EXP_TOLERANCE, 0},
{ 75, 3219222738u, 2527221960u, 1099107978u, 2696971136u, 1071812085u, 1070446248u, 0, EXP_TOLERANCE, 0},
{ 76, 1079332208u, 173134582u, 1087299442u, 2877794600u, 1201571530u, 2450291402u, 0, EXP_TOLERANCE, 0},
{ 77, 1076963290u, 547642046u, 3197285510u, 3521286127u, 1098574476u, 1604458491u, 0, EXP_TOLERANCE, 0},
{ 78, 1073812126u, 1231582831u, 1090971734u, 1653446832u, 1075897874u, 3499443040u, 0, EXP_TOLERANCE, 0},
{ 79, 1070779719u, 3762182190u, 3252967851u, 2615360375u, 1073051323u, 4198562047u, 0, EXP_TOLERANCE, 0},
{ 80, 3216563063u, 2588067350u, 3206610957u, 3551059728u, 1072499190u, 3656398129u, 0, EXP_TOLERANCE, 0},
{ 81, 3217464616u, 845263327u, 1073415902u, 1749010288u, 1072353625u, 2543242068u, 0, EXP_TOLERANCE, 0},
{ 82, 3217110706u, 3092685191u, 3190678390u, 2872219490u, 1072429360u, 3896037664u, 0, EXP_TOLERANCE, 0},
{ 83, 3220412207u, 4107255722u, 3205337291u, 3069068345u, 1070780355u, 264836658u, 0, EXP_TOLERANCE, 0},
{ 84, 3227213641u, 2294867524u, 3216653996u, 2860384670u, 907048437u, 551868093u, 0, EXP_TOLERANCE, 0},
{ 85, 3214297870u, 2265437201u, 3240198679u, 1234948614u, 1072648084u, 4060123138u, 0, EXP_TOLERANCE, 0},
{ 86, 3219505657u, 1186945904u, 3251167793u, 1896750851u, 1071658624u, 3764186265u, 0, EXP_TOLERANCE, 0},
{ 87, 1075284022u, 3686084548u, 1079286273u, 3309277689u, 1081503302u, 60883681u, 0, EXP_TOLERANCE, 0},
{ 88, 3221379088u, 3006860614u, 3231412671u, 2504194724u, 1069144247u, 54379178u, 0, EXP_TOLERANCE, 0},
{ 89, 3224614924u, 1948717780u, 1048317852u, 3791803982u, 1042772858u, 2420958386u, 0, EXP_TOLERANCE, 0},
{ 90, 1070636471u, 4272034420u, 3192982124u, 1526175922u, 1073004093u, 3308824510u, 0, EXP_TOLERANCE, 0},
{ 91, 3226943458u, 4108948538u, 1104691287u, 640541190u, 931953430u, 3437532117u, 0, EXP_TOLERANCE, 0},
{ 92, 3217743177u, 3259274853u, 1082507103u, 3677038020u, 1072296221u, 2033726093u, 0, EXP_TOLERANCE, 0},
{ 93, 1076841042u, 3781708548u, 1096584871u, 1207386447u, 1096271275u, 77258u, 0, EXP_TOLERANCE, 0},
{ 94, 3213861096u, 3011191657u, 1103798670u, 1096124830u, 1072661109u, 742458517u, 0, EXP_TOLERANCE, 0},
{ 95, 1071623631u, 2540404725u, 3240157452u, 4122845725u, 1073364830u, 3560000573u, 0, EXP_TOLERANCE, 0},
{ 96, 1076303678u, 311336721u, 3214382367u, 4212533768u, 1090074692u, 2663913965u, 0, EXP_TOLERANCE, 0},
{ 97, 1067916643u, 1769686293u, 3240200923u, 3538602249u, 1072741671u, 4116363241u, 0, EXP_TOLERANCE, 0},
{ 98, 1075081821u, 508056696u, 1103793878u, 776520138u, 1080344162u, 242331594u, 0, EXP_TOLERANCE, 0},
{ 99, 1080890481u, 4064962760u, 1077424413u, 819766631u, 1424537001u, 3317334315u, 0, EXP_TOLERANCE, 0},
{ 100, 1074178362u, 2112385259u, 3227593179u, 1187058516u, 1076952439u, 2142218601u, 0, EXP_TOLERANCE, 0},
{ 101, 1076003603u, 2514398118u, 1076579751u, 870169764u, 1086615970u, 3988144815u, 0, EXP_TOLERANCE, 0},
{ 102, 3227977024u, 1190259653u, 1069112254u, 3417249840u, 794021017u, 2254415465u, 0, EXP_TOLERANCE, 0},
{ 103, 3214634603u, 3467757357u, 3215075200u, 2168175352u, 1072637814u, 1866384359u, 0, EXP_TOLERANCE, 0},
{ 104, 3226011647u, 1508888184u, 1060430241u, 3524949092u, 996893071u, 1032082419u, 0, EXP_TOLERANCE, 0},
{ 105, 3215238675u, 166402802u, 3237198975u, 3572369260u, 1072610353u, 2543405344u, 0, EXP_TOLERANCE, 0},
{ 106, 1075575366u, 2441536203u, 3202753937u, 3658194573u, 1083247124u, 1565872384u, 0, EXP_TOLERANCE, 0},
{ 107, 1070781516u, 2479742828u, 1062342831u, 4214154303u, 1073051926u, 2877262325u, 0, EXP_TOLERANCE, 0},
{ 108, 1076105338u, 426896765u, 1066474375u, 2201754442u, 1087780533u, 3456888252u, 0, EXP_TOLERANCE, 0},
{ 109, 3214503389u, 2055773734u, 3239267288u, 291396537u, 1072641810u, 1723790219u, 0, EXP_TOLERANCE, 0},
{ 110, 3224385121u, 874125203u, 3210508124u, 4091098764u, 1048079713u, 3922271118u, 0, EXP_TOLERANCE, 0},
{ 111, 1072007482u, 120488169u, 3241241441u, 1985269424u, 1073699997u, 3263405331u, 0, EXP_TOLERANCE, 0},
{ 112, 3218073746u, 2243036871u, 3243941101u, 740033495u, 1072230527u, 3210238367u, 0, EXP_TOLERANCE, 0},
{ 113, 3218862090u, 1176656356u, 1074261978u, 3588756231u, 1071951438u, 3060660754u, 0, EXP_TOLERANCE, 0},
{ 114, 3228699543u, 3037249392u, 1061635587u, 1173102190u, 635829382u, 979909056u, 0, EXP_TOLERANCE, 0},
{ 115, 3224626669u, 2882725208u, 1071440059u, 69225090u, 1042520691u, 1843293285u, 0, EXP_TOLERANCE, 0},
{ 116, 3218954930u, 272319256u, 1072073912u, 2493997123u, 1071921768u, 657202412u, 0, EXP_TOLERANCE, 0},
{ 117, 1070303098u, 188610379u, 3232757923u, 2209647371u, 1072944854u, 4022783570u, 0, EXP_TOLERANCE, 0},
{ 118, 3225224181u, 1990439193u, 1078073146u, 622849962u, 1028759537u, 3564758723u, 0, EXP_TOLERANCE, 0},
{ 119, 1069718653u, 756052458u, 1081649113u, 2247475162u, 1072857353u, 554847761u, 0, EXP_TOLERANCE, 0},
{ 120, 1071060248u, 3878055211u, 3222407050u, 2979438623u, 1073148623u, 540184608u, 0, EXP_TOLERANCE, 0},
{ 121, 3214165365u, 2676398686u, 1105124431u, 3631096636u, 1072652140u, 2373850172u, 0, EXP_TOLERANCE, 0},
{ 122, 1071370846u, 1697791764u, 3198136112u, 2299842819u, 1073264221u, 1573541634u, 0, EXP_TOLERANCE, 0},
{ 123, 1074939040u, 1931502677u, 3215264397u, 3016456382u, 1079513197u, 1530595558u, 0, EXP_TOLERANCE, 0},
{ 124, 1073302002u, 343404215u, 1061072607u, 4266232536u, 1075015225u, 3004108006u, 0, EXP_TOLERANCE, 0},
{ 125, 3225502196u, 4140316002u, 1082896196u, 868256971u, 1020424521u, 3460157795u, 0, EXP_TOLERANCE, 0},
{ 126, 1074374234u, 1864139509u, 3187675097u, 3084482407u, 1077456782u, 4150857240u, 0, EXP_TOLERANCE, 0},
{ 127, 3220191323u, 2427162817u, 3234748208u, 2715105792u, 1071069433u, 783584364u, 0, EXP_TOLERANCE, 0},
{ 128, 1070891968u, 3943389284u, 1046724025u, 3626825684u, 1073089477u, 1797152336u, 0, EXP_TOLERANCE, 0},
{ 129, 1067443098u, 967350972u, 1093012318u, 448002663u, 1072726416u, 797307317u, 0, EXP_TOLERANCE, 0},
{ 130, 3228777187u, 105058217u, 1069733884u, 171786224u, 607209346u, 771064197u, 0, EXP_TOLERANCE, 0},
{ 131, 3213731756u, 2863482262u, 3204997271u, 877784425u, 1072663100u, 426007619u, 0, EXP_TOLERANCE, 0},
{ 132, 3216260801u, 2801782962u, 3213604117u, 762347195u, 1072533788u, 600737923u, 0, EXP_TOLERANCE, 0},
{ 133, 3224049543u, 2317950339u, 3246333414u, 2135700283u, 1052112831u, 3287040885u, 0, EXP_TOLERANCE, 0},
{ 134, 1069099309u, 4171919805u, 1082858682u, 2180920863u, 1072801541u, 2165096902u, 0, EXP_TOLERANCE, 0},
{ 135, 3221197660u, 1918836931u, 1083603224u, 3137821660u, 1069664732u, 2532148552u, 0, EXP_TOLERANCE, 0},
{ 136, 1081882778u, 3456203663u, 3235600523u, 2335688936u, 1755681633u, 4057860990u, 0, EXP_TOLERANCE, 0},
{ 137, 1066396570u, 4170235262u, 1051824459u, 521583737u, 1072709719u, 1024167559u, 0, EXP_TOLERANCE, 0},
{ 138, 1075056847u, 1296623194u, 3250673860u, 2442872540u, 1080220627u, 2781106181u, 0, EXP_TOLERANCE, 0},
{ 139, 1071121461u, 289979405u, 1049514449u, 3865737145u, 1073170732u, 3903607776u, 0, EXP_TOLERANCE, 0},
{ 140, 1074250368u, 3699090239u, 1054539840u, 3259249360u, 1077116363u, 502955531u, 0, EXP_TOLERANCE, 0},
{ 141, 1079640884u, 1619819023u, 1045993352u, 1022642459u, 1230064705u, 1444182022u, 0, EXP_TOLERANCE, 0},
{ 142, 1075141548u, 19455098u, 3229182089u, 2096003654u, 1080692026u, 447080049u, 0, EXP_TOLERANCE, 0},
{ 143, 1074200784u, 3803689997u, 1071630912u, 2263729518u, 1077001092u, 1334450617u, 0, EXP_TOLERANCE, 0},
{ 144, 1080385741u, 2816837387u, 1063422305u, 2597606398u, 1331342121u, 1095829056u, 0, EXP_TOLERANCE, 0},
{ 145, 1072245897u, 3680967506u, 1040201163u, 179224723u, 1073844641u, 930186774u, 0, EXP_TOLERANCE, 0},
{ 146, 3213795591u, 978126928u, 1101553990u, 4047893399u, 1072662117u, 1101190271u, 0, EXP_TOLERANCE, 0},
{ 147, 3221273469u, 4059818629u, 1042678728u, 3640293589u, 1069522282u, 1267895499u, 0, EXP_TOLERANCE, 0},
{ 148, 3228541096u, 3383497159u, 1070002807u, 1527313008u, 689917614u, 1535716049u, 0, EXP_TOLERANCE, 0},
{ 149, 3216339167u, 2599946514u, 1104170406u, 2738675352u, 1072524758u, 1435148139u, 0, EXP_TOLERANCE, 0},
{ 150, 1081115375u, 3616571377u, 1060859316u, 1130603218u, 1472304603u, 3187069287u, 0, EXP_TOLERANCE, 0},
{ 151, 1073931644u, 3859211180u, 1067940450u, 1744531824u, 1076181432u, 1345205949u, 0, EXP_TOLERANCE, 0},
{ 152, 1065900012u, 1958025850u, 3236511256u, 2472176453u, 1072705786u, 932607201u, 0, EXP_TOLERANCE, 0},
{ 153, 3223669905u, 182132862u, 3250520938u, 3924356991u, 1056496908u, 661218322u, 0, EXP_TOLERANCE, 0},
{ 154, 3224210428u, 35632886u, 3209806504u, 1453402523u, 1050263526u, 3107753313u, 0, EXP_TOLERANCE, 0},
{ 155, 1076182070u, 743225214u, 3202890678u, 142917400u, 1088680431u, 3782028986u, 0, EXP_TOLERANCE, 0},
{ 156, 1075442096u, 1472665012u, 3203138231u, 256588219u, 1082425160u, 2507283120u, 0, EXP_TOLERANCE, 0},
{ 157, 1079253522u, 1062927000u, 1061134072u, 931677439u, 1194330468u, 3538812810u, 0, EXP_TOLERANCE, 0},
{ 158, 1069912068u, 2320910576u, 1055663370u, 288059864u, 1072885638u, 2756379436u, 0, EXP_TOLERANCE, 0},
{ 159, 1075812365u, 1448349062u, 3199478070u, 3454027134u, 1084557930u, 2428474527u, 0, EXP_TOLERANCE, 0},
{ 160, 3224875886u, 4215445172u, 3196654963u, 2231888973u, 1036778828u, 4095096416u, 0, EXP_TOLERANCE, 0},
{ 161, 3227757863u, 40413554u, 3232578253u, 983832844u, 834531371u, 1749210300u, 0, EXP_TOLERANCE, 0},
{ 162, 3221624382u, 3995725873u, 1050082319u, 777231627u, 1068511312u, 2187487459u, 0, EXP_TOLERANCE, 0},
{ 163, 1066152450u, 672789828u, 3253385962u, 2982787335u, 1072707783u, 3636282767u, 0, EXP_TOLERANCE, 0},
{ 164, 1072585179u, 2075971825u, 1070166500u, 4034633931u, 1074046830u, 2188206437u, 0, EXP_TOLERANCE, 0},
{ 165, 3218434785u, 1018222907u, 3244621407u, 3090050495u, 1072096796u, 906290978u, 0, EXP_TOLERANCE, 0},
{ 166, 1071875189u, 937732557u, 3200798890u, 2557898276u, 1073574348u, 956132579u, 0, EXP_TOLERANCE, 0},
{ 167, 1075196588u, 130346162u, 3223590310u, 275568693u, 1081086381u, 3765310085u, 0, EXP_TOLERANCE, 0},
{ 168, 1065967541u, 3807416441u, 1075961161u, 3706820266u, 1072706320u, 1003056074u, 0, EXP_TOLERANCE, 0},
{ 169, 3219244733u, 1710131411u, 1078123323u, 1900790503u, 1071799398u, 2869753911u, 0, EXP_TOLERANCE, 0},
{ 170, 3226236449u, 3420420033u, 3210844787u, 588423066u, 986539436u, 3295138570u, 0, EXP_TOLERANCE, 0},
{ 171, 1067509906u, 1160162008u, 3246307879u, 4265764460u, 1072728454u, 3054362979u, 0, EXP_TOLERANCE, 0},
{ 172, 1080523338u, 366653268u, 3188814424u, 466059202u, 1356813060u, 760636581u, 0, EXP_TOLERANCE, 0},
{ 173, 3222433435u, 1325936170u, 3221436876u, 680097612u, 1065643005u, 1532992433u, 0, EXP_TOLERANCE, 0},
{ 174, 3225711052u, 1827735934u, 3200554324u, 2875599271u, 1010834241u, 3777705215u, 0, EXP_TOLERANCE, 0},
{ 175, 3213050498u, 3117037091u, 3239246636u, 15838845u, 1072673618u, 1728450485u, 0, EXP_TOLERANCE, 0},
{ 176, 1067702644u, 749718883u, 3223587064u, 1523766569u, 1072734697u, 3920212286u, 0, EXP_TOLERANCE, 0},
{ 177, 1066853747u, 1966536294u, 3250158026u, 699164258u, 1072716957u, 3817171147u, 0, EXP_TOLERANCE, 0},
{ 178, 1079174067u, 3759049394u, 1106085272u, 1183789499u, 1186993088u, 3807740687u, 0, EXP_TOLERANCE, 0},
{ 179, 1074910167u, 1970107747u, 1095245453u, 2308233883u, 1079348720u, 1531523305u, 0, EXP_TOLERANCE, 0},
{ 180, 1076367836u, 1491017852u, 1041444355u, 1723375725u, 1090818724u, 2037541645u, 0, EXP_TOLERANCE, 0},
{ 181, 3219775798u, 1141349287u, 1097465301u, 3403438584u, 1071415739u, 1183515418u, 0, EXP_TOLERANCE, 0},
{ 182, 3224280452u, 1711085243u, 3250239076u, 1377484108u, 1049505584u, 2904152696u, 0, EXP_TOLERANCE, 0},
{ 183, 1079510651u, 2880275004u, 1084039594u, 1611394950u, 1217987707u, 2867297031u, 0, EXP_TOLERANCE, 0},
{ 184, 3224784251u, 2626629370u, 1063771493u, 1499080813u, 1038898033u, 1353327733u, 0, EXP_TOLERANCE, 0},
{ 185, 1068862751u, 3936262414u, 1103919063u, 3175668759u, 1072785344u, 648861936u, 0, EXP_TOLERANCE, 0},
{ 186, 3217418903u, 1270950554u, 3194616071u, 3680565379u, 1072363229u, 951093660u, 0, EXP_TOLERANCE, 0},
{ 187, 3217585407u, 1066985223u, 3221613219u, 4089383168u, 1072328499u, 2267080590u, 0, EXP_TOLERANCE, 0},
{ 188, 3220204567u, 4017329311u, 3208334452u, 1667591498u, 1071050331u, 296637723u, 0, EXP_TOLERANCE, 0},
{ 189, 1077678397u, 3154656624u, 1061894279u, 3886344038u, 1115063060u, 1143078455u, 0, EXP_TOLERANCE, 0},
{ 190, 1068478737u, 977586119u, 3209762784u, 953839852u, 1072760203u, 1532008227u, 0, EXP_TOLERANCE, 0},
{ 191, 1081896575u, 143071571u, 3206165386u, 913097445u, 1760793137u, 1725664653u, 0, EXP_TOLERANCE, 0},
{ 192, 3213634128u, 1371169579u, 1057079837u, 2594818628u, 1072664604u, 686553362u, 0, EXP_TOLERANCE, 0},
{ 193, 3228724664u, 2259342224u, 3217432469u, 1824221478u, 626552221u, 555843157u, 0, EXP_TOLERANCE, 0},
{ 194, 3227960407u, 1576604497u, 1079368611u, 185078728u, 797102216u, 2312754753u, 0, EXP_TOLERANCE, 0},
{ 195, 3221679427u, 444800035u, 3243343143u, 1734989302u, 1068312202u, 3537952111u, 0, EXP_TOLERANCE, 0},
{ 196, 1072748883u, 130452005u, 1041548088u, 2158433515u, 1074196068u, 1478831994u, 0, EXP_TOLERANCE, 0},
{ 197, 3225258784u, 1941318385u, 1045807374u, 792193370u, 1027918372u, 749451785u, 0, EXP_TOLERANCE, 0},
{ 198, 3225716754u, 1299392207u, 3212131720u, 3205732280u, 1010504056u, 162887831u, 0, EXP_TOLERANCE, 0},
{ 199, 1079824436u, 3035093505u, 1052187689u, 3287702190u, 1246977273u, 3659026689u, 0, EXP_TOLERANCE, 0},
{ 200, 3227801892u, 2160225215u, 1102624859u, 836655570u, 826392674u, 2334422787u, 0, EXP_TOLERANCE, 0},
{ 201, 1079946410u, 3360816360u, 3246176356u, 172860634u, 1258302663u, 595783054u, 0, EXP_TOLERANCE, 0},
{ 202, 1073092940u, 146831910u, 1051558014u, 2340722078u, 1074779693u, 2145151815u, 0, EXP_TOLERANCE, 0},
{ 203, 3224124895u, 1603798153u, 3207725532u, 1099413093u, 1051244985u, 2989707675u, 0, EXP_TOLERANCE, 0},
{ 204, 3227804010u, 2429340443u, 3190303581u, 3223770005u, 825977359u, 2890255810u, 0, EXP_TOLERANCE, 0},
{ 205, 1073785807u, 955542166u, 3230415151u, 275583938u, 1075843652u, 1493078710u, 0, EXP_TOLERANCE, 0},
{ 206, 1078291818u, 513397822u, 1090646554u, 2089321329u, 1137467212u, 351397573u, 0, EXP_TOLERANCE, 0},
{ 207, 3214141396u, 2782073372u, 1046063872u, 4023829068u, 1072652875u, 138208091u, 0, EXP_TOLERANCE, 0},
{ 208, 1079690454u, 3242223094u, 3194111199u, 4264674108u, 1234585286u, 346227329u, 0, EXP_TOLERANCE, 0},
{ 209, 3225927909u, 3506346169u, 1047020885u, 1742757458u, 1000737156u, 928258562u, 0, EXP_TOLERANCE, 0},
{ 210, 3214684573u, 1265459564u, 3193450280u, 3650514880u, 1072636294u, 3135130836u, 0, EXP_TOLERANCE, 0},
{ 211, 1075464434u, 1525260440u, 3235452527u, 2612331392u, 1082544645u, 3469250844u, 0, EXP_TOLERANCE, 0},
{ 212, 3227697400u, 1263613754u, 3219096387u, 635677201u, 845641032u, 2821259135u, 0, EXP_TOLERANCE, 0},
{ 213, 3217806423u, 4140947288u, 3200792376u, 2013265346u, 1072283451u, 2224455623u, 0, EXP_TOLERANCE, 0},
{ 214, 3227954296u, 1912759945u, 3237045253u, 1351396825u, 798217665u, 2086155788u, 0, EXP_TOLERANCE, 0},
{ 215, 3228282218u, 1001433078u, 3206926643u, 2741676659u, 737645798u, 2489257394u, 0, EXP_TOLERANCE, 0},
{ 216, 1075680726u, 1088945233u, 1085095743u, 3986114865u, 1083799535u, 115784002u, 0, EXP_TOLERANCE, 0},
{ 217, 3219928361u, 831239754u, 1099828675u, 3071308141u, 1071284656u, 1977716179u, 0, EXP_TOLERANCE, 0},
{ 218, 3222688769u, 3473592372u, 1102759382u, 1309576357u, 1064228744u, 3715932954u, 0, EXP_TOLERANCE, 0},
{ 219, 3229166610u, 2042340367u, 1091945628u, 2062772374u, 463396439u, 3913343620u, 0, EXP_TOLERANCE, 0},
{ 220, 3214688631u, 1840632537u, 1096533424u, 807510337u, 1072636171u, 1550550553u, 0, EXP_TOLERANCE, 0},
{ 221, 3224111690u, 144814872u, 3212698915u, 2282965697u, 1051416747u, 218973180u, 0, EXP_TOLERANCE, 0},
{ 222, 1073333582u, 2552499583u, 3229111426u, 1470130815u, 1075054160u, 3344155594u, 0, EXP_TOLERANCE, 0},
{ 223, 3227364425u, 2858583811u, 1089760910u, 6360994u, 893069846u, 2777198087u, 0, EXP_TOLERANCE, 0},
{ 224, 3215042145u, 1614537194u, 1075198900u, 4088705365u, 1072622185u, 3424131072u, 0, EXP_TOLERANCE, 0},
{ 225, 3228918974u, 3545570051u, 1065221325u, 1629217700u, 554828172u, 1332220829u, 0, EXP_TOLERANCE, 0},
{ 226, 1072744324u, 1813392963u, 3235313361u, 3772501596u, 1074189549u, 528208211u, 0, EXP_TOLERANCE, 0},
{ 227, 3215677054u, 2406734491u, 1042055360u, 89226663u, 1072584209u, 97402367u, 0, EXP_TOLERANCE, 0},
{ 228, 3214625449u, 1618759139u, 3194723421u, 3888234802u, 1072638092u, 4156317286u, 0, EXP_TOLERANCE, 0},
{ 229, 1068988736u, 3590035633u, 3212424262u, 2892456615u, 1072793942u, 113645931u, 0, EXP_TOLERANCE, 0},
{ 230, 3213011732u, 2431246964u, 3241512456u, 183850734u, 1072674218u, 2322381535u, 0, EXP_TOLERANCE, 0},
{ 231, 1076918189u, 3088319870u, 3211544311u, 862225364u, 1097534688u, 1720101583u, 0, EXP_TOLERANCE, 0},
{ 232, 3224808904u, 3495352775u, 1058576726u, 596957268u, 1038316024u, 2704436146u, 0, EXP_TOLERANCE, 0},
{ 233, 1066476292u, 1839214511u, 3205004060u, 1923240983u, 1072710943u, 3120088286u, 0, EXP_TOLERANCE, 0},
{ 234, 1069608200u, 739619702u, 3223356436u, 2689885273u, 1072841490u, 1671733001u, 0, EXP_TOLERANCE, 0},
{ 235, 3216053611u, 2143376228u, 1098306332u, 3760236188u, 1072557866u, 124949512u, 0, EXP_TOLERANCE, 0},
{ 236, 1074621795u, 671680995u, 1091262633u, 2315535361u, 1078184623u, 1598497576u, 0, EXP_TOLERANCE, 0},
{ 237, 3219408869u, 2493598049u, 3194927008u, 1689107592u, 1071708811u, 3795731906u, 0, EXP_TOLERANCE, 0},
{ 238, 3213058631u, 1578976988u, 1066368383u, 2117279163u, 1072673492u, 2246846524u, 0, EXP_TOLERANCE, 0},
{ 239, 3221939535u, 3425290087u, 1098487295u, 1263412017u, 1067565021u, 2944648507u, 0, EXP_TOLERANCE, 0},
{ 240, 3217869948u, 3635396812u, 1070999426u, 3965655689u, 1072270721u, 3634981027u, 0, EXP_TOLERANCE, 0},
{ 241, 1069633530u, 2183973116u, 1101098363u, 1118613350u, 1072845109u, 3339325204u, 0, EXP_TOLERANCE, 0},
{ 242, 3221946089u, 199516350u, 1078368488u, 164621458u, 1067550572u, 2506509655u, 0, EXP_TOLERANCE, 0},
{ 243, 3212871842u, 3570940805u, 3230316437u, 3596080877u, 1072676385u, 2634172860u, 0, EXP_TOLERANCE, 0},
{ 244, 3217646749u, 980880313u, 1079833442u, 884465057u, 1072315877u, 2036884740u, 0, EXP_TOLERANCE, 0},
{ 245, 1080054180u, 2558179220u, 1052873711u, 1233598120u, 1270109524u, 2524660391u, 0, EXP_TOLERANCE, 0},
{ 246, 1067038165u, 1909994277u, 1085015978u, 2991527452u, 1072719908u, 2697640880u, 0, EXP_TOLERANCE, 0},
{ 247, 1070292444u, 1680290941u, 1074309900u, 2943870846u, 1072943204u, 3151340758u, 0, EXP_TOLERANCE, 0},
{ 248, 1069981892u, 1451927357u, 3228615456u, 1502585517u, 1072896011u, 500177266u, 0, EXP_TOLERANCE, 0},
{ 249, 3224677615u, 751136990u, 3230392165u, 3493275472u, 1041368347u, 2625785490u, 0, EXP_TOLERANCE, 0},
{ 250, 1079491599u, 1209623292u, 3238056647u, 979495322u, 1216301027u, 1345426533u, 0, EXP_TOLERANCE, 0},
{ 251, 3228404200u, 1717672108u, 1048120593u, 531240316u, 715186535u, 1714377665u, 0, EXP_TOLERANCE, 0},
{ 252, 1068854987u, 3548721654u, 1086112947u, 3391817224u, 1072784816u, 1708052498u, 0, EXP_TOLERANCE, 0},
{ 253, 1074691123u, 2758195125u, 1100880260u, 2028440924u, 1078367996u, 3066779734u, 0, EXP_TOLERANCE, 0},
{ 254, 1076883861u, 2750123373u, 3232200256u, 1086294931u, 1096841846u, 788833203u, 0, EXP_TOLERANCE, 0},
{ 255, 1065978768u, 2986160931u, 1076097908u, 2540046258u, 1072706409u, 172413673u, 0, EXP_TOLERANCE, 0},
{ 256, 3224990842u, 451471221u, 1064816262u, 4187644495u, 1034117199u, 2383134537u, 0, EXP_TOLERANCE, 0},
{ 257, 1080585860u, 2439500162u, 1065280276u, 1979490284u, 1368362891u, 4075308906u, 0, EXP_TOLERANCE, 0},
{ 258, 1065581656u, 2283342035u, 1078398157u, 1345997553u, 1072703272u, 1306641747u, 0, EXP_TOLERANCE, 0},
{ 259, 3219540804u, 179066662u, 1103272172u, 1217337578u, 1071637260u, 357090176u, 0, EXP_TOLERANCE, 0},
{ 260, 3218902409u, 3779303391u, 3210023352u, 3115946280u, 1071938472u, 1299997584u, 0, EXP_TOLERANCE, 0},
{ 261, 3213961394u, 286247089u, 1085153597u, 713645369u, 1072658399u, 978675133u, 0, EXP_TOLERANCE, 0},
{ 262, 1077941860u, 1468283899u, 1042831668u, 2022736418u, 1121280747u, 2888650454u, 0, EXP_TOLERANCE, 0},
{ 263, 1076847649u, 3305564080u, 1065483445u, 482392433u, 1096351817u, 3604886221u, 0, EXP_TOLERANCE, 0},
{ 264, 3216375871u, 2256346551u, 3222430705u, 2071674991u, 1072520543u, 2427121917u, 0, EXP_TOLERANCE, 0},
{ 265, 3216607607u, 2295269094u, 1084451053u, 2773103941u, 1072494144u, 3385062574u, 0, EXP_TOLERANCE, 0},
{ 266, 1075028218u, 1482721827u, 1092243422u, 3125409590u, 1080092760u, 3102857585u, 0, EXP_TOLERANCE, 0},
{ 267, 3221065973u, 1381740563u, 1071545057u, 2918235653u, 1069820730u, 3040152884u, 0, EXP_TOLERANCE, 0},
{ 268, 3226133060u, 1105857967u, 3241990046u, 2703723225u, 991268023u, 2258767820u, 0, EXP_TOLERANCE, 0},
{ 269, 1066084243u, 174689677u, 1079333374u, 3947057014u, 1072707243u, 3130733960u, 0, EXP_TOLERANCE, 0},
{ 270, 1077878947u, 2023082423u, 3242081486u, 1169047927u, 1119748901u, 3426525989u, 0, EXP_TOLERANCE, 0},
{ 271, 1070817355u, 3742487766u, 1043425732u, 194972788u, 1073064002u, 3585031582u, 0, EXP_TOLERANCE, 0},
{ 272, 3220083283u, 2136071361u, 3211529757u, 993675115u, 1071160954u, 3515311890u, 0, EXP_TOLERANCE, 0},
{ 273, 3219954837u, 210772141u, 3241441539u, 580731413u, 1071262863u, 2304851028u, 0, EXP_TOLERANCE, 0},
{ 274, 1078111773u, 1751560711u, 1074522705u, 180987057u, 1129175206u, 2518765659u, 0, EXP_TOLERANCE, 0},
{ 275, 1071997471u, 2552236599u, 1088658621u, 2112468655u, 1073690210u, 1525052105u, 0, EXP_TOLERANCE, 0},
{ 276, 3213407865u, 1578223762u, 3224596567u, 2456166162u, 1072668094u, 738092801u, 0, EXP_TOLERANCE, 0},
{ 277, 1070041301u, 2110924310u, 1086207177u, 3161208323u, 1072904904u, 3047488155u, 0, EXP_TOLERANCE, 0},
{ 278, 3223474786u, 2352173188u, 1079361728u, 4070222179u, 1058769652u, 3906475321u, 0, EXP_TOLERANCE, 0},
{ 279, 1080041384u, 2481562701u, 1090937016u, 3809489716u, 1267797634u, 404634930u, 0, EXP_TOLERANCE, 0},
{ 280, 3215877019u, 330905705u, 1086260896u, 90264431u, 1072572396u, 1208844547u, 0, EXP_TOLERANCE, 0},
{ 281, 1065895785u, 4162008079u, 3194387916u, 759522153u, 1072705752u, 3450625873u, 0, EXP_TOLERANCE, 0},
{ 282, 1075772157u, 1839697482u, 3216442625u, 2211508949u, 1084361851u, 2955268254u, 0, EXP_TOLERANCE, 0},
{ 283, 3227787115u, 3736863454u, 1063475914u, 3150741666u, 829092625u, 968779094u, 0, EXP_TOLERANCE, 0},
{ 284, 1070223067u, 4200269406u, 3236646101u, 1061812176u, 1072932509u, 3212891973u, 0, EXP_TOLERANCE, 0},
{ 285, 1074975099u, 106027290u, 3234978297u, 2245237549u, 1079745755u, 680984417u, 0, EXP_TOLERANCE, 0},
{ 286, 3228109966u, 2132131375u, 3250483427u, 3449276437u, 769507420u, 1538427034u, 0, EXP_TOLERANCE, 0},
{ 287, 1077854442u, 2334440944u, 1105423490u, 4004336184u, 1119135302u, 1452344798u, 0, EXP_TOLERANCE, 0},
{ 288, 3220869856u, 4090088208u, 1042030013u, 3898658299u, 1070092575u, 3230411400u, 0, EXP_TOLERANCE, 0},
{ 289, 3217345248u, 2272831437u, 3253082595u, 2639188641u, 1072378813u, 2389059511u, 0, EXP_TOLERANCE, 0},
{ 290, 1069446748u, 1856594168u, 3189515294u, 4101853676u, 1072825748u, 3613517627u, 0, EXP_TOLERANCE, 0},
{ 291, 1073915260u, 2211699255u, 3195060344u, 3865018604u, 1076138633u, 3271750546u, 0, EXP_TOLERANCE, 0},
{ 292, 3227038370u, 996259334u, 3241496889u, 3782673116u, 923155228u, 4107521594u, 0, EXP_TOLERANCE, 0},
{ 293, 1080256379u, 3840380763u, 1048674041u, 550040067u, 1307510065u, 928374556u, 0, EXP_TOLERANCE, 0},
{ 294, 3229399497u, 95874100u, 3237232828u, 2645647822u, 377375137u, 719222175u, 0, EXP_TOLERANCE, 0},
{ 295, 1065685736u, 3441419500u, 3252367038u, 876710419u, 1072704093u, 2246841165u, 0, EXP_TOLERANCE, 0},
{ 296, 3226010640u, 2560836004u, 3199616543u, 1180840586u, 996949059u, 82980477u, 0, EXP_TOLERANCE, 0},
{ 297, 3221602966u, 2218230392u, 3227485787u, 3947214579u, 1068555547u, 3858061400u, 0, EXP_TOLERANCE, 0},
{ 298, 1075345350u, 1447312532u, 1081476588u, 780366847u, 1081890764u, 2057809468u, 0, EXP_TOLERANCE, 0},
{ 299, 1073618219u, 2842113832u, 3216156731u, 225159029u, 1075463434u, 3769540376u, 0, EXP_TOLERANCE, 0},
{ 300, 1079242825u, 1601981129u, 3234628869u, 2236538344u, 1193325070u, 2364090570u, 0, EXP_TOLERANCE, 0},
{ 301, 1076784916u, 2194185737u, 3242362684u, 87913366u, 1095695295u, 2239129155u, 0, EXP_TOLERANCE, 0},
{ 302, 3215861096u, 1346862963u, 1077836259u, 3604666660u, 1072573334u, 1410091035u, 0, EXP_TOLERANCE, 0},
{ 303, 3218547435u, 3115209742u, 1099332326u, 1325101950u, 1072057026u, 3877451405u, 0, EXP_TOLERANCE, 0},
{ 304, 3221400314u, 3889223100u, 1053247613u, 3371396923u, 1069077038u, 2922304680u, 0, EXP_TOLERANCE, 0},
{ 305, 3220477868u, 4163120793u, 1075022670u, 1387631215u, 1070705523u, 1262184460u, 0, EXP_TOLERANCE, 0},
{ 306, 3218064691u, 1532426189u, 1063168268u, 3397022615u, 1072232293u, 14882088u, 0, EXP_TOLERANCE, 0},
{ 307, 3216761961u, 89324166u, 1079206060u, 3429424710u, 1072476762u, 2025275555u, 0, EXP_TOLERANCE, 0},
{ 308, 3214345198u, 747591401u, 1072238381u, 2803213904u, 1072646638u, 1362298570u, 0, EXP_TOLERANCE, 0},
{ 309, 1078530868u, 271904221u, 1044258318u, 1858545114u, 1148479724u, 2228394364u, 0, EXP_TOLERANCE, 0},
{ 310, 3222826034u, 314958082u, 3249912496u, 2966213175u, 1063404822u, 2546095187u, 0, EXP_TOLERANCE, 0},
{ 311, 3215005206u, 3119528953u, 3217179014u, 2908718240u, 1072624417u, 1982673129u, 0, EXP_TOLERANCE, 0},
{ 312, 3226738936u, 2018361566u, 1100926600u, 3985805054u, 950839806u, 2828622982u, 0, EXP_TOLERANCE, 0},
{ 313, 1073278308u, 409584884u, 3239758947u, 755795129u, 1074986774u, 588973461u, 0, EXP_TOLERANCE, 0},
{ 314, 1074723870u, 1819156379u, 3251342302u, 2982669005u, 1078463413u, 1788076940u, 0, EXP_TOLERANCE, 0},
{ 315, 1080591913u, 2080534280u, 3188254060u, 449171797u, 1369474257u, 3068381489u, 0, EXP_TOLERANCE, 0},
{ 316, 1079179684u, 168744837u, 3214950009u, 1322217822u, 1187423881u, 280204842u, 0, EXP_TOLERANCE, 0},
{ 317, 3229061076u, 3250487255u, 1062120700u, 1876195180u, 502358220u, 4092158339u, 0, EXP_TOLERANCE, 0},
{ 318, 3223197752u, 1336400247u, 1098057903u, 3314079581u, 1061270312u, 2063251548u, 0, EXP_TOLERANCE, 0},
{ 319, 3216261732u, 265025555u, 1063854282u, 3779482256u, 1072533680u, 2941193185u, 0, EXP_TOLERANCE, 0},
{ 320, 1072543381u, 887044257u, 1054789618u, 2732056261u, 1074020119u, 1583710347u, 0, EXP_TOLERANCE, 0},
{ 321, 1067932534u, 4027115185u, 3191764868u, 2940199511u, 1072742191u, 2686232784u, 0, EXP_TOLERANCE, 0},
{ 322, 3216131643u, 2875684421u, 3227459837u, 2251967570u, 1072548762u, 3720766546u, 0, EXP_TOLERANCE, 0},
{ 323, 1071633020u, 284173546u, 3238823679u, 3557800647u, 1073368685u, 2242917222u, 0, EXP_TOLERANCE, 0},
{ 324, 1080487040u, 3147771266u, 3220110464u, 2933364246u, 1350032806u, 3038347863u, 0, EXP_TOLERANCE, 0},
{ 325, 1071144616u, 3366183281u, 3234870843u, 537442654u, 1073179181u, 915714027u, 0, EXP_TOLERANCE, 0},
{ 326, 3227341572u, 2529029548u, 3249882819u, 3781513577u, 895182279u, 740047972u, 0, EXP_TOLERANCE, 0},
{ 327, 3219727810u, 1080845539u, 3206760016u, 911778687u, 1071458981u, 2588212980u, 0, EXP_TOLERANCE, 0},
{ 328, 3213971132u, 469586759u, 1091830022u, 3080528840u, 1072658099u, 4263113631u, 0, EXP_TOLERANCE, 0},
{ 329, 1075006224u, 2863108169u, 3225605506u, 2508274250u, 1079973897u, 1343663736u, 0, EXP_TOLERANCE, 0},
{ 330, 3218167016u, 4080017377u, 3206492941u, 1470284690u, 1072195726u, 2669611838u, 0, EXP_TOLERANCE, 0},
{ 331, 3217606150u, 3867917386u, 1102054928u, 3504746045u, 1072324220u, 3738189842u, 0, EXP_TOLERANCE, 0},
{ 332, 1070813735u, 2962134101u, 3244741577u, 3390537350u, 1073062778u, 1341868663u, 0, EXP_TOLERANCE, 0},
{ 333, 1077716053u, 1702237980u, 1071598971u, 1102587474u, 1115946680u, 2058865259u, 0, EXP_TOLERANCE, 0},
{ 334, 3216601606u, 2180218657u, 3211592260u, 1206527853u, 1072494823u, 3525678913u, 0, EXP_TOLERANCE, 0},
{ 335, 3215959112u, 394130786u, 3242511482u, 2437699868u, 1072567567u, 211465123u, 0, EXP_TOLERANCE, 0},
{ 336, 1066257155u, 849581558u, 3252006507u, 2008614943u, 1072708613u, 2224607887u, 0, EXP_TOLERANCE, 0},
{ 337, 3218528622u, 3128971673u, 3249137531u, 2773583059u, 1072063594u, 1861199787u, 0, EXP_TOLERANCE, 0},
{ 338, 1076641258u, 590727700u, 3248651761u, 2183878539u, 1093973382u, 51932800u, 0, EXP_TOLERANCE, 0},
{ 339, 1080127109u, 820687580u, 3208143496u, 1402434664u, 1283604000u, 2229435922u, 0, EXP_TOLERANCE, 0},
{ 340, 3229222163u, 1873709254u, 3245167989u, 44275991u, 442816163u, 2556589127u, 0, EXP_TOLERANCE, 0},
{ 341, 3213786001u, 1174874204u, 3208263730u, 2360372288u, 1072662264u, 3781223426u, 0, EXP_TOLERANCE, 0},
{ 342, 1081834580u, 937573440u, 3208953761u, 211240241u, 1737879034u, 1339532059u, 0, EXP_TOLERANCE, 0},
{ 343, 3226771718u, 2469774991u, 1043117070u, 3380071805u, 947847649u, 1283680172u, 0, EXP_TOLERANCE, 0},
{ 344, 1069655378u, 442507560u, 3254252803u, 3257889649u, 1072848240u, 1357220231u, 0, EXP_TOLERANCE, 0},
{ 345, 1071996248u, 1854921625u, 1049810168u, 2729627545u, 1073689017u, 2766820334u, 0, EXP_TOLERANCE, 0},
{ 346, 3229546805u, 4001809575u, 3240128649u, 278261523u, 322987487u, 2511328647u, 0, EXP_TOLERANCE, 0},
{ 347, 1077787510u, 1793907966u, 3238955714u, 398859249u, 1117634274u, 3075914843u, 0, EXP_TOLERANCE, 0},
{ 348, 3216681187u, 2511916952u, 3219195283u, 1697158299u, 1072485838u, 3086667046u, 0, EXP_TOLERANCE, 0},
{ 349, 1073131276u, 3230931724u, 3243897690u, 3508781585u, 1074823893u, 2387891840u, 0, EXP_TOLERANCE, 0},
{ 350, 1081827510u, 1674254897u, 1046547577u, 217148561u, 1735342545u, 3735031445u, 0, EXP_TOLERANCE, 0},
{ 351, 3218603986u, 3275604304u, 3194840159u, 2991205850u, 1072037461u, 2711189111u, 0, EXP_TOLERANCE, 0},
{ 352, 3214123743u, 3509997278u, 3248888030u, 3897986511u, 1072653416u, 576737657u, 0, EXP_TOLERANCE, 0},
{ 353, 1067105379u, 2156824613u, 1042295665u, 1239257646u, 1072720986u, 385023856u, 0, EXP_TOLERANCE, 0},
{ 354, 3219555541u, 1073153314u, 3250031627u, 2567234990u, 1071622626u, 1879921992u, 0, EXP_TOLERANCE, 0},
{ 355, 3213662084u, 4261696995u, 3197784432u, 323702024u, 1072664173u, 1494770321u, 0, EXP_TOLERANCE, 0},
{ 356, 3226913781u, 4075177615u, 3202791065u, 1919006082u, 934660210u, 4071141554u, 0, EXP_TOLERANCE, 0},
{ 357, 3225638525u, 386429966u, 1086504491u, 3698826164u, 1014131228u, 2849059877u, 0, EXP_TOLERANCE, 0},
{ 358, 1075181462u, 1681986446u, 3194985869u, 3072950140u, 1080972819u, 4027497035u, 0, EXP_TOLERANCE, 0},
{ 359, 3220457661u, 3719038997u, 1055433962u, 3331415058u, 1070728055u, 2502518029u, 0, EXP_TOLERANCE, 0},
{ 360, 1070186897u, 2420250111u, 3238002206u, 1928661079u, 1072926968u, 3179169477u, 0, EXP_TOLERANCE, 0},
{ 361, 1075622754u, 3679866727u, 3227386672u, 1273835792u, 1083468387u, 4108683448u, 0, EXP_TOLERANCE, 0},
{ 362, 1065739986u, 2682092368u, 3234222284u, 1325425811u, 1072704521u, 3522344556u, 0, EXP_TOLERANCE, 0},
{ 363, 1068895525u, 4175172697u, 3208346191u, 2130706153u, 1072787574u, 2645569776u, 0, EXP_TOLERANCE, 0},
{ 364, 1078458136u, 1200784450u, 1083605096u, 1248595607u, 1145159070u, 3624009342u, 0, EXP_TOLERANCE, 0},
{ 365, 3219133743u, 1897285171u, 3251296075u, 944966123u, 1071864797u, 3230578766u, 0, EXP_TOLERANCE, 0},
{ 366, 3225642610u, 2270747330u, 3230692631u, 422503284u, 1013989767u, 3220011003u, 0, EXP_TOLERANCE, 0},
{ 367, 1076780005u, 2857564741u, 1075647403u, 3308906709u, 1095620625u, 3220040566u, 0, EXP_TOLERANCE, 0},
{ 368, 3216058010u, 1380066948u, 3232612906u, 2613634294u, 1072557351u, 3176396515u, 0, EXP_TOLERANCE, 0},
{ 369, 1071230888u, 4022784584u, 1060483857u, 3264056381u, 1073211071u, 866665154u, 0, EXP_TOLERANCE, 0},
{ 370, 1066657500u, 1778509100u, 3213146285u, 2665833973u, 1072713826u, 3324574262u, 0, EXP_TOLERANCE, 0},
{ 371, 3219873028u, 1859175955u, 1079949560u, 4258450607u, 1071331100u, 1387314031u, 0, EXP_TOLERANCE, 0},
{ 372, 1067151756u, 4128020197u, 1076266146u, 4122840980u, 1072721730u, 703093847u, 0, EXP_TOLERANCE, 0},
{ 373, 3214154683u, 2454653987u, 3229487005u, 2977478685u, 1072652467u, 3648959943u, 0, EXP_TOLERANCE, 0},
{ 374, 3229439235u, 1355181872u, 1095308770u, 436846481u, 362699701u, 144776434u, 0, EXP_TOLERANCE, 0},
{ 375, 3227730934u, 2592856453u, 3247825559u, 3195234082u, 839453380u, 3215902683u, 0, EXP_TOLERANCE, 0},
{ 376, 3222118023u, 3554670043u, 1091621009u, 3321236467u, 1067008394u, 515558083u, 0, EXP_TOLERANCE, 0},
{ 377, 1072158561u, 1936670355u, 1095715713u, 2958468553u, 1073797675u, 3840516752u, 0, EXP_TOLERANCE, 0},
{ 378, 3214311205u, 2960339502u, 1098808013u, 1044068983u, 1072647677u, 1015104521u, 0, EXP_TOLERANCE, 0},
{ 379, 3215565553u, 4093388677u, 1095478112u, 1735930261u, 1072590826u, 1998582813u, 0, EXP_TOLERANCE, 0},
{ 380, 1078457390u, 1807398746u, 3195743135u, 4261616162u, 1145132905u, 2733988366u, 0, EXP_TOLERANCE, 0},
{ 381, 3218731378u, 3250576797u, 1059002384u, 3043079652u, 1071994341u, 3135803100u, 0, EXP_TOLERANCE, 0},
{ 382, 1072352837u, 666051428u, 3208765404u, 1912684117u, 1073904876u, 2200829650u, 0, EXP_TOLERANCE, 0},
{ 383, 1081467324u, 1949030179u, 1096388934u, 896459246u, 1602299239u, 4124280137u, 0, EXP_TOLERANCE, 0},
{ 384, 1068980717u, 622499767u, 1066707637u, 1490260486u, 1072793392u, 3411156525u, 0, EXP_TOLERANCE, 0},
{ 385, 1081522669u, 1490616165u, 3251242436u, 795675736u, 1622680601u, 1772451300u, 0, EXP_TOLERANCE, 0},
{ 386, 1075701016u, 3662877092u, 3234317146u, 3200513112u, 1083933859u, 948582088u, 0, EXP_TOLERANCE, 0},
{ 387, 1076748754u, 1356101968u, 3236536816u, 3062844611u, 1095205719u, 1389519343u, 0, EXP_TOLERANCE, 0},
{ 388, 3220971216u, 2284484846u, 3219498359u, 3240896015u, 1069945740u, 300004641u, 0, EXP_TOLERANCE, 0},
{ 389, 3225273929u, 494503287u, 1092811254u, 142673998u, 1027637252u, 1197719694u, 0, EXP_TOLERANCE, 0},
{ 390, 3229057244u, 3394882641u, 3225306538u, 364852125u, 503719187u, 1185927887u, 0, EXP_TOLERANCE, 0},
{ 391, 3222116035u, 193885269u, 1088149839u, 1359805831u, 1067014684u, 2719415674u, 0, EXP_TOLERANCE, 0},
{ 392, 3216213422u, 592580907u, 3199560872u, 3086438952u, 1072539267u, 4261894756u, 0, EXP_TOLERANCE, 0},
{ 393, 1070004424u, 1778008540u, 1049064687u, 73581647u, 1072899376u, 3317554069u, 0, EXP_TOLERANCE, 0},
{ 394, 3227859230u, 233240285u, 1081923320u, 2710903921u, 815830717u, 753681861u, 0, EXP_TOLERANCE, 0},
{ 395, 1072659495u, 3719878805u, 1079866720u, 3615458228u, 1074095657u, 776338417u, 0, EXP_TOLERANCE, 0},
{ 396, 3221194724u, 3647632375u, 3247225271u, 3839959621u, 1069668000u, 3902990147u, 0, EXP_TOLERANCE, 0},
{ 397, 1081381000u, 2232210456u, 3235434773u, 224271737u, 1570366929u, 1467736445u, 0, EXP_TOLERANCE, 0},
{ 398, 3213975204u, 2134662911u, 3190390590u, 4239009051u, 1072657974u, 3724433639u, 0, EXP_TOLERANCE, 0},
{ 399, 1075283265u, 2305279897u, 1077668039u, 1854523320u, 1081499061u, 1371511881u, 0, EXP_TOLERANCE, 0},
{ 400, 3220912835u, 538224650u, 3206153057u, 1379649610u, 1070028577u, 3385463776u, 0, EXP_TOLERANCE, 0},
{ 401, 3215284875u, 3683897920u, 3244167599u, 3647579469u, 1072607582u, 369746842u, 0, EXP_TOLERANCE, 0},
{ 402, 1077698021u, 2694093608u, 1042775347u, 598406111u, 1115578102u, 2696598259u, 0, EXP_TOLERANCE, 0},
{ 403, 3218975424u, 872706833u, 1084802480u, 2200602798u, 1071915306u, 2038804970u, 0, EXP_TOLERANCE, 0},
{ 404, 1065408269u, 904146293u, 1060867322u, 1729685598u, 1072701905u, 2787254479u, 0, EXP_TOLERANCE, 0},
{ 405, 3214569338u, 1894173462u, 3232800651u, 191960416u, 1072639801u, 138794756u, 0, EXP_TOLERANCE, 0},
{ 406, 1078642431u, 3521028551u, 1054522089u, 3287274359u, 1153643349u, 3672113002u, 0, EXP_TOLERANCE, 0},
{ 407, 1079658324u, 959640601u, 3201578263u, 4136915018u, 1231622977u, 2234964481u, 0, EXP_TOLERANCE, 0},
{ 408, 1071345483u, 1553716379u, 1106027987u, 984725765u, 1073254457u, 2029348498u, 0, EXP_TOLERANCE, 0},
{ 409, 3226249729u, 2287646644u, 3240329321u, 2276183378u, 985897502u, 1659813779u, 0, EXP_TOLERANCE, 0},
{ 410, 1072403478u, 3940225170u, 3199544434u, 997572161u, 1073934490u, 3814688844u, 0, EXP_TOLERANCE, 0},
{ 411, 3219059817u, 36116288u, 3206886566u, 4196602670u, 1071889028u, 622952862u, 0, EXP_TOLERANCE, 0},
{ 412, 3225967213u, 3550227562u, 3207257983u, 2747744117u, 998936682u, 4215021001u, 0, EXP_TOLERANCE, 0},
{ 413, 1081167454u, 507130047u, 1048359321u, 3229888373u, 1491488321u, 2514231187u, 0, EXP_TOLERANCE, 0},
{ 414, 3221948202u, 2210969014u, 1081031001u, 1946786091u, 1067545951u, 134943692u, 0, EXP_TOLERANCE, 0},
{ 415, 3224772654u, 4059150589u, 3189759234u, 1177045799u, 1039198095u, 3770974960u, 0, EXP_TOLERANCE, 0},
{ 416, 1078423548u, 2664812822u, 1050343198u, 2034180320u, 1143517713u, 3731467255u, 0, EXP_TOLERANCE, 0},
{ 417, 3220070573u, 1175750283u, 3235559706u, 1424491340u, 1071170763u, 285360716u, 0, EXP_TOLERANCE, 0},
{ 418, 3219147073u, 1630036121u, 3231972785u, 3195479448u, 1071856759u, 825964156u, 0, EXP_TOLERANCE, 0},
{ 419, 1077846963u, 2527029044u, 1046927050u, 4000723255u, 1118989351u, 3673409802u, 0, EXP_TOLERANCE, 0},
{ 420, 1076820069u, 3335703647u, 3237349676u, 3869440059u, 1096040909u, 786910848u, 0, EXP_TOLERANCE, 0},
{ 421, 1078850936u, 3888398377u, 3196041693u, 1290567220u, 1163247715u, 1366973945u, 0, EXP_TOLERANCE, 0},
{ 422, 1071921950u, 3242451480u, 3248384948u, 707431021u, 1073617858u, 3148318263u, 0, EXP_TOLERANCE, 0},
{ 423, 1075890477u, 2739665123u, 1060777905u, 1733073225u, 1085358008u, 2026080761u, 0, EXP_TOLERANCE, 0},
{ 424, 1075371333u, 1297274853u, 3208848704u, 3341639139u, 1082084306u, 1161258137u, 0, EXP_TOLERANCE, 0},
{ 425, 1066493885u, 2228057309u, 1084318902u, 1317851136u, 1072711223u, 1263590417u, 0, EXP_TOLERANCE, 0},
{ 426, 1077769567u, 270039934u, 3241414679u, 3063626339u, 1117167369u, 251426608u, 0, EXP_TOLERANCE, 0},
{ 427, 3220226926u, 83062251u, 3211262173u, 2659016437u, 1071018626u, 3607873799u, 0, EXP_TOLERANCE, 0},
{ 428, 1080015246u, 3833539373u, 3206667189u, 1567476111u, 1264640185u, 3066665016u, 0, EXP_TOLERANCE, 0},
{ 429, 3217777984u, 2382776852u, 3249232579u, 1546622468u, 1072289181u, 3303189231u, 0, EXP_TOLERANCE, 0},
{ 430, 1076099255u, 1714300821u, 1104130938u, 4167591598u, 1087714517u, 3396587971u, 0, EXP_TOLERANCE, 0},
{ 431, 1067869976u, 2798720100u, 1086978789u, 449990704u, 1072740147u, 1441545775u, 0, EXP_TOLERANCE, 0},
{ 432, 3223858383u, 4039516226u, 3244344107u, 4272932619u, 1054317676u, 2225867290u, 0, EXP_TOLERANCE, 0},
{ 433, 3221659865u, 1683007544u, 1091105663u, 3805494321u, 1068384828u, 2642772291u, 0, EXP_TOLERANCE, 0},
{ 434, 3220852948u, 2072627412u, 1094383324u, 3394151662u, 1070118481u, 2781076629u, 0, EXP_TOLERANCE, 0},
{ 435, 3220570024u, 1120106427u, 3223631624u, 3404608264u, 1070608094u, 3726035371u, 0, EXP_TOLERANCE, 0},
{ 436, 1078985629u, 559918757u, 3205077053u, 908100198u, 1169510707u, 348797896u, 0, EXP_TOLERANCE, 0},
{ 437, 1065746590u, 2026673913u, 3244833635u, 2844573214u, 1072704573u, 4160322489u, 0, EXP_TOLERANCE, 0},
{ 438, 3229401435u, 3946837259u, 3234993796u, 3850406820u, 376626627u, 2645031468u, 0, EXP_TOLERANCE, 0},
{ 439, 1070062721u, 3139330994u, 1046133568u, 1539650690u, 1072908126u, 3501052954u, 0, EXP_TOLERANCE, 0},
{ 440, 3225171164u, 1554593884u, 3228899878u, 2813752562u, 1029949960u, 634658456u, 0, EXP_TOLERANCE, 0},
{ 441, 1069087916u, 3804703138u, 1072931071u, 2053677923u, 1072800756u, 699656724u, 0, EXP_TOLERANCE, 0},
{ 442, 3227038507u, 289355864u, 1078453818u, 2143066338u, 923143111u, 3108681133u, 0, EXP_TOLERANCE, 0},
{ 443, 3216522792u, 2157691971u, 1106629150u, 110806409u, 1072503764u, 1811146510u, 0, EXP_TOLERANCE, 0},
{ 444, 1075865563u, 3570399481u, 1085637605u, 180265334u, 1085048493u, 1043128358u, 0, EXP_TOLERANCE, 0},
{ 445, 3216708822u, 558779875u, 3202046748u, 2338464653u, 1072482728u, 2560919037u, 0, EXP_TOLERANCE, 0},
{ 446, 1066676984u, 1703969219u, 3229797258u, 1417521063u, 1072714137u, 992457887u, 0, EXP_TOLERANCE, 0},
{ 447, 3225199349u, 3917440951u, 1051668894u, 3736066983u, 1029291645u, 1524244054u, 0, EXP_TOLERANCE, 0},
{ 448, 1071043536u, 3106613409u, 1066627453u, 2735392257u, 1073142642u, 2422476262u, 0, EXP_TOLERANCE, 0},
{ 449, 1071956828u, 2229777605u, 1065061963u, 2405869925u, 1073650949u, 990909907u, 0, EXP_TOLERANCE, 0},
{ 450, 3225831741u, 3967957902u, 1057416138u, 3459188071u, 1005185820u, 1500159877u, 0, EXP_TOLERANCE, 0},
{ 451, 1071784938u, 3699016825u, 3249713090u, 796144848u, 1073493066u, 2784789311u, 0, EXP_TOLERANCE, 0},
{ 452, 3222524940u, 3285165564u, 3211948811u, 401510871u, 1065144087u, 2462551555u, 0, EXP_TOLERANCE, 0},
{ 453, 1078529018u, 634857910u, 3199607513u, 914218057u, 1148406303u, 2060143941u, 0, EXP_TOLERANCE, 0},
{ 454, 1076403304u, 2030735578u, 3233855943u, 965677531u, 1091237697u, 3806493702u, 0, EXP_TOLERANCE, 0},
{ 455, 1075362511u, 3957229084u, 1051050470u, 3123776651u, 1082016435u, 3236122522u, 0, EXP_TOLERANCE, 0},
{ 456, 3221863333u, 162122081u, 3239376395u, 108064594u, 1067746995u, 3736551116u, 0, EXP_TOLERANCE, 0},
{ 457, 3224688874u, 869031839u, 3225020876u, 1344301606u, 1041127895u, 2468905470u, 0, EXP_TOLERANCE, 0},
{ 458, 3219676354u, 946696117u, 3231825228u, 1700703647u, 1071506461u, 2633364322u, 0, EXP_TOLERANCE, 0},
{ 459, 1074444299u, 3394168074u, 1076939786u, 1666995668u, 1077688097u, 1414459791u, 0, EXP_TOLERANCE, 0},
{ 460, 3218211979u, 2488789804u, 3238508333u, 1506943664u, 1072178670u, 1219639660u, 0, EXP_TOLERANCE, 0},
{ 461, 1072788663u, 3844072288u, 3202592279u, 2630019853u, 1074254177u, 2710454031u, 0, EXP_TOLERANCE, 0},
{ 462, 3220983118u, 1244307192u, 3191297711u, 2540916692u, 1069929411u, 857160910u, 0, EXP_TOLERANCE, 0},
{ 463, 3215791332u, 2871645739u, 3239081581u, 1440249115u, 1072577449u, 2224257486u, 0, EXP_TOLERANCE, 0},
{ 464, 1072544937u, 1231934926u, 3236746788u, 603977748u, 1074021104u, 1153376056u, 0, EXP_TOLERANCE, 0},
{ 465, 3214324057u, 2386312545u, 1063169277u, 2715234268u, 1072647284u, 1633360252u, 0, EXP_TOLERANCE, 0},
{ 466, 1077317658u, 915867083u, 1046790892u, 3347417612u, 1106735782u, 2072797994u, 0, EXP_TOLERANCE, 0},
{ 467, 1081866940u, 3553288373u, 1065698616u, 2906680663u, 1749870023u, 2025279999u, 0, EXP_TOLERANCE, 0},
{ 468, 1066477746u, 2342364630u, 1051356723u, 4019093203u, 1072710966u, 3567891728u, 0, EXP_TOLERANCE, 0},
{ 469, 3216897802u, 2911548084u, 1105282515u, 2476735795u, 1072461596u, 2505953515u, 0, EXP_TOLERANCE, 0},
{ 470, 1068298564u, 1836216409u, 1101062307u, 2519592554u, 1072754229u, 2097073093u, 0, EXP_TOLERANCE, 0},
{ 471, 1073323889u, 1235369496u, 3222946447u, 668087854u, 1075042085u, 432513398u, 0, EXP_TOLERANCE, 0},
{ 472, 3217991780u, 2981820811u, 1059838516u, 2845580478u, 1072246576u, 866819828u, 0, EXP_TOLERANCE, 0},
{ 473, 3214902934u, 1565550570u, 3217165795u, 4162017137u, 1072629667u, 221223936u, 0, EXP_TOLERANCE, 0},
{ 474, 3224668466u, 2808968027u, 1055630096u, 1782326814u, 1041545264u, 3106633046u, 0, EXP_TOLERANCE, 0},
{ 475, 1069305614u, 1492622658u, 3216653077u, 3972512122u, 1072815855u, 18398701u, 0, EXP_TOLERANCE, 0},
{ 476, 3222171679u, 2722693603u, 3227814791u, 3169731970u, 1066847382u, 693197204u, 0, EXP_TOLERANCE, 0},
{ 477, 3221052359u, 899763203u, 3207606001u, 2804747833u, 1069838003u, 3960237442u, 0, EXP_TOLERANCE, 0},
{ 478, 3223330293u, 3789058912u, 3228095081u, 4135937628u, 1060420669u, 2863646027u, 0, EXP_TOLERANCE, 0},
{ 479, 1069636566u, 1682808307u, 3206960335u, 232877759u, 1072845544u, 1293413822u, 0, EXP_TOLERANCE, 0},
{ 480, 3226362846u, 2851963139u, 3246852961u, 2590862592u, 980672310u, 2121477897u, 0, EXP_TOLERANCE, 0},
{ 481, 1074908950u, 2422232642u, 3234779662u, 290458310u, 1079342178u, 769697412u, 0, EXP_TOLERANCE, 0},
{ 482, 3219059686u, 1082582386u, 1075605675u, 2602133689u, 1071889068u, 1943466506u, 0, EXP_TOLERANCE, 0},
{ 483, 3226187123u, 1789635787u, 1059414278u, 1048286093u, 988843638u, 1761624532u, 0, EXP_TOLERANCE, 0},
{ 484, 1079456174u, 231339448u, 1055573265u, 504907415u, 1212992503u, 57355760u, 0, EXP_TOLERANCE, 0},
{ 485, 1071600069u, 1153251200u, 3204617090u, 1772013857u, 1073355194u, 2543994465u, 0, EXP_TOLERANCE, 0},
{ 486, 1080676687u, 1082898276u, 3212089272u, 1449080862u, 1385133678u, 3383991944u, 0, EXP_TOLERANCE, 0},
{ 487, 1076571101u, 3177299045u, 1058862813u, 809400815u, 1093156946u, 1324449489u, 0, EXP_TOLERANCE, 0},
{ 488, 3223514518u, 1924429710u, 1056464743u, 3349283177u, 1058297638u, 3331281830u, 0, EXP_TOLERANCE, 0},
{ 489, 3226599023u, 42238036u, 1042379500u, 2113559863u, 963765357u, 1028628530u, 0, EXP_TOLERANCE, 0},
{ 490, 1071052699u, 3304403230u, 3217556703u, 58952646u, 1073145918u, 2870415022u, 0, EXP_TOLERANCE, 0},
{ 491, 3218960986u, 1645486982u, 3224301095u, 3636267471u, 1071919855u, 1479310056u, 0, EXP_TOLERANCE, 0},
{ 492, 1071150617u, 619402181u, 3235208235u, 557360557u, 1073181378u, 211059331u, 0, EXP_TOLERANCE, 0},
{ 493, 3225655482u, 110029735u, 1046937383u, 984375729u, 1013314403u, 3677128438u, 0, EXP_TOLERANCE, 0},
{ 494, 3213613986u, 4063688092u, 3203235744u, 1049950343u, 1072664914u, 2549757512u, 0, EXP_TOLERANCE, 0},
{ 495, 1070739227u, 650996069u, 1054971928u, 3953359826u, 1073037809u, 838695363u, 0, EXP_TOLERANCE, 0},
{ 496, 3222861501u, 66926332u, 1090561839u, 1379780888u, 1063250554u, 387700961u, 0, EXP_TOLERANCE, 0},
{ 497, 3224016123u, 2803378256u, 1086057989u, 498534626u, 1052530954u, 1101873220u, 0, EXP_TOLERANCE, 0},
{ 498, 1076327097u, 2846400785u, 1047142525u, 1375153550u, 1090398038u, 3404434636u, 0, EXP_TOLERANCE, 0},
{ 499, 1066601297u, 2869128958u, 1070972315u, 4246440273u, 1072712931u, 3206431290u, 0, EXP_TOLERANCE, 0},
{ 500, 1067561146u, 3112381207u, 1044430965u, 3981604561u, 1072730111u, 14195977u, 0, EXP_TOLERANCE, 0},
{ 501, 3223914965u, 243303420u, 1093735824u, 1575581926u, 1053731509u, 904055362u, 0, EXP_TOLERANCE, 0},
{ 502, 3225506509u, 3218865041u, 3204803496u, 3840388050u, 1020275468u, 1833594413u, 0, EXP_TOLERANCE, 0},
{ 503, 1067289799u, 336846959u, 1052664471u, 3798336786u, 1072723947u, 4034846420u, 0, EXP_TOLERANCE, 0},
{ 504, 1068537148u, 3639240976u, 1081202165u, 1844741676u, 1072763420u, 176306533u, 0, EXP_TOLERANCE, 0},
{ 505, 3218196249u, 717293069u, 3211534283u, 582401011u, 1072184616u, 3222172175u, 0, EXP_TOLERANCE, 0},
{ 506, 3228893840u, 3766248610u, 3196520332u, 1174437546u, 564150813u, 811276996u, 0, EXP_TOLERANCE, 0},
{ 507, 1076091194u, 756959182u, 3204099341u, 1581804034u, 1087631618u, 1978209737u, 0, EXP_TOLERANCE, 0},
{ 508, 3217340780u, 3560686300u, 3220980617u, 4277975772u, 1072379763u, 1155762898u, 0, EXP_TOLERANCE, 0},
{ 509, 3218294684u, 2598148853u, 3217622194u, 3460421008u, 1072147770u, 346718411u, 0, EXP_TOLERANCE, 0},
{ 510, 1071963704u, 136600515u, 3209934920u, 3340653128u, 1073657537u, 2596417839u, 0, EXP_TOLERANCE, 0},
{ 511, 1078994518u, 1045480938u, 3251354609u, 4133432965u, 1170363966u, 1471292306u, 0, EXP_TOLERANCE, 0},
{ 512, 1077967943u, 1630207738u, 3239996829u, 2393354808u, 1122481140u, 2643918337u, 0, EXP_TOLERANCE, 0},
{ 513, 3213694690u, 3739770117u, 1059520750u, 3959551225u, 1072663671u, 23114429u, 0, EXP_TOLERANCE, 0},
{ 514, 3223390473u, 1498861716u, 1091297147u, 847410798u, 1059730387u, 1062439242u, 0, EXP_TOLERANCE, 0},
{ 515, 1073516688u, 983275314u, 3232538664u, 2244973629u, 1075304551u, 788448980u, 0, EXP_TOLERANCE, 0},
{ 516, 1069529329u, 2353103845u, 3235718771u, 2978889966u, 1072831576u, 2964825654u, 0, EXP_TOLERANCE, 0},
{ 517, 3229337896u, 1546972125u, 3249076079u, 1987349196u, 400067810u, 350725282u, 0, EXP_TOLERANCE, 0},
{ 518, 3225636601u, 2769161072u, 1075207126u, 292616282u, 1014204187u, 2505832380u, 0, EXP_TOLERANCE, 0},
{ 519, 3215440938u, 36855311u, 1052128202u, 1479039342u, 1072598248u, 1535663252u, 0, EXP_TOLERANCE, 0},
{ 520, 1076417021u, 2027463605u, 1066023013u, 3369686340u, 1091432667u, 1056725485u, 0, EXP_TOLERANCE, 0},
{ 521, 3215678541u, 3808681655u, 1054161346u, 1821773119u, 1072584120u, 3865333882u, 0, EXP_TOLERANCE, 0},
{ 522, 1065851752u, 3175490326u, 3226879970u, 845687760u, 1072705404u, 3214402448u, 0, EXP_TOLERANCE, 0},
{ 523, 1065371665u, 3124482451u, 3242748377u, 3259417226u, 1072701617u, 1556794065u, 0, EXP_TOLERANCE, 0},
{ 524, 1067265791u, 2751606436u, 3236210939u, 3923142740u, 1072723561u, 3907206090u, 0, EXP_TOLERANCE, 0},
{ 525, 1079966097u, 2016872044u, 3228408064u, 4201274408u, 1260053709u, 2351383485u, 0, EXP_TOLERANCE, 0},
{ 526, 3215077894u, 1019916843u, 3219974785u, 1977881787u, 1072620028u, 1513873245u, 0, EXP_TOLERANCE, 0},
{ 527, 3215207392u, 2060433318u, 1075872515u, 366073725u, 1072612232u, 1485589014u, 0, EXP_TOLERANCE, 0},
{ 528, 3213200653u, 1098469906u, 1082900695u, 2349346832u, 1072671295u, 2138435974u, 0, EXP_TOLERANCE, 0},
{ 529, 3218363315u, 3011196295u, 3252479932u, 2459281672u, 1072122586u, 3209321029u, 0, EXP_TOLERANCE, 0},
{ 530, 3221334323u, 2843222682u, 1089275809u, 298982001u, 1069295228u, 2479655835u, 0, EXP_TOLERANCE, 0},
{ 531, 1080766178u, 914741728u, 3203468059u, 2833809843u, 1401595225u, 1543027566u, 0, EXP_TOLERANCE, 0},
{ 532, 3225229542u, 1274901962u, 3241535845u, 3759113509u, 1028668815u, 1805280638u, 0, EXP_TOLERANCE, 0},
{ 533, 3227042074u, 2134927252u, 3253802671u, 3013731444u, 922860414u, 1506262932u, 0, EXP_TOLERANCE, 0},
{ 534, 1080326973u, 2230655177u, 3254510616u, 1249674366u, 1320480180u, 3545707614u, 0, EXP_TOLERANCE, 0},
{ 535, 1071359861u, 717357389u, 1083533731u, 3746683362u, 1073259985u, 785194633u, 0, EXP_TOLERANCE, 0},
{ 536, 3220064570u, 834976849u, 3217357661u, 2465861779u, 1071175416u, 1040443015u, 0, EXP_TOLERANCE, 0},
{ 537, 1066627637u, 1385714428u, 1053358395u, 3007113740u, 1072713351u, 479550567u, 0, EXP_TOLERANCE, 0},
{ 538, 1068353711u, 599268545u, 3201368210u, 2309854744u, 1072756054u, 2342579642u, 0, EXP_TOLERANCE, 0},
{ 539, 1073100182u, 2840234388u, 3232496515u, 333365983u, 1074792277u, 1476863741u, 0, EXP_TOLERANCE, 0},
{ 540, 1066894301u, 3136078996u, 3194520860u, 2650572904u, 1072717606u, 314014954u, 0, EXP_TOLERANCE, 0},
{ 541, 3224250507u, 2405805086u, 3251640319u, 324233833u, 1049818942u, 619300132u, 0, EXP_TOLERANCE, 0},
{ 542, 1081533322u, 2589598340u, 3254677807u, 952438812u, 1626625304u, 2555502454u, 0, EXP_TOLERANCE, 0},
{ 543, 3213232021u, 1922837702u, 3216892718u, 3535907549u, 1072670810u, 2392774352u, 0, EXP_TOLERANCE, 0},
{ 544, 3226838652u, 261447440u, 3209805849u, 1150571079u, 941666308u, 2929954307u, 0, EXP_TOLERANCE, 0},
{ 545, 1079028016u, 4026487528u, 1073152064u, 27340691u, 1173468543u, 273403284u, 0, EXP_TOLERANCE, 0},
{ 546, 3222832236u, 338765118u, 1086225786u, 3207238249u, 1063376827u, 2552266259u, 0, EXP_TOLERANCE, 0},
{ 547, 3215057071u, 1085283176u, 3187775111u, 1601194210u, 1072621284u, 3181137750u, 0, EXP_TOLERANCE, 0},
{ 548, 1078937261u, 3031712790u, 3252307859u, 170666844u, 1167258064u, 3602398320u, 0, EXP_TOLERANCE, 0},
{ 549, 3220959383u, 3148395674u, 1041913758u, 3306391490u, 1069962159u, 449105735u, 0, EXP_TOLERANCE, 0},
{ 550, 3217005710u, 2205233857u, 3208100078u, 3993195511u, 1072449636u, 2341049361u, 0, EXP_TOLERANCE, 0},
{ 551, 1071893912u, 4282766727u, 1072820377u, 1874778218u, 1073591653u, 3798859726u, 0, EXP_TOLERANCE, 0},
{ 552, 3218173124u, 2920860798u, 3218070226u, 3104066154u, 1072193398u, 4039462005u, 0, EXP_TOLERANCE, 0},
{ 553, 3217533263u, 969991373u, 3250596895u, 1734386152u, 1072339301u, 3336979462u, 0, EXP_TOLERANCE, 0},
{ 554, 3226332906u, 1218740205u, 3239802737u, 2610078504u, 982042268u, 3949815583u, 0, EXP_TOLERANCE, 0},
{ 555, 3217565578u, 1485218325u, 3220870240u, 3591664613u, 1072332599u, 1755137557u, 0, EXP_TOLERANCE, 0},
{ 556, 3216754207u, 690157417u, 3190850619u, 4192347699u, 1072477631u, 3662215240u, 0, EXP_TOLERANCE, 0},
{ 557, 1079276594u, 4009839784u, 1079670252u, 394167192u, 1196450945u, 2525536651u, 0, EXP_TOLERANCE, 0},
{ 558, 3225122053u, 961532417u, 1092588071u, 2923790239u, 1031073549u, 1672191880u, 0, EXP_TOLERANCE, 0},
{ 559, 3216462003u, 4174125604u, 1050682630u, 2169701868u, 1072510688u, 4180692824u, 0, EXP_TOLERANCE, 0},
{ 560, 3227363835u, 4146748230u, 1087373950u, 2481478351u, 893135089u, 582298895u, 0, EXP_TOLERANCE, 0},
{ 561, 1073842138u, 3984715440u, 1050421618u, 2446142566u, 1075963121u, 1824117845u, 0, EXP_TOLERANCE, 0},
{ 562, 1076832374u, 936290150u, 1100614426u, 3625806370u, 1096171572u, 79506205u, 0, EXP_TOLERANCE, 0},
{ 563, 1080913584u, 1866615265u, 3215651428u, 2337013350u, 1428810148u, 2464900529u, 0, EXP_TOLERANCE, 0},
{ 564, 3229081054u, 712227971u, 1106004723u, 973148499u, 494989773u, 881372988u, 0, EXP_TOLERANCE, 0},
{ 565, 3223796743u, 3409813738u, 3244817008u, 1933503498u, 1055057116u, 1987951892u, 0, EXP_TOLERANCE, 0},
{ 566, 1075749429u, 3180389060u, 3228735703u, 83422217u, 1084263619u, 3719345681u, 0, EXP_TOLERANCE, 0},
{ 567, 1074732996u, 556972671u, 3204582372u, 841555801u, 1078491082u, 3497361082u, 0, EXP_TOLERANCE, 0},
{ 568, 1072864873u, 4189151332u, 1080874032u, 706326922u, 1074371849u, 3237121563u, 0, EXP_TOLERANCE, 0},
{ 569, 1079374091u, 198291836u, 1057281892u, 2188836928u, 1205376783u, 2535783908u, 0, EXP_TOLERANCE, 0},
{ 570, 1074946267u, 1219449298u, 3228734687u, 3504562743u, 1079557279u, 563112082u, 0, EXP_TOLERANCE, 0},
{ 571, 3217153376u, 1776099219u, 1094316777u, 4188083896u, 1072420059u, 1952839512u, 0, EXP_TOLERANCE, 0},
{ 572, 3214817228u, 2614400266u, 1073750227u, 3003203347u, 1072632265u, 3501612041u, 0, EXP_TOLERANCE, 0},
{ 573, 3219225558u, 2959351406u, 1105603716u, 311851587u, 1071810451u, 740693120u, 0, EXP_TOLERANCE, 0},
{ 574, 1076155826u, 865443613u, 1097532516u, 3622237781u, 1088443249u, 3543760780u, 0, EXP_TOLERANCE, 0},
{ 575, 3223398058u, 447506102u, 3195759295u, 3603669725u, 1059633838u, 605796371u, 0, EXP_TOLERANCE, 0},
{ 576, 1079015805u, 3934398273u, 1040996422u, 2968621268u, 1172360989u, 1233059955u, 0, EXP_TOLERANCE, 0},
{ 577, 3215614193u, 784208771u, 1088764788u, 2182296421u, 1072587937u, 320113544u, 0, EXP_TOLERANCE, 0},
{ 578, 3228409347u, 1527590526u, 3206961556u, 2823164069u, 714212086u, 3700796565u, 0, EXP_TOLERANCE, 0},
{ 579, 3225109795u, 3876699591u, 3207481130u, 4028148535u, 1031355705u, 3297444173u, 0, EXP_TOLERANCE, 0},
{ 580, 1076236154u, 2164249756u, 1059857743u, 1785169952u, 1089348091u, 3028702007u, 0, EXP_TOLERANCE, 0},
{ 581, 1078172521u, 2079273665u, 1080303860u, 625760474u, 1131925960u, 2820657748u, 0, EXP_TOLERANCE, 0},
{ 582, 3222291804u, 3636214836u, 1068367620u, 2932621925u, 1066501856u, 2508581844u, 0, EXP_TOLERANCE, 0},
{ 583, 1066015468u, 4274131512u, 1047707755u, 92550763u, 1072706699u, 1716559078u, 0, EXP_TOLERANCE, 0},
{ 584, 3215599337u, 2648933384u, 1084603503u, 3534304873u, 1072588819u, 508060763u, 0, EXP_TOLERANCE, 0},
{ 585, 1070854691u, 3216750767u, 3191088629u, 547482628u, 1073076693u, 2158989442u, 0, EXP_TOLERANCE, 0},
{ 586, 1070521958u, 1420360746u, 1080063101u, 1690029499u, 1072979223u, 1425260532u, 0, EXP_TOLERANCE, 0},
{ 587, 3223563908u, 1908572179u, 1080112083u, 1228319033u, 1057745063u, 1750491909u, 0, EXP_TOLERANCE, 0},
{ 588, 1067032546u, 500312015u, 3212368508u, 3864619086u, 1072719818u, 2566005358u, 0, EXP_TOLERANCE, 0},
{ 589, 3221335610u, 4211343447u, 1087492676u, 4272583781u, 1069290704u, 1406122007u, 0, EXP_TOLERANCE, 0},
{ 590, 1080518026u, 2382118000u, 1042665328u, 567154882u, 1355833620u, 2043686521u, 0, EXP_TOLERANCE, 0},
{ 591, 1069547778u, 1435344339u, 3216303171u, 2275988178u, 1072832900u, 3711969349u, 0, EXP_TOLERANCE, 0},
{ 592, 3219781499u, 3403659753u, 3218043030u, 1926480488u, 1071410667u, 198580343u, 0, EXP_TOLERANCE, 0},
{ 593, 1074743231u, 1198845185u, 3225556149u, 1130089684u, 1078522694u, 2138026103u, 0, EXP_TOLERANCE, 0},
{ 594, 3221614466u, 2183928090u, 1048403956u, 963834821u, 1068531570u, 1143881486u, 0, EXP_TOLERANCE, 0},
{ 595, 1080701440u, 2120625396u, 1041006976u, 2137548527u, 1389637151u, 2814596158u, 0, EXP_TOLERANCE, 0},
{ 596, 1080355870u, 586700956u, 1059670521u, 303891699u, 1325810327u, 2561465523u, 0, EXP_TOLERANCE, 0},
{ 597, 3221091650u, 2509132460u, 1102827530u, 2205707903u, 1069788756u, 946327002u, 0, EXP_TOLERANCE, 0},
{ 598, 3217443509u, 1229308263u, 3209170414u, 4206576047u, 1072358053u, 1505047828u, 0, EXP_TOLERANCE, 0},
{ 599, 3221979137u, 4078010749u, 3199236456u, 733478972u, 1067480393u, 1883768308u, 0, EXP_TOLERANCE, 0},
{ 600, 3215538376u, 4277541051u, 3199806921u, 397102023u, 1072592442u, 3112407863u, 0, EXP_TOLERANCE, 0},
{ 601, 3214849381u, 900999594u, 3234720188u, 2530214248u, 1072631290u, 2136324251u, 0, EXP_TOLERANCE, 0},
{ 602, 1074446396u, 4000609478u, 1096577064u, 4148592328u, 1077695508u, 2530213621u, 0, EXP_TOLERANCE, 0},
{ 603, 1067542452u, 2154187873u, 3224392607u, 3957250362u, 1072729506u, 1888618017u, 0, EXP_TOLERANCE, 0},
{ 604, 3221316336u, 2867079200u, 1101870326u, 921212001u, 1069359619u, 1291621322u, 0, EXP_TOLERANCE, 0},
{ 605, 3223784706u, 674547716u, 1063216239u, 3929755226u, 1055176221u, 2342580293u, 0, EXP_TOLERANCE, 0},
{ 606, 3225735787u, 3158182449u, 1043794244u, 3259056345u, 1009666296u, 2099303467u, 0, EXP_TOLERANCE, 0},
{ 607, 3225242320u, 3002823940u, 1059511739u, 2832435794u, 1028307478u, 65827691u, 0, EXP_TOLERANCE, 0},
{ 608, 3220450550u, 2196511929u, 1049973941u, 3672092877u, 1070736089u, 371341051u, 0, EXP_TOLERANCE, 0},
{ 609, 1068263848u, 3655292191u, 1086438127u, 3567072906u, 1072753082u, 551440254u, 0, EXP_TOLERANCE, 0},
{ 610, 3227458308u, 1617573614u, 3201863123u, 3090723732u, 884380609u, 990057858u, 0, EXP_TOLERANCE, 0},
{ 611, 3223764196u, 679893506u, 3211547753u, 824081024u, 1055406136u, 1185397254u, 0, EXP_TOLERANCE, 0},
{ 612, 1076947613u, 2285242807u, 1084999409u, 2221731406u, 1098199194u, 2093305428u, 0, EXP_TOLERANCE, 0},
{ 613, 3217219424u, 1935990727u, 1088822246u, 1058156518u, 1072405754u, 3411302972u, 0, EXP_TOLERANCE, 0},
{ 614, 1080819070u, 521023584u, 1059186903u, 4245163857u, 1411420761u, 1987577595u, 0, EXP_TOLERANCE, 0},
{ 615, 1081871044u, 2312887617u, 3191771354u, 1885370807u, 1751362761u, 485435265u, 0, EXP_TOLERANCE, 0},
{ 616, 3228836567u, 1796441468u, 1100030327u, 2772711004u, 585257982u, 1197588774u, 0, EXP_TOLERANCE, 0},
{ 617, 3216859732u, 2095685003u, 1077984448u, 2100773742u, 1072465834u, 2188254173u, 0, EXP_TOLERANCE, 0},
{ 618, 3213926140u, 2892538035u, 1042396334u, 4162200338u, 1072659482u, 3755395969u, 0, EXP_TOLERANCE, 0},
{ 619, 3226997111u, 2177698116u, 3227557177u, 150832500u, 927022330u, 2114378896u, 0, EXP_TOLERANCE, 0},
{ 620, 3213582312u, 607966734u, 3236250630u, 4164600559u, 1072665402u, 3794761595u, 0, EXP_TOLERANCE, 0},
{ 621, 3219535540u, 2830122967u, 1046096700u, 3713346883u, 1071642511u, 1936011333u, 0, EXP_TOLERANCE, 0},
{ 622, 3224615051u, 2314640506u, 3203696416u, 3276228872u, 1042769881u, 709365161u, 0, EXP_TOLERANCE, 0},
{ 623, 3219203763u, 469331883u, 3249037349u, 2999233437u, 1071823137u, 3035360404u, 0, EXP_TOLERANCE, 0},
{ 624, 1079556219u, 560886625u, 1091899487u, 748795120u, 1222196219u, 1766795176u, 0, EXP_TOLERANCE, 0},
{ 625, 1067712650u, 2958421324u, 1092569414u, 3235243477u, 1072735023u, 111129972u, 0, EXP_TOLERANCE, 0},
{ 626, 3213998017u, 3221475559u, 1043038304u, 915608434u, 1072657274u, 270655903u, 0, EXP_TOLERANCE, 0},
{ 627, 1073294682u, 3007808652u, 3216682290u, 2531019474u, 1075006367u, 3946889810u, 0, EXP_TOLERANCE, 0},
{ 628, 3226300359u, 1767658578u, 3237045269u, 2313128318u, 983611715u, 1963249883u, 0, EXP_TOLERANCE, 0},
{ 629, 3219006500u, 1926845182u, 1066835624u, 1783256828u, 1071905568u, 1550065103u, 0, EXP_TOLERANCE, 0},
{ 630, 1065741453u, 90378038u, 1057168870u, 164358218u, 1072704533u, 1716133177u, 0, EXP_TOLERANCE, 0},
{ 631, 1081693348u, 1610524680u, 1085283851u, 2903496007u, 1685728394u, 520929572u, 0, EXP_TOLERANCE, 0},
{ 632, 1075489858u, 4274321404u, 3202913591u, 720121831u, 1082693625u, 2845193504u, 0, EXP_TOLERANCE, 0},
{ 633, 1067982472u, 2034778236u, 1071133763u, 1413236391u, 1072743826u, 988128607u, 0, EXP_TOLERANCE, 0},
{ 634, 1067840244u, 1489112261u, 1076691395u, 348210906u, 1072739177u, 317516419u, 0, EXP_TOLERANCE, 0},
{ 635, 3217229677u, 2797651324u, 3224410527u, 2374818327u, 1072403544u, 1037637956u, 0, EXP_TOLERANCE, 0},
{ 636, 1077801496u, 1823161666u, 3197810695u, 3119680047u, 1117940019u, 2045262415u, 0, EXP_TOLERANCE, 0},
{ 637, 1072218792u, 3420950657u, 1087084743u, 2136638961u, 1073829855u, 2407470294u, 0, EXP_TOLERANCE, 0},
{ 638, 1073047952u, 3554566429u, 1062907717u, 2736702589u, 1074692071u, 2140620171u, 0, EXP_TOLERANCE, 0},
{ 639, 3227062875u, 2928437580u, 3187765027u, 1393427873u, 920907098u, 4135143034u, 0, EXP_TOLERANCE, 0},
{ 640, 3218738745u, 189447067u, 1051643315u, 828663513u, 1071991888u, 870021011u, 0, EXP_TOLERANCE, 0},
{ 641, 1068042509u, 2852350928u, 1045683757u, 673354280u, 1072745794u, 2790514124u, 0, EXP_TOLERANCE, 0},
{ 642, 1065966397u, 3589563265u, 3248741629u, 812657927u, 1072706311u, 791385654u, 0, EXP_TOLERANCE, 0},
{ 643, 3213679498u, 1766416701u, 1100392103u, 2185373290u, 1072663905u, 227240416u, 0, EXP_TOLERANCE, 0},
{ 644, 3220275389u, 3763582673u, 3191965790u, 388374829u, 1070952181u, 2061416280u, 0, EXP_TOLERANCE, 0},
{ 645, 1075440832u, 1187403069u, 1075300235u, 336640304u, 1082418698u, 3092350278u, 0, EXP_TOLERANCE, 0},
{ 646, 1081906155u, 1718795752u, 3243118752u, 683369237u, 1764318904u, 2150807698u, 0, EXP_TOLERANCE, 0},
{ 647, 3218132129u, 1863545307u, 1069449477u, 3418627399u, 1072209087u, 2449778810u, 0, EXP_TOLERANCE, 0},
{ 648, 1072747022u, 3295607249u, 1068878592u, 1633297809u, 1074193404u, 2476970617u, 0, EXP_TOLERANCE, 0},
{ 649, 1070481463u, 2585980994u, 3236670483u, 1286750688u, 1072972796u, 2203733059u, 0, EXP_TOLERANCE, 0},
{ 650, 1067128553u, 15816845u, 3233249283u, 2491924775u, 1072721357u, 3513632630u, 0, EXP_TOLERANCE, 0},
{ 651, 1065481693u, 1051983351u, 1049180786u, 1474421917u, 1072702484u, 724278735u, 0, EXP_TOLERANCE, 0},
{ 652, 3216978165u, 2003816032u, 1086050104u, 668090487u, 1072452682u, 906509909u, 0, EXP_TOLERANCE, 0},
{ 653, 1068284677u, 3671484625u, 1067020039u, 430024694u, 1072753770u, 1677416970u, 0, EXP_TOLERANCE, 0},
{ 654, 1072639990u, 3991830201u, 3207808714u, 1021245839u, 1074082674u, 1254795532u, 0, EXP_TOLERANCE, 0},
{ 655, 1071534423u, 4255801807u, 3207681716u, 1926756877u, 1073328631u, 2248030752u, 0, EXP_TOLERANCE, 0},
{ 656, 1067869425u, 4167786896u, 1077097744u, 1775517981u, 1072740129u, 1534603149u, 0, EXP_TOLERANCE, 0},
{ 657, 1076164794u, 3187518564u, 1082437406u, 944672491u, 1088519022u, 2668154428u, 0, EXP_TOLERANCE, 0},
{ 658, 1068240650u, 953085192u, 3227310828u, 3459155777u, 1072752316u, 293671938u, 0, EXP_TOLERANCE, 0},
{ 659, 1072648234u, 1908555460u, 1073640207u, 260441967u, 1074088146u, 2650479583u, 0, EXP_TOLERANCE, 0},
{ 660, 1072462486u, 250762477u, 1072582645u, 2886742039u, 1073969911u, 1983590134u, 0, EXP_TOLERANCE, 0},
{ 661, 3228885910u, 786180031u, 3197734769u, 2788918312u, 567029081u, 1303524864u, 0, EXP_TOLERANCE, 0},
{ 662, 3225074643u, 2055912467u, 3244244909u, 1394142937u, 1032164285u, 2520921127u, 0, EXP_TOLERANCE, 0},
{ 663, 1072758713u, 91984146u, 3222252812u, 4126276047u, 1074210222u, 4046645726u, 0, EXP_TOLERANCE, 0},
{ 664, 1075048683u, 3942715706u, 3239316352u, 410676547u, 1080182733u, 198592884u, 0, EXP_TOLERANCE, 0},
{ 665, 3215335062u, 86296211u, 1085850694u, 649202596u, 1072604575u, 3552442703u, 0, EXP_TOLERANCE, 0},
{ 666, 3226492024u, 3069064472u, 3237358008u, 23209276u, 973600692u, 3560381944u, 0, EXP_TOLERANCE, 0},
{ 667, 1074943832u, 1867297860u, 1072956607u, 2513414118u, 1079542291u, 1065513243u, 0, EXP_TOLERANCE, 0},
{ 668, 3228513251u, 3171788768u, 3235208783u, 162138697u, 695028140u, 3343634362u, 0, EXP_TOLERANCE, 0},
{ 669, 1075436999u, 1245110700u, 1081653954u, 2584994077u, 1082399294u, 168782383u, 0, EXP_TOLERANCE, 0},
{ 670, 3226635752u, 3347226587u, 1058962932u, 2291943376u, 960392171u, 946952000u, 0, EXP_TOLERANCE, 0},
{ 671, 1070433398u, 966940828u, 1060726420u, 2798041096u, 1072965208u, 1430944161u, 0, EXP_TOLERANCE, 0},
{ 672, 1072793759u, 2487340727u, 3223786370u, 4105954991u, 1074261781u, 2671510586u, 0, EXP_TOLERANCE, 0},
{ 673, 3228193553u, 1671039260u, 1086395032u, 3745833360u, 754060863u, 1699618982u, 0, EXP_TOLERANCE, 0},
{ 674, 1069661709u, 651714217u, 1047070645u, 2130549237u, 1072849149u, 67549253u, 0, EXP_TOLERANCE, 0},
{ 675, 3217601491u, 1423000172u, 3247822717u, 1551488170u, 1072325181u, 206424647u, 0, EXP_TOLERANCE, 0},
{ 676, 3216277371u, 921077236u, 3213332351u, 1431049019u, 1072531875u, 1612803421u, 0, EXP_TOLERANCE, 0},
{ 677, 1071704599u, 655715547u, 3190985373u, 1527556471u, 1073423595u, 3219744316u, 0, EXP_TOLERANCE, 0},
{ 678, 3222412099u, 4110878657u, 3251297180u, 879739345u, 1065756487u, 2212366251u, 0, EXP_TOLERANCE, 0},
{ 679, 1076367578u, 2623955764u, 1093699897u, 1216444475u, 1090816075u, 3859513056u, 0, EXP_TOLERANCE, 0},
{ 680, 1078274115u, 107442539u, 3239767031u, 1149813329u, 1136691095u, 2525054892u, 0, EXP_TOLERANCE, 0},
{ 681, 3224008056u, 1761361082u, 3226030205u, 1121849716u, 1052648890u, 3257183639u, 0, EXP_TOLERANCE, 0},
{ 682, 3226455627u, 2534144722u, 1044223733u, 3512285706u, 976403563u, 1539377918u, 0, EXP_TOLERANCE, 0},
{ 683, 3218137533u, 4073670723u, 1050729852u, 3034818849u, 1072207010u, 2190601685u, 0, EXP_TOLERANCE, 0},
{ 684, 1081013054u, 1421423503u, 1060278048u, 1397153092u, 1447201916u, 3645912721u, 0, EXP_TOLERANCE, 0},
{ 685, 3220567557u, 1649206019u, 1104525577u, 1267104290u, 1070610592u, 3909007411u, 0, EXP_TOLERANCE, 0},
{ 686, 3213419345u, 3775270392u, 1040251850u, 68667319u, 1072667916u, 4071660364u, 0, EXP_TOLERANCE, 0},
{ 687, 3216913812u, 3099226694u, 3254103006u, 4020102648u, 1072459817u, 1012804737u, 0, EXP_TOLERANCE, 0},
{ 688, 3216271776u, 3718441177u, 3215643451u, 4032951536u, 1072532520u, 4153916148u, 0, EXP_TOLERANCE, 0},
{ 689, 1066151467u, 508048351u, 3210196713u, 1707937896u, 1072707776u, 258625177u, 0, EXP_TOLERANCE, 0},
{ 690, 3215388843u, 2784738160u, 1073435430u, 1109346010u, 1072601359u, 769624204u, 0, EXP_TOLERANCE, 0},
{ 691, 3222579562u, 3331916473u, 3238794568u, 2707019594u, 1064788968u, 937187646u, 0, EXP_TOLERANCE, 0},
{ 692, 1078502606u, 3093165197u, 1072894805u, 2853215019u, 1147222804u, 2594603642u, 0, EXP_TOLERANCE, 0},
{ 693, 3219727867u, 2135797997u, 1048399559u, 2941926126u, 1071458929u, 1831646623u, 0, EXP_TOLERANCE, 0},
{ 694, 1067305348u, 2083412145u, 3249335391u, 507212448u, 1072724198u, 176926544u, 0, EXP_TOLERANCE, 0},
{ 695, 1074315175u, 4270176401u, 3246546709u, 3288753319u, 1077284434u, 1533074967u, 0, EXP_TOLERANCE, 0},
{ 696, 3228009919u, 3692175292u, 3197271515u, 3989064196u, 787929498u, 530433217u, 0, EXP_TOLERANCE, 0},
{ 697, 3228623066u, 3111924274u, 1066772558u, 59281695u, 664079135u, 3761950200u, 0, EXP_TOLERANCE, 0},
{ 698, 1071878215u, 2135245466u, 3208804313u, 3846547392u, 1073577134u, 3594627032u, 0, EXP_TOLERANCE, 0},
{ 699, 1079149171u, 972051266u, 3222814246u, 3539700586u, 1184638055u, 2607924773u, 0, EXP_TOLERANCE, 0},
{ 700, 3216597418u, 330951080u, 1079189813u, 583922384u, 1072495297u, 3853879766u, 0, EXP_TOLERANCE, 0},
{ 701, 1077057180u, 1711944085u, 1104170032u, 643991456u, 1100755327u, 436337680u, 0, EXP_TOLERANCE, 0},
{ 702, 3224992365u, 2072550721u, 3250147641u, 4280263530u, 1034088022u, 2955452855u, 0, EXP_TOLERANCE, 0},
{ 703, 3213944226u, 1566376352u, 1067251433u, 72984588u, 1072658926u, 3741224203u, 0, EXP_TOLERANCE, 0},
{ 704, 1079547929u, 3103043079u, 1045853123u, 410067497u, 1221488103u, 692790947u, 0, EXP_TOLERANCE, 0},
{ 705, 3219818221u, 1910366299u, 1081770885u, 634683073u, 1071378326u, 3640151292u, 0, EXP_TOLERANCE, 0},
{ 706, 1075239232u, 2226525875u, 3224149290u, 2126302825u, 1081272417u, 3298903549u, 0, EXP_TOLERANCE, 0},
{ 707, 1073150247u, 1383818978u, 3193885723u, 1220372650u, 1074843648u, 1040872434u, 0, EXP_TOLERANCE, 0},
{ 708, 1071725823u, 1953339096u, 1077176252u, 1476516558u, 1073441690u, 3533967691u, 0, EXP_TOLERANCE, 0},
{ 709, 1072383456u, 1306277326u, 1079089150u, 4093716191u, 1073922696u, 2073217550u, 0, EXP_TOLERANCE, 0},
{ 710, 3223711603u, 51750045u, 3242913901u, 4256866157u, 1056052895u, 2162728962u, 0, EXP_TOLERANCE, 0},
{ 711, 3213959335u, 2163853087u, 3232053146u, 2962422808u, 1072658462u, 2104272775u, 0, EXP_TOLERANCE, 0},
{ 712, 1074468369u, 1618388148u, 3233154824u, 3711953164u, 1077774967u, 2677827653u, 0, EXP_TOLERANCE, 0},
{ 713, 3227993634u, 357108214u, 3202294604u, 2306775262u, 790944380u, 765011821u, 0, EXP_TOLERANCE, 0},
{ 714, 3216584150u, 2571356437u, 3249064063u, 2394851808u, 1072496800u, 1660021973u, 0, EXP_TOLERANCE, 0},
{ 715, 3224196635u, 4273880094u, 1103698617u, 3578832032u, 1050450775u, 303911533u, 0, EXP_TOLERANCE, 0},
{ 716, 3223989517u, 2091068742u, 3228270226u, 3980489730u, 1052859686u, 2610368796u, 0, EXP_TOLERANCE, 0},
{ 717, 3222725296u, 2772307714u, 1051008486u, 32546576u, 1063965846u, 2154006417u, 0, EXP_TOLERANCE, 0},
{ 718, 3225500575u, 2143788498u, 3195498043u, 3630119231u, 1020485834u, 409157440u, 0, EXP_TOLERANCE, 0},
{ 719, 3215410151u, 2527385594u, 3240503648u, 3482095012u, 1072600086u, 811621435u, 0, EXP_TOLERANCE, 0},
{ 720, 3226440159u, 2690097362u, 1068598730u, 2360266862u, 977144307u, 2410462353u, 0, EXP_TOLERANCE, 0},
{ 721, 1070392205u, 2673272949u, 1082639557u, 522449749u, 1072958739u, 2923917591u, 0, EXP_TOLERANCE, 0},
{ 722, 1081355475u, 3596379400u, 3242016775u, 2002293002u, 1560941176u, 3057535830u, 0, EXP_TOLERANCE, 0},
{ 723, 1080565288u, 4113224369u, 3222122439u, 2152316893u, 1364491948u, 2667631927u, 0, EXP_TOLERANCE, 0},
{ 724, 3220796716u, 31662602u, 1047721249u, 1747087514u, 1070207704u, 1554554093u, 0, EXP_TOLERANCE, 0},
{ 725, 3228443661u, 2489659568u, 1097051253u, 277506957u, 707885899u, 1135160826u, 0, EXP_TOLERANCE, 0},
{ 726, 3213421930u, 3850162281u, 3213841942u, 438724093u, 1072667877u, 194850427u, 0, EXP_TOLERANCE, 0},
{ 727, 1079663895u, 2431814052u, 1075518084u, 2672434118u, 1232182675u, 340027527u, 0, EXP_TOLERANCE, 0},
{ 728, 3227434095u, 391606792u, 1048184750u, 4168944276u, 886619642u, 2173937429u, 0, EXP_TOLERANCE, 0},
{ 729, 3227869472u, 457529672u, 3201090276u, 72407935u, 813892000u, 300809617u, 0, EXP_TOLERANCE, 0},
{ 730, 3220817871u, 3954981400u, 1052053242u, 2411049585u, 1070173574u, 549649836u, 0, EXP_TOLERANCE, 0},
{ 731, 1076742907u, 485456950u, 1088415093u, 1655397424u, 1095138487u, 1354370438u, 0, EXP_TOLERANCE, 0},
{ 732, 3215011644u, 1551748070u, 3236871640u, 1329701152u, 1072624028u, 1513346128u, 0, EXP_TOLERANCE, 0},
{ 733, 3221493394u, 3099222537u, 1104984570u, 4293792842u, 1068812430u, 62941796u, 0, EXP_TOLERANCE, 0},
{ 734, 3216532617u, 3603065260u, 3197735968u, 2402359253u, 1072502647u, 2362417431u, 0, EXP_TOLERANCE, 0},
{ 735, 3215601800u, 3961208159u, 3219057584u, 2340553876u, 1072588672u, 3579521348u, 0, EXP_TOLERANCE, 0},
{ 736, 1073833333u, 4014841779u, 3197672877u, 3697233334u, 1075943590u, 4186803204u, 0, EXP_TOLERANCE, 0},
{ 737, 3219567113u, 1403876392u, 3254028950u, 921363393u, 1071611207u, 2326666261u, 0, EXP_TOLERANCE, 0},
{ 738, 1082085982u, 1862576361u, 3194031708u, 2476290925u, 1830816471u, 2702820797u, 0, EXP_TOLERANCE, 0},
{ 739, 1067487560u, 1454212851u, 1088378861u, 3400401866u, 1072727733u, 836581379u, 0, EXP_TOLERANCE, 0},
{ 740, 1074406809u, 552676385u, 3188635745u, 3778112968u, 1077560487u, 3057135642u, 0, EXP_TOLERANCE, 0},
{ 741, 3219555010u, 1199568671u, 3225679997u, 46947405u, 1071623151u, 3836040209u, 0, EXP_TOLERANCE, 0},
{ 742, 1074539809u, 2596231448u, 3253943728u, 2219151748u, 1077996857u, 995998522u, 0, EXP_TOLERANCE, 0},
{ 743, 1071769915u, 4119719558u, 3222036299u, 1275474618u, 1073479873u, 114508863u, 0, EXP_TOLERANCE, 0},
{ 744, 3226277175u, 3347296825u, 1101507910u, 1254014794u, 984676144u, 3717441086u, 0, EXP_TOLERANCE, 0},
{ 745, 1076779960u, 673775040u, 1070743626u, 244126093u, 1095619946u, 3392967245u, 0, EXP_TOLERANCE, 0},
{ 746, 3216831338u, 1832066983u, 1051358028u, 3262483417u, 1072469001u, 2438383671u, 0, EXP_TOLERANCE, 0},
{ 747, 1074413872u, 3962610501u, 3198598777u, 849269178u, 1077583838u, 3412069925u, 0, EXP_TOLERANCE, 0},
{ 748, 3224988140u, 2497516122u, 3254374111u, 2821429629u, 1034170638u, 3098720309u, 0, EXP_TOLERANCE, 0},
{ 749, 1074139136u, 2805941787u, 3217785843u, 779131141u, 1076856794u, 1761248984u, 0, EXP_TOLERANCE, 0},
{ 750, 3222714382u, 723423605u, 1084533420u, 627282213u, 1064040601u, 4058248859u, 0, EXP_TOLERANCE, 0},
{ 751, 3220141984u, 4292778869u, 1078101071u, 1676860147u, 1071116419u, 1193771065u, 0, EXP_TOLERANCE, 0},
{ 752, 1074191350u, 3528118587u, 3194648564u, 2363260897u, 1076980368u, 633116683u, 0, EXP_TOLERANCE, 0},
{ 753, 3214917975u, 1307010018u, 1061248120u, 1468743108u, 1072629211u, 1389200168u, 0, EXP_TOLERANCE, 0},
{ 754, 3227708771u, 107905661u, 3226089788u, 1943427674u, 843541216u, 3065091785u, 0, EXP_TOLERANCE, 0},
{ 755, 3213396365u, 760006940u, 1054265604u, 1749976597u, 1072668271u, 3069507900u, 0, EXP_TOLERANCE, 0},
{ 756, 3225190472u, 2787503556u, 1081282610u, 1195841206u, 1029536384u, 461530301u, 0, EXP_TOLERANCE, 0},
{ 757, 3213822252u, 545462045u, 3208381743u, 1981311808u, 1072661706u, 3884293482u, 0, EXP_TOLERANCE, 0},
{ 758, 1070669320u, 3657978397u, 1104463616u, 3501253426u, 1073014782u, 1116550155u, 0, EXP_TOLERANCE, 0},
{ 759, 1067709649u, 1804177501u, 3210693633u, 3606766729u, 1072734925u, 2164791361u, 0, EXP_TOLERANCE, 0},
{ 760, 1074759727u, 1336278526u, 1043741618u, 3165279431u, 1078574960u, 112244839u, 0, EXP_TOLERANCE, 0},
{ 761, 1069103403u, 1599382075u, 1058018527u, 4212580517u, 1072801823u, 3428114030u, 0, EXP_TOLERANCE, 0},
{ 762, 3217988086u, 3007589929u, 3202026547u, 2792028313u, 1072247303u, 707355694u, 0, EXP_TOLERANCE, 0},
{ 763, 3228965522u, 1866066996u, 1060329048u, 3727175322u, 537617132u, 2682837865u, 0, EXP_TOLERANCE, 0},
{ 764, 3215193859u, 150890940u, 1056025306u, 3082724735u, 1072613045u, 2896088168u, 0, EXP_TOLERANCE, 0},
{ 765, 1071446123u, 80400395u, 1093584426u, 3478941315u, 1073293550u, 1633279969u, 0, EXP_TOLERANCE, 0},
{ 766, 3228571942u, 4050954182u, 3219263194u, 2537475930u, 682960060u, 281321075u, 0, EXP_TOLERANCE, 0},
{ 767, 1071133327u, 2881752155u, 3212589299u, 2559651278u, 1073175056u, 2501448914u, 0, EXP_TOLERANCE, 0},
{ 768, 3228044784u, 440309030u, 3214267461u, 3788040806u, 781499599u, 1484254395u, 0, EXP_TOLERANCE, 0},
{ 769, 1080553671u, 918813144u, 3208535698u, 1607035904u, 1362352642u, 4120585298u, 0, EXP_TOLERANCE, 0},
{ 770, 1066254699u, 2497054124u, 1089139147u, 2549609010u, 1072708594u, 225519014u, 0, EXP_TOLERANCE, 0},
{ 771, 1066960585u, 790219083u, 1054657139u, 2797979479u, 1072718666u, 1434868292u, 0, EXP_TOLERANCE, 0},
{ 772, 1070364312u, 1149462078u, 1095765205u, 3879963182u, 1072954377u, 2014673971u, 0, EXP_TOLERANCE, 0},
{ 773, 3216361301u, 2684353926u, 3205212854u, 1732474928u, 1072522215u, 2345875229u, 0, EXP_TOLERANCE, 0},
{ 774, 1079508325u, 2742237025u, 1051317716u, 3386396147u, 1217770709u, 1976234612u, 0, EXP_TOLERANCE, 0},
{ 775, 1071619594u, 3408320912u, 1103071166u, 4233059513u, 1073363176u, 268602029u, 0, EXP_TOLERANCE, 0},
{ 776, 1071155004u, 1077495917u, 1088399968u, 433115118u, 1073182986u, 1009302603u, 0, EXP_TOLERANCE, 0},
{ 777, 3217130484u, 841366493u, 1051716814u, 4121125128u, 1072425043u, 3371760020u, 0, EXP_TOLERANCE, 0},
{ 778, 1070923540u, 321857207u, 1089128010u, 1149988239u, 1073100393u, 3087266675u, 0, EXP_TOLERANCE, 0},
{ 779, 3226668295u, 799866606u, 3197637091u, 3924438208u, 957395551u, 739998359u, 0, EXP_TOLERANCE, 0},
{ 780, 3213082986u, 2002049816u, 1077053447u, 2240354761u, 1072673115u, 2550101486u, 0, EXP_TOLERANCE, 0},
{ 781, 3222714827u, 478939968u, 1097035749u, 1066716440u, 1064037493u, 846934361u, 0, EXP_TOLERANCE, 0},
{ 782, 3224085033u, 1653104725u, 1088548129u, 81977716u, 1051771332u, 1927581294u, 0, EXP_TOLERANCE, 0},
{ 783, 3215735644u, 3899475018u, 3189694084u, 3330093036u, 1072580740u, 2366929092u, 0, EXP_TOLERANCE, 0},
{ 784, 1077778247u, 2612450289u, 1079065127u, 603380842u, 1117377332u, 409577748u, 0, EXP_TOLERANCE, 0},
{ 785, 1080713847u, 3962735564u, 1101570429u, 1372490825u, 1391915326u, 1157784041u, 0, EXP_TOLERANCE, 0},
{ 786, 1069486080u, 1479841439u, 1059312257u, 541504905u, 1072828520u, 4141675227u, 0, EXP_TOLERANCE, 0},
{ 787, 1075516450u, 2626148789u, 1057571099u, 4121656076u, 1082865702u, 21674613u, 0, EXP_TOLERANCE, 0},
{ 788, 1075321933u, 1902560314u, 1043130231u, 3557671562u, 1081732033u, 2391450025u, 0, EXP_TOLERANCE, 0},
{ 789, 3214801292u, 41779312u, 1081626342u, 831171823u, 1072632749u, 1759846185u, 0, EXP_TOLERANCE, 0},
{ 790, 1069665436u, 1393168821u, 1066457405u, 1381616968u, 1072849684u, 1289163532u, 0, EXP_TOLERANCE, 0},
{ 791, 1073386717u, 3756584649u, 3222267229u, 1423157432u, 1075122375u, 2406905526u, 0, EXP_TOLERANCE, 0},
{ 792, 3229269850u, 1894912556u, 1042426694u, 155024547u, 425197429u, 3283544678u, 0, EXP_TOLERANCE, 0},
{ 793, 3214327880u, 35164295u, 3203391785u, 1037041084u, 1072647167u, 2362324192u, 0, EXP_TOLERANCE, 0},
{ 794, 1076388871u, 3957875950u, 3232195211u, 1590756436u, 1091053435u, 3120602682u, 0, EXP_TOLERANCE, 0},
{ 795, 1071990050u, 1447585080u, 1071279485u, 1107922438u, 1073682984u, 2307905638u, 0, EXP_TOLERANCE, 0},
{ 796, 1067224038u, 981897615u, 1051856116u, 430357614u, 1072722890u, 3697512449u, 0, EXP_TOLERANCE, 0},
{ 797, 3222281335u, 395145384u, 3219821938u, 50586510u, 1066548660u, 2167568476u, 0, EXP_TOLERANCE, 0},
{ 798, 1072921640u, 750827797u, 1082862669u, 230466783u, 1074465228u, 444665273u, 0, EXP_TOLERANCE, 0},
{ 799, 1077231635u, 1365083575u, 3204848310u, 1700831722u, 1104756143u, 2384443675u, 0, EXP_TOLERANCE, 0},
{ 800, 3220187542u, 344241827u, 1071538935u, 2715566077u, 1071074931u, 2466090340u, 0, EXP_TOLERANCE, 0},
{ 801, 3227659912u, 4069301823u, 3193208760u, 2949125229u, 852610347u, 1078331087u, 0, EXP_TOLERANCE, 0},
{ 802, 1081211291u, 3585711710u, 1065801594u, 2302229267u, 1507738998u, 4025253862u, 0, EXP_TOLERANCE, 0},
{ 803, 3214041900u, 709803845u, 1048741487u, 2296910194u, 1072655926u, 3012611721u, 0, EXP_TOLERANCE, 0},
{ 804, 3214252299u, 744421179u, 1069302001u, 2659232829u, 1072649478u, 3670751894u, 0, EXP_TOLERANCE, 0},
{ 805, 1078155904u, 1799949903u, 3192522886u, 4212149209u, 1131196559u, 2298972399u, 0, EXP_TOLERANCE, 0},
{ 806, 3217642838u, 145234164u, 3250614064u, 912384201u, 1072316679u, 2192878632u, 0, EXP_TOLERANCE, 0},
{ 807, 3225830600u, 2784620507u, 1102812948u, 3531481022u, 1005246022u, 3138466984u, 0, EXP_TOLERANCE, 0},
{ 808, 3229139567u, 383952592u, 3205659905u, 3633194728u, 473314917u, 2102131961u, 0, EXP_TOLERANCE, 0},
{ 809, 3216059164u, 3792395543u, 1070072378u, 3864816376u, 1072557216u, 3332910443u, 0, EXP_TOLERANCE, 0},
{ 810, 3217899185u, 2115553675u, 1066288499u, 3538377867u, 1072264895u, 2000840220u, 0, EXP_TOLERANCE, 0},
{ 811, 3229006513u, 1230026762u, 1090719723u, 440819880u, 522467282u, 176843704u, 0, EXP_TOLERANCE, 0},
{ 812, 3214518020u, 2991290482u, 1096886719u, 1097971167u, 1072641364u, 1885259123u, 0, EXP_TOLERANCE, 0},
{ 813, 1077465688u, 1098035020u, 3230900504u, 1479059095u, 1110183315u, 1050435763u, 0, EXP_TOLERANCE, 0},
{ 814, 3229036868u, 1719428427u, 3188631907u, 3707377409u, 511248635u, 1142506866u, 0, EXP_TOLERANCE, 0},
{ 815, 1068964805u, 3748932896u, 1084908557u, 1325384361u, 1072792303u, 3780694184u, 0, EXP_TOLERANCE, 0},
{ 816, 1076315468u, 3979168763u, 1057455255u, 2454615952u, 1090230266u, 2957407211u, 0, EXP_TOLERANCE, 0},
{ 817, 1068835624u, 1449164578u, 1056960316u, 1654931641u, 1072783501u, 1093920167u, 0, EXP_TOLERANCE, 0},
{ 818, 1073536162u, 2120487381u, 3226298974u, 2364226633u, 1075333845u, 2170325994u, 0, EXP_TOLERANCE, 0},
{ 819, 1074022852u, 1074268944u, 1065730444u, 280016852u, 1076445746u, 2202470074u, 0, EXP_TOLERANCE, 0},
{ 820, 3216036896u, 3315127889u, 3236295594u, 2900924954u, 1072559821u, 2002231287u, 0, EXP_TOLERANCE, 0},
{ 821, 3215300259u, 2246037502u, 1049691002u, 1496066550u, 1072606660u, 401761059u, 0, EXP_TOLERANCE, 0},
{ 822, 3213978379u, 4191285446u, 3217936236u, 2382392789u, 1072657877u, 1309200979u, 0, EXP_TOLERANCE, 0},
{ 823, 1078153244u, 640099844u, 1042152237u, 2064279383u, 1131049946u, 3369789477u, 0, EXP_TOLERANCE, 0},
{ 824, 1075719134u, 3468560824u, 1093251038u, 310958750u, 1084062910u, 2169865167u, 0, EXP_TOLERANCE, 0},
{ 825, 1080011184u, 1413568905u, 1100941106u, 1627289946u, 1264211895u, 2702685927u, 0, EXP_TOLERANCE, 0},
{ 826, 3213569646u, 3797143370u, 3195497539u, 3843275034u, 1072665598u, 686484879u, 0, EXP_TOLERANCE, 0},
{ 827, 3229008721u, 2806642640u, 3201943068u, 2515980718u, 521639300u, 2160860697u, 0, EXP_TOLERANCE, 0},
{ 828, 1077440132u, 632580632u, 1078673506u, 3259601317u, 1109589645u, 1728707154u, 0, EXP_TOLERANCE, 0},
{ 829, 3216709215u, 3309678799u, 1049337078u, 3056787074u, 1072482684u, 1422033902u, 0, EXP_TOLERANCE, 0},
{ 830, 3221495289u, 2341164249u, 1080834967u, 2810890005u, 1068807516u, 1228216989u, 0, EXP_TOLERANCE, 0},
{ 831, 1072262554u, 932124675u, 1093915797u, 662682630u, 1073853822u, 1808565180u, 0, EXP_TOLERANCE, 0},
{ 832, 3228258571u, 1367996113u, 3251723684u, 2974064663u, 742026714u, 1183375229u, 0, EXP_TOLERANCE, 0},
{ 833, 1074987851u, 323437999u, 1090499064u, 901457511u, 1079835961u, 484425891u, 0, EXP_TOLERANCE, 0},
{ 834, 3225293116u, 4184941840u, 3196770014u, 2458988443u, 1027121096u, 3710678278u, 0, EXP_TOLERANCE, 0},
{ 835, 1077132524u, 2023065054u, 3211994098u, 2734612965u, 1102463134u, 3575590741u, 0, EXP_TOLERANCE, 0},
{ 836, 1071414726u, 3679267365u, 3237728785u, 1699558211u, 1073281253u, 3860891479u, 0, EXP_TOLERANCE, 0},
{ 837, 1077593250u, 1826799031u, 1078709629u, 3986905229u, 1113100092u, 1053308024u, 0, EXP_TOLERANCE, 0},
{ 838, 1068572425u, 351061688u, 3194386466u, 4105857588u, 1072765774u, 3548107827u, 0, EXP_TOLERANCE, 0},
{ 839, 1068808070u, 1365244058u, 1064457319u, 1452191426u, 1072781632u, 1873938050u, 0, EXP_TOLERANCE, 0},
{ 840, 1071462417u, 2463030625u, 3215975031u, 3773488326u, 1073299968u, 2609346878u, 0, EXP_TOLERANCE, 0},
{ 841, 3229256575u, 752664055u, 1065110394u, 1835931663u, 430123802u, 2553348310u, 0, EXP_TOLERANCE, 0},
{ 842, 1077559328u, 3496172149u, 1089617208u, 109068701u, 1112360377u, 1798297128u, 0, EXP_TOLERANCE, 0},
{ 843, 3215960879u, 1636966254u, 1086098766u, 2016598298u, 1072567463u, 927350131u, 0, EXP_TOLERANCE, 0},
{ 844, 1067708534u, 3551516956u, 1097969102u, 1317953425u, 1072734889u, 1241991990u, 0, EXP_TOLERANCE, 0},
{ 845, 3223540761u, 2977627788u, 1045339018u, 516058480u, 1058055761u, 569636114u, 0, EXP_TOLERANCE, 0},
{ 846, 3224825666u, 3901731263u, 3189566462u, 32272932u, 1037966615u, 1722002382u, 0, EXP_TOLERANCE, 0},
{ 847, 1074136068u, 1956025297u, 3246628529u, 3840733905u, 1076844736u, 3998888857u, 0, EXP_TOLERANCE, 0},
{ 848, 1080943668u, 561057891u, 3198494340u, 4271027193u, 1434442732u, 930486357u, 0, EXP_TOLERANCE, 0},
{ 849, 3228909825u, 692989850u, 3242630588u, 2492225971u, 558170866u, 4102964135u, 0, EXP_TOLERANCE, 0},
{ 850, 3218062309u, 3439913962u, 1067477011u, 2973333638u, 1072232757u, 2540923660u, 0, EXP_TOLERANCE, 0},
{ 851, 3219236869u, 877613377u, 1044917899u, 809672798u, 1071803919u, 1940541557u, 0, EXP_TOLERANCE, 0},
{ 852, 3222171454u, 905426932u, 1046417457u, 1086320855u, 1066848024u, 3143546584u, 0, EXP_TOLERANCE, 0},
{ 853, 3227472261u, 2645567288u, 1051258339u, 557182478u, 883115166u, 3149220578u, 0, EXP_TOLERANCE, 0},
{ 854, 3216640862u, 186287752u, 1061342054u, 4054003419u, 1072490386u, 1493344933u, 0, EXP_TOLERANCE, 0},
{ 855, 1079440881u, 3506889716u, 3243866036u, 519056371u, 1211540924u, 931610429u, 0, EXP_TOLERANCE, 0},
{ 856, 1065722725u, 2171898436u, 3246911982u, 1091500784u, 1072704385u, 2261342317u, 0, EXP_TOLERANCE, 0},
{ 857, 3226870457u, 368493885u, 3222871893u, 1419055230u, 938682684u, 2071809339u, 0, EXP_TOLERANCE, 0},
{ 858, 1078319084u, 2010971245u, 3188804530u, 1518695799u, 1138773255u, 3191526077u, 0, EXP_TOLERANCE, 0},
{ 859, 3218009421u, 1239207795u, 1040192984u, 2199481342u, 1072243109u, 70493476u, 0, EXP_TOLERANCE, 0},
{ 860, 3218318669u, 4264613432u, 3203460972u, 3558930895u, 1072138922u, 254209313u, 0, EXP_TOLERANCE, 0},
{ 861, 1068125075u, 3772748958u, 3227667376u, 309688336u, 1072748507u, 2061269699u, 0, EXP_TOLERANCE, 0},
{ 862, 3223403009u, 1077949160u, 1075769893u, 2405271377u, 1059573760u, 4171816038u, 0, EXP_TOLERANCE, 0},
{ 863, 1078203664u, 3751608506u, 3232278094u, 930375071u, 1133432542u, 338172682u, 0, EXP_TOLERANCE, 0},
{ 864, 3215394369u, 1518334131u, 3205247482u, 791756713u, 1072601028u, 4217463222u, 0, EXP_TOLERANCE, 0},
{ 865, 1067240397u, 2825203170u, 3245054001u, 1822981827u, 1072723153u, 3157609123u, 0, EXP_TOLERANCE, 0},
{ 866, 1080093419u, 514474738u, 1089072073u, 3300845441u, 1277369232u, 226623888u, 0, EXP_TOLERANCE, 0},
{ 867, 3219536978u, 247369460u, 3197320093u, 687450958u, 1071641076u, 107110682u, 0, EXP_TOLERANCE, 0},
{ 868, 1081092750u, 2722237629u, 1058272368u, 90602316u, 1463940977u, 1953188388u, 0, EXP_TOLERANCE, 0},
{ 869, 3217535619u, 1845900544u, 3231520830u, 3389751458u, 1072338812u, 908962619u, 0, EXP_TOLERANCE, 0},
{ 870, 3227612301u, 737689911u, 3195377751u, 3462616966u, 861355698u, 2672114716u, 0, EXP_TOLERANCE, 0},
{ 871, 3221441232u, 3620285831u, 1055501023u, 2708056059u, 1068954913u, 645027974u, 0, EXP_TOLERANCE, 0},
{ 872, 3220513572u, 4073430285u, 1056206159u, 172017902u, 1070666757u, 252709185u, 0, EXP_TOLERANCE, 0},
{ 873, 3219161094u, 2799176222u, 1052706894u, 4083892667u, 1071848358u, 2936835175u, 0, EXP_TOLERANCE, 0},
{ 874, 3216959621u, 1562351330u, 1069705601u, 1247765260u, 1072454735u, 1965167652u, 0, EXP_TOLERANCE, 0},
{ 875, 3224328691u, 51853475u, 3189080201u, 2783553144u, 1048896499u, 4214951332u, 0, EXP_TOLERANCE, 0},
{ 876, 3220502929u, 3851781549u, 3241598113u, 514064046u, 1070678175u, 727808314u, 0, EXP_TOLERANCE, 0},
{ 877, 1080123021u, 934745487u, 3248182437u, 2798581921u, 1282811572u, 865963855u, 0, EXP_TOLERANCE, 0},
{ 878, 3219373949u, 2948648757u, 3232177250u, 4278702895u, 1071727494u, 4061869059u, 0, EXP_TOLERANCE, 0},
{ 879, 1073534300u, 4259101461u, 1061606772u, 84229920u, 1075331021u, 3220111151u, 0, EXP_TOLERANCE, 0},
{ 880, 3215901351u, 3891230598u, 1095924595u, 3049217547u, 1072570963u, 2739288242u, 0, EXP_TOLERANCE, 0},
{ 881, 1074207325u, 3806018919u, 3243191216u, 280177341u, 1077015681u, 2817451756u, 0, EXP_TOLERANCE, 0},
{ 882, 1070061714u, 3900344258u, 1063647809u, 4206745890u, 1072907975u, 777731621u, 0, EXP_TOLERANCE, 0},
{ 883, 3222464456u, 2126253040u, 3207248026u, 808507485u, 1065493639u, 3957926160u, 0, EXP_TOLERANCE, 0},
{ 884, 1076653133u, 3465685634u, 3230391053u, 3754958214u, 1094102091u, 3736097686u, 0, EXP_TOLERANCE, 0},
{ 885, 1080840988u, 461094531u, 1101110393u, 1316091396u, 1415451629u, 3462873770u, 0, EXP_TOLERANCE, 0},
{ 886, 1071271770u, 4197635149u, 1091873113u, 1240127141u, 1073226413u, 2596063650u, 0, EXP_TOLERANCE, 0},
{ 887, 1074333893u, 118603800u, 1105304898u, 4291425557u, 1077336969u, 1088342233u, 0, EXP_TOLERANCE, 0},
{ 888, 3219720621u, 3744663425u, 3212482771u, 953662066u, 1071465544u, 3159670354u, 0, EXP_TOLERANCE, 0},
{ 889, 1076782697u, 3564196690u, 3228101916u, 904305212u, 1095661213u, 2831821769u, 0, EXP_TOLERANCE, 0},
{ 890, 1067207479u, 3566257266u, 3235138829u, 2734275140u, 1072722624u, 3670818002u, 0, EXP_TOLERANCE, 0},
{ 891, 3227171261u, 606044282u, 3241318094u, 2446416887u, 910906934u, 627559627u, 0, EXP_TOLERANCE, 0},
{ 892, 1065744532u, 2336116589u, 3197594053u, 2296925138u, 1072704557u, 3081873910u, 0, EXP_TOLERANCE, 0},
{ 893, 1070101995u, 907670625u, 3240769036u, 1827119006u, 1072914055u, 3781503906u, 0, EXP_TOLERANCE, 0},
{ 894, 1066487279u, 2818710946u, 3246059905u, 553394170u, 1072711118u, 1345913310u, 0, EXP_TOLERANCE, 0},
{ 895, 3213621342u, 4099522736u, 3232742168u, 3718083858u, 1072664801u, 910507915u, 0, EXP_TOLERANCE, 0},
{ 896, 1078739788u, 1059279404u, 1080245336u, 175941677u, 1158113937u, 1087430260u, 0, EXP_TOLERANCE, 0},
{ 897, 1082121019u, 1650862428u, 1061816101u, 1723201723u, 1843679461u, 3875297949u, 0, EXP_TOLERANCE, 0},
{ 898, 3226429902u, 2462163405u, 3218946201u, 3876535372u, 977570353u, 3320675628u, 0, EXP_TOLERANCE, 0},
{ 899, 1076004278u, 495844137u, 1073721460u, 772777946u, 1086622883u, 3050800095u, 0, EXP_TOLERANCE, 0},
{ 900, 1068143970u, 458757721u, 3245680321u, 3609892707u, 1072749129u, 926681458u, 0, EXP_TOLERANCE, 0},
{ 901, 3214254476u, 2533012202u, 1079980803u, 3592268374u, 1072649412u, 994782266u, 0, EXP_TOLERANCE, 0},
{ 902, 3216996268u, 4108274117u, 1063045844u, 571992389u, 1072450679u, 4029990628u, 0, EXP_TOLERANCE, 0},
{ 903, 1077984359u, 3541110973u, 1096296754u, 3118427427u, 1123258147u, 2499543662u, 0, EXP_TOLERANCE, 0},
{ 904, 3213902987u, 1213941007u, 1105433735u, 2172963370u, 1072660194u, 3827965195u, 0, EXP_TOLERANCE, 0},
{ 905, 1079027567u, 272190288u, 1095452370u, 4026581530u, 1173437109u, 1567535437u, 0, EXP_TOLERANCE, 0},
{ 906, 1079855269u, 2843638672u, 1100510986u, 3190536898u, 1249888458u, 1134925313u, 0, EXP_TOLERANCE, 0},
{ 907, 1076417062u, 2014317727u, 3247389683u, 2428462015u, 1091433281u, 358810388u, 0, EXP_TOLERANCE, 0},
{ 908, 1078248077u, 688442200u, 1047852515u, 3035186380u, 1135468183u, 2761855333u, 0, EXP_TOLERANCE, 0},
{ 909, 1074567060u, 1010095511u, 3221288076u, 405287991u, 1078056039u, 3040249862u, 0, EXP_TOLERANCE, 0},
{ 910, 3229225943u, 2983070435u, 1089546472u, 2907918480u, 441487241u, 709716015u, 0, EXP_TOLERANCE, 0},
{ 911, 1076696665u, 81928569u, 1056007286u, 2740556321u, 1094687411u, 274384680u, 0, EXP_TOLERANCE, 0},
{ 912, 1066276691u, 2076689028u, 1081558619u, 3039159031u, 1072708768u, 1687981859u, 0, EXP_TOLERANCE, 0},
{ 913, 1067230382u, 1376882094u, 3211003208u, 1296286481u, 1072722992u, 3411996678u, 0, EXP_TOLERANCE, 0},
{ 914, 1074871434u, 744133164u, 3200943494u, 955832216u, 1079154689u, 809333459u, 0, EXP_TOLERANCE, 0},
{ 915, 3223144598u, 176522478u, 1069999908u, 2891249491u, 1061531060u, 3521972652u, 0, EXP_TOLERANCE, 0},
{ 916, 1065584698u, 3685851715u, 3187829932u, 2363997529u, 1072703296u, 1288044552u, 0, EXP_TOLERANCE, 0},
{ 917, 1065409879u, 3974431579u, 1052505165u, 2589067816u, 1072701918u, 1445868855u, 0, EXP_TOLERANCE, 0},
{ 918, 3213516885u, 3819109588u, 1048561488u, 969143351u, 1072666411u, 3612690260u, 0, EXP_TOLERANCE, 0},
{ 919, 1073687973u, 4246896124u, 1104584799u, 1940097860u, 1075581856u, 2819180517u, 0, EXP_TOLERANCE, 0},
{ 920, 1066912836u, 2228686199u, 3220231833u, 777624847u, 1072717902u, 1922278384u, 0, EXP_TOLERANCE, 0},
{ 921, 3224127274u, 4189906558u, 3203004203u, 854242364u, 1051215832u, 3083344029u, 0, EXP_TOLERANCE, 0},
{ 922, 1081890311u, 4089051094u, 3227282692u, 2693170723u, 1758525329u, 2188757040u, 0, EXP_TOLERANCE, 0},
{ 923, 1066855127u, 1278581412u, 3239296746u, 1774588717u, 1072716979u, 4022161488u, 0, EXP_TOLERANCE, 0},
{ 924, 3221324110u, 1794845306u, 1104879344u, 4135865182u, 1069331519u, 811293238u, 0, EXP_TOLERANCE, 0},
{ 925, 1081283231u, 754938390u, 1061291430u, 2010786993u, 1534272358u, 1531468649u, 0, EXP_TOLERANCE, 0},
{ 926, 1073581409u, 2034303731u, 3240176537u, 314147356u, 1075404046u, 1548021515u, 0, EXP_TOLERANCE, 0},
{ 927, 3224109162u, 567588900u, 3195452230u, 1421366017u, 1051451646u, 4159762582u, 0, EXP_TOLERANCE, 0},
{ 928, 3221944027u, 2708717091u, 1071975971u, 1364590470u, 1067555098u, 1265958501u, 0, EXP_TOLERANCE, 0},
{ 929, 3229068611u, 3461956134u, 3207820115u, 1605709634u, 499521170u, 1987606117u, 0, EXP_TOLERANCE, 0},
{ 930, 1071594452u, 1497124553u, 1051715442u, 916736957u, 1073352905u, 1851626276u, 0, EXP_TOLERANCE, 0},
{ 931, 1070002699u, 834914365u, 1064667143u, 2839166298u, 1072899118u, 3236760025u, 0, EXP_TOLERANCE, 0},
{ 932, 1069862861u, 2139295776u, 1062816721u, 914592523u, 1072878380u, 2228412030u, 0, EXP_TOLERANCE, 0},
{ 933, 3213754179u, 851569132u, 1058503154u, 1399378677u, 1072662754u, 3489701620u, 0, EXP_TOLERANCE, 0},
{ 934, 3224100513u, 3897202342u, 3245382590u, 246600375u, 1051576264u, 1680693164u, 0, EXP_TOLERANCE, 0},
{ 935, 3222314580u, 3620429520u, 1055627557u, 229305u, 1066406271u, 669062905u, 0, EXP_TOLERANCE, 0},
{ 936, 1076618801u, 3641997865u, 3206673888u, 93720614u, 1093759686u, 70904860u, 0, EXP_TOLERANCE, 0},
{ 937, 3222565555u, 32766320u, 1062084905u, 3668443038u, 1064873107u, 2362077810u, 0, EXP_TOLERANCE, 0},
{ 938, 3222250420u, 2039713492u, 3248699388u, 1346210821u, 1066639017u, 1070391097u, 0, EXP_TOLERANCE, 0},
{ 939, 1078369952u, 1335820726u, 3191756860u, 1808427032u, 1141063400u, 1082588104u, 0, EXP_TOLERANCE, 0},
{ 940, 1070879947u, 650692001u, 1103515670u, 2253348763u, 1073085342u, 979466763u, 0, EXP_TOLERANCE, 0},
{ 941, 3213415283u, 2372623300u, 3210185343u, 3200572848u, 1072667979u, 2818022293u, 0, EXP_TOLERANCE, 0},
{ 942, 1080873125u, 762317532u, 3194595095u, 3192607437u, 1421328859u, 2571597720u, 0, EXP_TOLERANCE, 0},
{ 943, 1070651309u, 217775356u, 3232827087u, 2969367386u, 1073008911u, 622956426u, 0, EXP_TOLERANCE, 0},
{ 944, 1069755463u, 3621353969u, 1077994795u, 3873976266u, 1072862686u, 1190493624u, 0, EXP_TOLERANCE, 0},
{ 945, 1078719075u, 268372152u, 3221764390u, 3216978962u, 1157161937u, 77208680u, 0, EXP_TOLERANCE, 0},
{ 946, 3227563243u, 142942404u, 1075322987u, 1746449109u, 870456170u, 3164033211u, 0, EXP_TOLERANCE, 0},
{ 947, 1081986200u, 496534875u, 3254522293u, 2532372502u, 1793917531u, 1796814503u, 0, EXP_TOLERANCE, 0},
{ 948, 3228205445u, 2999955409u, 3222793392u, 1868977643u, 751888796u, 948939815u, 0, EXP_TOLERANCE, 0},
{ 949, 1074319042u, 3353193428u, 3218469191u, 3326244297u, 1077295134u, 2019316289u, 0, EXP_TOLERANCE, 0},
{ 950, 1072413103u, 73646871u, 3231442171u, 3711510104u, 1073940200u, 865419667u, 0, EXP_TOLERANCE, 0},
{ 951, 1077900612u, 218135177u, 3198908856u, 3082199105u, 1120199316u, 3713509082u, 0, EXP_TOLERANCE, 0},
{ 952, 1072262784u, 1061628117u, 3248859043u, 86776158u, 1073853949u, 3126348436u, 0, EXP_TOLERANCE, 0},
{ 953, 3217921858u, 938869114u, 1087911145u, 2416710759u, 1072260391u, 538149649u, 0, EXP_TOLERANCE, 0},
{ 954, 1079848192u, 2970853959u, 3239543429u, 1887505029u, 1249157830u, 3136433410u, 0, EXP_TOLERANCE, 0},
{ 955, 3225145875u, 1337895935u, 1076463812u, 1172733328u, 1030560683u, 1841720567u, 0, EXP_TOLERANCE, 0},
{ 956, 1068014296u, 1469010822u, 3229583535u, 551399515u, 1072744869u, 816575420u, 0, EXP_TOLERANCE, 0},
{ 957, 1074118123u, 1849711538u, 1049053713u, 1744276190u, 1076775612u, 57353426u, 0, EXP_TOLERANCE, 0},
{ 958, 3226410140u, 2976596113u, 3192137295u, 3033242648u, 978502995u, 3859738869u, 0, EXP_TOLERANCE, 0},
{ 959, 1079824113u, 876810930u, 3197470945u, 2571587447u, 1246952463u, 1889039904u, 0, EXP_TOLERANCE, 0},
{ 960, 3226042170u, 4007797282u, 3225853845u, 4069319648u, 995463929u, 75967049u, 0, EXP_TOLERANCE, 0},
{ 961, 1067202926u, 3840538373u, 1043189552u, 3668774580u, 1072722551u, 3111652835u, 0, EXP_TOLERANCE, 0},
{ 962, 3220757432u, 200857661u, 3229758439u, 3359367736u, 1070272935u, 3556446312u, 0, EXP_TOLERANCE, 0},
{ 963, 3227826349u, 111868139u, 3227902082u, 2366064003u, 821867115u, 285439771u, 0, EXP_TOLERANCE, 0},
{ 964, 1066215262u, 3510904416u, 3222131653u, 3822770497u, 1072708281u, 2102944929u, 0, EXP_TOLERANCE, 0},
{ 965, 3226947075u, 789151814u, 1099269239u, 2958956055u, 931583754u, 3557693371u, 0, EXP_TOLERANCE, 0},
{ 966, 1076290712u, 722163228u, 1105524559u, 1534462169u, 1089919020u, 2167990146u, 0, EXP_TOLERANCE, 0},
{ 967, 1066509006u, 2207037106u, 3208952465u, 1231254630u, 1072711463u, 2736011721u, 0, EXP_TOLERANCE, 0},
{ 968, 3215709852u, 3838689849u, 3198769679u, 1302617170u, 1072582266u, 2827125580u, 0, EXP_TOLERANCE, 0},
{ 969, 1076501722u, 2527556476u, 3240373426u, 124352692u, 1092391286u, 1779746092u, 0, EXP_TOLERANCE, 0},
{ 970, 3215269445u, 3502371499u, 1043411944u, 4190072016u, 1072608507u, 1214942277u, 0, EXP_TOLERANCE, 0},
{ 971, 1070967598u, 1798470077u, 3200116917u, 3421833729u, 1073115765u, 2970386936u, 0, EXP_TOLERANCE, 0},
{ 972, 3214486476u, 3653237931u, 3204255012u, 3683870669u, 1072642326u, 97744732u, 0, EXP_TOLERANCE, 0},
{ 973, 1069317222u, 376530104u, 1073853547u, 565755892u, 1072816665u, 2564841654u, 0, EXP_TOLERANCE, 0},
{ 974, 3226775211u, 558292492u, 1051772749u, 4267873474u, 947457526u, 4219624486u, 0, EXP_TOLERANCE, 0},
{ 975, 3221626981u, 509637100u, 3212030069u, 215050379u, 1068506067u, 3628098739u, 0, EXP_TOLERANCE, 0},
{ 976, 1078425613u, 3571665665u, 3188628584u, 757824767u, 1143623000u, 253046892u, 0, EXP_TOLERANCE, 0},
{ 977, 3220042217u, 998858159u, 1063077962u, 436029885u, 1071192860u, 1450775748u, 0, EXP_TOLERANCE, 0},
{ 978, 3217481301u, 996300405u, 3193842624u, 80548098u, 1072350133u, 1375924335u, 0, EXP_TOLERANCE, 0},
{ 979, 3222557384u, 3876129407u, 3215332180u, 2226970413u, 1064924298u, 2928337857u, 0, EXP_TOLERANCE, 0},
{ 980, 3225026041u, 200013509u, 3224552716u, 414878724u, 1033283085u, 3576891041u, 0, EXP_TOLERANCE, 0},
{ 981, 3224325637u, 309319541u, 1048979765u, 1261662434u, 1048928773u, 2501187603u, 0, EXP_TOLERANCE, 0},
{ 982, 1077718303u, 4062255924u, 3224274128u, 4289485681u, 1115992461u, 3449799183u, 0, EXP_TOLERANCE, 0},
{ 983, 3224601748u, 1611969213u, 1053890378u, 3774617276u, 1043115104u, 1332410328u, 0, EXP_TOLERANCE, 0},
{ 984, 1075169883u, 1752164782u, 3239587974u, 612223386u, 1080886915u, 1749786576u, 0, EXP_TOLERANCE, 0},
{ 985, 1065663030u, 2024044989u, 1074932678u, 3259111307u, 1072703914u, 1332706132u, 0, EXP_TOLERANCE, 0},
{ 986, 1068936158u, 2564965629u, 1093571065u, 169360454u, 1072790345u, 4117240763u, 0, EXP_TOLERANCE, 0},
{ 987, 1077016178u, 1860101737u, 3191222372u, 1676437468u, 1099835788u, 2272979216u, 0, EXP_TOLERANCE, 0},
{ 988, 1070288728u, 588387057u, 3192103292u, 2495288012u, 1072942629u, 2557725914u, 0, EXP_TOLERANCE, 0},
{ 989, 3214127225u, 659070058u, 1073095700u, 1393632068u, 1072653309u, 1767849680u, 0, EXP_TOLERANCE, 0},
{ 990, 3220828991u, 4276187829u, 3217553330u, 1868253275u, 1070155908u, 2703282856u, 0, EXP_TOLERANCE, 0},
{ 991, 3222171696u, 2085481575u, 3215994784u, 800910002u, 1066847334u, 587373869u, 0, EXP_TOLERANCE, 0},
{ 992, 1069517748u, 1950570756u, 3200582211u, 941022151u, 1072830757u, 2869741668u, 0, EXP_TOLERANCE, 0},
{ 993, 1070113280u, 2075610870u, 3250142022u, 3605152103u, 1072915764u, 3193490161u, 0, EXP_TOLERANCE, 0},
{ 994, 3216567890u, 3792931748u, 3204857863u, 804393211u, 1072498643u, 1528001685u, 0, EXP_TOLERANCE, 0},
{ 995, 3229529122u, 3430071177u, 3226288311u, 3652522729u, 329463250u, 4001823001u, 0, EXP_TOLERANCE, 0},
{ 996, 3215994766u, 236884699u, 3227874605u, 2193269825u, 1072564758u, 4053334377u, 0, EXP_TOLERANCE, 0},
{ 997, 1071228049u, 2744231849u, 1046186036u, 771053722u, 1073210011u, 860122133u, 0, EXP_TOLERANCE, 0},
{ 998, 1076656004u, 3000189819u, 1096500901u, 2057239777u, 1094134996u, 3545311159u, 0, EXP_TOLERANCE, 0},
{ 999, 1078106941u, 205759408u, 3244643377u, 2702292618u, 1128907012u, 16441604u, 0, EXP_TOLERANCE, 0},


// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_EXP_H multiple inclusion protection

// EOF exp.h
