/* VGAlib version 1.0 - (c) 1992 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty;   */
/* without even the implied warranty of merchantability or fitness */
/* for a particular purpose.					   */

/* TVGAlib version 1.0.0					   */
/*								   */
/* VGAlib modified by Toomas Losin to support the Trident 8900C    */
/* SVGA modes.  I wanted to annotate my modifications, but there   */
/* were just too many.  If there are any problems, blame my code   */
/* first, just remember that my code is offered without warranty   */
/* as well.							   */



#include <cyg/io/tvga/tvga.h>
#include <cyg/io/io.h>
#include <cyg/hal/hal_io.h>
#include <stdio.h>
#include <fcntl.h>
#include <signal.h>
#include <termios.h>
#include <string.h>
#include <unistd.h>

#undef free
#include <stdlib.h>

/********************add by lh***************/
extern int pc_inb (int port);
extern int pc_outb (int port, int value);
extern int pc_inw (int port);
extern int pc_outw (int port, int value);
/******************end add****************/




#define GRAPH_BASE 0xA0000
#define GRAPH_SIZE 0x10000
#define FONT_BASE  0xA0000
#define FONT_SIZE  0x2000
#define NULL_SIZE  0x1000

/* VGA index register ports */
#define CRT_IC  0x3D4   /* CRT Controller Index - color emulation */
#define CRT_IM  0x3B4   /* CRT Controller Index - mono emulation */
#define ATT_IW  0x3C0   /* Attribute Controller Index & Data Write Register */
#define GRA_I   0x3CE   /* Graphics Controller Index */
#define SEQ_I   0x3C4   /* Sequencer Index */
#define PEL_IW  0x3C8   /* PEL Write Index */
#define PEL_IR  0x3C7   /* PEL Read Index */

/* VGA data register ports */
#define CRT_DC  0x3D5   /* CRT Controller Data Register - color emulation */
#define CRT_DM  0x3B5   /* CRT Controller Data Register - mono emulation */
#define ATT_R   0x3C1   /* Attribute Controller Data Read Register */
#define GRA_D   0x3CF   /* Graphics Controller Data Register */
#define SEQ_D   0x3C5   /* Sequencer Data Register */
#define MIS_R   0x3CC   /* Misc Output Read Register */
#define MIS_W   0x3C2   /* Misc Output Write Register */
#define IS1_RC  0x3DA   /* Input Status Register 1 - color emulation */
#define IS1_RM  0x3BA   /* Input Status Register 1 - mono emulation */
#define PEL_D   0x3C9   /* PEL Data Register */

/* VGA indexes max counts */
#define CRT_C   31      /* 31 CRT Controller Registers */
#define ATT_C   21      /* 21 Attribute Controller Registers */
#define GRA_C   9       /* 9  Graphics Controller Registers */
#define SEQ_C   5       /* 5  Sequencer Registers */
#define NSEQ_C	4	/* 4  Sequencer Mode Registers */
#define MIS_C   1       /* 1  Misc Output Register */

/* VGA registers saving indexes */
#define CRT     0               /* CRT Controller Registers start */
#define ATT     CRT+CRT_C       /* Attribute Controller Registers start */
#define GRA     ATT+ATT_C       /* Graphics Controller Registers start */
#define SEQ     GRA+GRA_C       /* Sequencer Registers */
#define NSEQ	SEQ+SEQ_C	/* Sequencer old and new mode regs */
#define MIS     NSEQ+NSEQ_C     /* General Registers */
#define END     MIS+MIS_C       /* last */
#define REGCOUNT 71

#define ABS(a) (((a)<0) ? -(a) : (a))

/* variables used to shift between monchrome and color emulation */
static int CRT_I;		/* current CRT index register address */
static int CRT_D;		/* current CRT data register address */
static int IS1_R;		/* current input status register address */
static int color_text;		/* true if color text emulation */


/* graphics mode information */
struct info {
    int xdim;
    int ydim;
    int colors;
    int xbytes;
};

static	int	tvga_mem;		/* how much vram there is    */
static	int	tvga_not_inter;		/* 0 -> sw3 set to interlace */

/* BIOS mode 0Dh - 320x200x16 */
static char g320x200x16_regs[REGCOUNT] = {
  0x2D,0x27,0x28,0x90,0x2B,0x80,0xBF,0x1F,0x00,0xC0,0x00,0x00, 
  0x00,0x00,0x00,0x00,0x9C,0x8E,0x8F,0x14,0x00,0x96,0xB9,0xE3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b, 
  0x0c,0x0d,0x0e,0x0f,0x01,0x00,0x0F,0x00,0x00, 
  0x00,0x0f,0x00,0x20,0x00,0x00,0x05,0x0F,0xFF, 
  0x03,0x09,0x0F,0x00,0x06,
  0x20,0xa8, 0x00,0x42,
  0x63
};
static struct info g320x200x16_info = { 320, 200, 16, 40 };


/* BIOS mode 0Eh - 640x200x16 */
static char g640x200x16_regs[REGCOUNT] = {
  0x5F,0x4F,0x50,0x82,0x54,0x80,0xBF,0x1F,0x00,0xC0,0x00,0x00, 
  0x00,0x00,0x00,0x00,0x9C,0x8E,0x8F,0x28,0x00,0x96,0xB9,0xE3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b, 
  0x0c,0x0d,0x0e,0x0f,0x01,0x00,0x0F,0x00,0x00,
  0x00,0x0f,0x00,0x20,0x00,0x00,0x05,0x0F,0xFF, 
  0x03,0x01,0x0F,0x00,0x06,
  0x20,0xa8, 0x00,0x42,
  0x63
};
static struct info g640x200x16_info = { 640, 200, 16, 80 };


/* BIOS mode 10h - 640x350x16 */
static char g640x350x16_regs[REGCOUNT] = {
  0x5F,0x4F,0x50,0x82,0x54,0x80,0xBF,0x1F,0x00,0x40,0x00,0x00, 
  0x00,0x00,0x00,0x00,0x83,0x85,0x5D,0x28,0x0F,0x63,0xBA,0xE3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b, 
  0x0c,0x0d,0x0e,0x0f,0x01,0x00,0x0F,0x00,0x00,
  0x00,0x0f,0x00,0x20,0x00,0x00,0x05,0x0F,0xFF, 
  0x03,0x01,0x0F,0x00,0x06,
  0x20,0xa8, 0x00,0x42,
  0xA3
};
static struct info g640x350x16_info = { 640, 350, 16, 80 };


/* BIOS mode 12h - 640x480x16 */
static char g640x480x16_regs[REGCOUNT] = {
  0x5F,0x4F,0x50,0x82,0x54,0x80,0x0B,0x3E,0x00,0x40,0x00,0x00,
  0x00,0x00,0x00,0x00,0xEA,0x8C,0xDF,0x28,0x00,0xE7,0x04,0xE3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,
  0x0C,0x0D,0x0E,0x0F,0x01,0x00,0x0F,0x00,0x00,
  0x00,0x0f,0x00,0x20,0x00,0x00,0x05,0x0F,0xFF,
  0x03,0x01,0x0F,0x00,0x06,
  0x20,0xa8, 0x00,0x42,
  0xe3
 };
static struct info g640x480x16_info = { 640, 480, 16, 80 };


/* BIOS mode 13h - 320x200x256 */
static char g320x200x256_regs[REGCOUNT] = {
  0x5F,0x4F,0x50,0x82,0x54,0x80,0xBF,0x1F,0x00,0x41,0x00,0x00, 
  0x00,0x00,0x00,0x00,0x9C,0x8E,0x8F,0x28,0x40,0x96,0xB9,0xA3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B, 
  0x0C,0x0D,0x0E,0x0F,0x41,0x00,0x0F,0x00,0x00, 
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0F,0xFF, 
  0x03,0x01,0x0F,0x00,0x0E,
  0x20,0xa8, 0x00,0x42,
  0x63
};
static struct info g320x200x256_info = { 320, 200, 256, 320 };


/* non-BIOS mode - 320x240x256 */
static char g320x240x256_regs[REGCOUNT] = {
  0x5F,0x4F,0x50,0x82,0x54,0x80,0x0D,0x3E,0x00,0x41,0x00,0x00, 
  0x00,0x00,0x00,0x00,0xEA,0xAC,0xDF,0x28,0x00,0xE7,0x06,0xE3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B, 
  0x0C,0x0D,0x0E,0x0F,0x41,0x00,0x0F,0x00,0x00, 
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0F,0xFF, 
  0x03,0x01,0x0F,0x00,0x06,
  0x20,0xa8, 0x00,0x42,
  0xe3
};
static struct info g320x240x256_info = { 320, 240, 256, 80 };


/* non-BIOS mode - 320x400x256 */
static char g320x400x256_regs[REGCOUNT] = {
  0x5F,0x4F,0x50,0x82,0x54,0x80,0xBF,0x1F,0x00,0x40,0x00,0x00, 
  0x00,0x00,0x00,0x00,0x9C,0x8E,0x8F,0x28,0x00,0x96,0xB9,0xE3, 
  0xff,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B, 
  0x0C,0x0D,0x0E,0x0F,0x41,0x00,0x0F,0x00,0x00, 
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0F,0xFF, 
  0x03,0x01,0x0F,0x00,0x06,
  0x20,0xa8, 0x00,0x42,
  0x63
};
static struct info g320x400x256_info = { 320, 400, 256, 80 };


/* non-BIOS mode - 360x480x256 */
static char g360x480x256_regs[REGCOUNT] = {
  0x6B,0x59,0x5A,0x8E,0x5E,0x8A,0x0D,0x3E,0x00,0x40,0x00,0x00, 
  0x00,0x00,0x00,0x00,0xEA,0xAC,0xDF,0x2D,0x00,0xE7,0x06,0xE3, 
  0xff,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B, 
  0x0C,0x0D,0x0E,0x0F,0x41,0x00,0x0F,0x00,0x00, 
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0F,0xFF, 
  0x03,0x01,0x0F,0x00,0x06,
  0x20,0xa8, 0x00,0x42,
  0xE7
};
static struct info g360x480x256_info = { 360, 480, 256, 90 };


/* Trident SVGA mode 5b - 800x600x16 256k I + 512k I + 1M I */
static char g800x600x16i_regs[REGCOUNT] = {
  0x7b,0x63,0x64,0x9e,0x69,0x92,0x6f,0xf0,0x00,0x60,0x00,0x00,
  0x00,0x00,0x00,0x00,0x58,0x8a,0x57,0x32,0x00,0x58,0x6f,0xe3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x01,0x00,0x0f,0x00,0x00,
  0x00,0x0f,0x00,0x20,0x00,0x00,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x06,
  0x20,0xa8, 0x00,0x42,
  0xef
};
/* Trident SVGA mode 5b - 800x600x16 512k NI + 1M NI */
static char g800x600x16_regs[REGCOUNT] = {
  0x7e,0x63,0x64,0x81,0x6b,0x18,0x99,0xf0,0x00,0x60,0x00,0x00,
  0x00,0x00,0x00,0x00,0x6e,0x84,0x57,0x32,0x00,0x5e,0x93,0xe3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x00,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x01,0x00,0x0f,0x00,0x00,
  0x00,0x0f,0x00,0x20,0x00,0x00,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x06,
  0x00,0xa8, 0x01,0x02,
  0x2b
};
static struct info g800x600x16_info = { 800, 600, 16, 100 };


/* Trident SVGA mode 5c - 640x400x256 512k + 1M I */
static char g640x400x256i_regs[REGCOUNT] = {
  0xc3,0x9f,0xa1,0x84,0xa6,0x00,0xbf,0x1f,0x00,0x40,0x00,0x00,
  0x00,0x00,0x00,0x00,0x9c,0x8e,0x8f,0x50,0x40,0x96,0xb9,0xa3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x80,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x0e,
  0x0,0xa8, 0x01,0x02,
  0x6b
};
/* Trident SVGA mode 5c - 640x400x256 1M NI */
static char g640x400x256_regs[REGCOUNT] = {
  0x5f,0x4f,0x50,0x82,0x54,0x80,0xbf,0x1f,0x00,0x40,0x00,0x00,
  0x00,0x00,0x00,0x00,0x9c,0x8e,0x8f,0x28,0x40,0x96,0xb9,0xa3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x80,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x0e,
  0x30,0xa8, 0x00,0x42,
  0x63
};
static struct info g640x400x256_info = { 640, 400, 256, 640 };


/* Trident SVGA mode 5d - 640x480x256 512k + 1M I */
static char g640x480x256i_regs[REGCOUNT] = {
  0xc3,0x9f,0xa1,0x84,0xa6,0x00,0x0b,0x3e,0x00,0x40,0x00,0x00,
  0x00,0x00,0x00,0x00,0xea,0x8c,0xdf,0x50,0x40,0xe7,0x04,0xa3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x80,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x0e,
  0x00,0xa8, 0x01,0x02,
  0xeb
};
/* Trident SVGA mode 5d - 640x480x256 1M NI */
static char g640x480x256_regs[REGCOUNT] = {
  0x5f,0x4f,0x50,0x82,0x54,0x80,0x0b,0x3e,0x00,0x40,0x00,0x00,
  0x00,0x00,0x00,0x00,0xea,0x8c,0xdf,0x28,0x40,0xe7,0x04,0xa3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x80,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x0e,
  0x30,0xa8, 0x00,0x42,
  0x63
};
static struct info g640x480x256_info = { 640, 480, 256, 640 };


/* Trident SVGA mode 5e - 800x600x256 512k */
static char g800x600x256i1_regs[REGCOUNT] = {
  0xeb,0xc7,0xc9,0x8d,0xcb,0x86,0x4a,0x1f,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x2f,0x81,0x2b,0xc8,0x40,0x2f,0x47,0xa3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x84,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x0e,
  0x00,0xa8, 0x01,0x02,
  0xa3
};
/* Trident SVGA mode 5e - 800x600x256 1M I */
static char g800x600x256i_regs[REGCOUNT] = {
  0x7b,0x63,0x64,0x9e,0x69,0x92,0x6f,0xf0,0x00,0x60,0x00,0x00,
  0x00,0x00,0x00,0x00,0x58,0x8a,0x57,0x32,0x40,0x58,0x6f,0xa3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x80,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x0e,
  0x30,0xa8, 0x00,0x42,
  0xef
};
/* Trident SVGA mode 5e - 800x600x256 1M NI */
static char g800x600x256_regs[REGCOUNT] = {
  0x7e,0x63,0x64,0x81,0x6b,0x18,0x99,0xf0,0x00,0x60,0x00,0x00,
  0x00,0x00,0x00,0x00,0x6e,0x84,0x57,0x32,0x40,0x5e,0x93,0xa3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x80,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x0e,
  0x10,0xa8, 0x01,0x02,
  0x2b
};
static struct info g800x600x256_info = { 800, 600, 256, 800 };


/* Trident SVGA mode 5f - 1024x768x16 512k I + 1M I */
static char g1024x768x16i_regs[REGCOUNT] = {
  0x99,0x7f,0x81,0x1b,0x83,0x19,0x98,0x1f,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x81,0x0f,0x7f,0x80,0x00,0x83,0x95,0xe3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x84,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x01,0x00,0x0f,0x00,0x00,
  0x00,0x0f,0x00,0x20,0x00,0x00,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x06,
  0x00,0xa8, 0x00,0x02,
  0x2b
};
/* Trident SVGA mode 5f - 1024x768x16 512k NI + 1M NI */
static char g1024x768x16_regs[REGCOUNT] = {
  0xa2,0x7f,0x80,0x85,0x87,0x90,0x2c,0xfd,0x00,0x60,0x00,0x00,
  0x00,0x00,0x00,0x00,0x0f,0x81,0xff,0x40,0x00,0x07,0x26,0xe3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x80,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x01,0x00,0x0f,0x00,0x00,
  0x00,0x0f,0x00,0x20,0x00,0x00,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x06,
  0x00,0xa8, 0x01,0x02,
  0x27
};
static struct info g1024x768x16_info = { 1024, 768, 16, 128 };


/* Trident SVGA mode 61 - 768x1024x16 sw3 = don't care */
static char g768x1024x16i_regs[REGCOUNT] = {
  0x8f,0x5f,0x61,0x91,0x61,0x17,0x1c,0xb2,0x00,0x60,0x00,0x00,
  0x00,0x00,0x00,0x00,0x04,0x86,0xff,0x60,0x00,0x04,0x18,0xe3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x84,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x01,0x00,0x0f,0x00,0x00,
  0x00,0x0f,0x00,0x20,0x00,0x00,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x06,
  0x00,0xa8, 0x00,0x02,
  0x2b
};
static struct info g768x1024x16_info = { 768, 1024, 16, 96 };


/* Trident SVGA mode 62 - 1024x768x256 1M I */
static char g1024x768x256i_regs[REGCOUNT] = {
  0x99,0x7f,0x81,0x1b,0x83,0x19,0x98,0x1f,0x00,0x00,0x00,0x00,
  0x00,0x00,0x00,0x00,0x81,0x0f,0x7f,0x80,0x40,0x83,0x95,0xa3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x84,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x0e,
  0x10,0xa8, 0x00,0x02,
  0x2b
};
/* Trident SVGA mode 62 - 1024x768x256 1M NI */
static char g1024x768x256_regs[REGCOUNT] = {
  0xa2,0x7f,0x80,0x85,0x87,0x90,0x2c,0xfd,0x00,0x60,0x00,0x00,
  0x00,0x00,0x00,0x00,0x0f,0x81,0xff,0x40,0x40,0x07,0x26,0xa3,
  0xff,0x00,0x00,0x00,0x00,0x00,0x80,
  0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,
  0x0c,0x0d,0x0e,0x0f,0x41,0x00,0x0f,0x00,0x00,
  0x00,0x00,0x00,0x00,0x00,0x40,0x05,0x0f,0xff,
  0x01,0x01,0x0f,0x00,0x0e,
  0x10,0xa8, 0x01,0x02,
  0x27
};
static struct info g1024x768x256_info = { 1024, 768, 256, 1024 };

static char reg0c_values[16][4] = { {0xad, 0xcd, 0xcd, 0xcd},
				    {0xad, 0xcd, 0xcd, 0xcd},
				    {0xad, 0xcd, 0xcd, 0xcd},
				    {0xad, 0xcd, 0xcd, 0xcd},
				    {0xad, 0xcd, 0xcd, 0xcd},
/* These values	are the mode   */   {0xad, 0xcd, 0xcd, 0xcd},
/* reg 0xc values for each     */   {0xad, 0xcd, 0xcd, 0xcd},
/* different mode and the four */   {0xad, 0xcd, 0xcd, 0xcd},
/* possible memory sizes.      */   {0xad, 0xcd, 0xcd, 0xcd},
/* Entry 0 takes the place of  */   {0xad, 0xcd, 0xcd, 0xcd},
/* the TEXT mode; it is never  */   {0xad, 0xcd, 0xcd, 0xed},
/* used.                       */   {0xad, 0xcd, 0xcd, 0xed},
				    {0xad, 0xcd, 0xcd, 0xed},
				    {0xad, 0xcd, 0xcd, 0xcd},
				    {0xad, 0xcd, 0xcd, 0xcd},
				    {0xad, 0xcd, 0xcd, 0xed} };

static char reg1f_values[16][4] = { {0x14, 0x18, 0x18, 0x18},
				    {0x14, 0x18, 0x18, 0x18},
				    {0x14, 0x18, 0x18, 0x18},
				    {0x14, 0x18, 0x18, 0x18},
/* These values are for the    */   {0x14, 0x18, 0x18, 0x18},
/* CRTC reg 1f.  Don't know    */   {0x14, 0x18, 0x18, 0x98},
/* what they're for, but they  */   {0x14, 0x18, 0x18, 0x98},
/* could be important.  These  */   {0x14, 0x18, 0x18, 0x98},
/* values are OR'd with the    */   {0x14, 0x18, 0x18, 0x98},
/* lower 2 bits as read from   */   {0x94, 0x98, 0x98, 0x18},
/* reg 1f to preserve the RAM  */   {0x94, 0x98, 0x98, 0x18},
/* size value.                 */   {0x94, 0x98, 0x98, 0x18},
				    {0x94, 0x98, 0x98, 0x18},
				    {0x94, 0x98, 0x98, 0x18},
				    {0x94, 0x98, 0x98, 0x18},
				    {0x94, 0x98, 0x98, 0x98} };


/* default palette values */
static char default_red[256]   
             = { 0, 0, 0, 0,42,42,42,42,21,21,21,21,63,63,63,63,
		 0, 5, 8,11,14,17,20,24,28,32,36,40,45,50,56,63,
		 0,16,31,47,63,63,63,63,63,63,63,63,63,47,31,16,
		 0, 0, 0, 0, 0, 0, 0, 0,31,39,47,55,63,63,63,63,
		63,63,63,63,63,55,47,39,31,31,31,31,31,31,31,31,
		45,49,54,58,63,63,63,63,63,63,63,63,63,58,54,49,
		45,45,45,45,45,45,45,45, 0, 7,14,21,28,28,28,28,
		28,28,28,28,28,21,14, 7, 0, 0, 0, 0, 0, 0, 0, 0,
		14,17,21,24,28,28,28,28,28,28,28,28,28,24,21,17,
		14,14,14,14,14,14,14,14,20,22,24,26,28,28,28,28,
		28,28,28,28,28,26,24,22,20,20,20,20,20,20,20,20,
		 0, 4, 8,12,16,16,16,16,16,16,16,16,16,12, 8, 4,
		 0, 0, 0, 0, 0, 0, 0, 0, 8,10,12,14,16,16,16,16,
		16,16,16,16,16,14,12,10, 8, 8, 8, 8, 8, 8, 8, 8,
		11,12,13,15,16,16,16,16,16,16,16,16,16,15,13,12,
		11,11,11,11,11,11,11,11, 0, 0, 0, 0, 0, 0, 0, 0};
static char default_green[256] 
	     = { 0, 0,42,42, 0, 0,21,42,21,21,63,63,21,21,63,63,
		 0, 5, 8,11,14,17,20,24,28,32,36,40,45,50,56,63,
		 0, 0, 0, 0, 0, 0, 0, 0, 0,16,31,47,63,63,63,63,
		63,63,63,63,63,47,31,16,31,31,31,31,31,31,31,31,
		31,39,47,55,63,63,63,63,63,63,63,63,63,55,47,39,
		45,45,45,45,45,45,45,45,45,49,54,58,63,63,63,63,
		63,63,63,63,63,58,54,49, 0, 0, 0, 0, 0, 0, 0, 0,
		 0, 7,14,21,29,28,28,28,28,28,28,28,28,21,14, 7,
		14,14,14,14,14,14,14,14,14,17,21,24,28,28,28,28,
		28,28,28,28,28,24,21,17,20,20,20,20,20,20,20,20,
		20,22,24,26,28,28,28,28,28,28,28,28,28,26,24,22,
		 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 8,12,16,16,16,16,
		16,16,16,16,16,12, 8, 4, 8, 8, 8, 8, 8, 8, 8, 8,
		 8,10,12,14,16,16,16,16,16,16,16,16,16,14,12,10,
		11,11,11,11,11,11,11,11,11,12,13,15,16,16,16,16,
		16,16,16,16,16,15,13,12, 0, 0, 0, 0, 0, 0, 0, 0};
static char default_blue[256]  
             = { 0,42, 0,42, 0,42, 0,42,21,63,21,63,21,63,21,63,
		 0, 5, 8,11,14,17,20,24,28,32,36,40,45,50,56,63,
		63,63,63,63,63,47,31,16, 0, 0, 0, 0, 0, 0, 0, 0,
		 0,16,31,47,63,63,63,63,63,63,63,63,63,55,47,39,
		31,31,31,31,31,31,31,31,31,39,47,55,63,63,63,63,
		63,63,63,63,63,58,54,49,45,45,45,45,45,45,45,45,
		45,49,54,58,63,63,63,63,28,28,28,28,28,21,14, 7,
		 0, 0, 0, 0, 0, 0, 0, 0, 0, 7,14,21,28,28,28,28,
		28,28,28,28,28,24,21,17,14,14,14,14,14,14,14,14,
		14,17,21,24,28,28,28,28,28,28,28,28,28,26,24,22,
		20,20,20,20,20,20,20,20,20,22,24,26,28,28,28,28,
		16,16,16,16,16,12, 8, 4, 0, 0, 0, 0, 0, 0, 0, 0,
		 0, 4, 8,12,16,16,16,16,16,16,16,16,16,14,12,10,
		 8, 8, 8, 8, 8, 8, 8, 8, 8,10,12,14,16,16,16,16,
		16,16,16,16,16,15,13,12,11,11,11,11,11,11,11,11,
		11,12,13,15,16,16,16,16, 0, 0, 0, 0, 0, 0, 0, 0};


/* used to decompose color value into bits (for fast scanline drawing) */
union bits {
    struct {
        char bit3;
        char bit2;
        char bit1;
        char bit0;
    } b;
    unsigned int i;
};

/* color decompositions */
static union bits color16[16] = {{0,0,0,0},
			         {0,0,0,1},
			      	 {0,0,1,0},
			         {0,0,1,1},
			         {0,1,0,0},
			         {0,1,0,1},
			         {0,1,1,0},
			         {0,1,1,1},
			         {1,0,0,0},
			         {1,0,0,1},
			         {1,0,1,0},
			         {1,0,1,1},
			         {1,1,0,0},
			         {1,1,0,1},
			         {1,1,1,0},
			         {1,1,1,1}};

/* display plane buffers (for fast scanline drawing) */
static char plane0[256];
static char plane1[256];
static char plane2[256];
static char plane3[256];


static char text_regs[REGCOUNT];   /* VGA registers for saved text mode */   
static char text_seq_0c;	   /* saved text mode sequencer 0xc     */
static char text_crtc_1f;	   /* saved text mode CRTC 1f           */

/* saved text mode palette values */ 
static char text_red[256];  
static char text_green[256];  
static char text_blue[256];  

/* saved graphics mode palette values */ 
static char graph_red[256];  
static char graph_green[256];  
static char graph_blue[256];  

static int         prv_mode  = TEXT;     /* previous video mode      */
static int         cur_mode  = TEXT;     /* current video mode       */
static int         flip_mode = TEXT;     /* flipped video mode       */
static struct info cur_info;             /* current video parameters */
static int         cur_color;            /* current color            */

static int initialized = 0;   /* flag: initialize() called ?  */
static int flip        = 0;   /* flag: executing vga_flip() ? */

/*static int   tty0_fd;     /dev/tty0 file descriptor 		     */
static cyg_io_handle_t tty0_fd;   /*revise by lh 2001.9.4*/
static int   mem_fd;     /* /dev/mem file descriptor		     */
static FILE* console;    /* console input stream		     */
static char* graph_mem;  /* dummy buffer for mmapping grahics memory */

static char* graph_buf = NULL;  /* saves graphics data during flip */

static char font_buf1[FONT_SIZE];  /* saved font data - plane 2 */
static char font_buf2[FONT_SIZE];  /* saved font data - plane 3 */

static struct termios text_termio;  /* text mode termio parameters     */
static struct termios graph_termio; /* graphics mode termio parameters */

int flipchar = '\x1b';   /* flip character - initially  ESCAPE */

/*******************add by lh************************/
/* Optional actions to tcsetattr() */

#define TCSANOW         0
#define TCSADRAIN       1
#define TCSAFLUSH       2
/*******************add end************************/


static void inline port_out(char value, unsigned short port)  
{
  HAL_WRITE_UINT8(port,value);  //write hardware port
}


static unsigned char inline port_in(unsigned short port)
{
    cyg_uint8 d;
    HAL_READ_UINT8( port, d );   //read port
    return d;
}


static void set_graphtermio()
{
  
     tcsetattr(0,TCSADRAIN,&graph_termio);
}


static void set_texttermio()
{
             
     tcsetattr(0,TCSADRAIN,&text_termio);
}


static void disable_interrupt()
{
    struct termios cur_termio;
    tcgetattr(0,&cur_termio);
    cur_termio.c_cflag &=~ISIG;
    tcsetattr(0,TCSADRAIN,&cur_termio);
}


static void enable_interrupt()
{
    struct termios cur_termio;
    tcgetattr(0,&cur_termio);
    cur_termio.c_cflag |=ISIG;
    tcsetattr(0,TCSADRAIN,&cur_termio);
}

static int set_regs(char regs[], char seq_reg_0c, char crtc_reg_1f)
{
    int i;
    FILE *fd;

    /* disable video */
    port_in(IS1_R);	        
    port_out(0x00, ATT_IW);     
  
    /* update misc output register */
    port_out(regs[MIS], MIS_W);         

    /* write attribute controller registers */
    for (i = 0; i < ATT_C; i++) {       
	port_in(IS1_R);   /* reset flip-flop */
	port_out(i, ATT_IW);
	port_out(regs[ATT+i],ATT_IW);
    }

    /* synchronous reset on */
    port_out(0x00,SEQ_I); 
    port_out(0x01,SEQ_D);	        
  
    /* write sequencer registers */
    for (i = 1; i < SEQ_C; i++) {       
	port_out(i, SEQ_I); 
	port_out(regs[SEQ+i], SEQ_D); 
    }

    /* synchronous reset off */
    port_out(0x00, SEQ_I); 
    port_out(0x03, SEQ_D);	        

    /* deprotect CRT registers 0-7 */
    port_out(0x11, CRT_I);		  
    port_out(port_in(CRT_D)&0x7F, CRT_D);   
  
    /* write CRT registers */
    for (i = 0; i < CRT_C; i++) {       
	port_out(i, CRT_I); 
	port_out(regs[CRT+i], CRT_D); 
    }

    /* write graphics controller registers */
    for (i = 0; i < GRA_C; i++) {       
	port_out(i, GRA_I); 
	port_out(regs[GRA+i], GRA_D);
    }

    /* update sequencer mode regs */
    port_out(0x0b, SEQ_I);		/* select old regs */
    port_out(port_in(SEQ_D), SEQ_D);
    port_out(0x0d, SEQ_I);		/* old reg 13 */
    port_out(regs[NSEQ], SEQ_D);
    port_out(0x0e, SEQ_I);		/* old reg 14 */
    port_out(regs[NSEQ+1], SEQ_D);

    port_out(0x0b, SEQ_I);
    port_in(SEQ_D);			/* select new regs */

    port_out(0x0e, SEQ_I);		/* set bit 7 of reg 14  */
    port_out(0x80, SEQ_D);		/* to enable writing to */
    port_out(0x0c, SEQ_I);		/* reg 12               */
    port_out(seq_reg_0c, SEQ_D);

    port_out(0x0d, SEQ_I);		/* new reg 13 */
    port_out(regs[NSEQ+2], SEQ_D);
    port_out(0x0e, SEQ_I);		/* new reg 14 */
    port_out(regs[NSEQ+3], SEQ_D);

    /* update CRTC reg 1f */
    port_out(0x1f, CRT_I);
    port_out((port_in(CRT_D) & 0x03) | crtc_reg_1f, CRT_D);
}


static void interrupt_handler(int value) 
{
    /* handle SIGINT - restore text mode and exit */
    if (cur_mode != TEXT) 
	vga_setmode(TEXT);
    set_texttermio();
    exit(-1);
}


static void initialize()
{
    int  i, j;

    /* save text mode termio parameters */
    /*ioctl(0, TCGETS, &text_termio);  del by lh 2001.9.4*/
    tcgetattr(0,&text_termio);

    graph_termio = text_termio;

    /* change termio parameters to allow our own I/O processing */
    graph_termio.c_iflag &= ~(BRKINT|PARMRK|INPCK|IXON|IXOFF);   /*termbits.h*///del IUCLC and ONOCR just try lh
    graph_termio.c_iflag |=  (IGNBRK|IGNPAR);

    //graph_termio.c_oflag &= ~(ONOCR);   //try by lh

    graph_termio.c_lflag &= ~(ICANON|ECHO|ECHOE|ECHOK|ECHONL|NOFLSH);
    graph_termio.c_lflag |= (ISIG);   /* enable interrupt */

    graph_termio.c_cc[VMIN] = 1;
    graph_termio.c_cc[VTIME] = 0;
    graph_termio.c_cc[VSUSP] = 0;   /* disable suspend */

    disable_interrupt();

    /* color or monochrome text emulation? */
    color_text = port_in(MIS_R)&0x01;

    /* chose registers for color/monochrome emulation */
    if (color_text) {
	CRT_I = CRT_IC;
	CRT_D = CRT_DC;
	IS1_R = IS1_RC;
    } else {
	CRT_I = CRT_IM;
	CRT_D = CRT_DM;
	IS1_R = IS1_RM;
    }

    /* are we actually talking to a Trident 8900C ? */

    port_out(0x0d, SEQ_I);
    i = port_in(SEQ_D);
    port_out(0x00, SEQ_D);
    j = port_in(SEQ_D) & 0x0f;
    port_out(i, SEQ_D);
    port_out(0x0b, SEQ_I);
    port_out(0x00, SEQ_D);
    i = port_in(SEQ_D);	
    if ((j != 2) && (i < 3)){
	printf("TVGAlib:  not Trident 8900C\n");
	exit(-1);
    }

    /* OK, we are.  Now how much memory on the card? */
    port_out(0x1f, CRT_I);
    tvga_mem = port_in(CRT_D) & 0x03;	/* save for later use */

    /* Now is the card running in interlace mode? */
    port_out(0x0f, SEQ_I);
    tvga_not_inter = port_in(SEQ_D) & 0x04;

    /* open /dev/tty0 - current virtual console */
    if ((tty0_fd = open("/dev/tty0", O_RDONLY) ) < 0) { 
	printf("TVGAlib: can't open /dev/tty0 \n");
	exit (-1);
    }
    //console = fdopen(tty0_fd, "r");    
    /*del by lh 2001.9.4*/
    //cyg_io_lookup("/dev/tty0",&tty0_fd);

    /* disable text output to console */
    /*ioctl(tty0_fd, KDSETMODE, KD_GRAPHICS);*//*waring lh try 2001.9.4*/  
    
    
    /* set graphics memory */
    
    graph_mem=0xA0000;  

    /* disable video */
    port_in(IS1_R);	        
    port_out(0x00, ATT_IW);     
  
    /* save text mode palette - first select palette index 0 */
    port_out(0, PEL_IR); 

    /* read RGB components - index is autoincremented */
    for(i = 0; i < 256; i++) {
	for(j = 0; j < 10; j++) ;   /* delay (minimum 240ns) */ 
	text_red[i] = port_in(PEL_D);
	for(j = 0; j < 10; j++) ;   /* delay (minimum 240ns) */ 
	text_green[i] = port_in(PEL_D);
	for(j = 0; j < 10; j++) ;   /* delay (minimum 240ns) */ 
	text_blue[i] = port_in(PEL_D);
    }

    /* save text mode VGA registers */
    for (i = 0; i < ATT_C; i++) {
      	 port_in(IS1_R);
         port_out(i, ATT_IW); 
         text_regs[ATT+i] = port_in(ATT_R); 
    }
    for (i = 0; i < SEQ_C; i++) {
       	 port_out(i, SEQ_I); 
       	 text_regs[SEQ+i] = port_in(SEQ_D); 
    }
    for (i = 0; i < CRT_C; i++) {
	 port_out(i, CRT_I); 
	 text_regs[CRT+i] = port_in(CRT_D); 
    }
    for (i = 0; i < GRA_C; i++) {
       	 port_out(i, GRA_I); 
       	 text_regs[GRA+i] = port_in(GRA_D); 
    }
    text_regs[MIS] = port_in(MIS_R); 

    /* now do the sequencer mode regs */
    port_out(0x0b, SEQ_I);		/* force old mode regs */
    port_out(port_in(SEQ_D), SEQ_D);	/* by writing */

    port_out(0x0c, SEQ_I);		/* reg 12 */
    text_seq_0c = port_in(SEQ_D);
    port_out(0x0d, SEQ_I);		/* old reg 13 */
    text_regs[NSEQ] = port_in(SEQ_D);
    port_out(0x0e, SEQ_I);		/* old reg 14 */
    text_regs[NSEQ+1] = port_in(SEQ_D);

    port_out(0x0b, SEQ_I);		/* now use new regs */
    port_in(SEQ_D);
    port_out(0x0d, SEQ_I);		/* new reg 13 */
    text_regs[NSEQ+2] = port_in(SEQ_D);
    port_out(0x0e, SEQ_I);		/* new reg 14 */
    text_regs[NSEQ+3] = port_in(SEQ_D) ^ 0x02;

	/* we do the ^ 0x02 so that when the regs are restored */
	/* later we don't have a special case; see trident.doc */

    port_out(0x1f, CRT_I);
    text_crtc_1f= port_in(CRT_D);

    /* shift to color emulation */
    CRT_I = CRT_IC;
    CRT_D = CRT_DC;
    IS1_R = IS1_RC;
    port_out(port_in(MIS_R)|0x01, MIS_W); 

    /* save font data - first select a 16 color graphics mode */
    set_regs(g640x480x16_regs, reg0c_values[G640x480x16][tvga_mem],
			       reg1f_values[G640x480x16][tvga_mem]);

    /* save font data in plane 2 */
    port_out(0x04, GRA_I); 
    port_out(0x02, GRA_D); 
    memcpy(font_buf1, graph_mem, FONT_SIZE);   

    /* save font data in plane 3 */
    port_out(0x04, GRA_I); 
    port_out(0x03, GRA_D); 
    memcpy(font_buf2, graph_mem, FONT_SIZE);

    initialized = 1;

    /* do our own interrupt handling */
    (void) signal(SIGINT, interrupt_handler);  
}


int vga_setmode(int mode) 
{
    int i, reg0cvalue, reg1fvalue;

    if ((cur_mode == TEXT) && (mode == TEXT)) return 0;

    if (!initialized)
        initialize();

    switch (tvga_mem){	/* does the card have enough memory? */
	case 0:  if (mode >= G640x400x256) return -1;
	case 1:
	case 2:	 if (mode >= G1024x768x256) return -1;
    }
    reg0cvalue = reg0c_values[mode][tvga_mem];
    reg1fvalue = reg1f_values[mode][tvga_mem];

    disable_interrupt();

    prv_mode = cur_mode;
    cur_mode = mode;

    /* disable video */
    port_in(IS1_R); 		
    port_out(0x00, ATT_IW);	
  
    if (mode == TEXT) {    
        /* restore font data - first select a 16 color graphics mode */
        set_regs(g640x480x16_regs, reg0c_values[G640x480x16][tvga_mem],
				   reg1f_values[G640x480x16][tvga_mem]);

	/* disable Set/Reset Register */
    	port_out(0x01, GRA_I ); 
    	port_out(0x00, GRA_D );   

        /* restore font data in plane 2 - necessary for all VGA's */
    	port_out(0x02, SEQ_I ); 
    	port_out(0x04, SEQ_D );   
	memcpy(graph_mem, font_buf1, FONT_SIZE);

        /* restore font data in plane 3 - necessary for Trident VGA's */
    	port_out(0x02, SEQ_I ); 
    	port_out(0x08, SEQ_D );   
	memcpy(graph_mem, font_buf2, FONT_SIZE);

        /* change register adresses if monochrome text mode */
        if (!color_text) {
            CRT_I = CRT_IM;
            CRT_D = CRT_DM;
            IS1_R = IS1_RM;
            port_out(port_in(MIS_R)&0xFE, MIS_W); 
        }

	/* restore text mode VGA registers */
    	set_regs(text_regs, text_seq_0c, text_crtc_1f);

        /* restore saved palette */
        for(i = 0; i < 256; i++)
            vga_setpalette(
                i, text_red[i], text_green[i], text_blue[i]
            );

	/* enable text output - restores the screen contents */ 
     //   ioctl(tty0_fd, KDSETMODE, KD_TEXT);  //revised by lh 2001.9.5

        /* enable video */
        port_in(IS1_R); 
        port_out(0x20, ATT_IW); 
  
        /* restore text mode termio */
        set_texttermio();

    } else {
	/* disable text output */
        //ioctl(tty0_fd, KDSETMODE, KD_GRAPHICS);  //revised by lh 2001.9.5

        /* shift to color emulation */
        CRT_I = CRT_IC;
        CRT_D = CRT_DC;
        IS1_R = IS1_RC;
        port_out(port_in(MIS_R)|0x01, MIS_W); 

        switch (mode) {
            case G320x200x16:
                set_regs(g320x200x16_regs, reg0cvalue, reg1fvalue);
                cur_info = g320x200x16_info;
                break;
            case G640x200x16:
                set_regs(g640x200x16_regs, reg0cvalue, reg1fvalue);
                cur_info = g640x200x16_info;
                break;
            case G640x350x16:
                set_regs(g640x350x16_regs, reg0cvalue, reg1fvalue);
                cur_info = g640x350x16_info;
                break;
            case G640x480x16:
                set_regs(g640x480x16_regs, reg0cvalue, reg1fvalue);
                cur_info = g640x480x16_info;
                break;
	    case G320x200x256:
                set_regs(g320x200x256_regs, reg0cvalue, reg1fvalue);
                cur_info = g320x200x256_info;
                break;
	    case G320x240x256:
                set_regs(g320x240x256_regs, reg0cvalue, reg1fvalue);
                cur_info = g320x240x256_info;
                break;
	    case G320x400x256:
                set_regs(g320x400x256_regs, reg0cvalue, reg1fvalue);
                cur_info = g320x400x256_info;
                break;
	    case G360x480x256:
                set_regs(g360x480x256_regs, reg0cvalue, reg1fvalue);
                cur_info = g360x480x256_info;
                break;

		/* Trident SVGA modes */

	    case G800x600x16:	/* 5b */
                if ((tvga_not_inter) && (tvga_mem > 0))
                    set_regs(g800x600x16_regs, reg0cvalue, reg1fvalue);
                else
                    set_regs(g800x600x16i_regs, reg0cvalue, reg1fvalue);
		cur_info = g800x600x16_info;
		break;
	    case G640x400x256:	/* 5c */
		if ((tvga_not_inter) && (tvga_mem == 3))
		    set_regs(g640x400x256_regs, reg0cvalue, reg1fvalue);
		else
		    set_regs(g640x400x256i_regs, reg0cvalue, reg1fvalue);
		cur_info = g640x400x256_info;
		break;
	    case G640x480x256:	/* 5d */
		if ((tvga_not_inter) && (tvga_mem == 3))
		    set_regs(g640x480x256_regs, reg0cvalue, reg1fvalue);
		else
		    set_regs(g640x480x256i_regs, reg0cvalue, reg1fvalue);
		cur_info = g640x480x256_info;
		break;
	    case G800x600x256:	/* 5e */
		if ((tvga_mem == 3) && (tvga_not_inter))
		    set_regs(g800x600x256_regs, reg0cvalue, reg1fvalue);
                else if (tvga_mem == 3)
                    set_regs(g800x600x256i_regs, reg0cvalue, reg1fvalue);
                else
                    set_regs(g800x600x256i1_regs, reg0cvalue, reg1fvalue);
		cur_info = g800x600x256_info;
		break;
	    case G1024x768x16:	/* 5f */
                if (tvga_not_inter)
                    set_regs(g1024x768x16_regs, reg0cvalue, reg1fvalue);
                else
                    set_regs(g1024x768x16i_regs, reg0cvalue, reg1fvalue);
		cur_info = g1024x768x16_info;
		break;
            case G768x1024x16:	/* 61 */
                set_regs(g768x1024x16i_regs, reg0cvalue, reg1fvalue);
		cur_info = g768x1024x16_info;
                break;
	    case G1024x768x256:	/* 62 */
                if (tvga_not_inter)
                    set_regs(g1024x768x256_regs, reg0cvalue, reg1fvalue);
                else
                    set_regs(g1024x768x256i_regs, reg0cvalue, reg1fvalue);
                cur_info = g1024x768x256_info;
                break;
        }
        tvga_setpage(0);

        if (!flip) {
            /* set default palette */
            for(i = 0; i < 256; i++)
                vga_setpalette(
                    i, default_red[i], default_green[i], default_blue[i]
                );
 
            /* clear screen (sets current color to 15) */
            vga_clear();
        }    

        /* enable video */
        port_in(IS1_R); 
        port_out(0x20, ATT_IW); 
  
        /* set graphics mode termio */
        set_graphtermio();
    }
    return 0;  
}


int vga_clear()
{
    int i, j;

    vga_screenoff();

    switch (cur_mode) {
        case G320x200x16:
        case G640x200x16:
        case G640x350x16:
        case G640x480x16:
	case G800x600x16:
            vga_setcolor(0);
            tvga_clear16(1);	/* clear currently set page */
            break;
	case G1024x768x16:
	case G768x1024x16:
            vga_setcolor(0);
            tvga_clear16(2);	/* clear current and next */
            break;
	case G320x200x256:
	case G320x240x256:
	case G320x400x256:
	case G360x480x256:   tvga_clear256(1);  break;

	case G640x400x256:   tvga_clear256(4);  break;
	case G640x480x256:   tvga_clear256(5);  break;
	case G800x600x256:   tvga_clear256(8);  break;
	case G1024x768x256:  tvga_clear256(12); break;
    }

    vga_setcolor(15);
        
    vga_screenon();

    return 0;
}


int inline vga_setcolor(int color)
{
    switch (cur_mode) {
        case G320x200x16:
        case G640x200x16:
        case G640x350x16:
        case G640x480x16:
	case G800x600x16:
	case G1024x768x16:
	case G768x1024x16:
            /* update set/reset register */
	    port_out(0x00, GRA_I ); 
	    port_out(color, GRA_D );   
            break;
	case G320x200x256:
	case G320x240x256:
	case G320x400x256:
	case G360x480x256:
	case G640x400x256:
	case G640x480x256:
	case G800x600x256:
	case G1024x768x256:
	    cur_color = color;
            break;
    }
        
    return 0;
}


int vga_setpalette(int index, int red, int green, int blue)
{
    int i;

    /* select palette register */
    port_out(index, PEL_IW); 

    /* write RGB components */
    for(i = 0; i < 10; i++) ;   /* delay (minimum 240ns) */ 
    port_out(red, PEL_D);
    for(i = 0; i < 10; i++) ;   /* delay (minimum 240ns) */ 
    port_out(green, PEL_D);
    for(i = 0; i < 10; i++) ;   /* delay (minimum 240ns) */ 
    port_out(blue, PEL_D);

    return 0;
}


int vga_getpalette(int index, int *red, int *green, int *blue)
{
    int i;

    /* select palette register */
    port_out(index, PEL_IR);

    /* read RGB components */
    for(i = 0; i < 10; i++) ;   /* delay (minimum 240ns) */
    *red = (int) port_in(PEL_D);
    for(i = 0; i < 10; i++) ;   /* delay (minimum 240ns) */
    *green = (int) port_in(PEL_D);
    for(i = 0; i < 10; i++) ;   /* delay (minimum 240ns) */
    *blue = (int) port_in(PEL_D);

    return 0;
}


int vga_setpalvec(int start, int num, int *pal)
{
    int i, j;

    /* select palette register */
    port_out(start, PEL_IW);

    for(j = 0; j < num; j++) {
        for(i = 0; i < 10; i++) ;   /* delay (minimum 240ns) */
        port_out(*(pal++), PEL_D);
        for(i = 0; i < 10; i++) ;   /* delay (minimum 240ns) */
        port_out(*(pal++), PEL_D);
        for(i = 0; i < 10; i++) ;   /* delay (minimum 240ns) */
        port_out(*(pal++), PEL_D);
    }

    return j;
}


int vga_getpalvec(int start, int num, int *pal)
{
    int i, j;

    /* select palette register */
    port_out(start, PEL_IR);

    for(j = 0; j < num; j++) {
        for(i = 0; i < 10; i++) ;   /* delay (minimum 240ns) */
        *(pal++) = (int) port_in(PEL_D);
        for(i = 0; i < 10; i++) ;   /* delay (minimum 240ns) */
        *(pal++) = (int) port_in(PEL_D);
        for(i = 0; i < 10; i++) ;   /* delay (minimum 240ns) */
        *(pal++) = (int) port_in(PEL_D);
    }

    return i;
}


int inline vga_drawpixel(int x, int y)
{
    unsigned long offset;
    int vaddr, page;	/* see drawscanline for usage */

    if ((x > cur_info.xdim) || (y > cur_info.ydim)) return -1;

    switch (cur_mode) {
        case G320x200x16:
        case G640x200x16:
        case G640x350x16:
        case G640x480x16:
	case G800x600x16:
	    /* select bit */
	    port_out(8, GRA_I);
	    port_out(0x80 >> (x & 7), GRA_D);   

            /* read into latch and write dummy back */
	    offset = y*cur_info.xbytes + (x>>3);   
            graph_mem[offset] = cur_color; //graph_mem[offset];  revise by lh 9.21 
            break;
	case G1024x768x16:
	case G768x1024x16:
	    /* select bit */
	    port_out(8, GRA_I);
	    port_out(0x80 >> (x & 7), GRA_D);   

            vaddr = y*cur_info.xbytes + (x >> 3);
            page = vaddr / GRAPH_SIZE;
            vaddr %= GRAPH_SIZE;
            tvga_setpage(page);

            /* read into latch and write dummy back */
            graph_mem[vaddr] =  cur_color; //graph_mem[offset];  revise by lh 9.21
            break;
	case G320x200x256:
	case G640x400x256:
	case G640x480x256:
	case G800x600x256:
	case G1024x768x256:
            /* get proper page and offset */
            vaddr = y*cur_info.xbytes + x;
            tvga_setpage(vaddr / GRAPH_SIZE);

            /* write color to pixel */
	    graph_mem[vaddr % GRAPH_SIZE] = cur_color;
            break;
	case G320x240x256:
	case G320x400x256:
	case G360x480x256:
	    /* select plane */ 
	    port_out(0x02, SEQ_I); 
    	    port_out(1 << (x & 3), SEQ_D);   

            /* write color to pixel */
	    graph_mem[y*cur_info.xbytes + (x>>2)] = cur_color;  
            break;
    }
        
    return 0;
}


int vga_drawscanline(int line, char* colors)
{
int	page,		/* graphics page where the data goes  */
	vaddr,		/* address of scanline start in vram  */
	excess;		/* how many pixels in the scan line   */
			/* are in excess for the current page */
			/* and must go on the next one        */

    if (line >= cur_info.ydim) return -1;

    switch (cur_mode) {
        case G320x200x16:
        case G640x200x16:
        case G640x350x16:
        case G640x480x16:
	case G800x600x16:
	case G1024x768x16:
	case G768x1024x16:
	    {
       		int i, j, k, first, last;
		union bits bytes;
                char* address;

		vaddr = line*cur_info.xbytes;
		page = vaddr / GRAPH_SIZE;
		vaddr %= GRAPH_SIZE;
		tvga_setpage(page);

                k = 0;
                for(i = 0; i < cur_info.xdim; i += 8) {
                    bytes.i = 0;
                    first = i;
                    last  = i+8;
                    for(j = first; j < last; j++)
                       bytes.i = (bytes.i<<1) | color16[colors[j]].i;
		    plane0[k]   = bytes.b.bit0;
		    plane1[k]   = bytes.b.bit1;
		    plane2[k]   = bytes.b.bit2;
		    plane3[k++] = bytes.b.bit3;
                }

                address = graph_mem + vaddr;

		/* disable Set/Reset Register */
	    	port_out(0x01, GRA_I ); 
    		port_out(0x00, GRA_D ); 

		/* write to all bits */
	        port_out(0x08, GRA_I ); 
    		port_out(0xFF, GRA_D );   

		/* select map mask register */
	    	port_out(0x02, SEQ_I ); 

                /* write plane 0 */
    		port_out(0x01, SEQ_D ); 
	        memcpy(address, plane0, cur_info.xbytes);

                /* write plane 1 */
    		port_out(0x02, SEQ_D ); 
	        memcpy(address, plane1, cur_info.xbytes);

                /* write plane 2 */
    		port_out(0x04, SEQ_D ); 
	        memcpy(address, plane2, cur_info.xbytes);

                /* write plane 3 */
    		port_out(0x08, SEQ_D ); 
	        memcpy(address, plane3, cur_info.xbytes);

                /* restore map mask register */
    		port_out(0x0F, SEQ_D ); 
  
		/* enable Set/Reset Register */
	    	port_out(0x01, GRA_I ); 
    		port_out(0x0F, GRA_D );   
            }
            break;

	case G320x200x256:
	case G640x400x256:
	case G640x480x256:
	case G800x600x256:
	case G1024x768x256:
	    vaddr = line*cur_info.xbytes;
	    page = vaddr / GRAPH_SIZE;
	    vaddr %= GRAPH_SIZE;
	    tvga_setpage(page);

	    excess = vaddr + cur_info.xbytes; /* not really excess yet */
	    if (excess > GRAPH_SIZE) {
		excess -= GRAPH_SIZE;	/* now it's really the excess */
		memcpy(graph_mem + vaddr, colors, cur_info.xbytes - excess);
		colors += cur_info.xbytes - excess;
		tvga_setpage(page + 1);
		memcpy(graph_mem, colors, excess);
	    }else
                memcpy(graph_mem + vaddr, colors, cur_info.xbytes);
            break;
	case G320x240x256:
	case G320x400x256:
	case G360x480x256: 
            {
                int first, last, offset, pixel, plane;

	        /* select map mask register */ 
	        port_out(0x02, SEQ_I); 

                for(plane = 0; plane < 4; plane++) {
                    /* select plane */
    	            port_out(1 << plane, SEQ_D);   

                    pixel = plane;
                    first = cur_info.xbytes * line;
                    last  = cur_info.xbytes * (line+1);
                    for(offset = first; offset < last; offset++) {
		        graph_mem[offset] = colors[pixel];  
                        pixel += 4;
                    }
	        }
            }
            break;
    }
        
    return 0;
}


int vga_drawline(int x1, int y1, int x2, int y2)
{
    int dx = x2 - x1;
    int dy = y2 - y1;
    int ax = ABS(dx) << 1;
    int ay = ABS(dy) << 1;
    int sx = (dx >= 0) ? 1 : -1;
    int sy = (dy >= 0) ? 1 : -1;
 
    int x  = x1;
    int y  = y1;

    if (ax > ay) {
        int d = ay - (ax >> 1);
        while (x != x2) {
	    vga_drawpixel(x, y);

            if (d > 0 || d == 0 && sx == 1) {
                y += sy;
                d -= ax;
            }
            x += sx;
            d += ay;
        }
    } else {
        int d = ax - (ay >> 1);
        while (y != y2) {
	    vga_drawpixel(x, y);

            if (d > 0 || d == 0 && sy == 1) {
                x += sx;
                d -= ay;
            }
            y += sy;
            d += ax;
        }
    }
    vga_drawpixel(x, y);
     
    return 0;
}

/*
 *	This routine swiped from Jack Morrison's posting to
 *	comp.graphics on Jan 8, 1988.  Algorithm from IEEE CG&A
 *	Sep 1984 p. 24
 */

int vga_drawellipse(cx, cy, rx, ry)
int	cx, cy, rx, ry;
{
	/* intermediate terms to speed up loop */

	long t1 = rx*rx, t2 = t1 << 1, t3 = t2 << 1;
	long t4 = ry*ry, t5 = t4 << 1, t6 = t5 << 1;
	long t7 = rx*t5, t8 = t7 << 1, t9 = 0L;

	long d1 = t2 - t7 + (t4 >> 1);	/* error terms */
	long d2 = (t1>>1) - t8 + t5;

	register int x = rx, y = 0;	/* ellipse points */

	while (d2 < 0){			/* til slope = -1 */
		vga_drawpixel(cx + x, cy + y);
		vga_drawpixel(cx + x, cy - y);
		vga_drawpixel(cx - x, cy + y);
		vga_drawpixel(cx - x, cy - y);

		y++;		/* always move up here */
		t9 += t3;
		if (d1 < 0){	/* move straight up */
			d1 += t9 + t2;
			d2 += t9;
		}else{		/* move up and left */
			x--;
			t8 -= t6;
			d1 += t9 + t2 - t8;
			d2 += t9 + t5 - t8;
		}
	}

	do{			/* rest of top right quadrant */
		vga_drawpixel(cx + x, cy + y);
		vga_drawpixel(cx + x, cy - y);
		vga_drawpixel(cx - x, cy + y);
		vga_drawpixel(cx - x, cy - y);

		x--;		/* always move left here */
		t8 -= t6;
		if (d2 < 0){	/* move up and left */
			y++;
			t9 += t3;
			d2 += t9 + t5 - t8;
		}else		/* move straight left */
			d2 += t5 - t8;
	}while (x >= 0);
}

/*
 *	Obvious way, not the fast way.  Maybe later.
 */

int vga_drawbox(x1, y1, x2, y2)
int	x1, y1, x2, y2;
{
	vga_drawline(x1, y1, x1, y2);
	vga_drawline(x1, y1, x2, y1);
	vga_drawline(x2, y2, x1, y2);
	vga_drawline(x2, y2, x2, y1);
}

int vga_screenoff()
{
    /* turn off screen for faster VGA memory acces */
    port_out(0x01, SEQ_I); 		  
    port_out(port_in(SEQ_D)|0x20, SEQ_D);   

    return 0;
}


int vga_screenon()
{
    /* turn screen back on */
    port_out(0x01, SEQ_I); 		  
    port_out(port_in(SEQ_D)&0xDF, SEQ_D);   

    return 0;
}


int vga_getxdim()
{
    return cur_info.xdim;
}


int vga_getydim()
{
    return cur_info.ydim;
}


int vga_getcolors()
{
    return cur_info.colors;
}


int vga_getch()
{
    char c;

    if (cur_mode == TEXT)
	return -1;

    read(tty0_fd, &c, 1); //*del by lh 2001.9.4*/  
    //cyg_io_read(tty0_fd,&c,1); /*add by lh 2001.9.4*/
    while(c == flipchar) {
	vga_flip();

	set_graphtermio();
        read(tty0_fd, &c, 1); //*del by lh 2001.9.4*/  
        //cyg_io_read(tty0_fd,&c,1); /*add by lh 2001.9.4*/

	vga_flip();
        read(tty0_fd, &c, 1); /*del by lh 2001.9.4*/  
        //cyg_io_read(tty0_fd,&c,1); /*add by lh 2001.9.4*/
    }

    return c;
}


int vga_setflipchar(int c)
{
    flipchar = c;

    return 0;
}


int vga_flip()
{
    int i, j;

    if (cur_mode == TEXT && flip_mode == TEXT)
	return -1;

    flip = 1;

    disable_interrupt();

    /* disable video */
    port_in(IS1_R); 		
    port_out(0x00, ATT_IW);	
  
    if (cur_mode == TEXT) {
	/* disable text output */
        //ioctl(tty0_fd, KDSETMODE, KD_GRAPHICS);  revised by lh 2001.9.5

        /* restore all four planes - first select a 16 color graphics mode */
        set_regs(g640x480x16_regs, reg0c_values[G640x480x16][tvga_mem],
				   reg1f_values[G640x480x16][tvga_mem]);

	/* disable Set/Reset Register */
    	port_out(0x01, GRA_I ); 
    	port_out(0x00, GRA_D );   

        for(i = 0; i < 4; i++) {
            /* restore plane i */
    	    port_out(0x02, SEQ_I ); 
    	    port_out(1<<i, SEQ_D );   
            memcpy(graph_mem, graph_buf + i*GRAPH_SIZE, GRAPH_SIZE);
	}

        free(graph_buf);

        /* restore saved palette */
        for(i = 0; i < 256; i++)
            vga_setpalette(
                i, graph_red[i], graph_green[i], graph_blue[i]
            );

        vga_setmode(flip_mode);

	flip_mode = TEXT;
    } else {
	/* save all four planes - first select a 16 color graphics mode */
        set_regs(g640x480x16_regs, reg0c_values[G640x480x16][tvga_mem],
				   reg1f_values[G640x480x16][tvga_mem]);

	/* allocate memory for saved graphics data - only if necessary */
        if ((graph_buf = malloc(4*GRAPH_SIZE)) == NULL) {
            printf("vga_flip: allocation error \n");
            exit (-1);
        }

        for(i = 0; i < 4; i++) {
            /* save plane i */
            port_out(0x04, GRA_I); 
            port_out(   i, GRA_D); 
            memcpy(graph_buf + i*GRAPH_SIZE, graph_mem, GRAPH_SIZE);
	}

    	/* save graphics mode palette - first select palette index 0 */
    	port_out(0, PEL_IR); 

    	/* read RGB components - index is autoincremented */
    	for(i = 0; i < 256; i++) {
            for(j = 0; j < 10; j++) ;   /* delay (minimum 240ns) */ 
            graph_red[i] = port_in(PEL_D);
    	    for(j = 0; j < 10; j++) ;   /* delay (minimum 240ns) */ 
            graph_green[i] = port_in(PEL_D);
    	    for(j = 0; j < 10; j++) ;   /* delay (minimum 240ns) */ 
            graph_blue[i] = port_in(PEL_D);
        }

        flip_mode = cur_mode;

	vga_setmode(TEXT);
    }

    flip = 0;

    return 0;
}

/*
 *	Here are new procedures required to do things cleanly.
 */

int tvga_setpage(page)
int page;
{
	port_out(0x0b, SEQ_I);
	port_out(port_in(SEQ_D), SEQ_D);
	port_in(SEQ_D);		/* select new mode regs */

	port_out(0x0e, SEQ_I);
	port_out(page ^ 0x02, SEQ_D);	/* select the page */
}

int tvga_clear256(pagecount)	/* Clear multiple pages of VRAM */
int pagecount;
{
int	i;

	/* write to all planes */ 
	port_out(0x02, SEQ_I ); 
	port_out(0x0F, SEQ_D );

	for(i=0; i<pagecount; i++){
		tvga_setpage(i);
                memset(graph_mem, 0, GRAPH_SIZE);
	}
}

int tvga_clear16(pagecount)
int pagecount;
{
int	i;

	/* write to all bits */
	port_out(0x08, GRA_I ); 
       	port_out(0xFF, GRA_D );   

	for (i=0; i<pagecount; i++){
		tvga_setpage(i);
	        memset(graph_mem, 0, GRAPH_SIZE); /* dummy values */
	}
}


/* Read Pixel info */
int inline vga_readpixel(int x, int y)
{
	unsigned long offset;
    int vaddr, page;	/* see drawscanline for usage */
	int curcolor;		/* get current color */

    if ((x > cur_info.xdim) || (y > cur_info.ydim)) return -1;

    switch (cur_mode) {
        case G320x200x16:
        case G640x200x16:
        case G640x350x16:
        case G640x480x16:
	case G800x600x16:
	    /* select bit */
	    //port_out(8, GRA_I);
	    //port_out(0x80 >> (x & 7), GRA_D);   

            /* read into latch and write dummy back */
	    offset = y*cur_info.xbytes + (x>>3);   
            //graph_mem[offset] = graph_mem[offset];  
			curcolor=graph_mem[offset];
            break;
	case G1024x768x16:
	case G768x1024x16:
	    /* select bit */
	    //port_out(8, GRA_I);
	    //port_out(0x80 >> (x & 7), GRA_D);   

            vaddr = y*cur_info.xbytes + (x >> 3);
            page = vaddr / GRAPH_SIZE;
            vaddr %= GRAPH_SIZE;
           // tvga_setpage(page);

            /* read into latch and write dummy back */
            //graph_mem[vaddr] = graph_mem[vaddr];
			curcolor=graph_mem[vaddr];
            break;
	case G320x200x256:
	case G640x400x256:
	case G640x480x256:
	case G800x600x256:
	case G1024x768x256:
            /* get proper page and offset */
            vaddr = y*cur_info.xbytes + x;
            //tvga_setpage(vaddr / GRAPH_SIZE);

            /* write color to pixel */
	    //graph_mem[vaddr % GRAPH_SIZE] = cur_color;
		curcolor=graph_mem[vaddr % GRAPH_SIZE]
            break;
	case G320x240x256:
	case G320x400x256:
	case G360x480x256:
	    /* select plane */ 
	   // port_out(0x02, SEQ_I); 
    //	    port_out(1 << (x & 3), SEQ_D);   

            /* write color to pixel */
	  //  graph_mem[y*cur_info.xbytes + (x>>2)] = cur_color;  
		curcolor=graph_mem[y*cur_info.xbytes + (x>>2)];
            break;
    }
        
    return curcolor;
}