.TH "ZIP_OPEN" "3" "February 13, 2012" "NiH" "Library Functions Manual"
.nh
.if n .ad l
.SH "NAME"
\fBzip_open\fR
\- open zip archive
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
\fB#include <zip.h>\fR
.sp
\fIstruct\ zip\ *\fR
.br
\fBzip_open\fR(\fIconst char *path\fR,\ \fIint flags\fR,\ \fIint *errorp\fR);
.SH "DESCRIPTION"
The zip archive specified by
\fIpath\fR
is opened and a pointer to a
\fIstruct zip\fR,
used to manipulate the archive, is returned.
The
\fIflags\fR
are specified by
\fIor\fR'ing
the following values, or 0 for none of them.
.RS 6n
.TP 15n
\fRZIP_CHECKCONS\fR
Perform additional stricter consistency checks on the archive, and
error if they fail.
.TP 15n
\fRZIP_CREATE\fR
Create the archive if it does not exist.
.TP 15n
\fRZIP_EXCL\fR
Error if archive already exists.
.TP 15n
\fRZIP_TRUNCATE\fR
If archive exists, ignore its current contents.
In other words, handle it the same way as an empty archive.
.RE
.PP
If an error occurs and
\fIerrorp\fR
is non-NULL, it will be set to the corresponding error code.
.SH "RETURN VALUES"
Upon successful completion
\fBzip_open\fR()
returns a
\fIstruct zip\fR
pointer.
Otherwise,
\fRNULL\fR
is returned and
\fI*errorp\fR
is set to indicate the error.
.SH "ERRORS"
The archive specified by
\fIpath\fR
is opened unless:
.TP 19n
[\fRZIP_ER_EXISTS\fR]
The file specified by
\fIpath\fR
exists and
\fRZIP_EXCL\fR
is set.
.TP 19n
[\fRZIP_ER_INCONS\fR]
Inconsistencies were found in the file specified by
\fIpath\fR.
This error is often caused by specifying
\fRZIP_CHECKCONS\fR
but can also happen without it.
.TP 19n
[\fRZIP_ER_INVAL\fR]
The
\fIpath\fR
argument is
\fRNULL\fR.
.TP 19n
[\fRZIP_ER_MEMORY\fR]
Required memory could not be allocated.
.TP 19n
[\fRZIP_ER_NOENT\fR]
The file specified by
\fIpath\fR
does not exist and
\fRZIP_CREATE\fR
is not set.
.TP 19n
[\fRZIP_ER_NOZIP\fR]
The file specified by
\fIpath\fR
is not a zip archive.
.TP 19n
[\fRZIP_ER_OPEN\fR]
The file specified by
\fIpath\fR
could not be opened.
.TP 19n
[\fRZIP_ER_READ\fR]
A read error occurred; see
\fIerrno\fR
for details.
.TP 19n
[\fRZIP_ER_SEEK\fR]
The file specified by
\fIpath\fR
does not allow seeks.
.SH "SEE ALSO"
libzip(3),
zip_close(3),
zip_error_to_str(3),
zip_fdopen(3)
.SH "AUTHORS"
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fItk@giga.or.at\fR>
