/* This file is automatically generated by aarch64-gen.  Do not edit!  */
/* Copyright (C) 2012-2019 Free Software Foundation, Inc.
   Contributed by ARM Ltd.

   This file is part of the GNU opcodes library.

   This library is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   It is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
   or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
   License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING3. If not,
   see <http://www.gnu.org/licenses/>.  */

#include "sysdep.h"
#include "aarch64-asm.h"


const aarch64_opcode *
aarch64_find_real_opcode (const aarch64_opcode *opcode)
{
  /* Use the index as the key to locate the real opcode.  */
  int key = opcode - aarch64_opcode_table;
  int value;
  switch (key)
    {
    case 3:	/* ngc */
    case 2:	/* sbc */
      value = 2;	/* --> sbc.  */
      break;
    case 5:	/* ngcs */
    case 4:	/* sbcs */
      value = 4;	/* --> sbcs.  */
      break;
    case 8:	/* cmn */
    case 7:	/* adds */
      value = 7;	/* --> adds.  */
      break;
    case 11:	/* cmp */
    case 10:	/* subs */
      value = 10;	/* --> subs.  */
      break;
    case 13:	/* mov */
    case 12:	/* add */
      value = 12;	/* --> add.  */
      break;
    case 15:	/* cmn */
    case 14:	/* adds */
      value = 14;	/* --> adds.  */
      break;
    case 18:	/* cmp */
    case 17:	/* subs */
      value = 17;	/* --> subs.  */
      break;
    case 23:	/* cmn */
    case 22:	/* adds */
      value = 22;	/* --> adds.  */
      break;
    case 25:	/* neg */
    case 24:	/* sub */
      value = 24;	/* --> sub.  */
      break;
    case 27:	/* cmp */
    case 28:	/* negs */
    case 26:	/* subs */
      value = 26;	/* --> subs.  */
      break;
    case 153:	/* mov */
    case 152:	/* umov */
      value = 152;	/* --> umov.  */
      break;
    case 155:	/* mov */
    case 154:	/* ins */
      value = 154;	/* --> ins.  */
      break;
    case 157:	/* mov */
    case 156:	/* ins */
      value = 156;	/* --> ins.  */
      break;
    case 243:	/* mvn */
    case 242:	/* not */
      value = 242;	/* --> not.  */
      break;
    case 318:	/* mov */
    case 317:	/* orr */
      value = 317;	/* --> orr.  */
      break;
    case 389:	/* sxtl */
    case 388:	/* sshll */
      value = 388;	/* --> sshll.  */
      break;
    case 391:	/* sxtl2 */
    case 390:	/* sshll2 */
      value = 390;	/* --> sshll2.  */
      break;
    case 413:	/* uxtl */
    case 412:	/* ushll */
      value = 412;	/* --> ushll.  */
      break;
    case 415:	/* uxtl2 */
    case 414:	/* ushll2 */
      value = 414;	/* --> ushll2.  */
      break;
    case 536:	/* mov */
    case 535:	/* dup */
      value = 535;	/* --> dup.  */
      break;
    case 623:	/* sxtw */
    case 622:	/* sxth */
    case 621:	/* sxtb */
    case 624:	/* asr */
    case 620:	/* sbfx */
    case 619:	/* sbfiz */
    case 618:	/* sbfm */
      value = 618;	/* --> sbfm.  */
      break;
    case 627:	/* bfc */
    case 628:	/* bfxil */
    case 626:	/* bfi */
    case 625:	/* bfm */
      value = 625;	/* --> bfm.  */
      break;
    case 633:	/* uxth */
    case 632:	/* uxtb */
    case 635:	/* lsr */
    case 634:	/* lsl */
    case 631:	/* ubfx */
    case 630:	/* ubfiz */
    case 629:	/* ubfm */
      value = 629;	/* --> ubfm.  */
      break;
    case 665:	/* cset */
    case 664:	/* cinc */
    case 663:	/* csinc */
      value = 663;	/* --> csinc.  */
      break;
    case 668:	/* csetm */
    case 667:	/* cinv */
    case 666:	/* csinv */
      value = 666;	/* --> csinv.  */
      break;
    case 670:	/* cneg */
    case 669:	/* csneg */
      value = 669;	/* --> csneg.  */
      break;
    case 688:	/* rev */
    case 689:	/* rev64 */
      value = 688;	/* --> rev.  */
      break;
    case 714:	/* lsl */
    case 713:	/* lslv */
      value = 713;	/* --> lslv.  */
      break;
    case 716:	/* lsr */
    case 715:	/* lsrv */
      value = 715;	/* --> lsrv.  */
      break;
    case 718:	/* asr */
    case 717:	/* asrv */
      value = 717;	/* --> asrv.  */
      break;
    case 720:	/* ror */
    case 719:	/* rorv */
      value = 719;	/* --> rorv.  */
      break;
    case 723:	/* cmpp */
    case 722:	/* subps */
      value = 722;	/* --> subps.  */
      break;
    case 736:	/* mul */
    case 735:	/* madd */
      value = 735;	/* --> madd.  */
      break;
    case 738:	/* mneg */
    case 737:	/* msub */
      value = 737;	/* --> msub.  */
      break;
    case 740:	/* smull */
    case 739:	/* smaddl */
      value = 739;	/* --> smaddl.  */
      break;
    case 742:	/* smnegl */
    case 741:	/* smsubl */
      value = 741;	/* --> smsubl.  */
      break;
    case 745:	/* umull */
    case 744:	/* umaddl */
      value = 744;	/* --> umaddl.  */
      break;
    case 747:	/* umnegl */
    case 746:	/* umsubl */
      value = 746;	/* --> umsubl.  */
      break;
    case 758:	/* ror */
    case 757:	/* extr */
      value = 757;	/* --> extr.  */
      break;
    case 990:	/* bic */
    case 989:	/* and */
      value = 989;	/* --> and.  */
      break;
    case 992:	/* mov */
    case 991:	/* orr */
      value = 991;	/* --> orr.  */
      break;
    case 995:	/* tst */
    case 994:	/* ands */
      value = 994;	/* --> ands.  */
      break;
    case 1000:	/* uxtw */
    case 999:	/* mov */
    case 998:	/* orr */
      value = 998;	/* --> orr.  */
      break;
    case 1002:	/* mvn */
    case 1001:	/* orn */
      value = 1001;	/* --> orn.  */
      break;
    case 1006:	/* tst */
    case 1005:	/* ands */
      value = 1005;	/* --> ands.  */
      break;
    case 1132:	/* staddb */
    case 1036:	/* ldaddb */
      value = 1036;	/* --> ldaddb.  */
      break;
    case 1133:	/* staddh */
    case 1037:	/* ldaddh */
      value = 1037;	/* --> ldaddh.  */
      break;
    case 1134:	/* stadd */
    case 1038:	/* ldadd */
      value = 1038;	/* --> ldadd.  */
      break;
    case 1135:	/* staddlb */
    case 1040:	/* ldaddlb */
      value = 1040;	/* --> ldaddlb.  */
      break;
    case 1136:	/* staddlh */
    case 1043:	/* ldaddlh */
      value = 1043;	/* --> ldaddlh.  */
      break;
    case 1137:	/* staddl */
    case 1046:	/* ldaddl */
      value = 1046;	/* --> ldaddl.  */
      break;
    case 1138:	/* stclrb */
    case 1048:	/* ldclrb */
      value = 1048;	/* --> ldclrb.  */
      break;
    case 1139:	/* stclrh */
    case 1049:	/* ldclrh */
      value = 1049;	/* --> ldclrh.  */
      break;
    case 1140:	/* stclr */
    case 1050:	/* ldclr */
      value = 1050;	/* --> ldclr.  */
      break;
    case 1141:	/* stclrlb */
    case 1052:	/* ldclrlb */
      value = 1052;	/* --> ldclrlb.  */
      break;
    case 1142:	/* stclrlh */
    case 1055:	/* ldclrlh */
      value = 1055;	/* --> ldclrlh.  */
      break;
    case 1143:	/* stclrl */
    case 1058:	/* ldclrl */
      value = 1058;	/* --> ldclrl.  */
      break;
    case 1144:	/* steorb */
    case 1060:	/* ldeorb */
      value = 1060;	/* --> ldeorb.  */
      break;
    case 1145:	/* steorh */
    case 1061:	/* ldeorh */
      value = 1061;	/* --> ldeorh.  */
      break;
    case 1146:	/* steor */
    case 1062:	/* ldeor */
      value = 1062;	/* --> ldeor.  */
      break;
    case 1147:	/* steorlb */
    case 1064:	/* ldeorlb */
      value = 1064;	/* --> ldeorlb.  */
      break;
    case 1148:	/* steorlh */
    case 1067:	/* ldeorlh */
      value = 1067;	/* --> ldeorlh.  */
      break;
    case 1149:	/* steorl */
    case 1070:	/* ldeorl */
      value = 1070;	/* --> ldeorl.  */
      break;
    case 1150:	/* stsetb */
    case 1072:	/* ldsetb */
      value = 1072;	/* --> ldsetb.  */
      break;
    case 1151:	/* stseth */
    case 1073:	/* ldseth */
      value = 1073;	/* --> ldseth.  */
      break;
    case 1152:	/* stset */
    case 1074:	/* ldset */
      value = 1074;	/* --> ldset.  */
      break;
    case 1153:	/* stsetlb */
    case 1076:	/* ldsetlb */
      value = 1076;	/* --> ldsetlb.  */
      break;
    case 1154:	/* stsetlh */
    case 1079:	/* ldsetlh */
      value = 1079;	/* --> ldsetlh.  */
      break;
    case 1155:	/* stsetl */
    case 1082:	/* ldsetl */
      value = 1082;	/* --> ldsetl.  */
      break;
    case 1156:	/* stsmaxb */
    case 1084:	/* ldsmaxb */
      value = 1084;	/* --> ldsmaxb.  */
      break;
    case 1157:	/* stsmaxh */
    case 1085:	/* ldsmaxh */
      value = 1085;	/* --> ldsmaxh.  */
      break;
    case 1158:	/* stsmax */
    case 1086:	/* ldsmax */
      value = 1086;	/* --> ldsmax.  */
      break;
    case 1159:	/* stsmaxlb */
    case 1088:	/* ldsmaxlb */
      value = 1088;	/* --> ldsmaxlb.  */
      break;
    case 1160:	/* stsmaxlh */
    case 1091:	/* ldsmaxlh */
      value = 1091;	/* --> ldsmaxlh.  */
      break;
    case 1161:	/* stsmaxl */
    case 1094:	/* ldsmaxl */
      value = 1094;	/* --> ldsmaxl.  */
      break;
    case 1162:	/* stsminb */
    case 1096:	/* ldsminb */
      value = 1096;	/* --> ldsminb.  */
      break;
    case 1163:	/* stsminh */
    case 1097:	/* ldsminh */
      value = 1097;	/* --> ldsminh.  */
      break;
    case 1164:	/* stsmin */
    case 1098:	/* ldsmin */
      value = 1098;	/* --> ldsmin.  */
      break;
    case 1165:	/* stsminlb */
    case 1100:	/* ldsminlb */
      value = 1100;	/* --> ldsminlb.  */
      break;
    case 1166:	/* stsminlh */
    case 1103:	/* ldsminlh */
      value = 1103;	/* --> ldsminlh.  */
      break;
    case 1167:	/* stsminl */
    case 1106:	/* ldsminl */
      value = 1106;	/* --> ldsminl.  */
      break;
    case 1168:	/* stumaxb */
    case 1108:	/* ldumaxb */
      value = 1108;	/* --> ldumaxb.  */
      break;
    case 1169:	/* stumaxh */
    case 1109:	/* ldumaxh */
      value = 1109;	/* --> ldumaxh.  */
      break;
    case 1170:	/* stumax */
    case 1110:	/* ldumax */
      value = 1110;	/* --> ldumax.  */
      break;
    case 1171:	/* stumaxlb */
    case 1112:	/* ldumaxlb */
      value = 1112;	/* --> ldumaxlb.  */
      break;
    case 1172:	/* stumaxlh */
    case 1115:	/* ldumaxlh */
      value = 1115;	/* --> ldumaxlh.  */
      break;
    case 1173:	/* stumaxl */
    case 1118:	/* ldumaxl */
      value = 1118;	/* --> ldumaxl.  */
      break;
    case 1174:	/* stuminb */
    case 1120:	/* lduminb */
      value = 1120;	/* --> lduminb.  */
      break;
    case 1175:	/* stuminh */
    case 1121:	/* lduminh */
      value = 1121;	/* --> lduminh.  */
      break;
    case 1176:	/* stumin */
    case 1122:	/* ldumin */
      value = 1122;	/* --> ldumin.  */
      break;
    case 1177:	/* stuminlb */
    case 1124:	/* lduminlb */
      value = 1124;	/* --> lduminlb.  */
      break;
    case 1178:	/* stuminlh */
    case 1127:	/* lduminlh */
      value = 1127;	/* --> lduminlh.  */
      break;
    case 1179:	/* stuminl */
    case 1130:	/* lduminl */
      value = 1130;	/* --> lduminl.  */
      break;
    case 1181:	/* mov */
    case 1180:	/* movn */
      value = 1180;	/* --> movn.  */
      break;
    case 1183:	/* mov */
    case 1182:	/* movz */
      value = 1182;	/* --> movz.  */
      break;
    case 1229:	/* autibsp */
    case 1228:	/* autibz */
    case 1227:	/* autiasp */
    case 1226:	/* autiaz */
    case 1225:	/* pacibsp */
    case 1224:	/* pacibz */
    case 1223:	/* paciasp */
    case 1222:	/* paciaz */
    case 1203:	/* psb */
    case 1202:	/* esb */
    case 1201:	/* autib1716 */
    case 1200:	/* autia1716 */
    case 1199:	/* pacib1716 */
    case 1198:	/* pacia1716 */
    case 1197:	/* xpaclri */
    case 1196:	/* sevl */
    case 1195:	/* sev */
    case 1194:	/* wfi */
    case 1193:	/* wfe */
    case 1192:	/* yield */
    case 1191:	/* bti */
    case 1190:	/* csdb */
    case 1189:	/* nop */
    case 1188:	/* hint */
      value = 1188;	/* --> hint.  */
      break;
    case 1207:	/* pssbb */
    case 1206:	/* ssbb */
    case 1205:	/* dsb */
      value = 1205;	/* --> dsb.  */
      break;
    case 1218:	/* cpp */
    case 1217:	/* dvp */
    case 1216:	/* cfp */
    case 1215:	/* tlbi */
    case 1214:	/* ic */
    case 1213:	/* dc */
    case 1212:	/* at */
    case 1211:	/* sys */
      value = 1211;	/* --> sys.  */
      break;
    case 2027:	/* bic */
    case 1277:	/* and */
      value = 1277;	/* --> and.  */
      break;
    case 1260:	/* mov */
    case 1279:	/* and */
      value = 1279;	/* --> and.  */
      break;
    case 1264:	/* movs */
    case 1280:	/* ands */
      value = 1280;	/* --> ands.  */
      break;
    case 2028:	/* cmple */
    case 1315:	/* cmpge */
      value = 1315;	/* --> cmpge.  */
      break;
    case 2031:	/* cmplt */
    case 1318:	/* cmpgt */
      value = 1318;	/* --> cmpgt.  */
      break;
    case 2029:	/* cmplo */
    case 1320:	/* cmphi */
      value = 1320;	/* --> cmphi.  */
      break;
    case 2030:	/* cmpls */
    case 1323:	/* cmphs */
      value = 1323;	/* --> cmphs.  */
      break;
    case 1257:	/* mov */
    case 1345:	/* cpy */
      value = 1345;	/* --> cpy.  */
      break;
    case 1259:	/* mov */
    case 1346:	/* cpy */
      value = 1346;	/* --> cpy.  */
      break;
    case 2038:	/* fmov */
    case 1262:	/* mov */
    case 1347:	/* cpy */
      value = 1347;	/* --> cpy.  */
      break;
    case 1252:	/* mov */
    case 1359:	/* dup */
      value = 1359;	/* --> dup.  */
      break;
    case 1254:	/* mov */
    case 1251:	/* mov */
    case 1360:	/* dup */
      value = 1360;	/* --> dup.  */
      break;
    case 2037:	/* fmov */
    case 1256:	/* mov */
    case 1361:	/* dup */
      value = 1361;	/* --> dup.  */
      break;
    case 1255:	/* mov */
    case 1362:	/* dupm */
      value = 1362;	/* --> dupm.  */
      break;
    case 2032:	/* eon */
    case 1364:	/* eor */
      value = 1364;	/* --> eor.  */
      break;
    case 1265:	/* not */
    case 1366:	/* eor */
      value = 1366;	/* --> eor.  */
      break;
    case 1266:	/* nots */
    case 1367:	/* eors */
      value = 1367;	/* --> eors.  */
      break;
    case 2033:	/* facle */
    case 1372:	/* facge */
      value = 1372;	/* --> facge.  */
      break;
    case 2034:	/* faclt */
    case 1373:	/* facgt */
      value = 1373;	/* --> facgt.  */
      break;
    case 2035:	/* fcmle */
    case 1386:	/* fcmge */
      value = 1386;	/* --> fcmge.  */
      break;
    case 2036:	/* fcmlt */
    case 1388:	/* fcmgt */
      value = 1388;	/* --> fcmgt.  */
      break;
    case 1249:	/* fmov */
    case 1394:	/* fcpy */
      value = 1394;	/* --> fcpy.  */
      break;
    case 1248:	/* fmov */
    case 1417:	/* fdup */
      value = 1417;	/* --> fdup.  */
      break;
    case 1250:	/* mov */
    case 1748:	/* orr */
      value = 1748;	/* --> orr.  */
      break;
    case 2039:	/* orn */
    case 1749:	/* orr */
      value = 1749;	/* --> orr.  */
      break;
    case 1253:	/* mov */
    case 1751:	/* orr */
      value = 1751;	/* --> orr.  */
      break;
    case 1263:	/* movs */
    case 1752:	/* orrs */
      value = 1752;	/* --> orrs.  */
      break;
    case 1258:	/* mov */
    case 1814:	/* sel */
      value = 1814;	/* --> sel.  */
      break;
    case 1261:	/* mov */
    case 1815:	/* sel */
      value = 1815;	/* --> sel.  */
      break;
    default: return NULL;
    }

  return aarch64_opcode_table + value;
}

bfd_boolean
aarch64_insert_operand (const aarch64_operand *self,
			   const aarch64_opnd_info *info,
			   aarch64_insn *code, const aarch64_inst *inst,
			   aarch64_operand_error *errors)
{
  /* Use the index as the key.  */
  int key = self - aarch64_operands;
  switch (key)
    {
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 15:
    case 16:
    case 17:
    case 18:
    case 20:
    case 21:
    case 22:
    case 23:
    case 24:
    case 25:
    case 26:
    case 27:
    case 28:
    case 29:
    case 160:
    case 161:
    case 162:
    case 163:
    case 164:
    case 165:
    case 166:
    case 167:
    case 168:
    case 169:
    case 182:
    case 183:
    case 184:
    case 185:
    case 186:
    case 187:
    case 188:
    case 189:
    case 190:
    case 194:
    case 197:
      return aarch64_ins_regno (self, info, code, inst, errors);
    case 13:
      return aarch64_ins_reg_extended (self, info, code, inst, errors);
    case 14:
      return aarch64_ins_reg_shifted (self, info, code, inst, errors);
    case 19:
      return aarch64_ins_ft (self, info, code, inst, errors);
    case 30:
    case 31:
    case 32:
    case 33:
    case 199:
      return aarch64_ins_reglane (self, info, code, inst, errors);
    case 34:
      return aarch64_ins_reglist (self, info, code, inst, errors);
    case 35:
      return aarch64_ins_ldst_reglist (self, info, code, inst, errors);
    case 36:
      return aarch64_ins_ldst_reglist_r (self, info, code, inst, errors);
    case 37:
      return aarch64_ins_ldst_elemlist (self, info, code, inst, errors);
    case 38:
    case 39:
    case 40:
    case 41:
    case 51:
    case 52:
    case 53:
    case 54:
    case 55:
    case 56:
    case 57:
    case 58:
    case 59:
    case 60:
    case 61:
    case 62:
    case 63:
    case 64:
    case 65:
    case 66:
    case 78:
    case 79:
    case 80:
    case 81:
    case 157:
    case 159:
    case 174:
    case 175:
    case 176:
    case 177:
    case 178:
    case 179:
    case 180:
    case 181:
      return aarch64_ins_imm (self, info, code, inst, errors);
    case 42:
    case 43:
      return aarch64_ins_advsimd_imm_shift (self, info, code, inst, errors);
    case 44:
    case 45:
    case 46:
      return aarch64_ins_advsimd_imm_modified (self, info, code, inst, errors);
    case 50:
    case 148:
      return aarch64_ins_fpimm (self, info, code, inst, errors);
    case 67:
    case 155:
      return aarch64_ins_limm (self, info, code, inst, errors);
    case 68:
      return aarch64_ins_aimm (self, info, code, inst, errors);
    case 69:
      return aarch64_ins_imm_half (self, info, code, inst, errors);
    case 70:
      return aarch64_ins_fbits (self, info, code, inst, errors);
    case 72:
    case 73:
    case 153:
      return aarch64_ins_imm_rotate2 (self, info, code, inst, errors);
    case 74:
    case 152:
      return aarch64_ins_imm_rotate1 (self, info, code, inst, errors);
    case 75:
    case 76:
      return aarch64_ins_cond (self, info, code, inst, errors);
    case 82:
    case 92:
      return aarch64_ins_addr_simple (self, info, code, inst, errors);
    case 83:
      return aarch64_ins_addr_simple_2 (self, info, code, inst, errors);
    case 84:
      return aarch64_ins_addr_regoff (self, info, code, inst, errors);
    case 85:
    case 86:
    case 87:
    case 89:
    case 91:
      return aarch64_ins_addr_simm (self, info, code, inst, errors);
    case 88:
      return aarch64_ins_addr_simm10 (self, info, code, inst, errors);
    case 90:
      return aarch64_ins_addr_uimm12 (self, info, code, inst, errors);
    case 93:
      return aarch64_ins_addr_offset (self, info, code, inst, errors);
    case 94:
      return aarch64_ins_simd_addr_post (self, info, code, inst, errors);
    case 95:
      return aarch64_ins_sysreg (self, info, code, inst, errors);
    case 96:
      return aarch64_ins_pstatefield (self, info, code, inst, errors);
    case 97:
    case 98:
    case 99:
    case 100:
    case 101:
      return aarch64_ins_sysins_op (self, info, code, inst, errors);
    case 102:
    case 103:
      return aarch64_ins_barrier (self, info, code, inst, errors);
    case 104:
      return aarch64_ins_prfop (self, info, code, inst, errors);
    case 105:
    case 106:
      return aarch64_ins_hint (self, info, code, inst, errors);
    case 107:
      return aarch64_ins_sve_addr_ri_s4 (self, info, code, inst, errors);
    case 108:
    case 109:
    case 110:
    case 111:
      return aarch64_ins_sve_addr_ri_s4xvl (self, info, code, inst, errors);
    case 112:
      return aarch64_ins_sve_addr_ri_s6xvl (self, info, code, inst, errors);
    case 113:
      return aarch64_ins_sve_addr_ri_s9xvl (self, info, code, inst, errors);
    case 114:
    case 115:
    case 116:
    case 117:
      return aarch64_ins_sve_addr_ri_u6 (self, info, code, inst, errors);
    case 118:
    case 119:
    case 120:
    case 121:
    case 122:
    case 123:
    case 124:
    case 125:
    case 126:
    case 127:
    case 128:
    case 129:
    case 130:
      return aarch64_ins_sve_addr_rr_lsl (self, info, code, inst, errors);
    case 131:
    case 132:
    case 133:
    case 134:
    case 135:
    case 136:
    case 137:
    case 138:
      return aarch64_ins_sve_addr_rz_xtw (self, info, code, inst, errors);
    case 139:
    case 140:
    case 141:
    case 142:
      return aarch64_ins_sve_addr_zi_u5 (self, info, code, inst, errors);
    case 143:
      return aarch64_ins_sve_addr_zz_lsl (self, info, code, inst, errors);
    case 144:
      return aarch64_ins_sve_addr_zz_sxtw (self, info, code, inst, errors);
    case 145:
      return aarch64_ins_sve_addr_zz_uxtw (self, info, code, inst, errors);
    case 146:
      return aarch64_ins_sve_aimm (self, info, code, inst, errors);
    case 147:
      return aarch64_ins_sve_asimm (self, info, code, inst, errors);
    case 149:
      return aarch64_ins_sve_float_half_one (self, info, code, inst, errors);
    case 150:
      return aarch64_ins_sve_float_half_two (self, info, code, inst, errors);
    case 151:
      return aarch64_ins_sve_float_zero_one (self, info, code, inst, errors);
    case 154:
      return aarch64_ins_inv_limm (self, info, code, inst, errors);
    case 156:
      return aarch64_ins_sve_limm_mov (self, info, code, inst, errors);
    case 158:
      return aarch64_ins_sve_scale (self, info, code, inst, errors);
    case 170:
    case 171:
      return aarch64_ins_sve_shlimm (self, info, code, inst, errors);
    case 172:
    case 173:
      return aarch64_ins_sve_shrimm (self, info, code, inst, errors);
    case 191:
    case 192:
    case 193:
      return aarch64_ins_sve_quad_index (self, info, code, inst, errors);
    case 195:
      return aarch64_ins_sve_index (self, info, code, inst, errors);
    case 196:
    case 198:
      return aarch64_ins_sve_reglist (self, info, code, inst, errors);
    default: assert (0); abort ();
    }
}
