/* input_file.c - -  */

/* Copyright (C) 1987 Free Software Foundation, Inc.

This file is part of Gas, the GNU Assembler.

The GNU assembler is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY.  No author or distributor
accepts responsibility to anyone for the consequences of using it
or for whether it serves any particular purpose or works at all,
unless he says so in writing.  Refer to the GNU Assembler General
Public License for full details.

Everyone is granted permission to copy, modify and redistribute
the GNU Assembler, but only under the conditions described in the
GNU Assembler General Public License.  A copy of this license is
supposed to have been given to you along with the GNU Assembler
so you can know your rights and responsibilities.  It should be
in a file named COPYING.  Among other things, the copyright
notice and this notice must be preserved on all copies.  */

/*
 * Confines all details of reading source bytes to this module.
 * All O/S specific crocks should live here.
 * What we lose in "efficiency" we gain in modularity.
 * Note we don't need to #include the "as.h" file. No common coupling!
 */

#define NDEBUG		/* JF remove asserts */

#include <stdio.h>
#include <assert.h>
/* #include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/wait.h> */

/* #include "style.h" */
#include "input-file.h"

/* This variable is non-zero if the file currently being read should be
   preprocessed by app.  It is zero if the file can be read straight in.
 */
int preprocess = 0;

void	as_perror();

/*
 * This code opens a file, then delivers BUFFER_SIZE character
 * chunks of the file on demand.
 * BUFFER_SIZE is supposed to be a number chosen for speed.
 * The caller only asks once what BUFFER_SIZE is, and asks before
 * the nature of the input files (if any) is known.
 */

#define BUFFER_SIZE (32 * 1024)

static char in_buf[BUFFER_SIZE];

/*
 * We use static data: the data area is not sharable.
 */

/* static int	file_handle;	/* <0 === not open */
FILE *f_in;	/* JF do things the RIGHT way */
/* static JF remove static so app.c can use file_name */
char *	file_name;

/* These hooks accomodate most operating systems. */

void
input_file_begin ()
{
  /* file_handle = -1; */
  f_in = (FILE *)0;
}

void
input_file_end ()
{
}

int				/* Return BUFFER_SIZE. */
input_file_buffer_size ()
{
  return (BUFFER_SIZE);
}

int
input_file_is_open ()
{
  /* return (file_handle >= 0); */
  return f_in!=(FILE *)0;
}

#ifdef DONTDEF		/* JF save old version in case we need it */
void
input_file_open (filename, preprocess, debugging)
     char *	filename;	/* "" means use stdin. Must not be 0. */
     int	preprocess;	/* TRUE if needs app. */
     int	debugging;	/* TRUE if we are debugging assembler. */
{
  assert( filename != 0 );	/* Filename may not be NULL. */
  if (filename [0])
    {				/* We have a file name. Suck it and see. */
      file_handle = open (filename, O_RDONLY, 0);
      file_name = filename;
    }
  else
    {				/* use stdin for the input file. */
      file_handle = fileno (stdin);
      file_name = "{standard input}"; /* For error messages. */
    }
  if (file_handle < 0)
    {
      as_perror ("Can't open source file for input", file_name);
    }
  if ( preprocess )
    {
/*
 * This code was written in haste for a frobbed BSD 4.2.
 * I have a flight to catch: will someone please do proper
 * error checks? - Dean.
 */
      int	pid;
      char temporary_file_name [12];
      int	fd;
      union wait	status;
      char	*mktemp();

      (void)strcpy (temporary_file_name, "#appXXXXXX");
      (void)mktemp (temporary_file_name);
      pid = vfork ();
      if (pid == -1)
	{
	  as_perror ("Can't fork to run app", file_name);
	  _exit (144);
	}
      if (pid == 0)
	{
	  (void)dup2 (file_handle, fileno(stdin));
	  fd = open (temporary_file_name, O_WRONLY + O_TRUNC + O_CREAT, 0666);
	  if (fd == -1)
	    {
	      (void)write(2,"Can't open temporary\n",21);
	      _exit (99);
	    }
	  (void)dup2 (fd, fileno(stdout));
/* JF for testing #define PREPROCESSOR "/lib/app" */
#define PREPROCESSOR "./app"
	  execl (PREPROCESSOR, PREPROCESSOR, 0);
	  execl ("app","app",0);
	  (void)write(2,"Exec of app failed.  Get help.\n",31);
	  (void)unlink(temporary_file_name);
	  _exit (11);
	}
      (void)wait (& status);
      if (status.w_status & 0xFF00)		/* JF was 0xF000, was wrong */
	{
	  file_handle = -1;
	  as_warn( "Can't preprocess file \"%s\", status = %xx", file_name, status.w_status );
	}
      else
	{
	  file_handle = open (temporary_file_name, O_RDONLY, 0);
	  if ( ! debugging )
	    {
	      if (unlink(temporary_file_name))
		{
		  as_perror ("Can't delete temporary file, continuing", temporary_file_name);
		}
	    }
	}
      if (file_handle == -1)
	{
	  as_perror ("Can't retrieve temporary file", temporary_file_name);
	}
    }
}
#else

void
input_file_open (filename,pre)
     char *	filename;	/* "" means use stdin. Must not be 0. */
{
	int	c;
	char	buf[80];

	preprocess = pre;

	assert( filename != 0 );	/* Filename may not be NULL. */
	if (filename [0]) {	/* We have a file name. Suck it and see. */
		f_in=fopen(filename,"r");
		file_name=filename;
	} else {			/* use stdin for the input file. */
		f_in = stdin;
		file_name = "{standard input}"; /* For error messages. */
	}
	if (f_in==(FILE *)0) {
		as_perror ("Can't open source file for input", file_name);
		return;
	}
	setbuffer(f_in,in_buf,BUFFER_SIZE);
	c=getc(f_in);
	if(c=='#') {	/* Begins with comment, may not want to preprocess */
		c=getc(f_in);
		if(c=='N') {
			fgets(buf,80,f_in);
			if(!strcmp(buf,"O_APP\n"))
				preprocess=0;
			if(!index(buf,'\n'))
				ungetc('#',f_in);	/* It was longer */
			else
				ungetc('\n',f_in);
		} else if(c=='\n')
			ungetc('\n',f_in);
		else
			ungetc('#',f_in);
	} else
		ungetc(c,f_in);

#ifdef DONTDEF
	if ( preprocess ) {
		char temporary_file_name [17];
		char	*mktemp();
		FILE	*f_out;

		(void)strcpy (temporary_file_name, "/tmp/#appXXXXXX");
		(void)mktemp (temporary_file_name);
		f_out=fopen(temporary_file_name,"w+");
		if(f_out==(FILE *)0) {
			as_perror("Can't open temp file");
		}
			/* JF this will have to be moved on any system that
			   does not support removal of open files.  */
		(void)unlink(temporary_file_name);/* JF do it NOW */
		do_scrub(f_in,f_out);
		(void)fclose(f_in);	/* All done with it */
		(void)rewind(f_out);
		f_in=f_out;
	}
#endif
}
#endif

char *
input_file_give_next_buffer (where)
     char *		where;	/* Where to place 1st character of new buffer. */
{
  char *	return_value;	/* -> Last char of what we read, + 1. */
  register int	size;

  if (f_in == (FILE *)0)
      return 0;
      /*
       * fflush (stdin); could be done here if you want to synchronise
       * stdin and stdout, for the case where our input file is stdin.
       * Since the assembler shouldn't do any output to stdout, we
       * don't bother to synch output and input.
       */
  /* size = read (file_handle, where, BUFFER_SIZE); */
  size= fread(where,sizeof(char),BUFFER_SIZE,f_in);
  if (size < 0)
    {
      as_perror ("Can't read source file: end-of-file faked.", file_name);
      size = 0;
    }
  if (size)
    return_value = where + size;
  else
    {
      if (fclose (f_in))
	as_perror ("Can't close source file -- continuing", file_name);
      f_in = (FILE *)0;
      return_value = 0;
    }
  return (return_value);
}

/* end: input_file.c */
