#
#  pyParts.py (C) 2002 Jim Bublitz <jbublitz@nwinternet.com>
#

"""

This is a simple example of the steps involved in using a KDE
Part. There are more concerns than obvious here about how to
contruct the XML file (pyParts.rc used here) and load it to
avoid duplicating GUI elements.

"createReadOnlyPart" and the corresponding "createReadWritePart"
are PyKDE-unique methods to handle the typecasts necessary
with the KDE Parts mechanism, which can't be accomplished
directly in Python. The object returned from these calls
is cast as a KParts::ReadOnlyPart or KParts::ReadWritePart,
but is actually a subclass of one of those types. The openURL
call will access either the overloaded openURL or openFile
method of the Part, not the KParts:ReadOnlyPart or
KParts:ReadWritePart versions.

A good first exercise would be to add an 'Open' action to
the pyParts File menu (left as an exercise to the user) to
allow loading of an arbitrary image.

"""


# If you import more classes, don't forget to add them here (some of these
# are extras/not used)

from kdecore import KCmdLineArgs, KURL, KApplication, i18n, KAboutData, BarIcon, KLibLoader

from kdeui import KMainWindow, KMessageBox, KAction, KStdAction, KKeyDialog, KEditToolbar

from qt import  QString, QStringList

from kio import KTrader

# Importing the KParts namespace gets us all of the KParts:: classes
from kparts import KParts, createReadOnlyPart, createReadWritePart

import sys, os

FALSE = 0
TRUE  = not FALSE

TOOLBAR_EXIT = 0
TOOLBAR_OPEN = 1

# Note that we use KParts.MainWindow, not KMainWindow as the superclass
# (KParts.MainWindow subclasses KMainWindow). Also, be sure the 'apply'
# clause references KParts.MainWindow - it's a hard bug to track down
# if it doesn't.

class pyPartsMW (KParts.MainWindow):
        def __init__ (self, *args):
                apply (KParts.MainWindow.__init__, (self,) + args)

                # Create the actions for our menu/toolbar to use
                # Keep in mind that the part loaded will provide its
                # own menu/toolbar entries

                # check out KParts.MainWindow's ancestry to see where
                # some of this and later stuff (like self.actionCollection () )
                # comes from

                quitAction    = KStdAction.action (KStdAction.Quit, self.close, self.actionCollection (), "quitAction")

                self.m_toolbarAction = KStdAction.showToolbar(self.optionsShowToolbar, self.actionCollection());
                self.m_statusbarAction = KStdAction.showStatusbar(self.optionsShowStatusbar, self.actionCollection());

                KStdAction.keyBindings(self.optionsConfigureKeys, self.actionCollection());
                KStdAction.configureToolbars(self.optionsConfigureToolbars, self.actionCollection());

                self.path = os.getcwd () + '/'
                self.setGeometry (0, 0, 200, 350)

                # point to our XML file
                self.setXMLFile (self.path + "pyParts.rc", FALSE)

                # You might want to add some 'print' statements
                # in the following to see what's going on - I've
                # left them out for readability

                # see if any suitable parts are available
                offers = KTrader.self().query("image/gif", "'KParts/ReadOnlyPart' in ServiceTypes");
#                offers = KTrader.self().query("image/jpeg", "'KParts/ReadOnlyPart' in ServiceTypes");
                # contrived use of KTrader results - we could have
                # just gone for libkviewpart directly if that's
                # what we wanted.

                # The other viewer returned should work too (libkhtmlimage does)
                i = 0
                for offer in offers:
                        print offer.library ()
                        if str (offer.library ()) == "libkviewpart":
                                break
                        else:
                                i = i + 1

                ptr = offers [i];

                # get the part object (cast as KParts::ReadOnlyPart)
                # the actual 'createObject' call uses plain strings (char *)
                # but we use QStrings here for convenience, since that's
                # what library () and name () return
                self.part = createReadOnlyPart (ptr.library (), self, ptr.name ())

                # set the part as the main widget (you can use it in other
                # ways too)
                self.setCentralWidget (self.part.widget ())

                # merge the menus/toolbars and display them
                # (comment this out to see what happens)
                self.createGUI (self.part)

                # load a file to view - this calls the part's openURL or openFile
                # This should be network transparent, so any URL for an image
                # should work here
                self.part.openURL (KURL("file:" + self.path + "aboutkde.png"))
#                self.part.openURL (KURL("file:" + self.path + "pykdehome.jpg"))


        # slots for our actions
        def optionsShowToolbar (self):
                if self.m_toolbarAction.isChecked():
                        self.toolBar().show()
                else:
                        self.toolBar().hide()

        def optionsShowStatusbar (self):
                if self.m_statusbarAction.isChecked ():
                        self.statusBar().show()
                else:
                        self.statusBar().hide()


        def optionsConfigureKeys (self):
                KKeyDialog.configureActionKeys (self.actionCollection(), self.xmlFile ())


        def optionsConfigureToolbars (self):
                dlg = KEditToolbar (self.actionCollection(), self.xmlFile ())
                if dlg.exec_loop ():
                        self.createGUI(self);


        # some boilerplate left over from pyKLess/KLess
        def queryClose(self):
                res = KMessageBox.warningYesNoCancel(self,\
                        i18n("Save changes to Document?<br>(Does not make sense, we know, but it is just a programming example :-)"))
                if res == KMessageBox.Yes:
	        #// save document here. If saving fails, return FALSE
	                return TRUE

                elif res == KMessageBox.No:
                        return TRUE

                else: #// cancel
	                return FALSE

        def queryExit(self):
                #// this slot is invoked in addition when the *last* window is going
                #// to be closed. We could do some final cleanup here.
                return TRUE #// accept

        # I'm not sure the session mgmt stuff here works

        # Session management: save data
        def saveProperties(self, config):
        # This is provided just as an example.
        # It is generally not so good to save the raw contents of an application
        # in its configuration file (as this example does).
        # It is preferable to save the contents in a file on the application's
        # data zone and save an URL to it in the configuration resource.
                config.writeEntry("text", self.edit.text())


        # Session management: read data again
        def readProperties(self, config):
        # See above
                self.edit.setText(config.readEntry("text"))




#------------- main ----------------------------

# A Human readable description of your program
description = "KParts - simple example"
# The version
version = "0.1"

# stuff for the "About" menu
aboutData = KAboutData ("pyParts", "pyParts",\
    version, description, KAboutData.License_GPL,\
    "(c) 2002, Jim Bublitz")

aboutData.addAuthor ("Jim Bublitz", "Example for PyKDE", "jbublitz@nwinternet.com")

# This MUST go here (before KApplication () is called)
KCmdLineArgs.init1 (sys.argv, aboutData)

app = KApplication ()

if (app.isRestored()):
        RESTORE(KLess)
else:
        # no session management: just create one window
        # this is our KParts::MainWindow derived class
        parts = pyPartsMW (None, "pyParts")
        if len(sys.argv) > 1:
        # read kcmdlineargs.h for the full unabridged instructions
        # on using KCmdLineArgs, it's pretty confusing at first, but it works
        # This is pretty useless in this program - you might want to
        # expand this in your app (to load a file, etc)
                args = KCmdLineArgs.parsedArgs()

parts.show()
app.exec_loop()
