#!/bin/bash

clear
echo "KVim installer script"
echo "====================="
echo "KVim 0.2 provided by Thomas Capricelli, Philippe Fremy, Mickael Marchand"
echo
echo "How KVim Installation works :"
echo "First and most important of all, there are 2/3 ways of installing KVim :"
echo "-->Installing a full Vim 6.0 package with vim, rvim, evim, kvim ..."
echo "	This way will provide you the following things: "
echo "		* a full vim 6.0 package with normal features"
echo "		* typing :gui in Vim will start KVim instead of the usual gvim"
echo "	This is the choice you should do when you haven't a vim 6.x package installed"
echo "	or if you want to create a new Vim 6.0 full installation"
echo "  Note that most Linux distributions and BSDs provides a Vim 6.x package"
echo 
echo "-->Installing KVim over a previous Vim 6.x installation (provided by your distribution"
echo "for example)"
echo "	This is probably what most of you should choose. This installation does the following"
echo "	things:"
echo "		* compiles a full Vim 6.0 package but installs only one binary called kvim and some pixmaps"
echo "		* patch the existing menu.vim from your Vim 6.x package"
echo "		Why do we need to patch this file ? menu.vim defines the menus that are shown in your menu bar"
echo "		and in your toolbar; if we do not patch this file, then some functions will not be activated"
echo "		in your KVim (functions like graphical search/replace, font selection etc..."
echo "		Note: you do need a Vim 6.x package for this to works, if you have a previous Vim version like"
echo "		5.x then you MUST choose the first method or you will have a really broken KVim !"
echo
echo "-->For experts :"
echo "	This script simply uses the configure script found in the vim directory. You can compile Vim"
echo "	by using this configure yourself, then you need at least to add --enable-gui=kde to enable KDE "
echo "	support and --with-qt-dir=your_qt_dir, then you can add your own options"
echo "	This way 'make install' will do all the work, installing a full Vim package, if the configure fails"
echo "	with your specific options then please report it."
echo "	You do not need to patch your menu.vim because the one we provide is already patched"

echo "Now press ENTER to start the configuration of KVim and the compilation. This script needs to be run as root unless you are doing a full install in a user directory"

# Ask for QT and KDE now
echo "*) Checking Qt configuration"

echo "Where is installed your QT (QT prefix) ? [$QTDIR]"
read qt

if [ "$qt" = "" ]; then
	qt=$QTDIR
fi
echo "**) Checking for QT tools in $qt/bin"

if [ -e $qt/bin/moc ]; then
		echo "$qt/bin/moc found, OK"	
else
		echo "moc not found ... it is required, check your QT installation"
		exit 1	
fi

echo "**) Checking for QT libraries in $qt/lib"

if [ -e $qt/lib/libqt-mt.so.3 ]; then
		echo "looks like a QT 3 mt lib, this is ok for KDE 3 :)"
		qt_libs=$qt/lib/
else
	if [ -e $qt/lib/libqt.so.2 ]; then
			echo "found a QT 2 lib, this is ok for KDE 2 :)"
			qt_libs=$qt/lib/
	else
			echo "hmm,I need the directory where I can found your QT libraries :"
			read qt_libs
			if [ -e $qt_libs/libqt-mt.so.3 ]; then
				echo "looks like a QT 3 mt lib, this is ok for KDE 3 :)"
			else
				if [ -e $qt_libs/libqt.so.2 ]; then
					echo "found a QT 2 lib, this is ok for KDE 2 :)"
				else
						echo "Wrong, cannot find a good QT library, check your installation"
						exit 1
				fi

			fi
	fi
fi


echo "**) Checking for QT headers in $qt/include"

if [ -e $qt/include/qstring.h ]; then
		echo "OK, found QT headers"
		qt_includes=$qt/include/
else
			echo "hmm,I need the directory where I can found your QT headers :"
			read qt_includes
			if [ -e $qt_includes/qstring.h ]; then
				echo "OK, found QT headers"
			else
				echo "Wrong, cannot find QT headers, check your installation"
				exit 1
			fi
fi

echo "*) Checking KDE configuration"

echo "Where is installed your KDE (KDE prefix) ? [$KDEDIR]"
read kde

if [ "$kde" = "" ]; then
	kde=$KDEDIR
fi
echo "**) Checking for KDE tools in $kde/bin"
if [ -e $kde/bin/dcopidl ]; then
		echo "$kde/bin/dcopidl found, OK"	
else
		echo "dcopidl not found ... it is required, check your KDE installation"
		exit 1
fi

if [ -e $kde/bin/dcopidl2cpp ]; then
		echo "$kde/bin/dcopidl2cpp found, OK"	
else
		echo "dcopidl2cpp not found ... it is required, check your KDE installation"
		exit 1
fi

echo "**) Checking for KDE libraries in $kde/lib"

if [ -e $kde/lib/libkdeui.so ]; then
		echo "OK, found KDE libraries"
		kde_libraries=$kde/lib/
else
			echo "hmm,I need the directory where I can found your KDE libraries :"
			read kde_libraries
			if [ -e $kde_libraries/libkdeui.so ]; then
				echo "OK, found KDE libs"
			else
				echo "Wrong, cannot find KDE libs, check your installation"
				exit 1
			fi
fi


echo "**) Checking for KDE includes in $kde/include"

if [ -e $kde/include/kapplication.h ]; then
		echo "OK, found KDE headers"
		kde_includes=$kde/include/
else
			echo "hmm,I need the directory where I can found your KDE headers :"
			read kde_includes
			if [ -e $kde_includes/kapplication.h ]; then
				echo "OK, found KDE headers"
			else
				echo "Wrong, cannot find KDE headers, check your installation"
				exit 1
			fi
fi

echo "*) Checking Vim configuration"
echo "Do you have a Vim 6.x package already installed (and to you want me to use this one) ? (y/[n])"
read has_vim

if [ "$has_vim" = "y" ]; then
	FOUND=0	
	while [ $FOUND -lt 1 ]; do
		echo "Give me the path to your current Vim runtime (this is where you have a menu.vim file)"
		echo "On debian, this is /usr/share/vim/vim60/ for example, you can use 'locate menu.vim' to find this directory"
		read vim_path
		if [ -e $vim_path/menu.vim ]; then
				echo "Ok, I found your menu.vim"
				FOUND=1
		else
				echo "Sorry, I cannot found your menu.vim file there"
		fi
	done
else
		echo "Ok, then I'll make a full Vim 6.0 with KVim for you :)"
fi

if [ "$has_vim" = "y" ]; then
	echo "Ok , I will install to $kde"
else
	if [ -e $kde/bin/vim ]; then
			echo "Warning: there is a vim binary in the installation directory"
			echo "The installation method you selected will overwrite this binary"
			echo "Are you sure you want to do this ? (y/[n])"
			read confirm
			if [ ! a"$confirm" = a"y" ]; then
					echo " * Aborting *"
					exit 1;
			fi
	fi		
fi



echo "*) OK, we finished configuring, here is a sum up of your options :"
echo "Make only kvim : $has_vim"
if [ "$has_vim" = "y" ] ; then
		echo "Your vim 6.0 runtime directory : $vim_path"
fi
echo "QT dir : $qt"
echo "QT libraries dir : $qt_libs"
echo "QT headers dir : $qt_includes"
echo "KDE dir : $kde"
echo "KDE libraries dir : $kde_libraries"
echo "KDE includes dir : $kde_includes"
echo "If there is an error, press CTRL+C and start the script again"
echo " "
echo "Press enter to proceed"
read fddddddddddddd

echo "*) Ok, i start the compilation now :)"

if [ "$has_vim" = "y" ] ; then
	cd vim
	make distclean
	./configure --enable-gui=kde --prefix=$kde --with-kde-prefix=$kde --with-kde-includes=$kde_includes --with-kde-libs=$kde_libs --with-qt-dir=$qt --with-qt-includes=$qt_includes --with-qt-libs=$qt_libs
	if [ $? != 0 ]; then
		echo "*) Configuration FAILED ! Please check your settings, if you think it's ok then make a bug report"
		exit 1
	fi	
	make VIMRUNTIMEDIR=$vim_path
	
	if [ $? == 0 ]; then
		echo "*) Compilation successful, ready to install. Press enter to install or CTRL+C to abort"
		read fdssdfsd
		rm $kde/bin/kvim
		cp vim $kde/bin/kvim && chmod 755 $kde/bin/kvim
		cp KVim.desktop $kde/share/applnk/Editors/ && chmod 644 $kde/share/applnk/Editors/KVim.desktop
		cp ../runtime/vim32x32.xpm $kde/share/icons/hicolor/32x32/apps/kvim.xpm && chmod 644 $kde/share/icons/hicolor/32x32/apps/kvim.xpm
		cp ../runtime/vim16x16.xpm $kde/share/icons/hicolor/16x16/apps/kvim.xpm && chmod 644 $kde/share/icons/hicolor/16x16/apps/kvim.xpm
		cp ../runtime/vim48x48.xpm $kde/share/icons/hicolor/48x48/apps/kvim.xpm && chmod 644 $kde/share/icons/hicolor/48x48/apps/kvim.xpm
		mkdir $kde/share/apps/kvim
		cp kde-tips $kde/share/apps/kvim/tips && chmod 644 $kde/share/apps/kvim/tips
	else
		echo "*) Compilation FAILED ! Please check your settings, if you think it's ok then make a bug report"
		exit 1			
	fi
else
	cd vim
	make distclean
	./configure --enable-gui=kde --prefix=$kde --with-kde-prefix=$kde --with-kde-includes=$kde_includes --with-kde-libs=$kde_libs --with-qt-dir=$qt --with-qt-includes=$qt_includes --with-qt-libs=$qt_libs
	make VIMRUNTIMEDIR=$kde/share/vim/vim60/
	
	if [ $? == 0 ]; then
		echo "*) Compilation successful, ready to install. Press enter to install or CTRL+C to abort"
		read fdssdfsd
		make install		
	else
		echo "*) Compilation FAILED ! Please check your settings, if you think it's ok then make a bug report"
		exit 1			
	fi	
fi

echo "*) Installation finished, patching menu.vim now :)"

if [ "$has_vim" = "y" ]; then
	patch=$vim_path
else
	patch=$kde/share/vim/vim60	
fi

cat $patch/menu.vim | sed -e s/\|\|\ has\(\"gui_kde\"\)// | sed -e s/has\(\"gui_gtk\"\)/has\(\"gui_gtk\"\)\ \|\|\ has\(\"gui_kde\"\)/ > /tmp/menu.vim.tmp
mv $patch/menu.vim $patch/menu.old
mv /tmp/menu.vim.tmp $patch/menu.vim

echo "*) Installation completed. Have fun with KVim :)"

	
