/***************************************************************************
                          kbearclipboard.cpp  -  description
                             -------------------
    begin                : Fri Jul 14 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbearclipboard.h"

//-----------------------------------------------
KBearClipBoard::KBearClipBoard()
	: b_isCut( false ), b_isEmpty( true )
{
}
//-----------------------------------------------
KBearClipBoard::~KBearClipBoard(){
}
//-----------------------------------------------
/** clears the clipboard from it's contents */
void KBearClipBoard::clear() {
	b_isEmpty = true;
	QApplication::clipboard()->clear();
}
//-----------------------------------------------
void KBearClipBoard::setContents( const KURL::List& list, QWidget* w ) {
	QMimeSource* myContents = KURLDrag::newDrag( list, w );
	QApplication::clipboard()->setData( myContents );
	b_isEmpty = false;
}
//-----------------------------------------------
KURL::List KBearClipBoard::clipBoardContents() {
	KURL::List urlList;
	KURLDrag::decode( QApplication::clipboard()->data(), urlList );
	return urlList;
}
//-----------------------------------------------
void KBearClipBoard::setCut( bool cut ){
	b_isCut = cut;
}
//-----------------------------------------------
