
/**
 *
 *  This file is part of the kdewebdev package
 *  Copyright (c) 2002 Keith Isdale <keith@kdewebdev.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

/**
  *@author Keith Isdale
  */

#include <klocale.h>

#include <QLayout>
#include <QMessageBox>
#include <QDialog>
#include <QPushButton>
#include <QLabel>
#include <QBoxLayout>
#include "xsldbgmsgdialogimpl.h"


XsldbgMsgDialogImpl::XsldbgMsgDialogImpl(QWidget *parent,
					 QMessageBox::Icon icon,
					 const QString &title, const QString &msg)
  : QDialog(parent)
{
  setupUi(this);
  setWindowTitle(title);

  QMessageBox tmpMsg;
  tmpMsg.setIcon(icon);
  msgTextEdit->setText(msg);
  iconLbl->setPixmap(tmpMsg.iconPixmap());
}

void XsldbgMsgDialogImpl::append(const QString &text)
{
  msgTextEdit->append(text);
}




#include "xsldbgoutputview.h"

XsldbgOutputView::XsldbgOutputView(QWidget * parent)
  : QTextEdit(parent)
{
  new QBoxLayout(QBoxLayout::TopToBottom, this);
  setSizePolicy(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Preferred));
  setMinimumSize(QSize(500, 80));
  setWindowTitle(i18n("xsldbg Output"));
  setText(i18n("\t\txsldbg output capture ready\n\n"));
  dlg = 0L;
  show();
  setReadOnly(true);
}


void XsldbgOutputView::slotProcShowMessage(QString  msg)
{
  bool processed = false;
  // Is this a result of an evaluate command
  if ((msg[0] == QChar('=')) && (msg[1] == QChar(' '))){
    int endPosition = msg.indexOf(QChar('\n'));
    if (endPosition >= 0){
      processed = true;
      showDialog(QMessageBox::Information, i18n("Result of evaluation"),
		 msg.mid(endPosition + 1));
    }
  }else  /* Is there some sort of error message in msg */
    if ((msg.indexOf("Error:") != -1) ||
	(msg.indexOf("Warning:") != -1) ||
	(msg.indexOf("Request to xsldbg failed") != -1) ||
         /* the following errors are libxml or libxslt generated */
	(msg.indexOf("error:") != -1) ||
	(msg.indexOf("xmlXPathEval:") != -1) ||
	(msg.indexOf("runtime error")  != -1)) {
      /* OK we've found an error but ingore any errors about
	 data or source files */
      if ((msg.indexOf("Error: No XSL source file supplied") == -1) &&
	  (msg.indexOf("Error: No XML data file supplied") == -1) &&
	  (msg.indexOf("Load of source deferred") == -1) &&
	  (msg.indexOf("Load of data deferred") == -1) )
	showDialog(QMessageBox::Warning, i18n("Request Failed "),
		 msg);
      processed = true;
  }
  if (processed == false){
    if (isVisible() == false)
      show();
    append(msg);
  }
}


void XsldbgOutputView::slotClearView()
{
}

void XsldbgOutputView::showDialog(QMessageBox::Icon icon, QString title,
				  QString msg)
{

  if ( dlg ){
    // not pretty, add this text to the open dialog when multiple
    // calls to showDialog are made
    dlg->append(msg);
  }else{
      dlg = new XsldbgMsgDialogImpl(this, icon, title, msg);
      if ( dlg ){
	dlg->exec();
	delete dlg;
	dlg = 0L;
      }
  }
}



#include "xsldbgoutputview.moc"
