/***************************************************************************
                          fov.h  -  description
                             -------------------
    begin                : Fri 05 Sept 2003
    copyright            : (C) 2003 by Jason Harris
    email                : kstars@30doradus.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FOV_H_
#define FOV_H_

#include <qstring.h>
#include <klocale.h>

class QPainter;

/**@class FOV A simple class encapulating a Field-of-View symbol
	*@author Jason Harris
	*@version 1.0
	*/
class FOV {
public:
    /**Default constructor*/
    FOV();
    FOV( const QString &name );  //in this case, read params from fov.dat
    FOV( const QString &name, float a, float b=-1, int shape=0, const QString &color="#FFFFFF" );
    ~FOV() {}

    //			enum SHAPE { FOV_SQUARE=0, FOV_CIRCLE=1, FOV_CROSSHAIRS=2, FOV_BULLSEYE=3, FOV_UNKNOWN };

    inline QString name() const { return Name; }
    void setName( const QString &n ) { Name = n; }
    inline int shape() const { return Shape; }
    void setShape( int s ) { Shape = s; }
    inline float sizeX() const { return SizeX; }
    inline float sizeY() const { return SizeY; }
    void setSize( float s ) { SizeX = SizeY = s; }
    void setSize( float sx, float sy ) { SizeX = sx; SizeY = sy; }
    inline QString color() const { return Color; }
    void setColor( const QString &c ) { Color = c; }

    /**@short draw the FOV symbol on a QPainter
    	*@param p reference to the target QPainter.  The painter should already be started.
    	*@param size the size of the target symbol, in pixels.
    	*/
    void draw( QPainter &p, float pixelSizeX, float pixelSizeY=-1 );

private:
    QString Name, Color;
    float SizeX, SizeY;
    int Shape;
};

#endif
