/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2003-2008                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

// own header
#include "umlroleproperties.h"

// qt includes
//#include <QtGui/QRadioButton>
//#include <q3textedit.h>
//#include <qlineedit.h>

// kde includes
#include <klocale.h>
#include <kmessagebox.h>
#include <kdebug.h>


UMLRoleProperties::UMLRoleProperties ( QWidget *parent, UMLRole *role)
        : UMLRolePropertiesBase (parent)
{
    m_pRole = role;
    constructWidget();
}

UMLRoleProperties::~UMLRoleProperties()
{
}

void UMLRoleProperties::constructWidget()
{
    // Use Parent Role to set starting Properties

    // Rolename
    ui_pRoleLE->setText(m_pRole->getName());

    // Multiplicity
    ui_pMultiLE->setText(m_pRole->getMultiplicity());

    // Visibility
    Uml::Visibility scope = m_pRole->getVisibility();
    if ( scope == Uml::Visibility::Public )
        ui_pPublicRB -> setChecked( true );
    else if ( scope == Uml::Visibility::Private )
        ui_pPrivateRB -> setChecked( true );
    else if ( scope == Uml::Visibility::Protected )
        ui_pProtectedRB -> setChecked( true );
    else if ( scope == Uml::Visibility::Implementation )
        ui_pImplementationRB -> setChecked( true );

    // Changeability
    Uml::Changeability_Type changeability = m_pRole->getChangeability();
    if ( changeability == Uml::chg_Changeable )
        ui_pChangeableRB -> setChecked( true );
    else if ( changeability == Uml::chg_Frozen )
        ui_pFrozenRB -> setChecked( true );
    else
        ui_pAddOnlyRB -> setChecked( true );

    // Documentation
    ui_pDocTE-> setText(m_pRole-> getDoc());
    //ui_pDocTE->setWordWrap(QMultiLineEdit::WidgetWidth);
}

void UMLRoleProperties::updateObject()
{
    if (m_pRole) {

        // block signals to save work load. we only need to emit modified once,
        // not each time we update an attribute of the association. I suppose
        // we could check to see IF anything changed, but thats a lot more code,
        // and not much gained. This way is easier, if less 'beautiful'. -b.t.

        m_pRole->blockSignals(true);

        // set props
        m_pRole->setName(ui_pRoleLE->text());
        m_pRole->setMultiplicity(ui_pMultiLE->text());

        if (ui_pPrivateRB->isChecked())
            m_pRole->setVisibility(Uml::Visibility::Private);
        else if (ui_pProtectedRB->isChecked())
            m_pRole->setVisibility(Uml::Visibility::Protected);
        else if (ui_pPublicRB->isChecked())
            m_pRole->setVisibility(Uml::Visibility::Public);
        else if (ui_pImplementationRB->isChecked())
            m_pRole->setVisibility(Uml::Visibility::Implementation);

        if (ui_pFrozenRB->isChecked())
            m_pRole->setChangeability(Uml::chg_Frozen);
        else if (ui_pAddOnlyRB->isChecked())
            m_pRole->setChangeability(Uml::chg_AddOnly);
        else
            m_pRole->setChangeability(Uml::chg_Changeable);

        m_pRole->setDoc(ui_pDocTE->text());

        m_pRole->blockSignals(false);

        m_pRole->emitModified();

    } //end if m_pRole
}


#include "umlroleproperties.moc"
