/***************************************************************************
                            KProtocolInfo.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Information about I/O (Internet, etc.) protocols supported by KDE.

 This class is useful if you want to know which protocols
 KDE supports. In addition you can find out lots of information
 about a certain protocol. KProtocolInfo scans the .protocol
 files of all installed kioslaves to get this information.

 @author Torben Weis <weis@kde.org>
 
 @short 
 Information about I/O (Internet, etc.
*/
public class KProtocolInfo extends KSycocaEntry  {
	protected KProtocolInfo(Class dummy){super((Class) null);}


/** 
 Read a protocol description file
   
*/
	private native void newKProtocolInfo( String path);
	public KProtocolInfo( String path) {
		super((Class) null);
		newKProtocolInfo( path);
	}

/** 

   
*/
	private native void newKProtocolInfo( QDataStream _str, int offset);
	public KProtocolInfo( QDataStream _str, int offset) {
		super((Class) null);
		newKProtocolInfo( _str, offset);
	}
	protected native void finalize() throws InternalError;
	public native String name();
	public native boolean isValid();

/** 

 Load the protocol info from a stream.
   
*/
	public native void load( QDataStream arg1);

/** 

 Save the protocol info to a stream.
   
*/
	public native void save( QDataStream arg1);

/** 

*/
	public static native String exec( String protocol);
	public static native int inputType( KURL url);
	public static native int outputType( KURL url);

/** 

*/
	public static native ArrayList listing( KURL url);
	public static native boolean isSourceProtocol( KURL url);
	public static native boolean isHelperProtocol( KURL url);
	public static native boolean isFilterProtocol( KURL url);
	public static native boolean isKnownProtocol( KURL url);
	public static native boolean supportsListing( KURL url);
	public static native boolean supportsReading( KURL url);
	public static native boolean supportsWriting( KURL url);
	public static native boolean supportsMakeDir( KURL url);
	public static native boolean supportsDeleting( KURL url);
	public static native boolean supportsLinking( KURL url);
	public static native boolean supportsMoving( KURL url);
	public static native boolean canCopyFromFile( KURL url);
	public static native boolean canCopyToFile( KURL url);

/** 

*/
	public static native String defaultMimetype( KURL url);
	public static native int inputType( String protocol);
	public static native int outputType( String protocol);

/** 

*/
	public static native ArrayList listing( String protocol);
	public static native boolean isSourceProtocol( String protocol);
	public static native boolean isHelperProtocol( String protocol);
	public static native boolean isFilterProtocol( String protocol);
	public static native boolean isKnownProtocol( String protocol);
	public static native boolean supportsListing( String protocol);
	public static native boolean supportsReading( String protocol);
	public static native boolean supportsWriting( String protocol);
	public static native boolean supportsMakeDir( String protocol);
	public static native boolean supportsDeleting( String protocol);
	public static native boolean supportsLinking( String protocol);
	public static native boolean supportsMoving( String protocol);
	public static native boolean canCopyFromFile( String protocol);
	public static native boolean canCopyToFile( String protocol);
	public static native String defaultMimetype( String protocol);

/** 

*/
	public static native String icon( String protocol);

/** 

*/
	public static native String config( String protocol);
	public static native boolean determineMimetypeFromExtension( String protocol);

/** 

*/
	public static native ArrayList protocols();
	public static final int T_STREAM = 0;
	public static final int T_FILESYSTEM = 1;
	public static final int T_NONE = 2;
	public static final int T_ERROR = 3;
}
