/***************************************************************************
                            KMimeMagic.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Determine auto-magically the type of file,
 not only by using its extension, but also by reading its contents.

 Unless specified otherwise, {@link KMimeMagic} uses
 $KDEDIR/share/mimelnk/magic for this purpose.

 To make KMimeMagic restore the 'atime' of a file after it opened it,
 add its directory in kmimemagicrc like:
 [Settings]
 atimeDirs=/tmp,/var/tmp,/home/dfaure/tmp
 This isn't done by default because it changes the 'ctime'.
 See kmimemagic.cpp for a full discussion on this issue.

 The basic usage of {@link KMimeMagic} is :

 The result is contained in the class {@link KMimeMagicResult}.
 
 @short 
 Determine auto-magically the type of file,
 not only by using its extension, but also by reading its contents.
*/
public class  KMimeMagic implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KMimeMagic(Class dummy){}


/** 
 Create a parser and initialize it with the given config file.
   
*/
	private native void newKMimeMagic( String configFile);
	public KMimeMagic( String configFile) {
		newKMimeMagic( configFile);
	}

/** 
 Destroy the parser.
   
*/
	protected native void finalize() throws InternalError;

/** 
 Merge an existing parse table with the data from the
 given file.

*/
	public native boolean mergeConfig( String configFile);

/** 
 Merge an existing parse table with the data from the
 given buffer.

*/
	public native boolean mergeBufConfig( String arg1);

/** 
 Enable/Disable follow-links.

 (Default is disabled.)
   
*/
	public native void setFollowLinks( boolean _enable);

/** 
 Try to find a MimeType for the given file.

 If no special
 MimeType is found, the default MimeType is returned.
 This function looks at the content of the file.

*/
	public native KMimeMagicResult findFileType( String _filename);

/** 
 Same functionality as above, except data is not
 read from a file.

 Instead a buffer can be supplied which
 is examined. The integer parameter supplies the length of
 the buffer.

*/
	public native KMimeMagicResult findBufferType( byte[] p);

/** 
 Same functionality as {@link #findBufferType} but with
 additional capability of distinguishing between
 C-headers and C-Source.

 For this purpose this function looks
 at the extension of the filename. This means that 'filename'
 can be a filename on some FTP server, too.

*/
	public native KMimeMagicResult findBufferFileType( byte[] arg1, String filename);

/** 
 Returns a pointer to the unique {@link KMimeMagic} instance in this process.
   
*/
	public static native KMimeMagic self();
	protected static native void initStatic();
}
