/***************************************************************************
                            KApplication.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Controls and provides information to all KDE applications.

 Only one object of this class can be instantiated in a single app.
 This instance is always accessible via the {@link #kApplication} method.

 This class provides the following services to all KDE applications.

 See {@link KApplicationSignals} for signals emitted by KApplication.

 See {@link KApplicationEventHandling} for event handlers to override in subclasses of KApplication.

 @author Matthias Kalle Dalheimer <kalle@kde.org>

 @version $Id: KApplication.java,v 1.4.2.1 2001/08/29 23:14:09 rdale Exp $

 @short Controls and provides information to all KDE applications.

*/
public class KApplication extends QApplication implements  KInstanceInterface {
	protected KApplication(Class dummy){super((Class) null);}


/** 
 This constructor takes aboutData and command line
  arguments from {@link KCmdLineArgs}.

*/
	private native void newKApplication( boolean allowStyles, boolean GUIenabled);
	public KApplication( boolean allowStyles, boolean GUIenabled) {
		super((Class) null);
		newKApplication( allowStyles, GUIenabled);
	}
	private native void newKApplication();
	public KApplication() {
		super((Class) null);
		newKApplication();
	}

/** 
 Constructor. Parses command-line arguments. Use this constructor to use KApplication
 in a Motif or Xt program.

*/
//	private native void newKApplication( Display* display, int argc, String argv, String rAppName, boolean allowStyles, boolean GUIenabled);
//	public KApplication( Display* display, int argc, String argv, String rAppName, boolean allowStyles, boolean GUIenabled) {
//		super((Class) null);
//		newKApplication( display, argc, argv, rAppName, allowStyles, GUIenabled);
//	}
//	private native void newKApplication( Display* display, int argc, String argv, String rAppName);
//	public KApplication( Display* display, int argc, String argv, String rAppName) {
//		super((Class) null);
//		newKApplication( display, argc, argv, rAppName);
//	}

/** 

 Constructor. Parses command-line arguments.

*/
	private native void newKApplication( String[] args, String rAppName, boolean allowStyles, boolean GUIenabled);
	public KApplication( String[] args, String rAppName, boolean allowStyles, boolean GUIenabled) {
		super((Class) null);
		newKApplication( args, rAppName, allowStyles, GUIenabled);
	}
	public KApplication( String[] args, String rAppName, boolean allowStyles) {
		this( args, rAppName, allowStyles, true);
	}
	private native void newKApplication( String[] args, String rAppName);
	public KApplication( String[] args, String rAppName) {
		super((Class) null);
		newKApplication( args, rAppName);
	}
	protected native void finalize() throws InternalError;

/** 
 Retrieve the application session config object.

*/
	public native KConfig sessionConfig();

/** 
 Is the application restored from the session manager?

*/
	public native boolean isRestored();

/** 
 Disable session management for this application.

 Useful in case  your application is started by the
 initial "startkde" script.
   
*/
	public native void disableSessionManagement();

/** 
 Asks the session manager to shut the session down.

 Returns TRUE on sucess, FALSE if the session manager could not be
 contacted.
   
*/
	public native boolean requestShutDown();
	public native boolean requestShutDown( boolean bFast);

/** 
 Propagates the network address of the session manager in the
 SESSION_MANAGER environment variable so that child processes can
 pick it up.

 If SESSION_MANAGER isn't defined yet, the address is searched in
 $HOME/.KSMserver.

 This function is called by clients that are started outside the
 session ( i.e. before ksmserver is started), but want to launch
 other processes that should participate in the session.  Examples
 are kdesktop or kicker.
   
*/
	public native void propagateSessionManager();
	public native void commitData( QSessionManager sm);
	public native void saveState( QSessionManager sm);

/** 
 Retrieve a pointer to a {@link DCOPClient} for the application.
   
*/
	public native DCOPClient dcopClient();

/** 
 Get the application icon.

*/
	public native QPixmap icon();

/** 
 Get the mini-icon for the application.

*/
	public native QPixmap miniIcon();

/** 
   Set the top widget of the application.

  This means basically applying the right window caption and
  icon. An application may have several top widgets. You don't
  need to call this function manually when using {@link KMainWindow}.

*/
	public native void setTopWidget( QWidget topWidget);

/** 
 Invoke the KHelpCenter HTML help viewer from docbook sources.

*/
	public native void invokeHelp( String anchor, String appname);
	public native void invokeHelp();

/** 

 Invoke the khelpcenter HTML help viewer from HTML sources.
 Please use invokeHelp() instead.

*/
	public native void invokeHTMLHelp( String aFilename, String aTopic);
	public native void invokeHTMLHelp( String aFilename);

/** 
 Convenience method; invokes the standard email application.

*/
	public native void invokeMailer( String address, String subject);

/** 
 Invokes the standard email application.

*/
	public native void invokeMailer( KURL mailtoURL);

/** 
 Invoke the standard browser.

*/
	public native void invokeBrowser( String url);

/** 
 Retrieve the current KDE style object if a plugin is in use,
  or else NULL if a Qt internal style is being used.

   
*/
	public native KStyle kstyle();

/** 

   
*/
	public native boolean kdeFonts( String[] arg1);

/** 
 Return a text for the window caption.

 This may be set by
 "-caption", otherwise it will be equivalent to the name of the
 executable.
   
*/
	public native String caption();

/** 
 Build a caption that contains the application name along with the
 {@link #userCaption} using a standard layout.

 To make a compliant caption
 for your window, simply do: <code>setCaption</code>(kapp.makeStdCaption(yourCaption));

*/
	public native String makeStdCaption( String userCaption, boolean withAppName, boolean modified);

/** 
 Get a file name in order to make a temporary copy of your document.

*/
	public native String tempSaveName( String pFilename);

/** 
 Check whether  an auto-save file exists for the document you want to
 open.

*/
	public native String checkRecoverFile( String pFilename, boolean bRecover);

/** 
 Get the X11 display
   
*/
//	public native Display* getDisplay();

/** 
 Enable style plugins.

 This is useful only to applications that normally
 do not display a GUI and create the {@link KApplication} with
  <code>allowStyles</code> set to <code>false.</code>
   
*/
	public native void enableStyles();

/** 
 Disable style plugins.

 Current style plugins do not get unloaded.

 This is only usefull when used in combination with {@link enableStyles}.
   
*/
	public native void disableStyles();

/** 
  Install widget filter as global X11 event filter.

 The widget
  filter receives XEvents in its standard {@link QWidget#x11Event} function.

  Warning: Only do this when absolutely necessary. An installed X11 filter
  can slow things down.

*/
	public native void installX11EventFilter( QWidget filter);

/** 
 Add a message type to the KIPC event mask. You can only add "system
 messages" to the event mask. These are the messages with id < 32.
 Messages with id >= 32 are user messages.

*/
	public native void addKipcEventMask( int identifier);

/** 
 Remove a message type from the KIPC event mask. This message will not
 be handled anymore.

*/
	public native void removeKipcEventMask( int identifier);

/** 
 Returns the app startup notification identifier for this running application.
   
*/
	public native String startupId();

/** 
 Sets a new value for the application startup notification window property for newly
 created toplevel windows.
   
*/
	public native void setStartupId( String startup_id);

/** 

   
*/
	public native boolean notify( QObject receiver, QEvent event);

/** 

    
*/
	public native int xioErrhandler();

/** 

   
*/
//	public native void iceIOErrorHandler( _IceConn conn);

/** 
 Tell KApplication about one more operation that should be finished
 before the application exits. The standard behaviour is to exit on the
 "last window closed" event, but some events should outlive the last window closed
 (e.g. a file copy for a file manager, or 'compacting folders on exit' for a mail client).
   
*/
	public native void ref();

/** 
 Tell KApplication that one operation such as those described in {@link ref} just finished.
 The application exits if the counter is back to 0.
   
*/
	public native void deref();

/** 
 Returns the argument to --geometry if any, so the geometry can be set
 wherever necessary
    
*/
	public native String geometryArgument();

/** 
 Add Qt and KDE command line options to KCmdLineArgs.
    
*/
	public static native void addCmdLineOptions();

/** 
 Retrieve the current application object.

 This is similar to the global {@link QApplication} pointer {@link qApp}. It
 allows access to the single global {@link KApplication} object, since
 more than one cannot be created in the same application. It
 saves you the trouble of having to pass the pointer explicitly
 to every function that may require it.
   
*/
	public static native KApplication kApplication();

/** 
 Get the DCOP name of the service launcher. This will be something like
 klaucher_$host_$uid.

*/
	public static native String launcher();

/** 
 Starts a service based on the (translated) name of the service.
 E.g. "Web Browser"

*/
	public static native int startServiceByName( String _name, String URL, String error, String dcopService, int[] pid, String startup_id);
	public static native int startServiceByName( String _name, String[] URLs, String error, String dcopService, int[] pid, String startup_id);
	public static native int startServiceByName( String _name, String URL, String error, String dcopService, int[] pid);
	public static native int startServiceByName( String _name, String URL);
	public static native int startServiceByName( String _name, String[] URLs, String error, String dcopService, int[] pid);
	public static native int startServiceByName( String _name);

/** 
 Starts a service based on the desktop path of the service.
 E.g. "Applications/konqueror.desktop" or "/home/user/bla/myfile.desktop"

*/
	public static native int startServiceByDesktopPath( String _name, String URL, String error, String dcopService, int[] pid, String startup_id);
	public static native int startServiceByDesktopPath( String _name, String[] URLs, String error, String dcopService, int[] pid, String startup_id);
	public static native int startServiceByDesktopPath( String _name, String URL, String error, String dcopService, int[] pid);
	public static native int startServiceByDesktopPath( String _name, String URL);
	public static native int startServiceByDesktopPath( String _name, String[] URLs, String error, String dcopService, int[] pid);
	public static native int startServiceByDesktopPath( String _name);

/** 
 Starts a service based on the desktop name of the service.
 E.g. "konqueror"

*/
	public static native int startServiceByDesktopName( String _name, String URL, String error, String dcopService, int[] pid, String startup_id);
	public static native int startServiceByDesktopName( String _name, String[] URLs, String error, String dcopService, int[] pid, String startup_id);
	public static native int startServiceByDesktopName( String _name, String URL, String error, String dcopService, int[] pid);
	public static native int startServiceByDesktopName( String _name, String URL);
	public static native int startServiceByDesktopName( String _name, String[] URLs, String error, String dcopService, int[] pid);
	public static native int startServiceByDesktopName( String _name);

/** 
 Start a program via kdeinit.
 There will be no application startup notification, so you should
 use it only for starting internal processes. 

 program name and arguments are converted to according to the
 local encoding and passed as is to kdeinit.

*/
	public static native int kdeinitExec( String name, String[] args, String error, int[] pid);
	public static native int kdeinitExec( String name);

/** 
 Start a program via kdeinit and wait for it to finish.

 Like kdeinitExec but it waits till the program is finished.
 As such it behaves similair to the system(...) function.
   
*/
	public static native int kdeinitExecWait( String name, String[] args, String error, int[] pid);
	public static native int kdeinitExecWait( String name);

/** 
 Generate a uniform random number.

*/
	public static native int random();

/** 
 Generate a random string.  It operates in the range [A-Za-z0-9]

*/
	public static native String randomString( int length);

/** 
 Return a desktop widget that overrides the one in QT.  This is to
 provide Xinerama support.
   
*/
//	public static native KDesktopWidget* desktop();

/** 

   
*/
	public static native void startKdeinit();

/** 
 Used to catch X11 events
   
*/
//	protected native boolean x11EventFilter( XEvent* arg1);
	public static final int CaptionAppLast = 1;
	public static final int CaptionAppFirst = 0;
	public static final int CaptionNoApp = 1;
	public static final int SETTINGS_MOUSE = 0;
	public static final int SETTINGS_COMPLETION = 1;
	public static final int SETTINGS_PATHS = 2;
	public static final int SETTINGS_POPUPMENU = 3;
	public static final int SETTINGS_QT = 4;

        // From KInstanceInterface
        
        /**
          Retrieve the application standard dirs object.

        */
                public native KStandardDirs dirs();

        /**
          Retrieve the general config object.

        */
                public native KConfig config();

        /**
          Retrieve an iconloader object.

        */
                public native KIconLoader iconLoader();

        /**
         Re-allocate the global iconloader.

        */
                public native void newIconLoader();
                public native KCharsets charsets();

        /**

        */
                public native KAboutData aboutData();

        /**

        */
                public native String instanceName();

				public static native void setJavaSlotFactory();
}
