#ifndef LOGGING_H
#define LOGGING_H

#include "ftpaccess.h"
#include "InputCtl.h"
#include <qwidget.h>
#include <qcheckbox.h>
#include <kapp.h>
#include <qlistbox.h>
#include <qpushbutton.h>

class Logging : public QWidget {
	Q_OBJECT
public:
	Logging(QWidget *parent=0, const char *name=0);
	~Logging();
public slots:
	void	ftpaccessLoaded(ftpaccess *xs);
	void	update();
	void	mailAdminPressed();
	void	addRecipientPressed();
	void	rmRecipientPressed();
	void	RCPTAdded(QString rcpt);
private:
	void	redraw();
	ftpaccess *	ftpxs;
	QCheckBox *	logCommandsAnon;
	QCheckBox *	logCommandsGuest;
	QCheckBox *	logCommandsReal;
	QCheckBox *	logTransfersAnonIn;
	QCheckBox *	logTransfersAnonOut;
	QCheckBox *	logTransfersGuestIn;
	QCheckBox *	logTransfersGuestOut;
	QCheckBox *	logTransfersRealIn;
	QCheckBox *	logTransfersRealOut;
	QCheckBox *	logSecurityAnon;
	QCheckBox *	logSecurityGuest;
	QCheckBox *	logSecurityReal;
	QCheckBox *	logSyslog;
	QCheckBox *	mailAdmin;
	InputCtl *	mailFrom;
	InputCtl *	mailServer;
	QListBox *	mailRecipients;
	QPushButton *	addRecipient;
	QPushButton *	rmRecipient;
};

#endif
