/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.services;

import com.google.common.collect.Interner;
import javax.annotation.Nullable;
import org.gradle.StartParameter;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.caching.BuildCacheService;
import org.gradle.caching.configuration.BuildCache;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.DefaultBuildCacheController;
import org.gradle.caching.internal.controller.service.BuildCacheServicesConfiguration;
import org.gradle.caching.internal.origin.OriginMetadataFactory;
import org.gradle.caching.internal.packaging.BuildCacheEntryPacker;
import org.gradle.caching.internal.services.AbstractBuildCacheControllerFactory;
import org.gradle.caching.local.DirectoryBuildCache;
import org.gradle.caching.local.internal.DirectoryBuildCacheService;
import org.gradle.caching.local.internal.LocalBuildCacheService;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.util.Path;

public class DefaultBuildCacheControllerFactory
extends AbstractBuildCacheControllerFactory<DirectoryBuildCacheService> {
    private final TemporaryFileProvider temporaryFileProvider;
    private final BuildCacheEntryPacker packer;
    private final BuildOperationProgressEventEmitter buildOperationProgressEmitter;

    public DefaultBuildCacheControllerFactory(StartParameter startParameter, BuildOperationExecutor buildOperationExecutor, BuildOperationProgressEventEmitter buildOperationProgressEmitter, OriginMetadataFactory originMetadataFactory, StringInterner stringInterner, TemporaryFileProvider temporaryFileProvider, BuildCacheEntryPacker packer) {
        super(startParameter, buildOperationExecutor, originMetadataFactory, stringInterner);
        this.temporaryFileProvider = temporaryFileProvider;
        this.packer = packer;
        this.buildOperationProgressEmitter = buildOperationProgressEmitter;
    }

    @Override
    protected BuildCacheController doCreateController(Path buildPath, @Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<DirectoryBuildCache, DirectoryBuildCacheService> localDescribedService, @Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<BuildCache, BuildCacheService> remoteDescribedService) {
        BuildCacheServicesConfiguration config = DefaultBuildCacheControllerFactory.toConfiguration(buildPath, localDescribedService, remoteDescribedService);
        boolean logStackTraces = this.startParameter.getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS;
        return new DefaultBuildCacheController(config, (BuildOperationRunner)this.buildOperationExecutor, this.buildOperationProgressEmitter, (x$0, x$1) -> this.temporaryFileProvider.createTemporaryFile(x$0, x$1, new String[0]), logStackTraces, !Boolean.getBoolean("org.gradle.unsafe.build-cache.remote-continue-on-error"), this.packer, this.originMetadataFactory, (Interner)this.stringInterner);
    }

    private static BuildCacheServicesConfiguration toConfiguration(Path buildPath, @Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<DirectoryBuildCache, DirectoryBuildCacheService> local, @Nullable AbstractBuildCacheControllerFactory.DescribedBuildCacheService<BuildCache, BuildCacheService> remote) {
        boolean localPush = local != null && ((DirectoryBuildCache)local.config).isPush();
        boolean remotePush = remote != null && ((BuildCache)remote.config).isPush();
        return new BuildCacheServicesConfiguration(buildPath.getPath(), local != null ? (LocalBuildCacheService)local.service : null, localPush, remote != null ? (BuildCacheService)remote.service : null, remotePush);
    }
}

