/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.kotlin.dsl.concurrent;

import java.io.Closeable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.kotlin.dsl.concurrent.AsyncIOScopeFactory;
import org.gradle.kotlin.dsl.concurrent.AsyncIOScopeSettings;
import org.gradle.kotlin.dsl.concurrent.DefaultAsyncIOScopeFactory;
import org.gradle.kotlin.dsl.concurrent.IOScope;
import org.gradle.kotlin.dsl.concurrent.JavaSystemPropertiesAsyncIOScopeSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gradle/kotlin/dsl/concurrent/DefaultAsyncIOScopeFactory;", "Ljava/io/Closeable;", "Lorg/gradle/kotlin/dsl/concurrent/AsyncIOScopeFactory;", "settings", "Lorg/gradle/kotlin/dsl/concurrent/AsyncIOScopeSettings;", "executorServiceProvider", "Lkotlin/Function0;", "Ljava/util/concurrent/ExecutorService;", "(Lorg/gradle/kotlin/dsl/concurrent/AsyncIOScopeSettings;Lkotlin/jvm/functions/Function0;)V", "executorService", "Lkotlin/Lazy;", "close", "", "newScope", "Lorg/gradle/kotlin/dsl/concurrent/IOScope;", "kotlin-dsl"})
public final class DefaultAsyncIOScopeFactory
implements Closeable,
AsyncIOScopeFactory {
    @NotNull
    private final AsyncIOScopeSettings settings;
    @NotNull
    private final Lazy<ExecutorService> executorService;

    public DefaultAsyncIOScopeFactory(@NotNull AsyncIOScopeSettings settings, @NotNull Function0<? extends ExecutorService> executorServiceProvider) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(executorServiceProvider, (String)"executorServiceProvider");
        this.settings = settings;
        this.executorService = LazyKt.lazy(executorServiceProvider);
    }

    public /* synthetic */ DefaultAsyncIOScopeFactory(AsyncIOScopeSettings asyncIOScopeSettings, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            asyncIOScopeSettings = new JavaSystemPropertiesAsyncIOScopeSettings();
        }
        this(asyncIOScopeSettings, (Function0<? extends ExecutorService>)function0);
    }

    @Override
    @NotNull
    public IOScope newScope() {
        return new IOScope(this){
            @NotNull
            private final AtomicReference<Throwable> failure;
            @Nullable
            private Future<?> pending;
            final /* synthetic */ DefaultAsyncIOScopeFactory this$0;
            {
                this.this$0 = $receiver;
                this.failure = new AtomicReference<Object>(null);
            }

            public void io(@NotNull Function0<Unit> action) {
                Intrinsics.checkNotNullParameter(action, (String)"action");
                this.checkForFailure();
                this.pending = this.submit(action);
            }

            public void close() {
                Future<?> future = this.pending;
                if (future != null) {
                    future.get(DefaultAsyncIOScopeFactory.access$getSettings$p(this.this$0).getIoActionTimeoutMs(), TimeUnit.MILLISECONDS);
                }
                this.checkForFailure();
            }

            private final Future<?> submit(Function0<Unit> action) {
                Future<?> future = ((ExecutorService)DefaultAsyncIOScopeFactory.access$getExecutorService$p(this.this$0).getValue()).submit(new Runnable(action, this){
                    final /* synthetic */ Function0<Unit> $action;
                    final /* synthetic */ newScope.1 this$0;
                    {
                        this.$action = $action;
                        this.this$0 = $receiver;
                    }

                    public final void run() {
                        try {
                            this.$action.invoke();
                        }
                        catch (Throwable error) {
                            newScope.1.access$getFailure$p(this.this$0).set(error);
                        }
                    }
                });
                Intrinsics.checkNotNullExpressionValue(future, (String)"private\n        fun subm\u2026          }\n            }");
                return future;
            }

            private final void checkForFailure() {
                Throwable throwable = this.failure.getAndSet(null);
                if (throwable != null) {
                    Throwable it = throwable;
                    boolean bl = false;
                    throw it;
                }
            }

            public static final /* synthetic */ AtomicReference access$getFailure$p(newScope.1 $this) {
                return $this.failure;
            }
        };
    }

    @Override
    public void close() {
        Lazy<ExecutorService> lazy;
        Lazy<ExecutorService> $this$close_u24lambda_u240 = lazy = this.executorService;
        boolean bl = false;
        if ($this$close_u24lambda_u240.isInitialized()) {
            ((ExecutorService)$this$close_u24lambda_u240.getValue()).shutdown();
        }
    }

    public static final /* synthetic */ AsyncIOScopeSettings access$getSettings$p(DefaultAsyncIOScopeFactory $this) {
        return $this.settings;
    }

    public static final /* synthetic */ Lazy access$getExecutorService$p(DefaultAsyncIOScopeFactory $this) {
        return $this.executorService;
    }
}

