/* Copyright (C) 2023 Alif Semiconductor - All Rights Reserved.
 * Use, distribution and modification of this code is permitted under the
 * terms stated in the Alif Semiconductor Software License Agreement
 *
 * You should have received a copy of the Alif Semiconductor Software
 * License Agreement with this file. If not, please write to:
 * contact@alifsemi.com, or visit: https://alifsemi.com/license
 *
 */

/******************************************************************************
 * @file     conductor_board_config.c
 * @author   Silesh C V
 * @email    silesh@alifsemi.com
 * @version  V1.0.0
 * @date     21-Aug-2023
 * @brief    Conductor (https://conductor.alifsemi.com/) board configuration library.
 ******************************************************************************/
#include "conductor_board_config.h"
/* include "pins.h" generated by the conductor */
#include "pins.h"
#include <stdint.h>
#include <stddef.h>

/**
  \fn          int32_t conductor_pins_config(void)
  \brief       Initialize board pins as per the information generated by the conductor tool.
  \return      0 on success, -1 on failure
*/
int32_t conductor_pins_config(void)
{
    int32_t ret;
    size_t i;
    size_t num_pins = sizeof(board_pinconf) / sizeof(board_pinconf[0]);

    for (i = 0; i < num_pins; i++)
    {
        ret = pinconf_set(board_pinconf[i].port,
                          board_pinconf[i].pin,
                          board_pinconf[i].alternate_function,
                          board_pinconf[i].pad_control);

        if (ret != 0)
        {
            return -1;
        }
    }

    return 0;
}

