/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __MAINBOARD_GOOGLE_SKYWALKER_GPIO_H__
#define __MAINBOARD_GOOGLE_SKYWALKER_GPIO_H__

#include <soc/gpio.h>

#define GPIO_XHCI_INIT_DONE		GPIO(GBE_MDC)
#define GPIO_USB3_HUB_RST_L		GPIO(GPIO07)
#define GPIO_EC_AP_INT_ODL		GPIO(GBE_MDIO)
#define GPIO_AP_EC_WARM_RST_REQ		GPIO(GBE_AUX_PPS0)
#define GPIO_GSC_AP_INT_ODL		GPIO(GBE_AUX_PPS1)
#define GPIO_AP_SUSPEND_L		GPIO(CONN_TOP_DATA)
#define GPIO_FP_RST_1V8_S3_L		GPIO(GBE_RXER)
#define GPIO_AP_FP_FW_UP_STRAP		GPIO(GBE_TXER)
#define GPIO_EN_PWR_FP			GPIO(GPIO12)
#define GPIO_HP_INT_ODL			GPIO(GPIO04)
#define GPIO_SPKR_INT_ODL		GPIO(GPIO08)
#define GPIO_SAR_INT_ODL		GPIO(GPIO09)
#define GPIO_PEN_EJECT_OD		GPIO(GPIO11)
#define GPIO_TCHSCR_INT_1V8_ODL		GPIO(GPIO15)
#define GPIO_AP_WP_ODL			GPIO(GPIO16)
#define GPIO_EC_AP_DPOC_EN_ODL		GPIO(GPIO17)
#define GPIO_TCHPAD_INT_ODL		GPIO(GBE_RXD1)
#define GPIO_HDMI_AP_INT_ODL		GPIO(GBE_RXC)
#define GPIO_FP_AP_INT_1V8_S3_ODL	GPIO(GBE_RXDV)
#define GPIO_SD_CD_ODL			GPIO(GBE_INTR)
#define GPIO_HDMI_HPD_1V8_ODL		GPIO(CONN_TOP_CLK)
#define GPIO_AP_HDMI_RST_ODL		GPIO(GBE_TXC)
#define GPIO_EN_SPKR			GPIO(GPIO05)
#define GPIO_I2SOUT1_BCK		GPIO(DMIC0_DAT0)
#define GPIO_I2SOUT1_LRCK		GPIO(DMIC1_CLK)
#define GPIO_I2SOUT1_DOUT		GPIO(DMIC1_DAT0)
#define GPIO_I2SOUT0_MCK		GPIO(I2SOUT0_MCK)
#define GPIO_I2SOUT0_BCK		GPIO(I2SOUT0_BCK)
#define GPIO_I2SOUT0_LRCK		GPIO(I2SOUT0_LRCK)
#define GPIO_I2SOUT0_DOUT		GPIO(I2SOUT0_DO)
#define GPIO_BL_PWM_1V8			GPIO(DISP_PWM0)
#define GPIO_AP_EDP_BKLTEN		GPIO(GPIO13)
#define GPIO_EN_PP3300_EDP_X		GPIO(DSI_LCM_RST)
#define GPIO_EDP_HPD_1V8		GPIO(EDP_TX_HPD)

void setup_chromeos_gpios(void);

#endif
