/* SPDX-License-Identifier: BSD-3-Clause */
/*
 * Copyright (c) 2025, Rockchip Electronics Co., Ltd.
 */

#ifndef __PLAT_DEF_H__
#define __PLAT_DEF_H__

#define SIZE_K(n)		((n) * 1024)
#define SIZE_M(n)		((n) * 1024 * 1024)

#define WITH_16BITS_WMSK(bits)	(0xffff0000 | (bits))
#define BITS_WMSK(msk, shift)	((msk) << ((shift) + REG_MSK_SHIFT))

/* Special value used to verify platform parameters from BL2 to BL3-1 */
#define RK_BL31_PLAT_PARAM_VAL	0x0f1e2d3c4b5a6978ULL

#define RK3576_DEV_RNG0_BASE	0x00000000
#define RK3576_DEV_RNG0_SIZE	0x40000000

#define RK_DRAM_BASE		0x40000000

/* All slave base address declare below */
#define MCU_TCM_BASE		0x23800000
#define MCU_CACHE_BASE		0x23810000
#define MCU_RAM_TEST_BASE	0x23820000
#define MCU_BOOT_BASE		0x00000000
#define MCU_MAIN_BASE		0x00010000
#define PMU0SGRF_BASE		0x26000000
#define PMU1SGRF_BASE		0x26002000
#define PMU1SGRF_FW_BASE	0x26003000
#define SYS_SGRF_BASE		0x26004000
#define SYS_SGRF_FW_BASE	0x26005000
#define SYS_GRF_BASE		0x2600a000
#define BIGCORE_GRF_BASE	0x2600c000
#define LITCORE_GRF_BASE	0x2600e000
#define CCI_GRF_BASE		0x26010000
#define DDR_GRF_BASE		0x26012000
#define CENTER_GRF_BASE		0x26014000
#define GPUGRF_BASE		0x26016000
#define NPUGRF_BASE		0x26018000
#define VO_GRF_BASE		0x2601a000
#define VI_GRF_BASE		0x2601c000
#define USB_GRF_BASE		0x2601e000
#define PHP_GRF_BASE		0x26020000
#define VOP_GRF_BASE		0x26022000
#define PMU0_GRF_BASE		0x26024000
#define PMU1_GRF_BASE		0x26026000
#define USBDPPHY_GRF_BASE	0x2602c000
#define USB2PHY0_GRF_BASE	0x2602e000
#define USB2PHY1_GRF_BASE	0x26030000
#define PMU0_IOC_BASE		0x26040000
#define PMU1_IOC_BASE		0x26042000
#define TOP_IOC_BASE		0x26044000
#define VCCIO_IOC_BASE		0x26046000
#define VCCIO6_IOC_BASE		0x2604a000
#define VCCIO7_IOC_BASE		0x2604b000
#define CRU_BASE		0x27200000
#define PHP_CRU_BASE		0x27208000
#define SECURE_CRU_BASE		0x27210000
#define PMU1_CRU_BASE		0x27220000
#define DDRPHY0_CRU_BASE	0x27228000
#define DDRPHY1_CRU_BASE	0x27230000
#define BIGCORE_CRU_BASE	0x27238000
#define LITTLE_CRU_BASE		0x27240000
#define CCI_CRU_BASE		0x27248000
#define PVTPLL_CCI_BASE		0x27250000
#define PVTPLL_BIGCORE_BASE	0x27258000
#define PVTPLL_LITCORE_BASE	0x27260000
#define PVTPLL_GPU_BASE		0x27268000
#define PVTPLL_NPU_BASE		0x27270000
#define PVTPLL_CRU_BASE		0x27278000
#define I2C0_BASE		0x27300000
#define UART1_BASE		0x27310000
#define GPIO0_BASE		0x27320000
#define PWM0_BASE		0x27330000
#define WDT_PMU_BASE		0x27340000
#define TIMER_PMU_BASE		0x27350000
#define PMU_BASE		0x27360000
#define PMU0_BASE		0x27360000
#define PMU1_BASE		0x27370000
#define PMU2_BASE		0x27380000
#define PVTM_PMU_BASE		0x273f0000
#define HPTIMER_BASE		0x27400000
#define CCI_BASE		0x27500000
#define VOP_BASE		0x27d00000
#define INTERCONNECT_BASE	0x27f00000
#define FW_CCI2DDR_BASE		0x27f80000
#define FW_CENTER2DDR_BASE	0x27f90000
#define FW_SYSMEM_BASE		0x27fa0000
#define FW_VOP2DDR_BASE		0x27fb0000
#define FW_CBUF_BASE		0x27fc0000
#define FIREWALL_DDR_BASE	0x27f80000
#define DDRCTL0_BASE		0x28000000
#define DDRCTL1_BASE		0x29000000
#define DDR_MONITOR0_BASE	0x2a000000
#define DDR_MONITOR1_BASE	0x2a010000
#define DDRPHY0_BASE		0x2a020000
#define DDRPHY1_BASE		0x2a030000
#define HWLP0_BASE		0x2a060000
#define HWLP1_BASE		0x2a070000
#define KEYLADDER_BASE		0x2a420000
#define CRYPTO_S_BASE		0x2a430000
#define OTP_S_BASE		0x2a480000
#define DCF_BASE		0x2a490000
#define STIMER0_BASE		0x2a4a0000
#define STIMER1_BASE		0x2a4b0000
#define WDT_S_BASE		0x2a4c0000
#define OTP_MASK_BASE		0x2a4d0000
#define OTP_NS_BASE		0x2a580000
#define GIC400_BASE		0x2a700000
#define I2C1_BASE		0x2ac40000
#define NSTIMER0_BASE		0x2acc0000
#define NSTIMER1_BASE		0x2acd0000
#define WDT_NS_BASE		0x2ace0000
#define UART0_BASE		0x2ad40000
#define UART2_BASE		0x2ad50000
#define UART3_BASE		0x2ad60000
#define UART4_BASE		0x2ad70000
#define UART5_BASE		0x2ad80000
#define UART6_BASE		0x2ad90000
#define UART7_BASE		0x2ada0000
#define UART8_BASE		0x2adb0000
#define UART9_BASE		0x2adc0000
#define PWM1_BASE		0x2add0000
#define PWM2_BASE		0x2ade0000
#define PWM3_BASE		0x2adf0000
#define GPIO1_BASE		0x2ae10000
#define GPIO2_BASE		0x2ae20000
#define GPIO3_BASE		0x2ae30000
#define GPIO4_BASE		0x2ae40000
#define TSADC_BASE		0x2ae70000

#define PMUSRAM_BASE		0x3fe70000
#define PMUSRAM_RSIZE		SIZE_K(32)

#define CBUF_BASE		0x3fe80000
#define SRAM_BASE		0x3ff80000

#define STIMER0_CHN_BASE(i)	(STIMER0_BASE + 0x1000 * (i))
#define STIMER1_CHN_BASE(i)	(STIMER1_BASE + 0x1000 * (i))

#define NSTIMER0_CHN_BASE(i)	(NSTIMER0_BASE + 0x1000 * (i))
#define NSTIMER1_CHN_BASE(i)	(NSTIMER1_BASE + 0x1000 * (i))

#define DDRPHY_BASE_CH(n)	(DDRPHY0_BASE + ((n) * 0x10000))
#define DDRPHY_CRU_BASE_CH(n)	(DDRPHY0_CRU_BASE + ((n) * 0x8000))
#define UMCTL_BASE_CH(n)	(DDRCTL0_BASE + ((n) * 0x1000000))
#define HWLP_BASE_CH(n)		(HWLP0_BASE + ((n) * 0x10000))
#define MAILBOX1_BASE		(0x2ae50000 + 0xb000)

#define CRYPTO_S_BY_KEYLAD_BASE	CRYPTO_S_BASE

#define DDR_SHARE_MEM		(RK_DRAM_BASE + SIZE_K(1024))
#define DDR_SHARE_SIZE		SIZE_K(64)

#define SHARE_MEM_BASE		DDR_SHARE_MEM
#define SHARE_MEM_PAGE_NUM	15
#define SHARE_MEM_SIZE		SIZE_K(SHARE_MEM_PAGE_NUM * 4)

#define	SCMI_SHARE_MEM_BASE	(SHARE_MEM_BASE + SHARE_MEM_SIZE)
#define	SCMI_SHARE_MEM_SIZE	SIZE_K(4)

#define SMT_BUFFER_BASE		SCMI_SHARE_MEM_BASE
#define SMT_BUFFER0_BASE	SMT_BUFFER_BASE

#define ROCKCHIP_PM_REG_REGION_MEM_SIZE		SIZE_K(8)

/******************************************************************************
 * sgi, ppi
 ******************************************************************************/
#define RK_IRQ_SEC_PHY_TIMER	29

#define RK_IRQ_SEC_SGI_0	8
#define RK_IRQ_SEC_SGI_1	9
#define RK_IRQ_SEC_SGI_2	10
#define RK_IRQ_SEC_SGI_3	11
#define RK_IRQ_SEC_SGI_4	12
#define RK_IRQ_SEC_SGI_5	13
#define RK_IRQ_SEC_SGI_6	14
#define RK_IRQ_SEC_SGI_7	15

/*
 * Define a list of Group 0 interrupts.
 */
#define PLAT_RK_GICV2_G0_IRQS						\
	INTR_PROP_DESC(RK_IRQ_SEC_PHY_TIMER, GIC_HIGHEST_SEC_PRIORITY,	\
		       GICV2_INTR_GROUP0, GIC_INTR_CFG_LEVEL),		\
	INTR_PROP_DESC(RK_IRQ_SEC_SGI_6, GIC_HIGHEST_SEC_PRIORITY,	\
		       GICV2_INTR_GROUP0, GIC_INTR_CFG_LEVEL)

/* UART related constants */
#define RK_DBG_UART_BASE	UART0_BASE
#define RK_DBG_UART_BAUDRATE	1500000
#define RK_DBG_UART_CLOCK	24000000

/* Base rk_platform compatible GIC memory map */
#define PLAT_GICD_BASE		(GIC400_BASE + 0x1000)
#define PLAT_GICC_BASE		(GIC400_BASE + 0x2000)
#define PLAT_GICR_BASE		0

/* CCI */
#define PLAT_RK_CCI_BASE			CCI_BASE
#define PLAT_RK_CCI_CLUSTER0_SL_IFACE_IX	1
#define PLAT_RK_CCI_CLUSTER1_SL_IFACE_IX	2

#endif /* __PLAT_DEF_H__ */
