/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt.export;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.xmind.core.ITopic;
import org.xmind.gef.GEF;
import org.xmind.ui.gantt.GanttMessages;
import org.xmind.ui.gantt.GanttPlugin;
import org.xmind.ui.gantt.export.DateInfoPickerViewer2;
import org.xmind.ui.gantt.export.ExportConstants;
import org.xmind.ui.gantt.export.GanttImageCreator;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeHeaderViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeViewer;
import org.xmind.ui.gantt2.viewer.TimelineModel;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.internal.print.PrintUtils;
import org.xmind.ui.internal.print.multipage.DialogSettingsDecorator;
import org.xmind.ui.internal.print.multipage.MultipageImagePreviewViewer;
import org.xmind.ui.internal.taskinfo.DateInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintGanttSetupDialog
extends TitleAreaDialog {
    private static final long PREVIEW_DELAY = 1000L;
    private GanttViewer ganttViewer;
    private IDialogSettings settings;
    private GanttImageCreator previewImageCreator;
    private GeneratePreviewJob generatePreviewJob;
    private Button allTasksRadio;
    private Button tasksBetweenRadio;
    private DateInfoPickerViewer2 startDatePicker;
    private DateInfoPickerViewer2 endDatePicker;
    private Calendar minTime;
    private Calendar maxTime;
    private Button landscapeRadio;
    private Button portraitRadio;
    private Map<String, Spinner> marginControls = new HashMap<String, Spinner>();
    private Spinner widthPages;
    private Spinner heightPages;
    private Button pageLockCheck;
    private Text header;
    private Text footer;
    private Map<String, IAction[]> actions;
    private Button borderCheck;
    private Button pageNumberCheck;
    private boolean updating = false;
    private MultipageImagePreviewViewer viewer;
    private boolean isRefreshingPages = false;
    private boolean modifyingText = false;
    private Listener eventHandler = new Listener(){

        public void handleEvent(Event event) {
            PrintGanttSetupDialog.this.handleWidgetEvent(event);
        }
    };

    public PrintGanttSetupDialog(Shell parentShell, GanttViewer ganttViewer) {
        super(parentShell);
        this.ganttViewer = ganttViewer;
        this.settings = new DialogSettingsDecorator(GanttPlugin.getDefault().getDialogSettings());
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(DialogMessages.PageSetupDialog_windowTitle);
    }

    public void create() {
        super.create();
        this.update(null);
        this.setTitle(DialogMessages.PageSetupDialog_title);
        this.setMessage(GanttMessages.PrintGanttDialog_description);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getSettings();
    }

    protected int getDialogBoundsStrategy() {
        return 1;
    }

    public IDialogSettings getSettings() {
        return this.settings;
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = IDialogConstants.NEXT_LABEL;
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createPreviewControl(container);
        this.createSettingsPart(container);
        return composite;
    }

    private void createSettingsPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 15;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        this.createTimeRangeSection(composite);
        this.createOrientationSection(composite);
        this.createMarginsSection(composite);
        this.createPagesSection(composite);
        this.createHeaderFooterSection(composite);
        this.createPageSetupSection(composite);
    }

    private void createTimeRangeSection(Composite parent) {
        this.initTimeRange();
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 128, false, false));
        label.setFont(FontUtils.getBold((Font)FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0)));
        label.setText(GanttMessages.PrintGanttSetupDialog_DateRange_text);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        this.allTasksRadio = new Button(composite, 16);
        this.allTasksRadio.setText(GanttMessages.PrintGanttSetupDialog_AllTasks_text);
        this.allTasksRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.hookWidget((Widget)this.allTasksRadio, 13);
        this.createTaskBetweenOption(composite);
    }

    private void createOrientationSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 128, false, false));
        label.setFont(FontUtils.getBold((Font)FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0)));
        label.setText(GanttMessages.PrintGanttSetupDialog_Orientation_text);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 128, true, false));
        this.landscapeRadio = new Button(composite, 16);
        this.landscapeRadio.setData((Object)2);
        this.landscapeRadio.setText(DialogMessages.PageSetupDialog_Landscape);
        this.landscapeRadio.setLayoutData((Object)new GridData(4, 4, true, false));
        this.portraitRadio = new Button(composite, 16);
        this.portraitRadio.setData((Object)1);
        this.portraitRadio.setText(DialogMessages.PageSetupDialog_Portrait);
        this.portraitRadio.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hookWidget((Widget)this.portraitRadio, 13);
    }

    private void createMarginsSection(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData(131072, 128, false, false);
        gridData.verticalIndent = 3;
        label.setLayoutData((Object)gridData);
        label.setFont(FontUtils.getBold((Font)FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0)));
        label.setText(GanttMessages.PrintGanttSetupDialog_Margin_text);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 128, false, false));
        boolean isLinux = Util.isLinux();
        if (isLinux) {
            layout.numColumns = 1;
        }
        Composite leftComposite = new Composite(composite, 0);
        GridLayout layout1 = new GridLayout(2, false);
        layout1.marginHeight = 0;
        layout1.marginWidth = 0;
        leftComposite.setLayout((Layout)layout1);
        leftComposite.setLayoutData((Object)new GridData(16384, 128, false, false));
        Composite rightComposite = new Composite(composite, 0);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        rightComposite.setLayout((Layout)layout2);
        rightComposite.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.createMarginInput(leftComposite, "leftMargin", DialogMessages.PageSetupDialog_Left);
        this.createMarginInput(rightComposite, "rightMargin", DialogMessages.PageSetupDialog_Right);
        this.createMarginInput(leftComposite, "topMargin", DialogMessages.PageSetupDialog_Top);
        this.createMarginInput(rightComposite, "bottomMargin", DialogMessages.PageSetupDialog_Bottom);
    }

    private void createPagesSection(Composite parent) {
        Label label = new Label(parent, 0);
        GridData gridData = new GridData(131072, 128, false, false);
        gridData.verticalIndent = 3;
        label.setLayoutData((Object)gridData);
        label.setFont(FontUtils.getBold((Font)label.getFont()));
        label.setText(GanttMessages.PrintGanttSetupDialog_Pages_text);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 15;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.widthPages = this.createChangePageSection(composite, GanttMessages.PrintGanttSetupDialog_Horizontal_text);
        this.heightPages = this.createChangePageSection(composite, GanttMessages.PrintGanttSetupDialog_Vertical_text);
        this.pageLockCheck = new Button(composite, 32);
        this.pageLockCheck.setText(GanttMessages.PrintGanttSetupDialog_Paging_text);
        GridData layoutData = new GridData(16384, 4, false, false);
        layoutData.horizontalSpan = 2;
        this.pageLockCheck.setLayoutData((Object)layoutData);
        this.hookWidget((Widget)this.pageLockCheck, 13);
        boolean isLinux = Util.isLinux();
        if (isLinux) {
            layout.numColumns = 1;
            layoutData.horizontalSpan = 1;
        }
    }

    private void createHeaderFooterSection(Composite parent) {
        Composite leftComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        leftComposite.setLayout((Layout)layout);
        leftComposite.setLayoutData((Object)new GridData(131072, 4, false, false));
        Label label = new Label(leftComposite, 0);
        GridData gridData = new GridData(131072, 128, false, true);
        gridData.verticalIndent = 2;
        label.setLayoutData((Object)gridData);
        label.setFont(FontUtils.getBold((Font)FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0)));
        label.setText(DialogMessages.PageSetupDialog_Header);
        Label label2 = new Label(leftComposite, 0);
        GridData gridData2 = new GridData(131072, 128, false, true);
        gridData2.verticalIndent = 2;
        label2.setLayoutData((Object)gridData2);
        label2.setFont(FontUtils.getBold((Font)FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0)));
        label2.setText(DialogMessages.PageSetupDialog_Footer);
        Composite rightComposite = new Composite(parent, 0);
        GridLayout layout2 = new GridLayout(1, false);
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.verticalSpacing = 5;
        rightComposite.setLayout((Layout)layout2);
        rightComposite.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.createHeaderSection(rightComposite);
        this.createFooterSection(rightComposite);
    }

    private void createPageSetupSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(131072, 128, false, false));
        label.setFont(FontUtils.getBold((Font)FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)0)));
        label.setText(DialogMessages.PageSetupDialog_PageSetup);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(16384, 128, true, false));
        this.borderCheck = new Button(composite, 32);
        this.borderCheck.setText(DialogMessages.PageSetupDialog_Border);
        this.borderCheck.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.hookWidget((Widget)this.borderCheck, 13);
        this.pageNumberCheck = new Button(composite, 32);
        this.pageNumberCheck.setText(GanttMessages.PrintGanttSetupDialog_PageNumber_text);
        this.pageNumberCheck.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.hookWidget((Widget)this.pageNumberCheck, 13);
    }

    private void initTimeRange() {
        ITopic rootTopic = this.getCentralTopic();
        Date earliestDate = TaskInfoUtils.getEarliestStartDate((ITopic)rootTopic);
        if (earliestDate == null) {
            earliestDate = this.ganttViewer.getEditDomain().getTimelineModel().getOriginDate().getTime();
        }
        this.minTime = Calendar.getInstance();
        this.minTime.setTime(earliestDate);
        Date latestDate = TaskInfoUtils.getLatestEndDate((ITopic)rootTopic);
        if (latestDate == null) {
            latestDate = this.ganttViewer.getEditDomain().getTimelineModel().getOriginDate().getTime();
        }
        this.maxTime = Calendar.getInstance();
        this.maxTime.setTime(latestDate);
    }

    private ITopic getCentralTopic() {
        return (ITopic)this.ganttViewer.getInput();
    }

    private void createTaskBetweenOption(Composite parent) {
        this.tasksBetweenRadio = new Button(parent, 16);
        this.tasksBetweenRadio.setText(GanttMessages.ExportToImageWizard_TasksBetween_text);
        this.tasksBetweenRadio.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.createChangeDateSection(parent);
    }

    private void createChangeDateSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.horizontalIndent = 5;
        composite.setLayoutData((Object)gridData);
        boolean isLinux = Util.isLinux();
        if (isLinux) {
            layout.numColumns = 2;
        }
        this.startDatePicker = this.createDatePicker(composite);
        GridData gridData2 = new GridData(16384, 0x1000000, false, false);
        this.startDatePicker.getControl().setLayoutData((Object)gridData2);
        this.startDatePicker.setSelection((ISelection)new StructuredSelection((Object)new DateInfo(this.minTime, false)));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText(GanttMessages.ExportToImageWizard_and_text);
        this.endDatePicker = this.createDatePicker(composite);
        GridData gridData3 = new GridData(16384, 0x1000000, true, false);
        this.endDatePicker.getControl().setLayoutData((Object)gridData3);
        this.endDatePicker.setSelection((ISelection)new StructuredSelection((Object)new DateInfo(this.maxTime, false)));
        this.startDatePicker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Calendar selectedTime = PrintGanttSetupDialog.this.startDatePicker.getSelectedDate();
                Calendar minTime = PrintGanttSetupDialog.this.startDatePicker.getMinTime();
                Calendar maxTime = PrintGanttSetupDialog.this.startDatePicker.getMaxTime();
                if (!selectedTime.before(minTime) && !selectedTime.after(maxTime)) {
                    PrintGanttSetupDialog.this.getSettings().put("startTime", PrintGanttSetupDialog.this.startDatePicker.getSelectedDate().getTimeInMillis());
                    if (PrintGanttSetupDialog.this.previewImageCreator != null) {
                        PrintGanttSetupDialog.this.previewImageCreator.setHeaderImageValid(false);
                        PrintGanttSetupDialog.this.previewImageCreator.setContentImageValid(false);
                    }
                    PrintGanttSetupDialog.this.endDatePicker.setMinTime(PrintGanttSetupDialog.this.startDatePicker.getSelectedDate());
                    PrintGanttSetupDialog.this.refreshWidthHeightPages();
                    PrintGanttSetupDialog.this.generatePreview(true);
                }
            }
        });
        this.endDatePicker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Calendar selectedTime = PrintGanttSetupDialog.this.endDatePicker.getSelectedDate();
                Calendar minTime = PrintGanttSetupDialog.this.endDatePicker.getMinTime();
                Calendar maxTime = PrintGanttSetupDialog.this.endDatePicker.getMaxTime();
                if (!selectedTime.before(minTime) && !selectedTime.after(maxTime)) {
                    PrintGanttSetupDialog.this.getSettings().put("endTime", PrintGanttSetupDialog.this.endDatePicker.getSelectedDate().getTimeInMillis());
                    if (PrintGanttSetupDialog.this.previewImageCreator != null) {
                        PrintGanttSetupDialog.this.previewImageCreator.setHeaderImageValid(false);
                        PrintGanttSetupDialog.this.previewImageCreator.setContentImageValid(false);
                    }
                    PrintGanttSetupDialog.this.startDatePicker.setMaxTime(PrintGanttSetupDialog.this.endDatePicker.getSelectedDate());
                    PrintGanttSetupDialog.this.refreshWidthHeightPages();
                    PrintGanttSetupDialog.this.generatePreview(true);
                }
            }
        });
    }

    private DateInfoPickerViewer2 createDatePicker(Composite parent) {
        final DateInfoPickerViewer2 datePicker = new DateInfoPickerViewer2(parent);
        datePicker.setMinTime(this.minTime);
        datePicker.setMaxTime(this.maxTime);
        datePicker.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Calendar selectedTime = datePicker.getSelectedDate();
                final Calendar minTime = datePicker.getMinTime();
                final Calendar maxTime = datePicker.getMaxTime();
                if (selectedTime.before(minTime)) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)GanttMessages.ExportToImageWizard_InvalidValue_text, (String)GanttMessages.ExportToImageWizard_InvalidSmall_text);
                            datePicker.setSelection((ISelection)new StructuredSelection((Object)new DateInfo(minTime, false)));
                        }
                    });
                } else if (selectedTime.after(maxTime)) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)GanttMessages.ExportToImageWizard_InvalidValue_text, (String)GanttMessages.ExportToImageWizard_InvalidBig_text);
                            datePicker.setSelection((ISelection)new StructuredSelection((Object)new DateInfo(maxTime, false)));
                        }
                    });
                }
            }
        });
        return datePicker;
    }

    private Spinner createMarginInput(Composite parent, final String key, String name) {
        Label nameLabel = new Label(parent, 0);
        nameLabel.setText(name);
        nameLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        Spinner spinner = new Spinner(parent, 2048);
        spinner.setDigits(2);
        spinner.setMinimum(0);
        spinner.setMaximum(350);
        spinner.setIncrement(25);
        spinner.setPageIncrement(100);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        spinner.setLayoutData((Object)gd);
        this.marginControls.put(key, spinner);
        spinner.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PrintGanttSetupDialog.this.marginControls != null) {
                    PrintGanttSetupDialog.this.marginControls.remove(key);
                }
            }
        });
        this.hookWidget((Widget)spinner, 24);
        return spinner;
    }

    private Spinner createChangePageSection(Composite parent, String text) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(16384, 4, false, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        label.setText(text);
        Spinner spinner = new Spinner(composite, 2048);
        spinner.setDigits(0);
        spinner.setMinimum(1);
        spinner.setMaximum(100);
        spinner.setSelection(1);
        spinner.setIncrement(1);
        spinner.setPageIncrement(2);
        GridData gridData = new GridData(16384, 0x1000000, false, false);
        spinner.setLayoutData((Object)gridData);
        this.hookWidget((Widget)spinner, 24);
        return spinner;
    }

    private void createHeaderSection(Composite parent) {
        this.createHeaderSection(parent, DialogMessages.PageSetupDialog_Header, "headerAlign", "headerFont", "headerText");
    }

    private void createFooterSection(Composite parent) {
        this.createFooterSection(parent, DialogMessages.PageSetupDialog_Footer, "footerAlign", "footerFont", "footerText");
    }

    private void createHeaderSection(Composite parent, String name, String alignKey, String fontKey, String textKey) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        container.setLayout((Layout)layout);
        this.header = new Text(container, 2052);
        GridData inputLayoutData = new GridData(16384, 0x1000000, false, false);
        inputLayoutData.horizontalSpan = 3;
        inputLayoutData.widthHint = 130;
        this.header.setLayoutData((Object)inputLayoutData);
        this.createHFToolBar(alignKey, fontKey, container);
        this.hookWidget((Widget)this.header, 24);
        this.hookWidget((Widget)this.header, 14);
        this.hookWidget((Widget)this.header, 15);
    }

    private void createFooterSection(Composite parent, String name, String alignKey, String fontKey, String textKey) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        container.setLayout((Layout)layout);
        this.footer = new Text(container, 2052);
        GridData inputLayoutData = new GridData(16384, 0x1000000, false, false);
        inputLayoutData.horizontalSpan = 3;
        inputLayoutData.widthHint = 130;
        this.footer.setLayoutData((Object)inputLayoutData);
        this.createHFToolBar(alignKey, fontKey, container);
        this.hookWidget((Widget)this.footer, 24);
        this.hookWidget((Widget)this.footer, 14);
        this.hookWidget((Widget)this.footer, 15);
    }

    private void createHFToolBar(final String alignKey, String fontKey, Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout2 = new GridLayout(2, false);
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.horizontalSpacing = 0;
        composite.setLayout((Layout)layout2);
        composite.setLayoutData((Object)new GridData(16384, 128, false, false));
        AlignAction leftAction = new AlignAction(alignKey, "left");
        AlignAction centerAction = new AlignAction(alignKey, "center");
        AlignAction rightAction = new AlignAction(alignKey, "right");
        ToolBarManager alignBar = new ToolBarManager(0x800000);
        alignBar.add((IAction)leftAction);
        alignBar.add((IAction)centerAction);
        alignBar.add((IAction)rightAction);
        alignBar.createControl(composite);
        alignBar.getControl().setLayoutData((Object)new GridData(4, 4, false, false));
        this.addActions(alignKey, new IAction[]{leftAction, centerAction, rightAction});
        alignBar.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                PrintGanttSetupDialog.this.removeActions(alignKey);
            }
        });
        ToolBarManager fontBar = new ToolBarManager(0x800000);
        FontAction fontAction = new FontAction(fontKey);
        fontBar.add((IAction)fontAction);
        fontBar.createControl(composite);
        fontBar.getControl().setLayoutData((Object)new GridData(4, 4, false, false));
    }

    private void addActions(String key, IAction ... actions) {
        if (this.actions == null) {
            this.actions = new HashMap<String, IAction[]>();
        }
        this.actions.put(key, actions);
    }

    private void removeActions(String key) {
        if (this.actions != null) {
            this.actions.remove(key);
        }
    }

    private void createPreviewControl(Composite parent) {
        this.viewer = new MultipageImagePreviewViewer(true);
        this.viewer.createControl(parent);
        GridData layoutData = new GridData(16384, 128, false, false);
        layoutData.verticalIndent = 10;
        this.viewer.getControl().setLayoutData((Object)layoutData);
        this.viewer.getControl().setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)8));
    }

    private void hookWidget(Widget widget, int eventType) {
        widget.addListener(eventType, this.eventHandler);
    }

    private void generatePreview(boolean hasDelay) {
        if (this.viewer != null && !this.viewer.getControl().isDisposed()) {
            this.updateViewer(null, PreviewState.Generating, false, null);
            this.viewer.setFeedbackVisible(false);
        }
        this.disposePreview();
        Display display = Display.getCurrent();
        this.generatePreviewJob = new GeneratePreviewJob(display);
        if (this.getSettings() instanceof DialogSettingsDecorator) {
            ((DialogSettingsDecorator)this.getSettings()).setDirty(false);
        }
        if (hasDelay) {
            this.generatePreviewJob.schedule(1000L);
        } else {
            this.generatePreviewJob.schedule();
        }
    }

    private void disposePreview() {
        this.cancel();
    }

    private void cancel() {
        if (this.generatePreviewJob != null) {
            this.generatePreviewJob.cancel();
            this.generatePreviewJob = null;
        }
    }

    private void setProperty(String key, String value) {
        this.getSettings().put(key, value);
        this.update(key);
    }

    private void setProperty(String key, int value) {
        this.getSettings().put(key, value);
        this.update(key);
    }

    private void setProperty(String key, boolean value) {
        this.getSettings().put(key, value);
        this.update(key);
    }

    private void handleWidgetEvent(Event event) {
        if (event.widget == this.allTasksRadio || event.widget == this.tasksBetweenRadio) {
            this.setProperty("timeRange", this.tasksBetweenRadio.getSelection());
        } else if (event.widget == this.landscapeRadio || event.widget == this.portraitRadio) {
            Button selectedButton = this.landscapeRadio.getSelection() ? this.landscapeRadio : this.portraitRadio;
            this.getSettings().put("orientation", ((Integer)selectedButton.getData()).intValue());
            this.refreshWidthHeightPages();
            this.update("orientation");
        } else if (this.marginControls.containsValue(event.widget)) {
            Spinner spinner = (Spinner)event.widget;
            this.getSettings().put(this.getKey(this.marginControls, event.widget), this.getSnipperValue(spinner));
            this.refreshWidthHeightPages();
            this.update(this.getKey(this.marginControls, event.widget));
        } else if (event.widget == this.widthPages) {
            boolean locked = this.getBoolean("aspectRatioLocked");
            if (!this.isRefreshingPages) {
                if (locked) {
                    this.isRefreshingPages = true;
                    this.getSettings().put("fillHeight", false);
                    int heightPageNumber = this.getHeightPageByWidth(this.widthPages.getSelection());
                    this.heightPages.setSelection(heightPageNumber);
                    this.setProperty("widthPages", this.widthPages.getSelection());
                    this.isRefreshingPages = false;
                } else {
                    this.getSettings().put("fillHeight", false);
                    this.setProperty("widthPages", this.widthPages.getSelection());
                }
            } else {
                this.getSettings().put("widthPages", this.widthPages.getSelection());
            }
        } else if (event.widget == this.heightPages) {
            boolean locked = this.getBoolean("aspectRatioLocked");
            if (!this.isRefreshingPages) {
                if (locked) {
                    this.isRefreshingPages = true;
                    this.getSettings().put("fillHeight", true);
                    this.widthPages.setSelection(this.getWidthPageByHeight(this.heightPages.getSelection()));
                    this.setProperty("heightPages", this.heightPages.getSelection());
                    this.isRefreshingPages = false;
                } else {
                    this.getSettings().put("fillHeight", true);
                    this.setProperty("heightPages", this.heightPages.getSelection());
                }
            } else {
                this.getSettings().put("heightPages", this.heightPages.getSelection());
            }
        } else if (event.widget == this.pageLockCheck) {
            boolean locked = this.pageLockCheck.getSelection();
            this.getSettings().put("aspectRatioLocked", locked);
            this.refreshWidthHeightPages();
            this.update("aspectRatioLocked");
        } else if (event.widget == this.header) {
            if (event.type == 15) {
                this.header.selectAll();
            } else if (event.type == 14 || event.type == 24) {
                int caretPosition = this.header.getCaretPosition();
                this.modifyingText = true;
                String oldHeaderText = this.getString("headerText", "");
                String newHeaderText = this.header.getText();
                if ("".equals(oldHeaderText) && !"".equals(newHeaderText) || !"".equals(oldHeaderText) && "".equals(newHeaderText)) {
                    this.getSettings().put("headerText", this.header.getText());
                    this.refreshWidthHeightPages();
                    this.update("headerText");
                    this.generatePreview(false);
                } else {
                    this.setProperty("headerText", this.header.getText());
                }
                this.modifyingText = false;
                caretPosition = Math.min(caretPosition, this.header.getText().length());
                this.header.setSelection(caretPosition);
            }
        } else if (event.widget == this.footer) {
            String oldFooterText = this.getString("footerText", "");
            String newFooterText = this.footer.getText();
            if ("".equals(oldFooterText) && !"".equals(newFooterText) || !"".equals(oldFooterText) && "".equals(newFooterText)) {
                this.getSettings().put("footerText", this.footer.getText());
                this.refreshWidthHeightPages();
                this.update("footerText");
                this.generatePreview(false);
            } else {
                this.setProperty("footerText", this.footer.getText());
            }
        } else if (event.widget == this.borderCheck) {
            this.setProperty("noBorder", !this.borderCheck.getSelection());
        } else if (event.widget == this.pageNumberCheck) {
            this.setProperty("noPageNumber", !this.pageNumberCheck.getSelection());
        }
    }

    private void refreshWidthHeightPages() {
        boolean locked = this.getBoolean("aspectRatioLocked");
        if (locked) {
            boolean fillWidth = !this.getSettings().getBoolean("fillHeight");
            this.isRefreshingPages = true;
            if (fillWidth) {
                this.heightPages.setSelection(this.getHeightPageByWidth(this.widthPages.getSelection()));
            } else {
                this.widthPages.setSelection(this.getWidthPageByHeight(this.heightPages.getSelection()));
            }
            this.isRefreshingPages = false;
        }
    }

    private void update(String key) {
        if (this.updating) {
            return;
        }
        if (key == "fillHeight") {
            return;
        }
        boolean timeRangeRadioChanged = key == null || "timeRange".equals(key);
        boolean orientationChanged = key == null || "orientation".equals(key);
        boolean marginChanged = key == null || "leftMargin".equals(key) || "rightMargin".equals(key) || "topMargin".endsWith(key) || "bottomMargin".equals(key);
        boolean widthPagesChanged = key == null || "widthPages".equals(key);
        boolean heightPagesChanged = key == null || "heightPages".equals(key);
        boolean headerChanged = key == null || "headerAlign".equals(key) || "headerFont".equals(key) || "headerText".equals(key);
        boolean footerChanged = key == null || "footerAlign".equals(key) || "footerFont".equals(key) || "footerText".equals(key);
        boolean buttonLockChanged = key == null || "aspectRatioLocked".equals(key);
        boolean borderChanged = key == null || "noBorder".equals(key);
        boolean pageNumberChanged = key == null || "noPageNumber".equals(key);
        this.updating = true;
        if (timeRangeRadioChanged) {
            this.updateTimeRange();
        }
        if (orientationChanged) {
            this.updateOrientation();
            this.updateBackgroundImage();
        }
        if (buttonLockChanged) {
            boolean isButtonLocked = this.getBoolean("aspectRatioLocked");
            this.pageLockCheck.setSelection(isButtonLocked);
        }
        if (headerChanged) {
            this.updateHFSectionAndPreview("headerText", "", "headerAlign", "center", 2, "headerFont");
        }
        if (footerChanged) {
            this.updateHFSectionAndPreview("footerText", "", "footerAlign", "right", 4, "footerFont");
        }
        if (borderChanged) {
            boolean showBorder = !this.getBoolean("noBorder");
            this.borderCheck.setSelection(showBorder);
            this.viewer.setBorderVisible(showBorder);
        }
        if (pageNumberChanged) {
            boolean showPageNumber = !this.getBoolean("noPageNumber");
            this.pageNumberCheck.setSelection(showPageNumber);
            this.viewer.setPageNumberVisible(showPageNumber);
        }
        if (key == null) {
            this.initMargins();
            this.initWidthHeightPages();
        }
        if (key == null) {
            this.generatePreview(false);
        } else if (timeRangeRadioChanged || orientationChanged || marginChanged || widthPagesChanged || heightPagesChanged || buttonLockChanged) {
            this.generatePreview(true);
        }
        this.updating = false;
    }

    private void initMargins() {
        for (Map.Entry<String, Spinner> entry : this.marginControls.entrySet()) {
            String key = entry.getKey();
            double margin = this.getDouble(key, 0.25);
            Spinner spinner = entry.getValue();
            entry.getValue().setSelection((int)(margin * Math.pow(10.0, spinner.getDigits())));
        }
    }

    private void initWidthHeightPages() {
        boolean locked = this.getBoolean("aspectRatioLocked");
        boolean fillWidth = !this.getBoolean("fillHeight");
        int widthPageNumber = this.getInteger("widthPages", 1);
        int heightPageNumber = this.getInteger("heightPages", 1);
        if (locked) {
            if (fillWidth) {
                this.widthPages.setSelection(widthPageNumber);
            } else {
                this.heightPages.setSelection(heightPageNumber);
            }
        } else {
            this.widthPages.setSelection(widthPageNumber);
            this.heightPages.setSelection(heightPageNumber);
        }
        this.widthPages.setMaximum(this.getMaxWidthPages());
        this.heightPages.setMaximum(this.getMaxHeightPages());
    }

    private void updateTimeRange() {
        boolean tasksBetween = this.getBoolean("timeRange");
        this.allTasksRadio.setSelection(!tasksBetween);
        this.tasksBetweenRadio.setSelection(tasksBetween);
        if (!tasksBetween) {
            this.getSettings().put("startTime", this.minTime.getTimeInMillis());
            this.getSettings().put("endTime", this.maxTime.getTimeInMillis());
            this.startDatePicker.setEnabled(false);
            this.endDatePicker.setEnabled(false);
        } else {
            this.getSettings().put("startTime", this.startDatePicker.getSelectedDate().getTimeInMillis());
            this.getSettings().put("endTime", this.endDatePicker.getSelectedDate().getTimeInMillis());
            this.startDatePicker.setEnabled(true);
            this.endDatePicker.setEnabled(true);
        }
        if (this.previewImageCreator != null) {
            this.previewImageCreator.setHeaderImageValid(false);
            this.previewImageCreator.setContentImageValid(false);
        }
        this.refreshWidthHeightPages();
    }

    private void updateOrientation() {
        int orientation = this.getInteger("orientation", 2);
        boolean landscape = orientation != 1;
        this.landscapeRadio.setSelection(landscape);
        this.portraitRadio.setSelection(!landscape);
    }

    private void updateBackgroundImage() {
        int orientation = this.getInteger("orientation", 2);
        boolean landscape = orientation != 1;
        int prefWidth = landscape ? 289 : 204;
        int prefHeight = landscape ? 204 : 289;
        this.viewer.updateBackgroundImageComposite(true, landscape);
        this.viewer.updateBackgroundImage();
        this.viewer.setPrefSize(new org.eclipse.swt.graphics.Point(prefWidth, prefHeight));
        this.viewer.initPreviewImageRatio();
    }

    private void updateHFSectionAndPreview(String textKey, String defaultText, String alignKey, String defaultAlign, int defaultDraw2DAlign, String fontKey) {
        String text = this.getString(textKey, defaultText);
        String alignValue = this.getString(alignKey, defaultAlign);
        IAction[] alignActions = this.getActions(alignKey);
        if (alignActions != null) {
            IAction[] iActionArray = alignActions;
            int n = alignActions.length;
            int n2 = 0;
            while (n2 < n) {
                IAction action = iActionArray[n2];
                action.setChecked(((AlignAction)action).value.equals(alignValue));
                ++n2;
            }
        }
        if (!this.modifyingText) {
            if ("headerText".equals(textKey)) {
                this.header.setText(text);
            } else if ("footerText".equals(textKey) && !this.footer.getText().equals(text)) {
                this.footer.setText(text);
            }
        }
        String fontValue = this.getString(fontKey, null);
        Font font = null;
        if (fontValue != null) {
            font = FontUtils.getFont((String)fontValue);
        }
        if (font == null) {
            font = Display.getCurrent().getSystemFont();
        }
        if (this.viewer != null) {
            if ("headerText".equals(textKey)) {
                this.viewer.updateHeaderPreview(text, alignValue, defaultDraw2DAlign, fontValue);
            } else if ("footerText".equals(textKey)) {
                this.viewer.updateFooterPreview(text, alignValue, defaultDraw2DAlign, fontValue);
            }
        }
    }

    private IAction[] getActions(String key) {
        return this.actions == null ? null : this.actions.get(key);
    }

    private double getSnipperValue(Spinner spinner) {
        if (spinner == null || spinner.isDisposed()) {
            return 0.0;
        }
        return (double)spinner.getSelection() / Math.pow(10.0, spinner.getDigits());
    }

    private String getString(String key, String defaultValue) {
        String value = this.getSettings().get(key);
        return value == null ? defaultValue : value;
    }

    private double getDouble(String key, double defaultValue) {
        try {
            return this.getSettings().getDouble(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private int getInteger(String key, int defaultValue) {
        try {
            return this.getSettings().getInt(key);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private boolean getBoolean(String key) {
        return this.getSettings().getBoolean(key);
    }

    private String getKey(Map<String, ?> maps, Object obj) {
        if (maps != null || obj != null) {
            for (Map.Entry<String, ?> entry : maps.entrySet()) {
                if (entry.getValue() != obj) continue;
                return entry.getKey();
            }
        }
        return "";
    }

    private void updateViewer(Image image, PreviewState state, boolean largeImage, Point origin) {
        if (this.viewer == null || this.viewer.getControl().isDisposed()) {
            return;
        }
        if (image != null && origin != null) {
            this.viewer.setImage(image, (double)origin.x, (double)origin.y);
        } else {
            this.viewer.setImage(image);
        }
        this.viewer.setTitle(state.getTitle(image, largeImage));
        this.viewer.setTitlePlacement(state.getTitlePlacement());
        state.setColor(this.viewer.getControl());
        this.viewer.initPreviewImageRatio();
    }

    private void createPreviewImage() {
        this.previewImageCreator = this.getPreviewImageCreator(Display.getCurrent());
        this.viewer.setImageBorderBounds(this.getImageBorderBounds());
        this.previewImageCreator.releaseResource();
        Image previewImage = this.previewImageCreator.createPrintPreviewDetailedImage();
        this.viewer.setWholeImage(previewImage);
        Image[] images = this.previewImageCreator.getSingleImages();
        this.viewer.setSingleImages(images);
    }

    private GanttImageCreator getPreviewImageCreator(Display display) {
        if (this.previewImageCreator == null) {
            this.previewImageCreator = this.createPreviewImageCreator(display);
        }
        return this.previewImageCreator;
    }

    private GanttImageCreator createPreviewImageCreator(Display display) {
        IDialogSettings settings = this.getSettings();
        GanttImageCreator exporter = new GanttImageCreator(display, this.ganttViewer, settings);
        return exporter;
    }

    private void asyncUpdateViewer(Display display, final Image image, final PreviewState state, final boolean largeImage, final Point origin) {
        if (Thread.currentThread() != display.getThread()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    PrintGanttSetupDialog.this.updateViewer(image, state, largeImage, origin);
                }
            });
        } else {
            this.updateViewer(image, state, largeImage, origin);
        }
    }

    public boolean close() {
        if (this.previewImageCreator != null) {
            this.previewImageCreator.dispose();
            this.previewImageCreator = null;
        }
        return super.close();
    }

    private int getMaxWidthPages() {
        TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
        RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue() + rangeModel.getExtent();
        int leftWidth = ExportConstants.round(value, this.ganttViewer.getWidthsSupport());
        TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        long startTime = this.settings.getLong("startTime");
        long endTime = this.settings.getLong("endTime");
        int rightWidth = 0;
        if (startTime != endTime) {
            rightWidth = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
        }
        int sourceWidth = leftWidth + rightWidth;
        int leftMarginPixel = ExportConstants.toPixel(this.getDouble("leftMargin", 0.25));
        int rightMarginPixel = ExportConstants.toPixel(this.getDouble("rightMargin", 0.25));
        int topMarginPixel = ExportConstants.toPixel(this.getDouble("topMargin", 0.25));
        int bottomMarginPixel = ExportConstants.toPixel(this.getDouble("bottomMargin", 0.25));
        int headerHeight = PrintUtils.getHeaderHeight((IDialogSettings)this.settings, (int)120);
        int footerHeight = PrintUtils.getBottomHeight((IDialogSettings)this.settings, (int)120);
        int orientation = this.getInteger("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int usefulPerPageWidth = perPageWidth - leftMarginPixel - rightMarginPixel;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        int usefulPerPageHeight = perPageHeight - topMarginPixel - bottomMarginPixel - headerHeight - footerHeight;
        double maxRatio = (double)usefulPerPageHeight / (double)(ExportConstants.HEADER_HEIGHT + ExportConstants.ITEM_HEIGHT);
        int maxWidthPages = (int)(maxRatio * (double)sourceWidth / (double)usefulPerPageWidth);
        return maxWidthPages;
    }

    private int getMaxHeightPages() {
        TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
        int contentHeight = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
        int maxHeightPages = contentHeight / ExportConstants.ITEM_HEIGHT;
        return maxHeightPages;
    }

    private int getHeightPageByWidth(int widthPages) {
        TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
        RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue() + rangeModel.getExtent();
        int leftWidth = ExportConstants.round(value, this.ganttViewer.getWidthsSupport());
        int headerHeight = headerViewer.getCanvas().getSize().y;
        TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
        int contentHeight = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
        TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        long startTime = this.settings.getLong("startTime");
        long endTime = this.settings.getLong("endTime");
        int rightWidth = 0;
        if (startTime != endTime) {
            rightWidth = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
        }
        int sourceWidth = leftWidth + rightWidth;
        int leftMarginPixel = ExportConstants.toPixel(this.getDouble("leftMargin", 0.25));
        int rightMarginPixel = ExportConstants.toPixel(this.getDouble("rightMargin", 0.25));
        int topMarginPixel = ExportConstants.toPixel(this.getDouble("topMargin", 0.25));
        int bottomMarginPixel = ExportConstants.toPixel(this.getDouble("bottomMargin", 0.25));
        int headerHeight2 = PrintUtils.getHeaderHeight((IDialogSettings)this.settings, (int)120);
        int footerHeight = PrintUtils.getBottomHeight((IDialogSettings)this.settings, (int)120);
        int orientation = this.getInteger("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int usefulPerPageWidth = perPageWidth - leftMarginPixel - rightMarginPixel;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        int usefulPerPageHeight = perPageHeight - topMarginPixel - bottomMarginPixel - headerHeight2 - footerHeight;
        double ratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
        int heightByRatio = (int)((double)usefulPerPageHeight / ratio);
        int lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
        int usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
        int heightPages = contentHeight / (usefulPerPageHeightByRatio - headerHeight);
        heightPages = contentHeight % (usefulPerPageHeightByRatio - headerHeight) == 0 ? heightPages : heightPages + 1;
        return heightPages;
    }

    private int getWidthPageByHeight(int heightPages) {
        TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
        RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue() + rangeModel.getExtent();
        int leftWidth = ExportConstants.round(value, this.ganttViewer.getWidthsSupport());
        int headerHeight = headerViewer.getCanvas().getSize().y;
        TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
        int contentHeight = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
        TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        long startTime = this.settings.getLong("startTime");
        long endTime = this.settings.getLong("endTime");
        int rightWidth = 0;
        if (startTime != endTime) {
            rightWidth = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
        }
        int sourceWidth = leftWidth + rightWidth;
        int leftMarginPixel = ExportConstants.toPixel(this.getDouble("leftMargin", 0.25));
        int rightMarginPixel = ExportConstants.toPixel(this.getDouble("rightMargin", 0.25));
        int topMarginPixel = ExportConstants.toPixel(this.getDouble("topMargin", 0.25));
        int bottomMarginPixel = ExportConstants.toPixel(this.getDouble("bottomMargin", 0.25));
        int headerHeight2 = PrintUtils.getHeaderHeight((IDialogSettings)this.settings, (int)120);
        int footerHeight = PrintUtils.getBottomHeight((IDialogSettings)this.settings, (int)120);
        int orientation = this.getInteger("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int usefulPerPageWidth = perPageWidth - leftMarginPixel - rightMarginPixel;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        int usefulPerPageHeight = perPageHeight - topMarginPixel - bottomMarginPixel - headerHeight2 - footerHeight;
        double ratio = (double)usefulPerPageHeight * (double)heightPages / (double)(contentHeight + heightPages * headerHeight);
        int heightByRatio = (int)((double)usefulPerPageHeight / ratio);
        int lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
        lines = (heightByRatio - headerHeight) % ExportConstants.ITEM_HEIGHT == 0 ? lines : lines + 1;
        int usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
        ratio = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio;
        int widthPages = sourceWidth / (int)((double)usefulPerPageWidth / ratio);
        widthPages = sourceWidth % (int)((double)usefulPerPageWidth / ratio) == 0 ? widthPages : widthPages + 1;
        return widthPages;
    }

    private Rectangle getImageBorderBounds() {
        int usefulPerPageHeightByRatio;
        int lines;
        int heightByRatio;
        double ratio;
        boolean fullWidth;
        TaskTreeHeaderViewer headerViewer = this.ganttViewer.getTaskTreeHeaderViewer();
        RangeModel rangeModel = headerViewer.getViewport().getHorizontalRangeModel();
        int value = rangeModel.getValue() + rangeModel.getExtent();
        int leftWidth = ExportConstants.round(value, this.ganttViewer.getWidthsSupport());
        int headerHeight = headerViewer.getCanvas().getSize().y;
        TaskTreeViewer taskTreeViewer = this.ganttViewer.getTaskTreeViewer();
        int contentHeight = ((FreeformLayer)taskTreeViewer.getLayer((Object)GEF.LAYER_CONTENTS)).getFreeformExtent().height;
        TimelineModel timelineModel = this.ganttViewer.getEditDomain().getTimelineModel();
        long startTime = this.settings.getLong("startTime");
        long endTime = this.settings.getLong("endTime");
        int rightWidth = 0;
        if (startTime != endTime) {
            rightWidth = timelineModel.getPixelsFromMillis(endTime - startTime) + 100;
        }
        int sourceWidth = leftWidth + rightWidth;
        int leftMarginPixel = ExportConstants.toPixel(this.getDouble("leftMargin", 0.25));
        int rightMarginPixel = ExportConstants.toPixel(this.getDouble("rightMargin", 0.25));
        int topMarginPixel = ExportConstants.toPixel(this.getDouble("topMargin", 0.25));
        int bottomMarginPixel = ExportConstants.toPixel(this.getDouble("bottomMargin", 0.25));
        int headerHeight2 = PrintUtils.getHeaderHeight((IDialogSettings)this.settings, (int)120);
        int footerHeight = PrintUtils.getBottomHeight((IDialogSettings)this.settings, (int)120);
        int orientation = this.getInteger("orientation", 2);
        int perPageWidth = orientation == 2 ? 1403 : 992;
        int usefulPerPageWidth = perPageWidth - leftMarginPixel - rightMarginPixel;
        int perPageHeight = orientation == 1 ? 1403 : 992;
        int usefulPerPageHeight = perPageHeight - topMarginPixel - bottomMarginPixel - headerHeight2 - footerHeight;
        int widthPages = this.getInteger("widthPages", 1);
        int heightPages = this.getInteger("heightPages", 1);
        boolean isAspectRatio = this.settings.getBoolean("aspectRatioLocked");
        boolean bl = fullWidth = !this.settings.getBoolean("fillHeight");
        if (!isAspectRatio) {
            double fillWidthratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            double fillHeightRatio = (double)usefulPerPageHeight * (double)heightPages / (double)(contentHeight + heightPages * headerHeight);
            int heightByRatio2 = (int)((double)usefulPerPageHeight / fillHeightRatio);
            int lines2 = (heightByRatio2 - headerHeight) / ExportConstants.ITEM_HEIGHT;
            lines2 = (heightByRatio2 - headerHeight) % ExportConstants.ITEM_HEIGHT == 0 ? lines2 : lines2 + 1;
            int usefulPerPageHeightByRatio2 = headerHeight + lines2 * ExportConstants.ITEM_HEIGHT;
            fillHeightRatio = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio2;
            fullWidth = fillWidthratio <= fillHeightRatio;
        }
        int usefulWidthPages = widthPages;
        int usefulHeightPages = heightPages;
        if (fullWidth) {
            ratio = (double)usefulPerPageWidth * (double)widthPages / (double)sourceWidth;
            heightByRatio = (int)((double)usefulPerPageHeight / ratio);
            lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
            usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
            usefulHeightPages = contentHeight / (usefulPerPageHeightByRatio - headerHeight);
            usefulHeightPages = contentHeight % (usefulPerPageHeightByRatio - headerHeight) == 0 ? usefulHeightPages : usefulHeightPages + 1;
        } else {
            ratio = (double)usefulPerPageHeight * (double)heightPages / (double)(contentHeight + heightPages * headerHeight);
            heightByRatio = (int)((double)usefulPerPageHeight / ratio);
            lines = (heightByRatio - headerHeight) / ExportConstants.ITEM_HEIGHT;
            lines = (heightByRatio - headerHeight) % ExportConstants.ITEM_HEIGHT == 0 ? lines : lines + 1;
            usefulPerPageHeightByRatio = headerHeight + lines * ExportConstants.ITEM_HEIGHT;
            ratio = (double)usefulPerPageHeight / (double)usefulPerPageHeightByRatio;
            usefulWidthPages = sourceWidth / (int)((double)usefulPerPageWidth / ratio);
            usefulWidthPages = sourceWidth % (int)((double)usefulPerPageWidth / ratio) == 0 ? usefulWidthPages : usefulWidthPages + 1;
        }
        int usefulPerPageWidthByRatio = (int)((double)usefulPerPageWidth / ratio);
        int leftMarginByRatio = (int)((double)leftMarginPixel / ratio);
        int topMarginByRation = (int)((double)(topMarginPixel + headerHeight2) / ratio);
        return new Rectangle(leftMarginByRatio, topMarginByRation, usefulPerPageWidthByRatio, usefulPerPageHeightByRatio);
    }

    private class AlignAction
    extends Action {
        private String key;
        private String value;

        public AlignAction(String key, String value) {
            super(null, 2);
            this.key = key;
            this.value = value;
            if ("left".equals(value)) {
                this.setText(DialogMessages.PageSetupDialog_AlignLeft_text);
                this.setToolTipText(DialogMessages.PageSetupDialog_AlignLeft_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("align_left.png", true));
            } else if ("center".equals(value)) {
                this.setText(DialogMessages.PageSetupDialog_AlignCenter_text);
                this.setToolTipText(DialogMessages.PageSetupDialog_AlignCenter_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("align_center.png", true));
            } else {
                this.setText(DialogMessages.PageSetupDialog_AlignRight_text);
                this.setToolTipText(DialogMessages.PageSetupDialog_AlignRight_toolTip);
                this.setImageDescriptor(MindMapUI.getImages().get("align_right.png", true));
            }
        }

        public void run() {
            PrintGanttSetupDialog.this.setProperty(this.key, this.value);
        }
    }

    private class FontAction
    extends Action {
        private String key;

        public FontAction(String key) {
            this.key = key;
            this.setText(DialogMessages.PageSetupDialog_Font_text);
            this.setToolTipText(DialogMessages.PageSetupDialog_Font_toolTip);
            this.setImageDescriptor(MindMapUI.getImages().get("text_font.png", true));
        }

        public void run() {
            FontDialog dialog = new FontDialog(PrintGanttSetupDialog.this.getShell());
            String string = PrintGanttSetupDialog.this.getString(this.key, null);
            if (string == null) {
                dialog.setFontList(JFaceResources.getDefaultFontDescriptor().getFontData());
            } else {
                dialog.setFontList(FontUtils.toFontData((String)string));
            }
            FontData open = dialog.open();
            if (open == null) {
                return;
            }
            PrintGanttSetupDialog.this.getSettings().put(this.key, FontUtils.toString((FontData[])dialog.getFontList()));
            PrintGanttSetupDialog.this.refreshWidthHeightPages();
            PrintGanttSetupDialog.this.update(this.key);
            PrintGanttSetupDialog.this.generatePreview(true);
        }
    }

    private class GeneratePreviewJob
    extends Job {
        private Display display;

        public GeneratePreviewJob(Display display) {
            super(GanttMessages.PrintGantt_Preview_jobName);
            this.display = display;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (PrintGanttSetupDialog.this.settings instanceof DialogSettingsDecorator && ((DialogSettingsDecorator)PrintGanttSetupDialog.this.settings).isDirty()) {
                return new Status(8, "org.xmind.ui", GanttMessages.PrintGanttSetupDialog_Generating_text);
            }
            monitor.beginTask(null, 100);
            monitor.worked(50);
            this.display.asyncExec(new Runnable(){

                public void run() {
                    PrintGanttSetupDialog.this.asyncUpdateViewer(GeneratePreviewJob.this.display, null, PreviewState.Showing, false, null);
                    PrintGanttSetupDialog.this.createPreviewImage();
                    PrintGanttSetupDialog.this.viewer.setImageIndex(0);
                    PrintGanttSetupDialog.this.viewer.initPreviewImageRatio();
                    if (!PrintGanttSetupDialog.this.getPreviewImageCreator(GeneratePreviewJob.this.display).checkImage()) {
                        PrintGanttSetupDialog.this.asyncUpdateViewer(GeneratePreviewJob.this.display, null, PreviewState.Error, false, null);
                    }
                }
            });
            monitor.worked(50);
            if (PrintGanttSetupDialog.this.generatePreviewJob == this) {
                PrintGanttSetupDialog.this.generatePreviewJob = null;
            }
            monitor.done();
            return new Status(0, "org.xmind.ui.gantt", GanttMessages.PrintGanttSetupDialog_Generated_text);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PreviewState {
        Showing(null, 16, 132096){

            public String getTitle(Image image, boolean largeImage) {
                if (image == null || image.isDisposed()) {
                    return super.getTitle(image, largeImage);
                }
                Rectangle r = image.getBounds();
                return String.format("%d x %d", r.width, r.height);
            }
        }
        ,
        Generating(GanttMessages.PrintGanttSetupDialog_Generating_text, 16, 0),
        Error(GanttMessages.PrintGanttSetupDialog_Failed_text, 4, 0){

            public String getTitle(Image image, boolean largeImage) {
                return PreviewState.makeErrorMessage(super.getTitle(image, largeImage), largeImage);
            }
        };

        private int colorId;
        private String title;
        private int titlePlacement;

        private static String makeErrorMessage(String originalMessage, boolean largeImage) {
            if (largeImage) {
                return String.valueOf(originalMessage) + " " + GanttMessages.PrintGanttSetupDialog_Large_text;
            }
            return originalMessage;
        }

        private PreviewState(String title, int colorId, int titlePlacement) {
            this.title = title;
            this.colorId = colorId;
            this.titlePlacement = titlePlacement;
        }

        public String getTitle(Image image, boolean largeImage) {
            return this.title;
        }

        public void setColor(Control control) {
            control.setForeground(control.getDisplay().getSystemColor(this.colorId));
        }

        public int getTitlePlacement() {
            return this.titlePlacement;
        }
    }
}

