/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.fishbone.structures;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.ReferencedLayoutData;
import org.xmind.gef.draw2d.geometry.Geometry;
import org.xmind.gef.draw2d.geometry.IPrecisionTransformer;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionInsets;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;
import org.xmind.gef.graphicalpolicy.IStructure;
import org.xmind.gef.part.IGraphicalPart;
import org.xmind.gef.part.IPart;
import org.xmind.ui.branch.AbstractBranchStructure;
import org.xmind.ui.branch.BoundaryLayoutHelper;
import org.xmind.ui.branch.IBranchPolicy;
import org.xmind.ui.branch.IInsertion;
import org.xmind.ui.branch.Insertion;
import org.xmind.ui.internal.figures.TopicFigure;
import org.xmind.ui.internal.fishbone.structures.FishboneData;
import org.xmind.ui.internal.fishbone.structures.IMainDirection;
import org.xmind.ui.internal.fishbone.structures.ISubDirection;
import org.xmind.ui.internal.fishbone.structures.MainFishboneData;
import org.xmind.ui.internal.fishbone.structures.Side;
import org.xmind.ui.internal.fishbone.structures.SubFishboneStructure;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.mindmap.IBranchRangePart;
import org.xmind.ui.mindmap.INodePart;
import org.xmind.ui.mindmap.IPlusMinusPart;
import org.xmind.ui.mindmap.ISummaryPart;
import org.xmind.ui.mindmap.ITopicPart;
import org.xmind.ui.tools.ParentSearchKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainFishboneStructure
extends AbstractBranchStructure {
    private static final double sin = Math.sin(Math.toRadians(70.0));
    private static final double cos = Math.cos(Math.toRadians(70.0));
    private static final double fMajor = 0.5;
    private static final double fMinor = 5.0;
    private final IMainDirection direction;
    private static final Dimension INSERTION_SIZE = new Dimension(30, 1);

    public MainFishboneStructure(IMainDirection direction) {
        this.direction = direction;
    }

    protected void addExtraSpaces(IBranchPart branch, ReferencedLayoutData data) {
        super.addExtraSpaces(branch, data);
        Insets insets = new Insets();
        if (this.direction == IMainDirection.LeftHeaded) {
            insets.right = 35;
        } else {
            insets.left = 35;
        }
        data.addMargins(insets);
    }

    protected void doFillPlusMinus(IBranchPart branch, IPlusMinusPart plusMinus, AbstractBranchStructure.LayoutInfo info) {
        Point ref = info.getReference();
        MainFishboneData fd = this.getCastedData(branch);
        fd.setOrigin(ref);
        Rectangle topicBounds = info.getCheckedClientArea();
        topicBounds = fd.hf.tr(topicBounds);
        IFigure figure = plusMinus.getFigure();
        Dimension size = figure.getPreferredSize();
        int x = topicBounds.right() + 1;
        int y = ref.y - size.height / 2;
        Rectangle r = new Rectangle(x, y, size.width, size.height);
        info.put(figure, fd.hf.rr(r));
    }

    protected void doFillSubBranches(IBranchPart branch, List<IBranchPart> subBranches, AbstractBranchStructure.LayoutInfo info) {
        double mainSpacing = (double)this.getMajorSpacing(branch) * 0.5;
        double subSpacing = (double)this.getMinorSpacing(branch) * 5.0;
        Point ref = info.getReference();
        MainFishboneData fd = this.getCastedData(branch);
        fd.setOrigin(ref);
        Rectangle refBounds = info.getCheckedClientArea();
        refBounds = fd.hf.tr(refBounds);
        fd.upSide.start((double)refBounds.right() + mainSpacing);
        fd.downSide.start(fd.upSide.right + subSpacing);
        int num = subBranches.size();
        IInsertion insertion = this.getCurrentInsertion(branch);
        BoundaryLayoutHelper helper = this.getBoundaryLayoutHelper(branch);
        Side lastSide = fd.downSide;
        double width = 0.0;
        int i = 0;
        while (i < num) {
            double rotatedBottom;
            double joint;
            PrecisionInsets fChildBranchNormal;
            IBranchPart subBranch = subBranches.get(i);
            IFigure subBranchFigure = subBranch.getFigure();
            Insets ins = helper.getInsets(subBranch);
            boolean upwards = this.getCastedData(branch).isUpwardBranch(i);
            Side side = upwards ? fd.upSide : fd.downSide;
            IPrecisionTransformer pvf = fd.pvf;
            pvf.setEnabled(!upwards);
            PrecisionInsets fChildBorder = pvf.ti(fd.phf.ti(new PrecisionInsets(ins)));
            if (fChildBorder.left != 0.0) {
                side.useRight = false;
            }
            PrecisionRectangle childBounds = new PrecisionRectangle();
            IBranchPolicy branchPolicy = subBranch.getBranchPolicy();
            IStructure sa = branchPolicy.getStructure((IGraphicalPart)subBranch);
            FishboneData sub = this.getFishboneData(subBranch, sa);
            if (sub != null) {
                PrecisionInsets fChildBranchRotated = pvf.ti(fd.phf.ti(sub.rBranchRefIns));
                fChildBranchNormal = fd.phf.ti(sub.branchRefIns);
                PrecisionInsets fChildTopicNormal = fd.phf.ti(sub.topicRefIns);
                double left = fChildBranchRotated.left + fChildBorder.left;
                double bottom = fChildBranchRotated.bottom + mainSpacing + fChildBorder.bottom;
                double jointOff = left - (bottom * cos - fChildTopicNormal.bottom) / sin;
                if (side.useRight) {
                    double rotatedSpacing = (fChildBranchNormal.top + fChildTopicNormal.bottom) / sin;
                    joint = side.rotatedBottom + rotatedSpacing;
                } else {
                    joint = Math.max(side.right, side.right + jointOff);
                }
                if (!upwards || i > 0) {
                    joint = Math.max(joint, lastSide.lastJoint + subSpacing);
                }
                Dimension size = subBranchFigure.getPreferredSize();
                childBounds.setSize((double)size.width, (double)size.height);
                childBounds.x = joint - jointOff;
                childBounds.y = side == fd.upSide ? (double)(ref.y - size.height) - mainSpacing - fChildBorder.bottom : (double)ref.y + mainSpacing + fChildBorder.bottom;
                if (fChildBorder.getHeight() != 0.0 && width <= childBounds.right()) {
                    width = childBounds.right();
                }
                rotatedBottom = joint + (fChildBranchNormal.bottom - fChildTopicNormal.bottom) / sin + subSpacing;
            } else {
                PrecisionInsets childBranchNormal = new PrecisionInsets(((IReferencedFigure)subBranchFigure).getReferenceDescription());
                fChildBranchNormal = pvf.ti(fd.phf.ti(childBranchNormal));
                double bottom = fChildBranchNormal.bottom + mainSpacing;
                double rotatedSpacing = fChildBranchNormal.top * cos / sin;
                joint = side.useRight ? side.rotatedBottom + rotatedSpacing : side.right;
                if (!upwards || i > 0) {
                    joint = Math.max(joint, lastSide.lastJoint + subSpacing);
                }
                double jointOff = bottom * cos / sin;
                Dimension size = subBranchFigure.getPreferredSize();
                childBounds.setSize((double)size.width, (double)size.height);
                childBounds.x = joint + jointOff;
                childBounds.y = side == fd.upSide ? (double)(ref.y - size.height) - mainSpacing - fChildBorder.bottom : (double)ref.y + mainSpacing + fChildBorder.bottom;
                if (fChildBorder.getHeight() != 0.0 && width <= childBounds.right()) {
                    width = childBounds.right();
                }
                rotatedBottom = joint + fChildBranchNormal.getWidth() + fChildBranchNormal.bottom * cos / sin + subSpacing;
            }
            if (insertion != null && i >= insertion.getIndex()) {
                childBounds.x += (double)insertion.getSize().width;
            }
            IPrecisionTransformer phf = fd.phf;
            PrecisionRectangle precRect = phf.rr(childBounds);
            Rectangle rect = precRect.toDraw2DRectangle();
            info.put(subBranchFigure, rect);
            side.lastJoint = joint;
            side.useRight = fChildBorder.right == 0.0;
            side.rotatedBottom = rotatedBottom;
            side.right = side.useRight ? childBounds.right() + subSpacing / 3.0 : width + subSpacing / 3.0;
            lastSide = side;
            ++i;
        }
    }

    private FishboneData getFishboneData(IBranchPart subBranch, IStructure sa) {
        if (sa instanceof SubFishboneStructure) {
            return ((SubFishboneStructure)sa).getCastedData(subBranch).getFishboneData();
        }
        return null;
    }

    protected Object createStructureData(IBranchPart branch) {
        return new MainFishboneData(branch, this.direction.isTransformerEnabled());
    }

    protected boolean isValidStructureData(IBranchPart branch, Object data) {
        return super.isValidStructureData(branch, data) && data instanceof MainFishboneData;
    }

    protected MainFishboneData getCastedData(IBranchPart branch) {
        return (MainFishboneData)((Object)super.getStructureData(branch));
    }

    public int calcChildDistance(IBranchPart branch, ParentSearchKey key) {
        Point childRef = key.getFigure().getReference();
        Point branchRef = this.getReference(branch);
        MainFishboneData fd = this.getCastedData(branch);
        fd.setOrigin(branchRef);
        PrecisionPoint source = this.calcSourceAnchorLocation(branch);
        int jointOffset = this.calcChildJointOffset(branch, key.getFeedback(), source);
        if (jointOffset > 0) {
            int dy;
            int range;
            Rectangle childrenNodesBounds = this.getChildrenNodesBounds(branch);
            if (childrenNodesBounds != null) {
                Rectangle r = fd.hf.tr(childrenNodesBounds);
                range = r.right() - branchRef.x + 100;
            } else {
                range = 200;
            }
            if (jointOffset < range && (dy = Math.abs(childRef.y - branchRef.y)) < 200) {
                return dy;
            }
        }
        return super.calcChildDistance(branch, key);
    }

    private PrecisionPoint calcSourceAnchorLocation(IBranchPart branch) {
        return ((INodePart)branch.getTopicPart()).getSourceAnchor((IGraphicalPart)branch).getLocation(this.getSourceOrientation(branch), 0.0);
    }

    private Rectangle getChildrenNodesBounds(IBranchPart branch) {
        Rectangle r = null;
        for (IBranchPart subbranch : branch.getSubBranches()) {
            r = Geometry.union(r, (Rectangle)subbranch.getTopicPart().getFigure().getBounds());
        }
        return r;
    }

    private int calcChildJointOffset(IBranchPart branch, IBranchPart child, PrecisionPoint source) {
        double angle = this.calcChildRotateAngle(branch, child);
        PrecisionPoint target = this.calcChildTargetLocation(branch, child, source);
        PrecisionDimension d = target.getDifference(source);
        int w = (int)Math.floor(d.height / Math.tan(Math.toRadians(angle)) + 1.0E-7);
        int offset = (int)Math.floor(d.width - (double)w + 1.0E-7);
        if (this.direction == IMainDirection.RightHeaded) {
            return -offset;
        }
        return offset;
    }

    private PrecisionPoint calcChildTargetLocation(IBranchPart branch, IBranchPart child, PrecisionPoint source) {
        IAnchor anchor;
        ITopicPart topic = child.getTopicPart();
        if (topic instanceof INodePart && (anchor = ((INodePart)topic).getTargetAnchor((IGraphicalPart)branch)) != null) {
            return anchor.getLocation(this.getChildTargetOrientation(branch, child), 0.0);
        }
        return new PrecisionPoint(this.getReference(child));
    }

    public boolean isChildUpwards(IBranchPart branch, IBranchPart child) {
        return this.isChildUpwards(branch, child, branch.getSubBranches().indexOf(child));
    }

    private boolean isChildUpwards(IBranchPart branch, IBranchPart child, int childIndex) {
        if (childIndex < 0) {
            Point branchRef = this.getReference(branch);
            Point childRef = this.getReference(child);
            return childRef.y < branchRef.y;
        }
        return this.getCastedData(branch).isUpwardBranch(childIndex);
    }

    private Point getReference(IBranchPart branch) {
        ITopicPart topic = branch.getTopicPart();
        if (topic != null) {
            return ((IReferencedFigure)topic.getFigure()).getReference();
        }
        return ((IReferencedFigure)branch.getFigure()).getReference();
    }

    private double calcChildRotateAngle(IBranchPart branch, IBranchPart child) {
        return this.isChildUpwards(branch, child) ? this.direction.getUpRotated().getRotateAngle() : this.direction.getDownRotated().getRotateAngle();
    }

    protected int calcInsIndex(IBranchPart branch, ParentSearchKey key, boolean withDisabled) {
        if (branch.getSubBranches().isEmpty() || branch.isFolded()) {
            return withDisabled ? 0 : -1;
        }
        PrecisionPoint source = this.calcSourceAnchorLocation(branch);
        int jointOffset = this.calcChildJointOffset(branch, key.getFeedback(), source);
        List subBranches = branch.getSubBranches();
        int num = subBranches.size();
        IInsertion lastInsertion = this.getCurrentInsertion(branch);
        int ret = 0;
        int i = 0;
        while (i < num) {
            int hint;
            IBranchPart subBranch = (IBranchPart)subBranches.get(i);
            int j = this.calcChildJointOffset(branch, subBranch, source);
            if (lastInsertion != null && i >= lastInsertion.getIndex()) {
                j -= lastInsertion.getSize().width;
            }
            if (jointOffset < (hint = j)) {
                return ret;
            }
            if (withDisabled || subBranch.getFigure().isEnabled()) {
                ++ret;
            }
            ++i;
        }
        return withDisabled ? num : -1;
    }

    public IInsertion calcInsertion(IBranchPart branch, ParentSearchKey key) {
        return new Insertion(branch, this.calcInsIndex(branch, key, true), INSERTION_SIZE);
    }

    public IPart calcChildNavigation(IBranchPart branch, IBranchPart sourceChild, String navReqType, boolean sequential) {
        if ("navigate_down".equals(navReqType) || "navigate_up".equals(navReqType)) {
            int childIndex = sourceChild.getBranchIndex();
            boolean upwards = this.isChildUpwards(branch, sourceChild, childIndex);
            if (upwards && "navigate_down".equals(navReqType) || !upwards && "navigate_up".equals(navReqType)) {
                int i = childIndex - 1;
                while (i >= 0) {
                    IBranchPart sub = (IBranchPart)branch.getSubBranches().get(i);
                    if (this.isChildUpwards(branch, sub, i) != upwards) {
                        return sub.getTopicPart();
                    }
                    --i;
                }
                return this.getSubTopicPart(branch, childIndex + 1);
            }
        } else {
            boolean prev;
            boolean next = this.direction == IMainDirection.LeftHeaded && "navigate_right".equals(navReqType) || this.direction == IMainDirection.RightHeaded && "navigate_left".equals(navReqType);
            boolean bl = prev = this.direction == IMainDirection.LeftHeaded && "navigate_left".equals(navReqType) || this.direction == IMainDirection.RightHeaded && "navigate_right".equals(navReqType);
            if (next || prev) {
                int childIndex = sourceChild.getBranchIndex();
                boolean upwards = this.isChildUpwards(branch, sourceChild, childIndex);
                int i = prev ? childIndex - 1 : childIndex + 1;
                while (!(prev ? i < 0 : i >= branch.getSubBranches().size())) {
                    IBranchPart sub = (IBranchPart)branch.getSubBranches().get(i);
                    if (this.isChildUpwards(branch, sourceChild, i) == upwards) {
                        return sub.getTopicPart();
                    }
                    if (prev) {
                        --i;
                        continue;
                    }
                    ++i;
                }
                if (prev && !sequential) {
                    ITopicPart prevTopic = this.getSubTopicPart(branch, childIndex - 1);
                    if (prevTopic != null) {
                        return prevTopic;
                    }
                    return branch.getTopicPart();
                }
                return this.getSubTopicPart(branch, childIndex + 1);
            }
        }
        return super.calcChildNavigation(branch, sourceChild, navReqType, sequential);
    }

    public IPart calcNavigation(IBranchPart branch, String navReqType) {
        if (this.direction == IMainDirection.RightHeaded ? "navigate_left".equals(navReqType) : "navigate_right".equals(navReqType)) {
            return this.getSubTopicPart(branch, 0);
        }
        return super.calcNavigation(branch, navReqType);
    }

    public int getChildTargetOrientation(IBranchPart branch, IBranchPart subBranch) {
        int index = branch.getSubBranches().indexOf(subBranch);
        if (index < 0) {
            return this.direction == IMainDirection.RightHeaded ? 16 : 8;
        }
        if (this.isChildUpwards(branch, subBranch, index)) {
            if (this.direction == IMainDirection.RightHeaded) {
                return 16;
            }
            return 8;
        }
        if (this.direction == IMainDirection.RightHeaded) {
            return 8;
        }
        return 16;
    }

    public int getSourceOrientation(IBranchPart branch) {
        if (this.direction == IMainDirection.RightHeaded) {
            return 8;
        }
        return 16;
    }

    public int getRangeGrowthDirection(IBranchPart branch, IBranchRangePart range) {
        if (this.direction == IMainDirection.RightHeaded) {
            return 8;
        }
        return 16;
    }

    public int getSummaryDirection(IBranchPart branch, ISummaryPart summary) {
        List enclosing = summary.getEnclosingBranches();
        if (!enclosing.isEmpty()) {
            if (this.getCastedData(branch).isUpwardBranch(((IBranchPart)enclosing.get(0)).getBranchIndex())) {
                return 1;
            }
            return 4;
        }
        return 1;
    }

    public int getQuickMoveOffset(IBranchPart branch, IBranchPart child, int direction) {
        if (direction == 16) {
            if (this.direction == IMainDirection.RightHeaded) {
                return -1;
            }
            return 1;
        }
        if (direction == 8) {
            if (this.direction == IMainDirection.RightHeaded) {
                return 1;
            }
            return -1;
        }
        return super.getQuickMoveOffset(branch, child, direction);
    }

    protected Point calcInsertPosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List subBranches = branch.getSubBranches();
        if (subBranches.isEmpty()) {
            return this.calcFirstChildPosition(branch, key);
        }
        int index = this.calcInsIndex(branch, key, true);
        if (index == subBranches.size()) {
            return this.calcInventPosition((IBranchPart)subBranches.get(index - 1), null, key, false);
        }
        return this.calcInventPosition((IBranchPart)subBranches.get(index), null, key, true);
    }

    protected Point calcMovePosition(IBranchPart branch, IBranchPart child, ParentSearchKey key) {
        List subBranches = branch.getSubBranches();
        List disables = this.getDisableBranches(branch);
        int index = this.calcInsIndex(branch, key, true);
        int oldIndex = this.getOldIndex(branch, child);
        if (disables != null) {
            if (disables.contains(index - 1)) {
                oldIndex = --index;
            } else if (disables.contains(index)) {
                oldIndex = index;
            }
        }
        Dimension inventSize = key.getInvent().getSize();
        boolean upWard = (index + 1) % 2 == 0;
        boolean leftWard = IMainDirection.LeftHeaded.equals(this.direction);
        if (index == oldIndex) {
            IBranchPart sub = (IBranchPart)subBranches.get(index);
            Dimension size = sub.getTopicPart().getFigure().getSize();
            double w = ((double)size.height * sin - (double)size.width * cos) / (sin * sin - cos * cos);
            double deltaX = (double)size.width * 0.5 - w * cos + (double)inventSize.width * 0.5 + (double)inventSize.width * cos * 0.5;
            double deltaY = upWard ? ((double)(-size.height) + (double)inventSize.width * sin) * 0.5 : ((double)size.height - (double)inventSize.width * sin) * 0.5;
            return this.getReference(sub).getTranslated(leftWard ? deltaX : -deltaX, deltaY);
        }
        return this.calcInsertPosition(branch, child, key);
    }

    protected Point calcInventPosition(IBranchPart orientation, IBranchPart assist, ParentSearchKey key, boolean isBeforeOrientation) {
        double x;
        double y;
        Dimension inventSize = key.getInvent().getSize();
        Dimension insSize = key.getFigure().getSize();
        double deltaY = (double)inventSize.width * sin * 0.5;
        boolean upwards = this.isChildUpwards(orientation.getParentBranch(), orientation);
        double d = y = upwards ^ isBeforeOrientation ? deltaY : -deltaY;
        if (isBeforeOrientation) {
            double offset = this.calcBeforeOffset(orientation);
            double deltaX = ((double)insSize.height / sin - (double)inventSize.width * cos - (double)inventSize.width) * 0.5;
            x = offset + (this.direction.equals(IMainDirection.RightHeaded) ? deltaX : -deltaX);
        } else {
            Rectangle pBounds = orientation.getParentBranch().getFigure().getBounds();
            x = this.direction.equals(IMainDirection.RightHeaded) ? pBounds.x : pBounds.right();
        }
        return new Point().getTranslated(x, y);
    }

    private double calcBeforeOffset(IBranchPart branch) {
        double offset = 0.0;
        double cot = cos / sin;
        List callouts = branch.getCalloutBranches();
        if (callouts == null || callouts.isEmpty()) {
            IFigure figure = branch.getTopicPart().getFigure();
            Rectangle bounds = figure.getBounds();
            double height = ((TopicFigure)figure).getNormalPreferredBounds((Point)new Point()).height;
            double delta = height * cos * cot;
            offset = this.direction.equals(IMainDirection.RightHeaded) ? (double)bounds.right() + delta : (double)bounds.x - delta;
        } else {
            Rectangle bounds = branch.getFigure().getBounds();
            offset = this.direction.equals(IMainDirection.RightHeaded) ? bounds.right() : bounds.x;
            for (IBranchPart callout : callouts) {
                Rectangle calloutBounds = callout.getFigure().getBounds();
                if (this.direction.equals(ISubDirection.NE)) {
                    Point tl = calloutBounds.getTopLeft();
                    offset = Math.min(offset, (double)tl.x - (double)(-tl.y) * cot);
                    continue;
                }
                if (this.direction.equals(ISubDirection.SE)) {
                    Point bl = calloutBounds.getBottomLeft();
                    offset = Math.min(offset, (double)bl.x - (double)bl.y * cot);
                    continue;
                }
                if (this.direction.equals(ISubDirection.NW)) {
                    Point tr = calloutBounds.getTopRight();
                    offset = Math.max(offset, (double)tr.x + (double)tr.y * cot);
                    continue;
                }
                Point br = calloutBounds.getBottomRight();
                offset = Math.max(offset, (double)br.x + (double)br.y * cot);
            }
        }
        return offset;
    }

    protected Point calcFirstChildPosition(IBranchPart branch, ParentSearchKey key) {
        double minorSpacing = (double)this.getMinorSpacing(branch) * 5.0;
        double x = (double)branch.getFigure().getSize().width * 0.5 + (double)key.getFigure().getSize().width * 0.5;
        return this.getFigureLocation(branch.getFigure()).getTranslated(IMainDirection.LeftHeaded.equals(this.direction) ? x : -x, -minorSpacing);
    }
}

