/* hapmapPhaseIIISummary.h was originally generated by the autoSql program, which also 
 * generated hapmapPhaseIIISummary.c and hapmapPhaseIIISummary.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef HAPMAPPHASEIIISUMMARY_H
#define HAPMAPPHASEIIISUMMARY_H

#define HAPMAPPHASEIIISUMMARY_NUM_COLS 18

struct hapmapPhaseIIISummary
/* HapMap Phase III allele summaries for filtering (BED 5+) */
    {
    struct hapmapPhaseIIISummary *next;  /* Next in singly linked list. */
    char *chrom;	/* Chromosome */
    unsigned chromStart;	/* Start position in chrom (0 based) */
    unsigned chromEnd;	/* End position in chrom (1 based) */
    char *name;	/* Reference SNP identifier from dbSnp */
    unsigned score;	/* Average of population heterozygosities in parts per thousand (0-500) */
    char *observed;	/* Observed string from genotype file */
    char overallMajorAllele;	/* This allele has been observed in at least half of the populations that have data for this SNP */
    char overallMinorAllele;	/* This allele may not have been observed in any HapMap sample */
    unsigned char popCount;	/* How many Phase III populations have data (1-11) */
    unsigned char phaseIIPopCount;	/* How many Phase II populations have data (0-4) */
    unsigned char isMixed;	/* 0 if all populations have the same major allele, 1 otherwise. */
    unsigned char foundInPop[11];	/* Got data for each of the 11 Phase III populations? */
    unsigned char monomorphicInPop[11];	/* Monomorphic in each of the 11 Phase III populations? */
    float minFreq;	/* Minimum minor allele frequency across all populations */
    float maxFreq;	/* Maximum minor allele frequency across all populations */
    unsigned orthoCount;	/* Species for which orthologous alleles have been determined */
    char *orthoAlleles;	/* Orthologous allele for each species (or N if not found) */
    unsigned short *orthoQuals;	/* Base quality score (0-100) for each species */
    };

struct hapmapPhaseIIISummary *hapmapPhaseIIISummaryLoad(char **row);
/* Load a hapmapPhaseIIISummary from row fetched with select * from hapmapPhaseIIISummary
 * from database.  Dispose of this with hapmapPhaseIIISummaryFree(). */

struct hapmapPhaseIIISummary *hapmapPhaseIIISummaryLoadAll(char *fileName);
/* Load all hapmapPhaseIIISummary from whitespace-separated file.
 * Dispose of this with hapmapPhaseIIISummaryFreeList(). */

struct hapmapPhaseIIISummary *hapmapPhaseIIISummaryLoadAllByChar(char *fileName, char chopper);
/* Load all hapmapPhaseIIISummary from chopper separated file.
 * Dispose of this with hapmapPhaseIIISummaryFreeList(). */

#define hapmapPhaseIIISummaryLoadAllByTab(a) hapmapPhaseIIISummaryLoadAllByChar(a, '\t');
/* Load all hapmapPhaseIIISummary from tab separated file.
 * Dispose of this with hapmapPhaseIIISummaryFreeList(). */

struct hapmapPhaseIIISummary *hapmapPhaseIIISummaryCommaIn(char **pS, struct hapmapPhaseIIISummary *ret);
/* Create a hapmapPhaseIIISummary out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new hapmapPhaseIIISummary */

void hapmapPhaseIIISummaryFree(struct hapmapPhaseIIISummary **pEl);
/* Free a single dynamically allocated hapmapPhaseIIISummary such as created
 * with hapmapPhaseIIISummaryLoad(). */

void hapmapPhaseIIISummaryFreeList(struct hapmapPhaseIIISummary **pList);
/* Free a list of dynamically allocated hapmapPhaseIIISummary's */

void hapmapPhaseIIISummaryOutput(struct hapmapPhaseIIISummary *el, FILE *f, char sep, char lastSep);
/* Print out hapmapPhaseIIISummary.  Separate fields with sep. Follow last field with lastSep. */

#define hapmapPhaseIIISummaryTabOut(el,f) hapmapPhaseIIISummaryOutput(el,f,'\t','\n');
/* Print out hapmapPhaseIIISummary as a line in a tab-separated file. */

#define hapmapPhaseIIISummaryCommaOut(el,f) hapmapPhaseIIISummaryOutput(el,f,',',',');
/* Print out hapmapPhaseIIISummary as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* HAPMAPPHASEIIISUMMARY_H */

