/* newTest.h was originally generated by the autoSql program, which also 
 * generated newTest.c and newTest.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef NEWTEST_H
#define NEWTEST_H

#include "jksql.h"
#define POINT_NUM_COLS 2

struct point
/* A simple point */
    {
    struct point *next;  /* Next in singly linked list. */
    int x;	/* horizontal position left to right */
    int y;	/* vertical position top to bottom */
    };

struct point *pointLoad(char **row);
/* Load a point from row fetched with select * from point
 * from database.  Dispose of this with pointFree(). */

struct point *pointLoadAll(char *fileName);
/* Load all point from whitespace-separated file.
 * Dispose of this with pointFreeList(). */

struct point *pointLoadAllByChar(char *fileName, char chopper);
/* Load all point from chopper separated file.
 * Dispose of this with pointFreeList(). */

#define pointLoadAllByTab(a) pointLoadAllByChar(a, '\t');
/* Load all point from tab separated file.
 * Dispose of this with pointFreeList(). */

struct point *pointCommaIn(char **pS, struct point *ret);
/* Create a point out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new point */

void pointFree(struct point **pEl);
/* Free a single dynamically allocated point such as created
 * with pointLoad(). */

void pointFreeList(struct point **pList);
/* Free a list of dynamically allocated point's */

void pointOutput(struct point *el, FILE *f, char sep, char lastSep);
/* Print out point.  Separate fields with sep. Follow last field with lastSep. */

#define pointTabOut(el,f) pointOutput(el,f,'\t','\n');
/* Print out point as a line in a tab-separated file. */

#define pointCommaOut(el,f) pointOutput(el,f,',',',');
/* Print out point as a comma separated list including final comma. */

#define AUTOTEST_NUM_COLS 11

struct autoTest
/* Just a test */
    {
    struct autoTest *next;  /* Next in singly linked list. */
    unsigned id;	/* Unique ID */
    char shortName[13];	/* 12 character or less name */
    char *longName;	/* full name */
    char *aliases[3];	/* three nick-names */
    int ptCount;	/* number of points */
    short *pts;	/* point list */
    int difCount;	/* number of difs */
    unsigned char *difs;	/* dif list */
    struct point *xy;	/* 2d coordinate */
    int valCount;	/* value count */
    char **vals;	/* list of values */
    };

struct autoTest *autoTestLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all autoTest from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with autoTestFreeList(). */

void autoTestSaveToDb(struct sqlConnection *conn, struct autoTest *el, char *tableName, int updateSize);
/* Save autoTest as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use autoTestSaveToDbEscaped() */

void autoTestSaveToDbEscaped(struct sqlConnection *conn, struct autoTest *el, char *tableName, int updateSize);
/* Save autoTest as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than autoTestSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct autoTest *autoTestLoad(char **row);
/* Load a autoTest from row fetched with select * from autoTest
 * from database.  Dispose of this with autoTestFree(). */

struct autoTest *autoTestLoadAll(char *fileName);
/* Load all autoTest from whitespace-separated file.
 * Dispose of this with autoTestFreeList(). */

struct autoTest *autoTestLoadAllByChar(char *fileName, char chopper);
/* Load all autoTest from chopper separated file.
 * Dispose of this with autoTestFreeList(). */

#define autoTestLoadAllByTab(a) autoTestLoadAllByChar(a, '\t');
/* Load all autoTest from tab separated file.
 * Dispose of this with autoTestFreeList(). */

struct autoTest *autoTestCommaIn(char **pS, struct autoTest *ret);
/* Create a autoTest out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new autoTest */

void autoTestFree(struct autoTest **pEl);
/* Free a single dynamically allocated autoTest such as created
 * with autoTestLoad(). */

void autoTestFreeList(struct autoTest **pList);
/* Free a list of dynamically allocated autoTest's */

void autoTestOutput(struct autoTest *el, FILE *f, char sep, char lastSep);
/* Print out autoTest.  Separate fields with sep. Follow last field with lastSep. */

#define autoTestTabOut(el,f) autoTestOutput(el,f,'\t','\n');
/* Print out autoTest as a line in a tab-separated file. */

#define autoTestCommaOut(el,f) autoTestOutput(el,f,',',',');
/* Print out autoTest as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* NEWTEST_H */

