/* affyProbe.c was originally generated by the autoSql program, which also 
 * generated affyProbe.h and affyProbe.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "affyProbe.h"


struct affyProbe *affyProbeLoad(char **row)
/* Load a affyProbe from row fetched with select * from affyProbe
 * from database.  Dispose of this with affyProbeFree(). */
{
struct affyProbe *ret;
int sizeOne;
AllocVar(ret);
ret->blockCount = sqlUnsigned(row[9]);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->psName = cloneString(row[3]);
ret->transId = sqlSigned(row[4]);
strcpy(ret->strand, row[5]);
ret->thickStart = sqlUnsigned(row[6]);
ret->thickEnd = sqlUnsigned(row[7]);
ret->reserved = sqlUnsigned(row[8]);
sqlSignedDynamicArray(row[10], &ret->blockSizes, &sizeOne);
assert(sizeOne == ret->blockCount);
sqlSignedDynamicArray(row[11], &ret->chromStarts, &sizeOne);
assert(sizeOne == ret->blockCount);
ret->seq = cloneString(row[12]);
ret->transcriptId = sqlSigned(row[13]);
ret->geneName = cloneString(row[14]);
ret->probeSetType = cloneString(row[15]);
ret->avgRawProbeScore = atof(row[16]);
ret->exonPos = sqlSigned(row[17]);
ret->rawProbeScore = atof(row[18]);
ret->xhyCount = sqlSigned(row[19]);
return ret;
}

struct affyProbe *affyProbeLoadAll(char *fileName) 
/* Load all affyProbe from a whitespace-separated file.
 * Dispose of this with affyProbeFreeList(). */
{
struct affyProbe *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[20];

while (lineFileRow(lf, row))
    {
    el = affyProbeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct affyProbe *affyProbeLoadAllByChar(char *fileName, char chopper) 
/* Load all affyProbe from a chopper separated file.
 * Dispose of this with affyProbeFreeList(). */
{
struct affyProbe *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[20];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = affyProbeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct affyProbe *affyProbeCommaIn(char **pS, struct affyProbe *ret)
/* Create a affyProbe out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new affyProbe */
{
char *s = *pS;
int i;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->psName = sqlStringComma(&s);
ret->transId = sqlSignedComma(&s);
sqlFixedStringComma(&s, ret->strand, sizeof(ret->strand));
ret->thickStart = sqlUnsignedComma(&s);
ret->thickEnd = sqlUnsignedComma(&s);
ret->reserved = sqlUnsignedComma(&s);
ret->blockCount = sqlUnsignedComma(&s);
s = sqlEatChar(s, '{');
AllocArray(ret->blockSizes, ret->blockCount);
for (i=0; i<ret->blockCount; ++i)
    {
    ret->blockSizes[i] = sqlSignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
s = sqlEatChar(s, '{');
AllocArray(ret->chromStarts, ret->blockCount);
for (i=0; i<ret->blockCount; ++i)
    {
    ret->chromStarts[i] = sqlSignedComma(&s);
    }
s = sqlEatChar(s, '}');
s = sqlEatChar(s, ',');
ret->seq = sqlStringComma(&s);
ret->transcriptId = sqlSignedComma(&s);
ret->geneName = sqlStringComma(&s);
ret->probeSetType = sqlStringComma(&s);
ret->avgRawProbeScore = sqlDoubleComma(&s);
ret->exonPos = sqlSignedComma(&s);
ret->rawProbeScore = sqlDoubleComma(&s);
ret->xhyCount = sqlSignedComma(&s);
*pS = s;
return ret;
}

void affyProbeFree(struct affyProbe **pEl)
/* Free a single dynamically allocated affyProbe such as created
 * with affyProbeLoad(). */
{
struct affyProbe *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->psName);
freeMem(el->blockSizes);
freeMem(el->chromStarts);
freeMem(el->seq);
freeMem(el->geneName);
freeMem(el->probeSetType);
freez(pEl);
}

void affyProbeFreeList(struct affyProbe **pList)
/* Free a list of dynamically allocated affyProbe's */
{
struct affyProbe *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    affyProbeFree(&el);
    }
*pList = NULL;
}

void affyProbeOutput(struct affyProbe *el, FILE *f, char sep, char lastSep) 
/* Print out affyProbe.  Separate fields with sep. Follow last field with lastSep. */
{
int i;
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->psName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->transId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->strand);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->thickStart);
fputc(sep,f);
fprintf(f, "%u", el->thickEnd);
fputc(sep,f);
fprintf(f, "%u", el->reserved);
fputc(sep,f);
fprintf(f, "%u", el->blockCount);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->blockCount; ++i)
    {
    fprintf(f, "%d", el->blockSizes[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(sep,f);
if (sep == ',') fputc('{',f);
for (i=0; i<el->blockCount; ++i)
    {
    fprintf(f, "%d", el->chromStarts[i]);
    fputc(',', f);
    }
if (sep == ',') fputc('}',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->seq);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->transcriptId);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->geneName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->probeSetType);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%f", el->avgRawProbeScore);
fputc(sep,f);
fprintf(f, "%d", el->exonPos);
fputc(sep,f);
fprintf(f, "%f", el->rawProbeScore);
fputc(sep,f);
fprintf(f, "%d", el->xhyCount);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

