/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.servlet;

import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.Lists;
import com.google.inject.internal.Maps;
import com.google.inject.internal.Sets;
import com.google.inject.servlet.FilterChainInvocation;
import com.google.inject.servlet.FilterDefinition;
import com.google.inject.servlet.FilterPipeline;
import com.google.inject.servlet.ManagedServletPipeline;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class ManagedFilterPipeline
implements FilterPipeline {
    private final List<FilterDefinition> filterDefinitions;
    private final ManagedServletPipeline servletPipeline;
    private final Provider<ServletContext> servletContext;
    private final Injector injector;
    private volatile boolean initialized = false;
    private static final TypeLiteral<List<FilterDefinition>> FILTER_DEFS = new TypeLiteral<List<FilterDefinition>>(){};

    @Inject
    public ManagedFilterPipeline(Injector injector, ManagedServletPipeline servletPipeline, Provider<ServletContext> servletContext) {
        this.injector = injector;
        this.servletPipeline = servletPipeline;
        this.servletContext = servletContext;
        this.filterDefinitions = Collections.unmodifiableList(this.collectFilterDefinitions(injector));
    }

    private List<FilterDefinition> collectFilterDefinitions(Injector injector) {
        ArrayList<FilterDefinition> filterDefinitions = Lists.newArrayList();
        for (Binding<List<FilterDefinition>> entry : injector.findBindingsByType(FILTER_DEFS)) {
            Key<List<FilterDefinition>> defsKey = entry.getKey();
            filterDefinitions.addAll((Collection<FilterDefinition>)injector.getInstance(defsKey));
        }
        return filterDefinitions;
    }

    @Override
    public synchronized void initPipeline(ServletContext servletContext) throws ServletException {
        if (this.initialized) {
            return;
        }
        Set<Filter> initializedSoFar = Sets.newSetFromMap(Maps.newIdentityHashMap());
        for (FilterDefinition filterDefinition : this.filterDefinitions) {
            filterDefinition.init(servletContext, this.injector, initializedSoFar);
        }
        this.servletPipeline.init(servletContext, this.injector);
        this.initialized = true;
    }

    @Override
    public void dispatch(ServletRequest request, ServletResponse response, FilterChain proceedingFilterChain) throws IOException, ServletException {
        if (!this.initialized) {
            this.initPipeline(this.servletContext.get());
        }
        new FilterChainInvocation(this.filterDefinitions, this.servletPipeline, proceedingFilterChain).doFilter(this.withDispatcher(request, this.servletPipeline), response);
    }

    private ServletRequest withDispatcher(ServletRequest servletRequest, final ManagedServletPipeline servletPipeline) {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        if (!servletPipeline.hasServletsMapped()) {
            return servletRequest;
        }
        return new HttpServletRequestWrapper(request){

            public RequestDispatcher getRequestDispatcher(String path) {
                RequestDispatcher dispatcher = servletPipeline.getRequestDispatcher(path);
                return null != dispatcher ? dispatcher : super.getRequestDispatcher(path);
            }
        };
    }

    @Override
    public void destroyPipeline() {
        this.servletPipeline.destroy();
        Set<Filter> destroyedSoFar = Sets.newSetFromMap(Maps.newIdentityHashMap());
        for (FilterDefinition filterDefinition : this.filterDefinitions) {
            filterDefinition.destroy(destroyedSoFar);
        }
    }
}

