/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.product.components;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.InstallationException;
import org.netbeans.installer.utils.exceptions.UninstallationException;
import org.netbeans.installer.utils.helper.RemovalMode;
import org.netbeans.installer.utils.helper.Status;
import org.netbeans.installer.utils.helper.Text;
import org.netbeans.installer.utils.progress.Progress;
import org.netbeans.installer.wizard.components.WizardComponent;

public abstract class ProductConfigurationLogic {
    private Product product;

    public abstract void install(Progress var1) throws InstallationException;

    public abstract void uninstall(Progress var1) throws UninstallationException;

    public abstract List<WizardComponent> getWizardComponents();

    protected final Product getProduct() {
        return this.product;
    }

    final void setProduct(Product product) {
        this.product = product;
    }

    public String validateInstallation() {
        if (this.getProduct().getStatus() == Status.INSTALLED) {
            File installLocation = this.getProduct().getInstallationLocation();
            if (installLocation == null) {
                return ResourceUtils.getString(ProductConfigurationLogic.class, "PCL.validation.directory.null");
            }
            if (!installLocation.exists()) {
                return ResourceUtils.getString(ProductConfigurationLogic.class, "PCL.validation.directory.missing", installLocation);
            }
            if (!installLocation.isDirectory()) {
                return ResourceUtils.getString(ProductConfigurationLogic.class, "PCL.validation.directory.file", installLocation);
            }
            if (FileUtils.isEmpty(installLocation)) {
                return ResourceUtils.getString(ProductConfigurationLogic.class, "PCL.validation.directory.empty", installLocation);
            }
        }
        return null;
    }

    protected final String getProperty(String name) {
        return this.getProperty(name, true);
    }

    protected final String getProperty(String name, boolean parse) {
        String value = this.product.getProperty(name);
        if (parse) {
            return value != null ? this.parseString(value) : null;
        }
        return value;
    }

    protected final void setProperty(String name, String value) {
        this.product.setProperty(name, value);
    }

    public Text getLicense() {
        String text = this.parseString("$R{" + StringUtils.asPath(this.getClass()) + "/license.txt;" + "UTF-8" + "}");
        return text == null ? null : new Text(text, Text.ContentType.PLAIN_TEXT);
    }

    public Map<String, Text> getThirdPartyLicenses() {
        return null;
    }

    public boolean requireLegalArtifactSaving() {
        return true;
    }

    public Text getThirdPartyLicense() {
        return null;
    }

    public Text getReleaseNotes() {
        return null;
    }

    public Text getReadme() {
        return null;
    }

    public Text getDistributionReadme() {
        return null;
    }

    public Text getInstallationInstructions() {
        return null;
    }

    public boolean registerInSystem() {
        return true;
    }

    public String getSystemDisplayName() {
        return this.product.getDisplayName();
    }

    public boolean allowModifyMode() {
        return true;
    }

    public boolean wrapForMacOs() {
        return false;
    }

    public boolean requireDotAppForMacOs() {
        return false;
    }

    @Deprecated
    public boolean prohibitExclamation() {
        return true;
    }

    public String[] getProhibitedInstallationPathParts() {
        return new String[]{"!", File.pathSeparator};
    }

    public String getExecutable() {
        return null;
    }

    public String getIcon() {
        return null;
    }

    public int getLogicPercentage() {
        return 10;
    }

    public Map<String, Object> getAdditionalSystemIntegrationInfo() {
        return new HashMap<String, Object>();
    }

    public RemovalMode getRemovalMode() {
        return RemovalMode.ALL;
    }

    protected final String parseString(String string) {
        return SystemUtils.resolveString(string, this.product.getClassLoader());
    }

    protected final File parsePath(String path) {
        return SystemUtils.resolvePath(path, this.product.getClassLoader());
    }

    protected final String getString(String key) {
        return ResourceUtils.getString(this.getClass(), key);
    }

    protected final Map<Locale, String> getStrings(String key) {
        return ResourceUtils.getStrings(this.getClass(), key, new Object[0]);
    }

    protected final Map<Locale, String> getStrings(String key, Object ... arguments) {
        return ResourceUtils.getStrings(this.getClass(), key, arguments);
    }

    protected final String getString(String key, Object ... arguments) {
        return ResourceUtils.getString(this.getClass(), key, arguments);
    }

    protected final InputStream getResource(String path) {
        return ResourceUtils.getResource(path, this.product.getClassLoader());
    }
}

