/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import org.netbeans.api.visual.print.ScenePrinter;
import org.netbeans.api.visual.widget.Scene;

public class PageableScene
implements Pageable,
Printable {
    private double mScaleX = 1.0;
    private double mScaleY = 1.0;
    private final Scene scene;
    private int mNumPagesX;
    private int mNumPagesY;
    private int mNumPages;
    private PageFormat mFormat;
    private final boolean selectedOnly;
    private final boolean visibleOnly;
    private Rectangle region = null;

    public PageableScene(Scene scene, PageFormat pageFormat, ScenePrinter.ScaleStrategy scaleStrategy, double d, double d2, boolean bl, boolean bl2, Rectangle rectangle) {
        this.scene = scene;
        this.selectedOnly = bl;
        this.visibleOnly = bl2;
        this.region = rectangle;
        double d3 = scene.getZoomFactor();
        if (pageFormat == null) {
            pageFormat = new PageFormat();
        }
        this.setPageFormat(pageFormat);
        if (bl2 || rectangle != null) {
            if (rectangle == null) {
                rectangle = scene.getView().getVisibleRect();
            }
            this.setSize(rectangle.width, rectangle.height);
        } else if (scaleStrategy.equals((Object)ScenePrinter.ScaleStrategy.SCALE_CURRENT_ZOOM)) {
            this.setScaledSize(1.0, 1.0);
        } else if (scaleStrategy.equals((Object)ScenePrinter.ScaleStrategy.NO_SCALING)) {
            double d4 = d3 > 1.0 ? 1.0 / d3 : 1.0;
            this.setScaledSize(d4, d4);
            this.mScaleX = 1.0;
            this.mScaleY = 1.0;
        } else if (scaleStrategy.equals((Object)ScenePrinter.ScaleStrategy.SCALE_TO_FIT_X)) {
            this.scaleToFitX();
        } else if (scaleStrategy.equals((Object)ScenePrinter.ScaleStrategy.SCALE_TO_FIT_Y)) {
            this.scaleToFitY();
        } else if (scaleStrategy.equals((Object)ScenePrinter.ScaleStrategy.SCALE_TO_FIT)) {
            this.scaleToFit(true);
        } else if (scaleStrategy.equals((Object)ScenePrinter.ScaleStrategy.SCALE_PERCENT)) {
            this.setScaledSize(d, d2);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (this.mNumPagesX == 0) {
            return 1;
        }
        double d = (double)(n % this.mNumPagesX) * this.mFormat.getImageableWidth();
        double d2 = (double)(n / this.mNumPagesX) * this.mFormat.getImageableHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.translate(-d, -d2);
        graphics2D.scale(this.mScaleX, this.mScaleY);
        this.scene.paint(graphics2D);
        return 0;
    }

    protected void setSize(float f, float f2) {
        if (this.mFormat.getImageableWidth() * this.mFormat.getImageableHeight() == 0.0) {
            return;
        }
        this.mNumPagesX = (int)(((double)f + this.mFormat.getImageableWidth() - 1.0) / this.mFormat.getImageableWidth());
        this.mNumPagesY = (int)(((double)f2 + this.mFormat.getImageableHeight() - 1.0) / this.mFormat.getImageableHeight());
        this.mNumPages = this.mNumPagesX * this.mNumPagesY;
    }

    private void scaleToFit(boolean bl) {
        PageFormat pageFormat = this.getPageFormat();
        Rectangle rectangle = this.scene.getView().getBounds();
        if (rectangle.width * rectangle.height == 0) {
            return;
        }
        double d = pageFormat.getImageableWidth() / (double)rectangle.width;
        double d2 = pageFormat.getImageableHeight() / (double)rectangle.height;
        if (d < 1.0 || d2 < 1.0) {
            if (bl) {
                if (d < d2) {
                    d2 = d;
                } else {
                    d = d2;
                }
            }
            this.setSize((float)((double)rectangle.width * d), (float)((double)rectangle.height * d2));
            this.setScaledSize(d, d2);
        }
    }

    private void scaleToFitX() {
        double d;
        PageFormat pageFormat = this.getPageFormat();
        Rectangle rectangle = this.scene.getBounds();
        if (rectangle.width == 0) {
            return;
        }
        double d2 = d = pageFormat.getImageableWidth() / (double)rectangle.width;
        if (d < 1.0) {
            this.setSize((float)pageFormat.getImageableWidth(), (float)((double)rectangle.height * d2));
            this.setScaledSize(d, d2);
        }
    }

    private void scaleToFitY() {
        double d;
        PageFormat pageFormat = this.getPageFormat();
        Rectangle rectangle = this.scene.getBounds();
        if (rectangle.height == 0) {
            return;
        }
        double d2 = d = pageFormat.getImageableHeight() / (double)rectangle.height;
        if (d < 1.0) {
            this.setSize((float)((double)rectangle.width * d2), (float)pageFormat.getImageableHeight());
            this.setScaledSize(d2, d);
        }
    }

    private void setScaledSize(double d, double d2) {
        this.mScaleX = d;
        this.mScaleY = d2;
        Rectangle rectangle = this.scene.getView().getBounds();
        this.setSize((float)((double)rectangle.width * d), (float)((double)rectangle.height * d2));
    }

    @Override
    public int getNumberOfPages() {
        return this.mNumPages;
    }

    private PageFormat getPageFormat() {
        return this.mFormat;
    }

    private void setPageFormat(PageFormat pageFormat) {
        this.mFormat = pageFormat;
    }

    @Override
    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        if (n >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this.getPageFormat();
    }

    @Override
    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        if (n >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }
}

