/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.List;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.DirectedGraph;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.LayeredGraph;

public class BarycenterCrossingMinimizer {
    public <N, E> LayeredGraph<N, E> minimizeCrossings(LayeredGraph<N, E> layeredGraph) {
        List<List<DirectedGraph.Vertex<N>>> list = layeredGraph.getLayers();
        if (list.size() > 1) {
            int n = 2;
            for (int i = 0; i < n; ++i) {
                this.minimizeCrossingsPhaseI(layeredGraph);
            }
            this.minimizeCrossingsPhaseII(layeredGraph);
        }
        return layeredGraph;
    }

    private <N, E> void minimizeCrossingsPhaseI(LayeredGraph<N, E> layeredGraph) {
        List<DirectedGraph.Vertex<N>> list;
        float[] fArray;
        int n;
        List<List<DirectedGraph.Vertex<N>>> list2 = layeredGraph.getLayers();
        int n2 = list2.size();
        for (n = 0; n < n2 - 1; ++n) {
            fArray = layeredGraph.computeLowerBarycenters(n);
            list = list2.get(n + 1);
            this.sortVertices(list, fArray, false);
        }
        for (n = n2 - 2; n >= 0; --n) {
            fArray = layeredGraph.computeUpperBarycenters(n);
            list = list2.get(n);
            this.sortVertices(list, fArray, false);
        }
    }

    private <N, E> void minimizeCrossingsPhaseII(LayeredGraph<N, E> layeredGraph) {
        List<DirectedGraph.Vertex<N>> list;
        float[] fArray;
        int n;
        List<List<DirectedGraph.Vertex<N>>> list2 = layeredGraph.getLayers();
        int n2 = list2.size();
        for (n = n2 - 2; n >= 0; --n) {
            fArray = layeredGraph.computeUpperBarycenters(n);
            list = list2.get(n);
            this.sortVertices(list, fArray, true);
            this.minimizeCrossingsPhaseI(layeredGraph);
        }
        for (n = 0; n < n2 - 1; ++n) {
            fArray = layeredGraph.computeLowerBarycenters(n);
            list = list2.get(n + 1);
            this.sortVertices(list, fArray, true);
            this.minimizeCrossingsPhaseI(layeredGraph);
        }
    }

    private <N> boolean sortVertices(List<DirectedGraph.Vertex<N>> list, float[] fArray, boolean bl) {
        int n = list.size();
        boolean bl2 = false;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                DirectedGraph.Vertex<N> vertex = list.get(j);
                DirectedGraph.Vertex<N> vertex2 = list.get(i);
                float f = fArray[j];
                float f2 = fArray[i];
                boolean bl3 = false;
                if (bl) {
                    if (f <= f2) {
                        bl3 = true;
                    }
                } else if (f < f2) {
                    bl3 = true;
                }
                if (!bl3) continue;
                list.set(j, vertex2);
                list.set(i, vertex);
                fArray[j] = f2;
                fArray[i] = f;
                vertex2.setX(j + 1);
                vertex.setX(i + 1);
                bl2 = true;
            }
        }
        return bl2;
    }
}

