/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.util.Arrays;

final class SparseIntList {
    private int[] keys;
    private int[] values;
    private int used = 0;
    private int lastAdded = Integer.MIN_VALUE;
    private int lastIndex = Integer.MIN_VALUE;
    private int lastGetIndex = -1;
    private int lastGetResult;
    private int lastGetNextKeyValue = -1;
    private int lastGetNextKeyResult;

    SparseIntList(int n) {
        this.allocArrays(n);
    }

    public synchronized void add(int n, int n2) {
        if (n2 < this.lastAdded) {
            throw new IllegalArgumentException("Contents must be presorted - added value " + n2 + " is less than preceding value " + this.lastAdded);
        }
        if (n <= this.lastIndex) {
            throw new IllegalArgumentException("Contents must be presorted - added index " + n + " is less than preceding index " + this.lastIndex);
        }
        if (this.used >= this.keys.length) {
            this.growArrays();
        }
        this.values[this.used] = n2;
        this.keys[this.used++] = n;
        this.lastAdded = n2;
        this.lastIndex = n;
        this.lastGetResult = -1;
        this.lastGetIndex = -1;
        this.lastGetNextKeyResult = -1;
        this.lastGetNextKeyValue = -1;
    }

    public synchronized void updateLast(int n, int n2) {
        if (this.lastIndex != n) {
            throw new IllegalArgumentException("Last index: " + this.lastIndex + " idx: " + n);
        }
        this.values[this.used - 1] = n2;
        this.lastAdded = n2;
        this.lastGetResult = -1;
        this.lastGetIndex = -1;
        this.lastGetNextKeyResult = -1;
        this.lastGetNextKeyValue = -1;
    }

    public synchronized void removeLast() {
        if (this.used < 1) {
            throw new IllegalStateException("Cannot remove last, list is empty");
        }
        --this.used;
        if (this.used > 0) {
            this.lastAdded = this.values[this.used - 1];
            this.lastIndex = this.keys[this.used - 1];
        } else {
            this.lastIndex = Integer.MIN_VALUE;
            this.lastAdded = Integer.MIN_VALUE;
        }
        this.lastGetResult = -1;
        this.lastGetIndex = -1;
        this.lastGetNextKeyResult = -1;
        this.lastGetNextKeyValue = -1;
    }

    int lastAdded() {
        return this.lastAdded;
    }

    int lastIndex() {
        return this.lastIndex;
    }

    private void allocArrays(int n) {
        this.keys = new int[n];
        this.values = new int[n];
        Arrays.fill(this.keys, Integer.MAX_VALUE);
        Arrays.fill(this.values, Integer.MAX_VALUE);
    }

    public synchronized int get(int n) {
        if (n < 0) {
            return 0;
        }
        if (this.used == 0 || this.used > 0 && n < this.keys[0]) {
            return n + 1;
        }
        if (n == this.lastGetIndex) {
            return this.lastGetResult;
        }
        this.lastGetIndex = n;
        int n2 = Arrays.binarySearch(this.keys, n);
        if (n2 >= 0) {
            this.lastGetResult = this.values[n2];
            return this.lastGetResult;
        }
        n2 = -n2 - 2;
        this.lastGetResult = this.values[n2] + n - this.keys[n2];
        return this.lastGetResult;
    }

    public synchronized int getNextKey(int n) {
        if (n < 0) {
            return 0;
        }
        if (this.used == 0) {
            return n;
        }
        if (this.used > 0 && n < this.values[0]) {
            return n < this.keys[0] ? n : this.keys[0];
        }
        if (n == this.lastGetNextKeyValue) {
            return this.lastGetNextKeyResult;
        }
        this.lastGetNextKeyValue = n;
        int n2 = Arrays.binarySearch(this.values, n);
        if (n2 < 0) {
            n2 = -n2 - 1;
            int n3 = n - this.values[n2 - 1] + this.keys[n2 - 1] + 1;
            this.lastGetNextKeyResult = n2 < this.used ? Math.min(n3, this.keys[n2]) : n3;
            return this.lastGetNextKeyResult;
        }
        while (n2 >= 0 && n2 + 1 < this.values.length && this.values[n2] == this.values[n2 + 1]) {
            ++n2;
        }
        this.lastGetNextKeyResult = this.keys[n2] + 1;
        return this.lastGetNextKeyResult;
    }

    public synchronized int getKey(int n) {
        if (n < 0) {
            return 0;
        }
        if (this.used == 0) {
            return n - 1;
        }
        if (this.used > 0 && n < this.values[0]) {
            return n < this.keys[0] ? n - 1 : this.keys[0];
        }
        int n2 = Arrays.binarySearch(this.values, n);
        if (n2 < 0) {
            n2 = -n2 - 1;
            int n3 = n - this.values[n2 - 1] + this.keys[n2 - 1];
            return n2 < this.used ? Math.min(n3, this.keys[n2]) : n3;
        }
        return this.keys[n2];
    }

    private void growArrays() {
        int[] nArray = this.keys;
        int[] nArray2 = this.values;
        this.allocArrays(Math.round((float)this.keys.length * 1.5f));
        System.arraycopy(nArray, 0, this.keys, 0, nArray.length);
        System.arraycopy(nArray2, 0, this.values, 0, nArray2.length);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SparseIntList [");
        stringBuffer.append("used=");
        stringBuffer.append(this.used);
        stringBuffer.append(" capacity=");
        stringBuffer.append(this.keys.length);
        stringBuffer.append(" keyValuePairs:");
        for (int i = 0; i < this.used; ++i) {
            stringBuffer.append(this.keys[i]);
            stringBuffer.append(':');
            stringBuffer.append(this.values[i]);
            if (i == this.used - 1) continue;
            stringBuffer.append(',');
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

