/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.output2;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.core.output2.AbstractLines;
import org.netbeans.core.output2.Lines;
import org.netbeans.core.output2.OutputDocument;
import org.netbeans.core.output2.ui.AbstractOutputPane;

public class FoldingSideBar
extends JComponent {
    private static final Logger LOG = Logger.getLogger(FoldingSideBar.class.getName());
    private final int BAR_WIDTH = 15;
    private final JEditorPane textView;
    private AbstractLines lines;
    private int charsPerLine = 80;
    private boolean wrapped;
    private int activeFold = -1;

    public FoldingSideBar(JEditorPane jEditorPane, AbstractOutputPane abstractOutputPane) {
        this.textView = jEditorPane;
        this.lines = this.getLines();
        jEditorPane.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FoldingSideBar.this.lines = FoldingSideBar.this.getLines();
            }
        });
        jEditorPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                FoldingSideBar.this.setPreferredSize(new Dimension(15, FoldingSideBar.this.textView.getHeight()));
                FoldingSideBar.this.repaint();
            }
        });
        this.setMinimumSize(new Dimension(15, 0));
        this.setPreferredSize(new Dimension(15, jEditorPane.getHeight()));
        this.setMaximumSize(new Dimension(15, Integer.MAX_VALUE));
        this.wrapped = abstractOutputPane.isWrapped();
        this.addMouseListener(new FoldingMouseListener());
        this.addMouseMotionListener(new FoldingMouseListener());
    }

    private AbstractLines getLines() {
        Document document = this.textView.getDocument();
        if (document instanceof OutputDocument) {
            Lines lines = ((OutputDocument)document).getLines();
            if (lines instanceof AbstractLines) {
                return (AbstractLines)lines;
            }
            return null;
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.lines == null) {
            return;
        }
        graphics.setColor(this.getForeground());
        FontMetrics fontMetrics = this.textView.getFontMetrics(this.textView.getFont());
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getDescent();
        int n3 = 0;
        try {
            Rectangle rectangle2 = this.textView.modelToView(0);
            n3 = rectangle2 == null ? 0 : rectangle2.y;
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.INFO, null, badLocationException);
        }
        n3 += n - fontMetrics.getAscent();
        int n4 = this.lines.getLineCount();
        int n5 = 0;
        int n6 = Math.max(0, this.getLineAtPosition(rectangle.y) - 1);
        int n7 = this.getLastVisibleLine(rectangle, n4);
        for (int i = n6; i < n7; ++i) {
            if (!this.lines.isVisible(i)) continue;
            int n8 = this.findLogicalLineIndex(this.findNextVisibleLine(i), n4);
            this.drawLineGraphics(graphics, i, n5, n8, n3, n, n2);
            n5 = n8;
        }
    }

    private int getLastVisibleLine(Rectangle rectangle, int n) {
        int n2 = this.getLineAtPosition(rectangle.y + rectangle.height);
        return n2 < 0 ? n - 1 : Math.min(n - 1, n2 + 1);
    }

    private int getLineAtPosition(int n) {
        int n2;
        FontMetrics fontMetrics = this.textView.getFontMetrics(this.textView.getFont());
        int n3 = fontMetrics.getHeight();
        int n4 = 0;
        try {
            Rectangle rectangle = this.textView.modelToView(0);
            n4 = rectangle == null ? 0 : rectangle.y;
        }
        catch (BadLocationException badLocationException) {
            LOG.log(Level.INFO, null, badLocationException);
        }
        int n5 = (n - (n4 += n3 - fontMetrics.getAscent())) / n3;
        if (this.wrapped) {
            int[] nArray = new int[]{n5, 0, 0};
            this.lines.toPhysicalLineIndex(nArray, this.charsPerLine);
            n2 = nArray[0];
        } else {
            n2 = n5 < this.lines.getVisibleLineCount() ? this.lines.visibleToRealLine(n5) : -1;
        }
        return n2;
    }

    private void drawLineGraphics(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        try {
            n8 = this.lines.getFoldOffsets().get(n);
            n7 = n + 1 < this.lines.getFoldOffsets().size() ? this.lines.getFoldOffsets().get(n + 1) : 0;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            LOG.log(Level.FINE, null, indexOutOfBoundsException);
            return;
        }
        int n9 = n2 * n5 + n4;
        int n10 = n3 * n5 + n4;
        if (n7 == 1) {
            this.drawButton(graphics, n9, n10, n);
        } else if (n8 != 0 && n8 + 1 == n7) {
            if (this.isActive(n)) {
                graphics.drawLine(6, n9, 6, n10);
            }
            graphics.drawLine(7, n9, 7, n10);
        } else if (n8 > 0 && n7 == 0) {
            this.drawFoldEnd(graphics, n, n9, FoldingSideBar.lineMid(n10, n5, n6));
        } else if (n8 > 0 && n7 > 0) {
            this.drawNestedFoldEnd(graphics, n, n9, n10, FoldingSideBar.lineMid(n10, n5, n6));
        }
    }

    private static int lineMid(int n, int n2, int n3) {
        return n - n2 / 2 - n3;
    }

    private void drawButton(Graphics graphics, int n, int n2, int n3) {
        boolean bl = !this.lines.isVisible(n3 + 1);
        graphics.drawRect(2, n, 10, 10);
        graphics.drawLine(5, n + 5, 9, n + 5);
        if (bl) {
            graphics.drawLine(7, n + 3, 7, n + 7);
        }
        if (n2 > n + 10 && (!bl || this.isLastVisibleLineInFold(n3))) {
            graphics.drawLine(7, n + 10, 7, n2);
            if (this.isActive(n3)) {
                graphics.drawLine(6, n + 10, 6, n2);
            }
        }
    }

    private boolean isLastVisibleLineInFold(int n) {
        if (this.lines.getFoldOffsets().get(n) > 0) {
            int n2 = this.lines.realToVisibleLine(n);
            int n3 = this.lines.visibleToRealLine(n2 + 1);
            if (n3 >= this.lines.getFoldOffsets().size()) {
                return true;
            }
            return this.lines.getFoldOffsets().get(n3) > 0;
        }
        return false;
    }

    private void drawNestedFoldEnd(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(7, n2, 7, n3);
        graphics.drawLine(7, n4, 11, n4);
        if (this.isActive(n)) {
            graphics.drawLine(6, n2, 6, n4);
            graphics.drawLine(7, n4 - 1, 11, n4 - 1);
            if (this.isActive(this.findNextVisibleLine(n))) {
                graphics.drawLine(6, n4, 6, n3);
            }
        }
    }

    private void drawFoldEnd(Graphics graphics, int n, int n2, int n3) {
        graphics.drawLine(7, n2, 7, n3);
        graphics.drawLine(7, n3, 11, n3);
        if (this.isActive(n)) {
            graphics.drawLine(6, n2, 6, n3);
            graphics.drawLine(7, n3 - 1, 11, n3 - 1);
        }
    }

    private int findLogicalLineIndex(int n, int n2) {
        if (this.wrapped) {
            if (n < n2) {
                return this.lines.getLogicalLineCountAbove(n, this.charsPerLine);
            }
            return this.lines.getLogicalLineCountIfWrappedAt(this.charsPerLine);
        }
        return this.lines.realToVisibleLine(n);
    }

    private int findNextVisibleLine(int n) {
        int n2 = this.lines.realToVisibleLine(n);
        if (n2 < 0) {
            return this.lines.getVisibleLineCount() - 1;
        }
        if (n2 + 1 < this.lines.getVisibleLineCount()) {
            return this.lines.visibleToRealLine(n2 + 1);
        }
        return this.lines.getVisibleLineCount() - 1;
    }

    public void setWrapped(boolean bl) {
        this.wrapped = bl;
        this.repaint();
    }

    public void setCharsPerLine(int n) {
        this.charsPerLine = n;
        this.repaint();
    }

    private boolean isActive(int n) {
        int n2;
        int n3;
        for (n2 = n; n2 != this.activeFold && n2 >= 0 && (n3 = this.lines.getFoldOffsets().get(n2)) != 0; n2 -= n3) {
        }
        return n2 == this.activeFold;
    }

    private class FoldingMouseListener
    extends MouseAdapter {
        private FoldingMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            FoldingSideBar.this.activeFold = -1;
            FoldingSideBar.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (FoldingSideBar.this.lines == null) {
                return;
            }
            int n = this.getLineForEvent(mouseEvent);
            this.updateActiveFold(n);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (FoldingSideBar.this.lines == null) {
                return;
            }
            int n = this.getLineForEvent(mouseEvent);
            this.updateActiveFold(n);
            if (FoldingSideBar.this.activeFold == n) {
                if (FoldingSideBar.this.lines.isVisible(n + 1)) {
                    FoldingSideBar.this.lines.hideFold(n);
                } else {
                    FoldingSideBar.this.lines.showFold(n);
                }
            }
        }

        private void updateActiveFold(int n) {
            int n2 = FoldingSideBar.this.activeFold;
            if (n < 0) {
                FoldingSideBar.this.activeFold = -1;
            } else if (n + 1 < FoldingSideBar.this.lines.getFoldOffsets().size() && FoldingSideBar.this.lines.getFoldOffsets().get(n + 1) == 1) {
                FoldingSideBar.this.activeFold = n;
            } else if (n < FoldingSideBar.this.lines.getFoldOffsets().size()) {
                FoldingSideBar.this.activeFold = n - FoldingSideBar.this.lines.getFoldOffsets().get(n);
            } else {
                FoldingSideBar.this.activeFold = -1;
            }
            if (FoldingSideBar.this.activeFold != n2) {
                FoldingSideBar.this.repaint();
            }
        }

        private int getLineForEvent(MouseEvent mouseEvent) {
            return FoldingSideBar.this.getLineAtPosition(mouseEvent.getY());
        }
    }
}

