// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// EnvironmentOptions environment options
//
// swagger:model environment_options
type EnvironmentOptions struct {

	// preset envs
	PresetEnvs []*PresetEnv `json:"presetenv,omitempty"`

	// set envs
	SetEnvs []*SetEnv `json:"setenv,omitempty"`

	// resetenv
	Resetenv string `json:"resetenv,omitempty"`

	// unsetenv
	Unsetenv string `json:"unsetenv,omitempty"`
}

// Validate validates this environment options
func (m *EnvironmentOptions) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validatePresetEnvs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSetEnvs(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EnvironmentOptions) validatePresetEnvs(formats strfmt.Registry) error {
	if swag.IsZero(m.PresetEnvs) { // not required
		return nil
	}

	for i := 0; i < len(m.PresetEnvs); i++ {
		if swag.IsZero(m.PresetEnvs[i]) { // not required
			continue
		}

		if m.PresetEnvs[i] != nil {
			if err := m.PresetEnvs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("presetenv" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("presetenv" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EnvironmentOptions) validateSetEnvs(formats strfmt.Registry) error {
	if swag.IsZero(m.SetEnvs) { // not required
		return nil
	}

	for i := 0; i < len(m.SetEnvs); i++ {
		if swag.IsZero(m.SetEnvs[i]) { // not required
			continue
		}

		if m.SetEnvs[i] != nil {
			if err := m.SetEnvs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("setenv" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("setenv" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this environment options based on the context it is used
func (m *EnvironmentOptions) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePresetEnvs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSetEnvs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *EnvironmentOptions) contextValidatePresetEnvs(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.PresetEnvs); i++ {

		if m.PresetEnvs[i] != nil {

			if swag.IsZero(m.PresetEnvs[i]) { // not required
				return nil
			}

			if err := m.PresetEnvs[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("presetenv" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("presetenv" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *EnvironmentOptions) contextValidateSetEnvs(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.SetEnvs); i++ {

		if m.SetEnvs[i] != nil {

			if swag.IsZero(m.SetEnvs[i]) { // not required
				return nil
			}

			if err := m.SetEnvs[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("setenv" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("setenv" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *EnvironmentOptions) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *EnvironmentOptions) UnmarshalBinary(b []byte) error {
	var res EnvironmentOptions
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// PresetEnv preset env
//
// swagger:model PresetEnv
type PresetEnv struct {

	// name
	// Required: true
	Name *string `json:"name"`

	// value
	// Required: true
	Value *string `json:"value"`
}

// Validate validates this preset env
func (m *PresetEnv) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateValue(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *PresetEnv) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *PresetEnv) validateValue(formats strfmt.Registry) error {

	if err := validate.Required("value", "body", m.Value); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this preset env based on context it is used
func (m *PresetEnv) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *PresetEnv) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *PresetEnv) UnmarshalBinary(b []byte) error {
	var res PresetEnv
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// SetEnv set env
//
// swagger:model SetEnv
type SetEnv struct {

	// name
	// Required: true
	Name *string `json:"name"`

	// value
	// Required: true
	Value *string `json:"value"`
}

// Validate validates this set env
func (m *SetEnv) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateValue(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SetEnv) validateName(formats strfmt.Registry) error {

	if err := validate.Required("name", "body", m.Name); err != nil {
		return err
	}

	return nil
}

func (m *SetEnv) validateValue(formats strfmt.Registry) error {

	if err := validate.Required("value", "body", m.Value); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this set env based on context it is used
func (m *SetEnv) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *SetEnv) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SetEnv) UnmarshalBinary(b []byte) error {
	var res SetEnv
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
