## HAProxy configuration parser

### Autogenerated code

if you change types/types.go you need to run
```bash
make gentypes
```

### Example

```go
package main

import (
    "github.com/haproxytech/client-native/v6/config-parser"
    "github.com/haproxytech/client-native/v6/config-parser/options"
    "github.com/haproxytech/client-native/v6/config-parser/parsers/http/actions"
    // ...
)
// ...

func main() {
    p, err := parser.New(options.Path("config.cfg"))
    /* p, err := parser.New(
        options.UseMd5Hash,
        options.Path("config.cfg")
    )*/
    if err != nil {
        log.Panic(err)
    }

    {
        data, _ := p.Get(parser.Comments, parser.CommentsSectionName, "# _version", true)
        if err == errors.ErrFetch {
            log.Panicln("we have an fetch error !!")
        }
        ver, _ := data.(*types.Int64C)
        ver.Value = ver.Value + 1
    }

    {
        p.Set(parser.Frontends, "http", "option forwardfor", types.OptionForwardFor{})
    }

    {
        // for options that can exists multiple times in config Insert is preferred
        //
        // setting http-request & http-response is a bit different
        // since they accept multiple structs
        httpRequestActionDeny := &actions.Deny{
            DenyStatus: "0",
            Cond:       "unless",
            CondTest:   "{ src 127.0.0.1 }",
        }
        err = p.Insert(parser.Backends, "web_servers", "http-request", httpRequestActionDeny)
        // you can also choose index where action should be inserted
        err = p.Insert(parser.Backends, "web_servers", "http-request", httpRequestActionDeny, 2)
    }

    {
        data, err := p.Get(parser.Global, parser.GlobalSectionName, "stats socket")
        if err != nil {
            log.Panicln(err)
        }
        val, _ := data.([]types.Socket)
        log.Println(val[0])
        val[0].Path = "$PWD/haproxy-runtime-api.1.sock"
        log.Println(val[0])
    }

    {
        data, err := p.Get(parser.Global, parser.GlobalSectionName, "daemon")
        log.Println(data, err)
        if err == errors.ErrFetch {
            log.Panicln("we have an fetch error !!")
        }
        //remove it
        p.Set(parser.Global, parser.GlobalSectionName, "daemon", nil)
    }

    {
        datar, err := p.Get(parser.Resolvers, "ns1", "nameserver")
        if err == nil {
            ns := datar.([]types.Nameserver)
            log.Println(ns[0].Name, ns[0].Address)
            log.Println(ns[1].Name, ns[1].Address)
            ns[1].Name = "hahaha"
            ns[0].Address = "0.0.0.0:8080"
        }
        datar, err = p.Get(parser.Resolvers, "ns1", "nameserver")
        if err == nil {
            ns := datar.([]types.Nameserver)
            log.Println(ns[0].Name, ns[0].Address)
            log.Println(ns[1].Name, ns[1].Address)
        }
    }

    {
        log.Println("nbproc ==================================================")
        data, err := p.Get(parser.Global, parser.GlobalSectionName, "nbproc")
        if err != nil {
            log.Println(err)
        } else {
            d := data.(*types.Int64C)
            log.Println(d.Value)
            d.Value = 5
        }
    }

    p.Save(configFilename)
}

```
